% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmTMB_tidiers.R
\name{glmmTMB_tidiers}
\alias{glmmTMB_tidiers}
\alias{tidy.glmmTMB}
\alias{augment.glmmTMB}
\alias{glance.glmmTMB}
\title{Tidying methods for glmmTMB models}
\usage{
\method{tidy}{glmmTMB}(
  x,
  effects = c("ran_pars", "fixed"),
  component = c("cond", "zi"),
  scales = NULL,
  ran_prefix = NULL,
  conf.int = FALSE,
  conf.level = 0.95,
  conf.method = "Wald",
  exponentiate = FALSE,
  ...
)

\method{augment}{glmmTMB}(x, data = stats::model.frame(x), newdata = NULL, ...)

\method{glance}{glmmTMB}(x, ...)
}
\arguments{
\item{x}{An object of class \code{merMod}, such as those from \code{lmer},
\code{glmer}, or \code{nlmer}}

\item{effects}{A character vector including one or more of "fixed" (fixed-effect parameters), "ran_pars" (variances and covariances or standard deviations and correlations of random effect terms) or "ran_vals" (conditional modes/BLUPs/latent variable estimates)}

\item{component}{which component to extract (e.g. \code{cond} for conditional effects (i.e., traditional fixed effects); \code{zi} for zero-inflation model; \code{disp} for dispersion model}

\item{scales}{scales on which to report the variables: for random effects, the choices are \sQuote{"sdcor"} (standard deviations and correlations: the default if \code{scales} is \code{NULL}) or \sQuote{"varcov"} (variances and covariances). \code{NA} means no transformation, appropriate e.g. for fixed effects; inverse-link transformations (exponentiation
or logistic) are not yet implemented, but may be in the future.}

\item{ran_prefix}{a length-2 character vector specifying the strings to use as prefixes for self- (variance/standard deviation) and cross- (covariance/correlation) random effects terms}

\item{conf.int}{whether to include a confidence interval}

\item{conf.level}{confidence level for CI}

\item{conf.method}{method for computing confidence intervals (see \code{\link[lme4]{confint.merMod}})}

\item{exponentiate}{whether to exponentiate the fixed-effect coefficient estimates and confidence intervals (common for logistic regression); if \code{TRUE}, also scales the standard errors by the exponentiated coefficient, transforming them to the new scale}

\item{...}{extra arguments (not used)}

\item{data}{original data this was fitted on; if not given this will
attempt to be reconstructed}

\item{newdata}{new data to be used for prediction; optional}
}
\value{
All tidying methods return a \code{tibble}.
The structure depends on the method chosen.

\code{tidy} returns one row for each estimated effect, either
with groups depending on the \code{effects} parameter.
It contains the columns
  \item{group}{the group within which the random effect is being estimated: \code{NA} for fixed effects}
  \item{level}{level within group (\code{NA} except for modes)}
  \item{term}{term being estimated}
  \item{estimate}{estimated coefficient}
  \item{std.error}{standard error}
  \item{statistic}{t- or Z-statistic (\code{NA} for modes)}
  \item{p.value}{P-value computed from t-statistic (may be missing/NA)}

\code{augment} returns one row for each original observation,
with columns (each prepended by a .) added. Included are the columns
  \item{.fitted}{predicted values}
  \item{.resid}{residuals}
  \item{.fixed}{predicted values with no random effects}

\code{glance} returns one row with the columns
  \item{sigma}{the square root of the estimated residual variance}
  \item{logLik}{the data's log-likelihood under the model}
  \item{AIC}{the Akaike Information Criterion}
  \item{BIC}{the Bayesian Information Criterion}
  \item{deviance}{deviance}
}
\description{
These methods tidy the coefficients of mixed effects models, particularly
responses of the \code{merMod} class
}
\details{
When the modeling was performed with \code{na.action = "na.omit"}
(as is the typical default), rows with NA in the initial data are omitted
entirely from the augmented data frame. When the modeling was performed
with \code{na.action = "na.exclude"}, one should provide the original data
as a second argument, at which point the augmented data will contain those
rows (typically with NAs in place of the new columns). If the original data
is not provided to \code{augment} and \code{na.action = "na.exclude"}, a
warning is raised and the incomplete rows are dropped.
}
\note{
zero-inflation parameters (including the intercept) are reported
on the logit scale
}
\examples{
if (require("glmmTMB") && require("lme4")) {
    data("sleepstudy",package="lme4")
    ## original model:
    \dontrun{
        lmm1 <- glmmTMB(Reaction ~ Days + (Days | Subject), sleepstudy)
    }
    ## load stored object
    load(system.file("extdata","glmmTMB_example.rda",package="broom.mixed"))
    tidy(lmm1)
    tidy(lmm1, effects = "fixed")
    tidy(lmm1, effects = "fixed", conf.int=TRUE)
    tidy(lmm1, effects = "fixed", conf.int=TRUE, conf.method="uniroot")
    ## FIX: tidy(lmm1, effects = "ran_vals", conf.int=TRUE)
    head(augment(lmm1, sleepstudy))
    glance(lmm1)

    ## original model:
    ##  glmm1 <- glmmTMB(incidence/size ~ period + (1 | herd),
    ##                  data = cbpp, family = binomial, weights=size)
    tidy(glmm1)
    tidy(glmm1, effects = "fixed")
    tidy(glmm1, effects = "fixed", exponentiate=TRUE)
    tidy(glmm1, effects = "fixed", conf.int=TRUE, exponentiate=TRUE)
    head(augment(glmm1, cbpp))
    head(augment(glmm1, cbpp, type.residuals="pearson"))
    glance(glmm1)
\dontrun{
    ## profile CIs - a little bit slower but more accurate
    tidy(glmm1, effects = "fixed", conf.int=TRUE, exponentiate=TRUE, conf.method="profile")
}
}
}
\seealso{
\link{na.action}
}
