dnl This is m4 source.
dnl Process using m4 to produce 'C' language file.
dnl
dnl This file is supposed to be the same as PnetCDF's test_iput.m4
dnl
dnl If you see this line, you can ignore the next one.
! Do not edit this file. It is produced from the corresponding .m4 source
dnl
!
!  Copyright (C) 2003, Northwestern University and Argonne National Laboratory
!  See COPYRIGHT notice in top-level directory.
!
! $Id$

dnl divert(-1)

dnl This is m4 source.
dnl Process using m4 to produce FORTRAN language file.

changequote([,]) dnl

define([TestFunc],[ifdef([PNETCDF],[test_nfmpi_iput_$1],[test_nf_iput_$1])])dnl
define([APIFunc],[ifdef([PNETCDF],[nfmpi_$1],[nf_$1])])dnl
define([ErrFunc],[ifdef([PNETCDF],[nfmpi_strerror($1)],[nf_strerror($1)])])dnl

define([FileCreate],[ifdef([PNETCDF],[nfmpi_create(comm, $1, $2, info, ncid)], [nf_create($1, $2, ncid)])])dnl
define([FileDelete],[ifdef([PNETCDF],[nfmpi_delete($1,$2)],[nf_delete($1)])])dnl
define([FileClose],[ifdef([PNETCDF],[nfmpi_close($1)],[nf_close($1)])])dnl

define([iPutVar1],[ifdef([PNETCDF],[nfmpi_iput_var1_$1],[nf_iput_var1_$1])])dnl
define([iPutVar], [ifdef([PNETCDF],[nfmpi_iput_var_$1], [nf_iput_var_$1])])dnl
define([iPutVara],[ifdef([PNETCDF],[nfmpi_iput_vara_$1],[nf_iput_vara_$1])])dnl
define([iPutVars],[ifdef([PNETCDF],[nfmpi_iput_vars_$1],[nf_iput_vars_$1])])dnl
define([iPutVarm],[ifdef([PNETCDF],[nfmpi_iput_varm_$1],[nf_iput_varm_$1])])dnl

undefine([index])dnl

dnl Macros

dnl Upcase(str)
dnl
define([Upcase],[dnl
translit($1, abcdefghijklmnopqrstuvwxyz, ABCDEFGHIJKLMNOPQRSTUVWXYZ)])

dnl NFT_ITYPE(type)
dnl
define([NFT_ITYPE], [NFT_[]Upcase($1)])

dnl ARITH3(itype, value)
dnl
define([ARITH3], [ifelse($1, text, ichar($2($3:$3)), $2($3))])

dnl VAR_ELEM(itype, value)
dnl
define([VAR_ELEM], [ifelse($1, text, $2($3:$3), $2($3))])

dnl ARITH_VAR1(itype, value)
dnl
define([ARITH_VAR1], [ifelse($1, text, ichar($2), $2)])

dnl  DATATYPE(funf_suffix)
dnl
define([DATATYPE], [dnl
ifelse($1, text, character*MAX_NELS $2,
ifelse($1, int1, NF_INT1_T $2$3,
ifelse($1, int2, NF_INT2_T $2$3,
ifelse($1, int, integer $2$3,
ifelse($1, int8, NF_INT8_T $2$3,
ifelse($1, real, real $2$3,
ifelse($1, double, doubleprecision $2$3)[]dnl
)[]dnl
)[]dnl
)[]dnl
)[]dnl
)[]dnl
)[]dnl
])

dnl  DATATYPE_VAR1(funf_suffix)
dnl
define([DATATYPE_VAR1], [dnl
ifelse($1, text, character $2,
ifelse($1, int1, NF_INT1_T $2,
ifelse($1, int2, NF_INT2_T $2,
ifelse($1, int, integer $2,
ifelse($1, int8, NF_INT8_T $2,
ifelse($1, real, real $2,
ifelse($1, double, doubleprecision $2)[]dnl
)[]dnl
)[]dnl
)[]dnl
)[]dnl
)[]dnl
)[]dnl
])

dnl  MAKE_ARITH_VAR1(funf_suffix, var)
dnl
define([MAKE_ARITH_VAR1], [dnl
ifelse($1, text, ichar($2), $2)[]dnl
])

dnl  MAKE_ARITH3(funf_suffix, var)
dnl
define([MAKE_ARITH3], [dnl
ifelse($1, text, ichar($2($3:$3)), $2($3))[]dnl
])

dnl  MAKE_DOUBLE(funf_suffix, var)
dnl
define([MAKE_DOUBLE], [dnl
ifelse($1, text, dble(ichar($2)), dble($2))[]dnl
])

dnl  MAKE_TYPE(itype, constant)
dnl
define([MAKE_TYPE], [dnl
ifelse($1, text,   char(INT($2)),
       $1, real,   REAL($2),
       $1, double, DBLE($2),
                   $2)[]dnl
])

dnl Use GNU intrinsic INT if available
define([ConvInt1], [ifdef([HAVE_F77_INT1],INT1($1),ifdef([HAVE_F77_GNU_INT],INT($1,1),$1))])dnl
define([ConvInt2], [ifdef([HAVE_F77_INT2],INT2($1),ifdef([HAVE_F77_GNU_INT],INT($1,2),$1))])dnl
define([ConvInt8], [ifdef([HAVE_F77_INT8],INT8($1),ifdef([HAVE_F77_GNU_INT],INT($1,8),$1))])dnl

dnl  MAKE_TYPE2(itype, dest, src)
dnl
define([MAKE_TYPE2], [ifelse($1, text,   $2 = char(INT($3)),
                             $1, real,   $2 = REAL($3),
                             $1, double, $2 = DBLE($3),
                             $1, int,    $2 = INT($3),
                             $1, int1,   $2 = ConvInt1($3),
                             $1, int2,   $2 = ConvInt2($3),
                             $1, int8,
                      if ($3 .EQ. X_INT8_MAX) then
                          $2 = X_INT8_MAX
                      else
                          $2 = ConvInt8($3)
                      endif,
                             $2 = $3)])

dnl TEST_NFMPI_IPUT_VAR1(TYPE)
dnl
define([TEST_NFMPI_IPUT_VAR1],dnl
[dnl
        subroutine TestFunc(var1_$1)
        implicit        none
        include "pnetcdf.inc"
#include "tests.inc"
        integer index2indexes
        double precision hash_$1
        logical inRange3

        integer ncid
        integer i
        integer j
        integer err, flags
        integer*8 index(MAX_RANK)
        logical canConvert      !/* Both text or both numeric */
        DATATYPE_VAR1($1, value)
        doubleprecision val
        integer reqid(1), st(1), err_w, infoused
        logical flag, bb_enable
        character*(MPI_MAX_INFO_VAL) hint

        value = MAKE_TYPE($1, 5)!/* any value would do - only for error cases */

        flags = IOR(NF_NOCLOBBER, extra_flags)
        err = FileCreate(scratch, flags)
        if (err .ne. NF_NOERR) then
            call errore('APIFunc(create): ', err)
            return
        end if

        ! Determine if burst buffer driver is being used
        bb_enable = .FALSE.
        err = nfmpi_inq_file_info(ncid, infoused)
        if (err .eq. NF_NOERR) then
            call MPI_Info_get(infoused, "nc_burst_buf",
     +            MPI_MAX_INFO_VAL, hint, flag, err)
            if (flag) then
                bb_enable = (hint .eq. 'enable')
            endif
            call MPI_Info_free(infoused, err);
        endif

        call def_dims(ncid)
        call def_vars(ncid)
        err = APIFunc(enddef)(ncid)
        if (err .ne. NF_NOERR)
     +      call errore('APIFunc(enddef): ', err)
        do 1, i = 1, numVars
            canConvert = (var_type(i) .eq. NF_CHAR) .eqv.
     +                   (NFT_ITYPE($1) .eq. NFT_TEXT)
            do 2, j = 1, var_rank(i)
                index(j) = 1
2           continue
            err = iPutVar1($1)(BAD_ID, i, index, value,
     +                               reqid(1))
            if (err .ne. NF_EBADID)
     +          call errore('bad ncid: ', err)
            err = iPutVar1($1)(ncid, BAD_VARID,
     +                           index, value,reqid(1))
            if (err .ne. NF_ENOTVAR)
     +          call errore('bad var id: ', err)
            do 3, j = 1, var_rank(i)
                if (var_dimid(j,i) .EQ. RECDIM) goto 3 ! skip record dim
                index(j) = var_shape(j,i) + 1
                err = iPutVar1($1)(ncid, i,
     +                index, value,reqid(1))
                if (.not. canConvert) then
                    if (err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                else
                    if (err .ne. NF_EINVALCOORDS)
     +                  call errore('bad index: ', err)
                endif
                index(j) = 0
3           continue
            do 4, j = 1, var_nels(i)
                err = index2indexes(j, var_rank(i), var_shape(1,i),
     +                              index)
                if (err .ne. NF_NOERR)
     +              call error('error in index2indexes 1')
                val = hash_$1(var_type(i),var_rank(i),
     +                            index, NFT_ITYPE($1))
                MAKE_TYPE2($1, value, val)
                err = iPutVar1($1)(ncid, i,
     +                index, value, reqid(1))
                if (bb_enable) then
                    if (err .NE. NF_ECHAR .AND. err .NE. NF_NOERR)
     +                  call errore('iPutVar($1) : ', err)
                endif
                if (err .eq. NF_NOERR .or. err .eq. NF_ERANGE) then
                    ! NF_ERANGE is not a fatal error, still call wait
                    ! Flush the burst buffer to reveal potential error
                    err_w = APIFunc(wait_all)(ncid,1,reqid,st)
                    if (bb_enable) then
                        err = err_w
                    else
                        if (err_w .NE. NF_NOERR)
     +                      call errore('APIFunc(wait_all) : ', err)
                    end if
                endif

                if (canConvert) then
                    val = ARITH_VAR1($1, value)
                    if (inRange3(val, var_type(i), NFT_ITYPE($1))) then
                        ! put data is within conversion range
                        if (err .ne. NF_NOERR)
     +                      call error(ErrFunc(err))
                    else
                        ! put data is NOT within conversion range
                        if (err .ne. NF_ERANGE)
     +                      call errore('Range error: ', err)
                    end if
                else
                    if (err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                end if
4           continue
1       continue
        err = FileClose(ncid)
        if (err .ne. NF_NOERR)
     +      call errore('APIFunc(close): ', err)

        call check_vars_$1(scratch)

        err = FileDelete(scratch, info)
        if (err .ne. NF_NOERR)
     +      call errorc('delete of scratch file failed: ',
     +                  scratch)
        end
])dnl


dnl TEST_NFMPI_IPUT_VAR(TYPE)
dnl
define([TEST_NFMPI_IPUT_VAR],dnl
[dnl
        subroutine TestFunc(var_$1)
        implicit        none
        include "pnetcdf.inc"
#include "tests.inc"
        integer index2indexes
        double precision hash_$1
        logical inRange3

        integer ncid
        integer vid
        integer i
        integer j
        integer err, flags
        integer nels
        integer*8 index(MAX_RANK)
        logical canConvert      !/* Both text or both numeric */
        logical allInExtRange   !/* All values within external range?*/
        DATATYPE($1, value, (MAX_NELS))
        doubleprecision val
        integer err_w, reqid(1), st(1), infoused
        logical flag, bb_enable
        character*(MPI_MAX_INFO_VAL) hint

        flags = IOR(NF_CLOBBER, extra_flags)
        err = FileCreate(scratch, flags)
        if (err .ne. NF_NOERR) then
            call errore('APIFunc(create): ', err)
            return
        end if

        ! Determine if burst buffer driver is being used
        bb_enable = .FALSE.
        err = nfmpi_inq_file_info(ncid, infoused)
        if (err .eq. NF_NOERR) then
            call MPI_Info_get(infoused, "nc_burst_buf",
     +            MPI_MAX_INFO_VAL, hint, flag, err)
            if (flag) then
                bb_enable = (hint .eq. 'enable')
            endif
            call MPI_Info_free(infoused, err);
        endif

        call def_dims(ncid)
        call def_vars(ncid)
        err = APIFunc(enddef)(ncid)
        if (err .ne. NF_NOERR)
     +      call errore('APIFunc(enddef): ', err)
        do 1, i = 1, numVars
            canConvert = (var_type(i) .eq. NF_CHAR) .eqv.
     +                   (NFT_ITYPE($1) .eq. NFT_TEXT)
            err = iPutVar($1)(BAD_ID, i, value,reqid(1))
            if (err .ne. NF_EBADID)
     +          call errore('bad ncid: ', err)
            err = iPutVar($1)(ncid, BAD_VARID, value,
     +                                   reqid(1))
            if (err .ne. NF_ENOTVAR)
     +          call errore('bad var id: ', err)
            nels = 1
            do 3, j = 1, var_rank(i)
                nels = nels * int(var_shape(j,i))
3           continue
            allInExtRange = .true.
            do 4, j = 1, var_nels(i)
                err = index2indexes(j, var_rank(i), var_shape(1,i),
     +                              index)
                if (err .ne. NF_NOERR)
     +              call error('error in index2indexes 1')
                val = hash_$1(var_type(i), var_rank(i),
     +                        index, NFT_ITYPE($1))
                MAKE_TYPE2($1, VAR_ELEM($1, value, j), val)
                val = ARITH3($1, value, j)
                allInExtRange = allInExtRange .and.
     +              inRange3(val, var_type(i), NFT_ITYPE($1))
4           continue
            err = iPutVar($1)(ncid, i, value,reqid(1))
            if (bb_enable) then
                if (err .NE. NF_ECHAR .AND. err .NE. NF_NOERR)
     +              call errore('iPutVar($1) : ', err)
            endif
            if (err .eq. NF_NOERR .or. err .eq. NF_ERANGE) then
                ! NF_ERANGE is not a fatal error, still call wait
                ! Flush the burst buffer to reveal potential error
                err_w = APIFunc(wait_all)(ncid,1,reqid,st)
                if (bb_enable) then
                    err = err_w
                else
                    if (err_w .NE. NF_NOERR)
     +                  call errore('APIFunc(wait_all) : ', err)
                end if
            endif
            if (canConvert) then
                if (allInExtRange) then
                    if (err .ne. NF_NOERR)
     +                  call error(ErrFunc(err))
                else
                    if (err .ne. NF_ERANGE .AND.
     +                  var_dimid(var_rank(i),i) .NE. RECDIM)
     +                  call errore('range error: ', err)
                endif
            else
                if (err .ne. NF_ECHAR)
     +              call errore('wrong type: ', err)
            endif
1       continue

C       The preceeding has written nothing for record variables, now try
C       again with more than 0 records.

C       Write record number NRECS to force writing of preceding records.
C       Assumes variable cr is char vector with UNLIMITED dimension.

        err = APIFunc(inq_varid)(ncid, "cr", vid)
        if (err .ne. NF_NOERR)
     +      call errore('APIFunc(inq_varid): ', err)
        index(1) = NRECS
        err = iPutVar1(text)(ncid, vid, index, 'x',reqid(1))
        if (err .ne. NF_NOERR) then
            call errore('iPutVar1(text): ', err)
        else
            err_w = APIFunc(wait_all)(ncid, 1, reqid, st)
        endif

        do 5 i = 1, numVars
C           Only test record variables here
            if (var_rank(i) .ge. 1 .and.
     +          var_dimid(var_rank(i),i) .eq. RECDIM) then
                canConvert = (var_type(i) .eq. NF_CHAR) .eqv.
     +                   (NFT_ITYPE($1) .eq. NFT_TEXT)
                if (var_rank(i) .gt. MAX_RANK)
     +              stop 'var_rank(i) .gt. MAX_RANK'
                if (var_nels(i) .gt. MAX_NELS)
     +              stop 'var_nels(i) .gt. MAX_NELS'

                nels = 1
                do 6 j = 1, var_rank(i)
                    nels = nels * int(var_shape(j,i))
6               continue
                allInExtRange = .true.
                do 7, j = 1, nels
                    err = index2indexes(j, var_rank(i), var_shape(1,i),
     +                              index)
                    if (err .ne. NF_NOERR)
     +                  call error('error in index2indexes()')
                    val = hash_$1(var_type(i), var_rank(i),
     +                            index, NFT_ITYPE($1))
                    MAKE_TYPE2($1, VAR_ELEM($1, value, j), val)
                    val = ARITH3($1, value, j)
                    allInExtRange = allInExtRange .and.
     +                  inRange3(val, var_type(i), NFT_ITYPE($1))
7               continue
                err = iPutVar($1)(ncid, i, value,reqid(1))
                if (bb_enable) then
                    if (err .NE. NF_ECHAR .AND. err .NE. NF_NOERR)
     +                  call errore('iPutVar($1) : ', err)
                endif
                if (err .eq. NF_NOERR .or. err .eq. NF_ERANGE) then
                    ! NF_ERANGE is not a fatal error, still call wait
                    ! Flush the burst buffer to reveal potential error
                    err_w = APIFunc(wait_all)(ncid,1,reqid,st)
                    if (bb_enable) then
                        err = err_w
                    else
                        if (err_w .NE. NF_NOERR)
     +                      call errore('APIFunc(wait_all) : ', err)
                    end if
                endif
                if (canConvert) then
                    if (allInExtRange) then
                        if (err .ne. NF_NOERR)
     +                      call error(ErrFunc(err))
                    else
                        if (err .ne. NF_ERANGE)
     +                      call errore('range error: ', err)
                    endif
                else
                    if (nels .gt. 0 .and. err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                endif
            endif
5       continue
        err = FileClose(ncid)
        if (err .ne. NF_NOERR)
     +      call errore('APIFunc(close): ', err)

        call check_vars_$1(scratch)

        err = FileDelete(scratch, info)
        if (err .ne. NF_NOERR)
     +      call errorc('delete of scratch file failed: ',
     +                  scratch)
        end
])dnl


dnl TEST_NFMPI_IPUT_VARA(TYPE)
dnl
define([TEST_NFMPI_IPUT_VARA],dnl
[dnl
        subroutine TestFunc(vara_$1)
        implicit        none
        include "pnetcdf.inc"
#include "tests.inc"
        integer index2indexes, roll
        double precision hash_$1
        logical inRange3

        integer ncid
        integer i
        integer j
        integer k
        integer d
        integer err, flags
        integer nslabs
        integer nels
        integer*8 start(MAX_RANK)
        integer*8 edge(MAX_RANK)
        integer*8 mid(MAX_RANK)
        integer*8 index(MAX_RANK)
        logical canConvert      !/* Both text or both numeric */
        logical allInExtRange   !/* all values within external range? */
        DATATYPE($1, value, (MAX_NELS))
        doubleprecision val
        integer ud_shift
        integer err_w, reqid(1), st(1), infoused
        logical flag, bb_enable
        character*(MPI_MAX_INFO_VAL) hint

        flags = IOR(NF_CLOBBER, extra_flags)
        err = FileCreate(scratch, flags)
        if (err .ne. NF_NOERR) then
            call errore('APIFunc(create): ', err)
            return
        end if

        ! Determine if burst buffer driver is being used
        bb_enable = .FALSE.
        err = nfmpi_inq_file_info(ncid, infoused)
        if (err .eq. NF_NOERR) then
            call MPI_Info_get(infoused, "nc_burst_buf",
     +            MPI_MAX_INFO_VAL, hint, flag, err)
            if (flag) then
                bb_enable = (hint .eq. 'enable')
            endif
            call MPI_Info_free(infoused, err);
        endif

        call def_dims(ncid)
        call def_vars(ncid)
        err = APIFunc(enddef)(ncid)
        if (err .ne. NF_NOERR)
     +      call errore('APIFunc(enddef): ', err)

        do 1, i = 1, numVars
            canConvert = (var_type(i) .eq. NF_CHAR) .eqv.
     +                   (NFT_ITYPE($1) .eq. NFT_TEXT)
            if (.not.(var_rank(i) .le. MAX_RANK))
     +          stop 'assert(var_rank(i) .le. MAX_RANK)'
            if (.not.(var_nels(i) .le. MAX_NELS))
     +          stop 'assert(var_nels(i) .le. MAX_NELS)'
            do 2, j = 1, var_rank(i)
                start(j) = 1
                edge(j) = 1
2           continue
            err = iPutVara($1)(BAD_ID, i,
     +            start, edge, value,reqid(1))
            if (err .ne. NF_EBADID)
     +          call errore('bad ncid: ', err)
            err = iPutVara($1)(ncid, BAD_VARID,
     +            start, edge, value,reqid(1))
            if (err .ne. NF_ENOTVAR)
     +          call errore('bad var id: ', err)
            do 3, j = 1, var_rank(i)
                if (var_dimid(j,i) .EQ. RECDIM) goto 3 ! skip record dim
                start(j) = var_shape(j,i) + 1
                err = iPutVara($1)(ncid, i,
     +                start, edge, value,reqid(1))
                if (.not. canConvert) then
                    if (err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                else
                    if (err .ne. NF_EINVALCOORDS)
     +                  call errore('bad start: ', err)
                endif
                start(j) = 1
                edge(j) = var_shape(j,i) + 1
                err = iPutVara($1)(ncid, i,
     +                start, edge, value,reqid(1))
                if (.not. canConvert) then
                    if (err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                else
                    if (err .ne. NF_EEDGE)
     +                  call errore('bad edge: ', err)
                endif
                edge(j) = 1
3           continue

C           /* Check correct error returned even when nothing to put */
            do 4, j = 1, var_rank(i)
                  edge(j) = 0
4           continue
            err = iPutVara($1)(BAD_ID, i,
     +            start, edge, value,reqid(1))
            if (err .ne. NF_EBADID)
     +          call errore('bad ncid: ', err)
            err = iPutVara($1)(ncid, BAD_VARID,
     +            start, edge, value,reqid(1))
            if (err .ne. NF_ENOTVAR)
     +          call errore('bad var id: ', err)
            do 5, j = 1, var_rank(i)
                if (var_dimid(j,i) .EQ. RECDIM) goto 5 ! skip record dim
                start(j) = var_shape(j,i) + 1
                err = iPutVara($1)(ncid, i,
     +                start, edge, value,reqid(1))
                if (.not. canConvert) then
                    if (err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                else
#ifdef RELAX_COORD_BOUND
                    if (err .ne. NF_NOERR)
     +                  call error(ErrFunc(err))
#else
                    if (err .ne. NF_EINVALCOORDS)
     +                  call errore('bad start: ', err)
#endif
                endif
                start(j) = var_shape(j,i) + 2
                err = iPutVara($1)(ncid, i,
     +                start, edge, value,reqid(1))
                if (.not. canConvert) then
                    if (err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                else
                    if (err .ne. NF_EINVALCOORDS)
     +                  call errore('bad start: ', err)
                endif
                start(j) = 1
5           continue
            MAKE_TYPE2($1, value, 0)
            err = iPutVara($1)(ncid, i,
     +            start, edge, value, reqid(1))
            if (canConvert) then
                if (err .ne. NF_NOERR)
     +              call error(ErrFunc(err))
                err = APIFunc(wait_all)(ncid,1,reqid,st)
                if (err .ne. NF_NOERR)
     +              call error(ErrFunc(err))
                if (st(1) .ne. NF_NOERR)
     +              call error(ErrFunc(st(1)))
            else
                if (err .ne. NF_ECHAR)
     +              call errore('wrong type: ', err)
            endif
            do 6, j = 1, var_rank(i)
                  edge(j) = 1
6           continue

            !/* Choose a random point dividing each dim into 2 parts */
            !/* Put 2^rank (nslabs) slabs so defined */
            nslabs = 1
            do 7, j = 1, var_rank(i)
                mid(j) = roll( var_shape(j,i) )
                nslabs = nslabs * 2
7           continue
            !/* bits of k determine whether to put lower or upper part of dim */
            do 8, k = 1, nslabs
                nels = 1
                do 9, j = 1, var_rank(i)
                    if (mod(ud_shift(k-1, -(j-1)), 2) .eq. 1) then
                        start(j) = 1
                        edge(j) = mid(j)
                    else
                        start(j) = 1 + mid(j)
                        edge(j) = var_shape(j,i) - mid(j)
                    end if
                    nels = nels * int(edge(j))
9               continue
                allInExtRange = .true.
                do 10, j = 1, nels
                    err = index2indexes(j, var_rank(i), edge, index)
                    if (err .ne. NF_NOERR)
     +                  call error('error in index2indexes 1')
                    do 11, d = 1, var_rank(i)
                        index(d) = index(d) + start(d) - 1
11                  continue
                    val = hash_$1(var_type(i), var_rank(i),
     +                            index, NFT_ITYPE($1))
                    MAKE_TYPE2($1, VAR_ELEM($1, value, j), val)
                    val = ARITH3($1, value, j)
                    allInExtRange = allInExtRange .and.
     +                  inRange3(val, var_type(i), NFT_ITYPE($1))
10              continue
                err = iPutVara($1)(ncid, i, start,
     +                  edge, value,reqid(1))
                if (bb_enable) then
                    if (err .NE. NF_ECHAR .AND. err .NE. NF_NOERR)
     +                  call errore('iPutVara($1) : ', err)
                endif
                if (err .eq. NF_NOERR .or. err .eq. NF_ERANGE) then
                    ! NF_ERANGE is not a fatal error, still call wait
                    ! Flush the burst buffer to reveal potential error
                    err_w = APIFunc(wait_all)(ncid,1,reqid,st)
                    if (bb_enable) then
                        err = err_w
                    else
                        if (err_w .NE. NF_NOERR)
     +                      call errore('APIFunc(wait_all) : ', err)
                    end if
                endif
                if (canConvert) then
                    if (allInExtRange) then
                        if (err .ne. NF_NOERR)
     +                      call error(ErrFunc(err))
                    else
                        if (err .ne. NF_ERANGE)
     +                      call errore('range error: ', err)
                    end if
                else
                    if (nels .gt. 0 .and. err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                end if
8           continue
1       continue

        err = FileClose(ncid)
        if (err .ne. NF_NOERR)
     +      call errore('APIFunc(close): ', err)

        call check_vars_$1(scratch)

        err = FileDelete(scratch, info)
        if (err .ne. NF_NOERR)
     +      call errorc('delete of scratch file failed: ',
     +          scratch)
        end
])dnl


dnl TEST_NFMPI_IPUT_VARS(TYPE)
dnl
define([TEST_NFMPI_IPUT_VARS],dnl
[dnl
        subroutine TestFunc(vars_$1)
        implicit        none
        include "pnetcdf.inc"
#include "tests.inc"
        integer index2indexes, roll
        double precision hash_$1
        logical inRange3

        integer ncid
        integer d
        integer i
        integer j
        integer k
        integer m
        integer err, flags
        integer nels
        integer nslabs
        integer nstarts        !/* number of different starts */
        integer*8 start(MAX_RANK)
        integer*8 edge(MAX_RANK)
        integer*8 index(MAX_RANK)
        integer*8 index2(MAX_RANK)
        integer*8 mid(MAX_RANK)
        integer*8 count(MAX_RANK)
        integer*8 sstride(MAX_RANK)
        integer*8 stride(MAX_RANK)
        logical canConvert      !/* Both text or both numeric */
        logical allInExtRange   !/* all values within external range? */
        DATATYPE($1, value, (MAX_NELS))
        doubleprecision val
        integer ud_shift
        integer err_w, reqid(1), st(1), infoused
        logical flag, bb_enable
        character*(MPI_MAX_INFO_VAL) hint

        flags = IOR(NF_CLOBBER, extra_flags)
        err = FileCreate(scratch, flags)
        if (err .ne. NF_NOERR) then
            call errore('APIFunc(create): ', err)
            return
        end if

        ! Determine if burst buffer driver is being used
        bb_enable = .FALSE.
        err = nfmpi_inq_file_info(ncid, infoused)
        if (err .eq. NF_NOERR) then
            call MPI_Info_get(infoused, "nc_burst_buf",
     +            MPI_MAX_INFO_VAL, hint, flag, err)
            if (flag) then
                bb_enable = (hint .eq. 'enable')
            endif
            call MPI_Info_free(infoused, err);
        endif

        call def_dims(ncid)
        call def_vars(ncid)
        err = APIFunc(enddef)(ncid)
        if (err .ne. NF_NOERR)
     +      call errore('APIFunc(enddef): ', err)

        do 1, i = 1, numVars
            canConvert = (var_type(i) .eq. NF_CHAR) .eqv.
     +                   (NFT_ITYPE($1) .eq. NFT_TEXT)
            if (.not.(var_rank(i) .le. MAX_RANK))
     +          stop 'assert(var_rank(i) .le. MAX_RANK)'
            if (.not.(var_nels(i) .le. MAX_NELS))
     +          stop 'assert(var_nels(i) .le. MAX_NELS)'
            do 2, j = 1, var_rank(i)
                start(j) = 1
                edge(j) = 1
                stride(j) = 1
2           continue
            err = iPutVars($1)(BAD_ID, i,
     +            start, edge, stride, value,reqid(1))
            if (err .ne. NF_EBADID)
     +          call errore('bad ncid: ', err)
            err = iPutVars($1)(ncid, BAD_VARID,
     +            start, edge, stride, value,reqid(1))
            if (err .ne. NF_ENOTVAR)
     +          call errore('bad var id: ', err)
            do 3, j = 1, var_rank(i)
                if (var_dimid(j,i) .EQ. RECDIM) goto 3 ! skip record dim
                start(j) = var_shape(j,i) + 1
                err = iPutVars($1)(ncid, i,
     +                start, edge, stride, value,reqid(1))
                if (.not. canConvert) then
                    if (err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                else
                    if (err .ne. NF_EINVALCOORDS)
     +                      call errore('bad start: ', err)
                endif
                start(j) = 1
                edge(j) = var_shape(j,i) + 1
                err = iPutVars($1)(ncid, i,
     +                start, edge, stride, value,reqid(1))
                if (.not. canConvert) then
                    if (err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                else
                    if (err .ne. NF_EEDGE)
     +                  call errore('bad edge: ', err)
                endif
                edge(j) = 1
                stride(j) = 0
                err = iPutVars($1)(ncid, i,
     +                start, edge, stride, value,reqid(1))
                if (.not. canConvert) then
                    if (err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                else
                    if (err .ne. NF_ESTRIDE)
     +                  call errore('bad stride: ', err)
                endif
                stride(j) = 1
3           continue

C           /* Check correct error returned even when nothing to put */
            do 4, j = 1, var_rank(i)
                  edge(j) = 0
4           continue
            err = iPutVars($1)(BAD_ID, i,
     +            start, edge, stride, value,reqid(1))
            if (err .ne. NF_EBADID)
     +          call errore('bad ncid: ', err)
            err = iPutVars($1)(ncid, BAD_VARID,
     +            start, edge, stride, value,reqid(1))
            if (err .ne. NF_ENOTVAR)
     +          call errore('bad var id: ', err)
            do 5, j = 1, var_rank(i)
                if (var_dimid(j,i) .EQ. RECDIM) goto 5 ! skip record dim
                start(j) = var_shape(j,i) + 1
                err = iPutVars($1)(ncid, i,
     +                start, edge, stride, value,reqid(1))
                if (.not. canConvert) then
                    if (err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                else
#ifdef RELAX_COORD_BOUND
                    if (err .ne. NF_NOERR)
     +                  call error(ErrFunc(err))
#else
                    if (err .ne. NF_EINVALCOORDS)
     +                  call errore('bad start: ', err)
#endif
                endif
                start(j) = var_shape(j,i) + 2
                err = iPutVars($1)(ncid, i,
     +                start, edge, stride, value,reqid(1))
                if (.not. canConvert) then
                    if (err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                else
                    if (err .ne. NF_EINVALCOORDS)
     +                  call errore('bad start: ', err)
                endif
                start(j) = 1
5           continue
            MAKE_TYPE2($1, value, 0)
            err = iPutVars($1)(ncid, i,
     +            start, edge, stride, value, reqid(1))
            if (canConvert) then
                if (err .ne. NF_NOERR)
     +              call error(ErrFunc(err))
                err = APIFunc(wait_all)(ncid,1,reqid,st)
                if (err .ne. NF_NOERR)
     +              call error(ErrFunc(err))
                if (st(1) .ne. NF_NOERR)
     +              call error(ErrFunc(st(1)))
            else
                if (err .ne. NF_ECHAR)
     +              call errore('wrong type: ', err)
            endif
            do 6, j = 1, var_rank(i)
                  edge(j) = 1
6           continue

            !/* Choose a random point dividing each dim into 2 parts */
            !/* Put 2^rank (nslabs) slabs so defined */
            nslabs = 1
            do 7, j = 1, var_rank(i)
                mid(j) = roll( var_shape(j,i) )
                nslabs = nslabs * 2
7           continue
            !/* bits of k determine whether to put lower or upper part of dim */
            !/* choose random stride from 1 to edge */
            do 8, k = 1, nslabs
                nstarts = 1
                do 9, j = 1, var_rank(i)
                    if (mod(ud_shift(k-1, -(j-1)), 2) .eq. 1) then
                        start(j) = 1
                        edge(j) = mid(j)
                    else
                        start(j) = 1 + mid(j)
                        edge(j) = var_shape(j,i) - mid(j)
                    end if
                    if (edge(j) .gt. 0) then
                        stride(j) = 1+roll(edge(j))
                    else
                        stride(j) = 1
                    end if
                    sstride(j) = stride(j)
                    nstarts = nstarts * int(stride(j))
9               continue
                do 10, m = 1, nstarts
                    err = index2indexes(m, var_rank(i), sstride, index)
                    if (err .ne. NF_NOERR)
     +                  call error('error in index2indexes')
                    nels = 1
                    do 11, j = 1, var_rank(i)
                        count(j) = 1 + (edge(j) - index(j)) / stride(j)
                        nels = nels * int(count(j))
                        index(j) = index(j) + start(j) - 1
11                   continue
                    !/* Random choice of forward or backward */
C/* TODO
C                   if ( roll(2) ) {
C                       for (j = 1 j .lt. var_rank(i) j++) {
C                           index(j) += (count(j) - 1) * stride(j)
C                           stride(j) = -stride(j)
C                       }
C                   }
C*/
                    allInExtRange = .true.
                    do 12, j = 1, nels
                        err = index2indexes(j, var_rank(i), count,
     +                                      index2)
                        if (err .ne. NF_NOERR)
     +                      call error('error in index2indexes')
                        do 13, d = 1, var_rank(i)
                            index2(d) = index(d) +
     +                                  (index2(d)-1) * stride(d)
13                      continue
                        val = hash_$1(var_type(i), var_rank(i),
     +                                index2, NFT_ITYPE($1))
                        MAKE_TYPE2($1, VAR_ELEM($1, value, j), val)
                        val = ARITH3($1, value, j)
                        allInExtRange = allInExtRange .and.
     +                      inRange3(val, var_type(i),
     +                               NFT_ITYPE($1))
12                  continue
                    err = iPutVars($1)(ncid, i,
     +                    index, count, stride, value,reqid(1))
                    if (bb_enable) then
                        if (err .NE. NF_ECHAR .AND. err .NE. NF_NOERR)
     +                      call errore('iPutVars($1) : ',err)
                    endif
                    if (err .eq. NF_NOERR .or. err .eq. NF_ERANGE) then
                        ! NF_ERANGE is not a fatal error, still call wait
                        ! Flush the burst buffer to reveal potential error
                        err_w = APIFunc(wait_all)(ncid,1,reqid,st)
                        if (bb_enable) then
                            err = err_w
                        else
                            if (err_w .NE. NF_NOERR)
     +                          call errore('APIFunc(wait_all) : ', err)
                        end if
                    endif
                    if (canConvert) then
                        if (allInExtRange) then
                            if (st(1) .ne. NF_NOERR)
     +                          call error(ErrFunc(st(1)))
                        else
                            if (err .ne. NF_ERANGE)
     +                          call errore('range error: ', err)
                        end if
                    else
                        if (nels .gt. 0 .and. err .ne. NF_ECHAR)
     +                      call errore('wrong type: ', err)
                    end if
10               continue
8           continue
1       continue

        err = FileClose(ncid)
        if (err .ne. NF_NOERR)
     +      call errore('APIFunc(close): ', err)

        call check_vars_$1(scratch)

        err = FileDelete(scratch, info)
        if (err .ne. NF_NOERR)
     +      call errorc('delete of scratch file failed:',
     +          scratch)
        end
])dnl


dnl
dnl TEST_NFMPI_IPUT_VARM(TYPE)
dnl
define([TEST_NFMPI_IPUT_VARM],dnl
[dnl
        subroutine TestFunc(varm_$1)
        implicit        none
        include "pnetcdf.inc"
#include "tests.inc"
        integer index2indexes, roll
        double precision hash_$1
        logical inRange3

        integer ncid
        integer d
        integer i
        integer j
        integer k
        integer m
        integer err, flags
        integer nels
        integer nslabs
        integer nstarts        !/* number of different starts */
        integer*8 start(MAX_RANK)
        integer*8 edge(MAX_RANK)
        integer*8 index(MAX_RANK)
        integer*8 index2(MAX_RANK)
        integer*8 mid(MAX_RANK)
        integer*8 count(MAX_RANK)
        integer*8 sstride(MAX_RANK)
        integer*8 stride(MAX_RANK)
        integer*8 imap(MAX_RANK)
        logical canConvert      !/* Both text or both numeric */
        logical allInExtRange   !/* all values within external range? */
        DATATYPE($1, value, (MAX_NELS))
        doubleprecision val
        integer ud_shift
        integer err_w, reqid(1), st(1), infoused
        logical flag, bb_enable
        character*(MPI_MAX_INFO_VAL) hint

        flags = IOR(NF_NOCLOBBER, extra_flags)
        err = FileCreate(scratch, flags)
        if (err .ne. NF_NOERR) then
            call errore('APIFunc(create): ', err)
            return
        end if

        ! Determine if burst buffer driver is being used
        bb_enable = .FALSE.
        err = nfmpi_inq_file_info(ncid, infoused)
        if (err .eq. NF_NOERR) then
            call MPI_Info_get(infoused, "nc_burst_buf",
     +            MPI_MAX_INFO_VAL, hint, flag, err)
            if (flag) then
                bb_enable = (hint .eq. 'enable')
            endif
            call MPI_Info_free(infoused, err);
        endif

        call def_dims(ncid)
        call def_vars(ncid)
        err = APIFunc(enddef)(ncid)
        if (err .ne. NF_NOERR)
     +      call errore('APIFunc(enddef): ', err)

        do 1, i = 1, numVars
            canConvert = (var_type(i) .eq. NF_CHAR) .eqv.
     +                   (NFT_ITYPE($1) .eq. NFT_TEXT)
            if (.not.(var_rank(i) .le. MAX_RANK))
     +          stop 'assert(var_rank(i) .le. MAX_RANK)'
            if (.not.(var_nels(i) .le. MAX_NELS))
     +          stop 'assert(var_nels(i) .le. MAX_NELS)'
            do 2, j = 1, var_rank(i)
                start(j) = 1
                edge(j) = 1
                stride(j) = 1
                imap(j) = 1
2           continue
            err = iPutVarm($1)(BAD_ID, i,
     +            start, edge, stride, imap, value,reqid(1))
            if (err .ne. NF_EBADID)
     +          call errore('bad ncid: ', err)
            err = iPutVarm($1)(ncid, BAD_VARID,
     +            start, edge, stride, imap, value,reqid(1))
            if (err .ne. NF_ENOTVAR)
     +          call errore('bad var id: ', err)
            do 3, j = 1, var_rank(i)
                if (var_dimid(j,i) .EQ. RECDIM) goto 3 ! skip record dim
                start(j) = var_shape(j,i) + 1
                err = iPutVarm($1)(ncid, i,
     +                start, edge, stride, imap, value,reqid(1))
                if (.not. canConvert) then
                    if (err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                else
                    if (err .ne. NF_EINVALCOORDS)
     +                  call errore('bad start: ', err)
                endif
                start(j) = 1
                edge(j) = var_shape(j,i) + 1
                err = iPutVarm($1)(ncid, i,
     +                start, edge, stride, imap, value,reqid(1))
                if (.not. canConvert) then
                    if (err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                else
                    if (err .ne. NF_EEDGE)
     +                  call errore('bad edge: ', err)
                endif
                edge(j) = 1
                stride(j) = 0
                err = iPutVarm($1)(ncid, i,
     +                start, edge, stride, imap, value,reqid(1))
                if (.not. canConvert) then
                    if (err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                else
                    if (err .ne. NF_ESTRIDE)
     +                  call errore('bad stride: ', err)
                endif
                stride(j) = 1
3           continue

C           /* Check correct error returned even when nothing to put */
            do 4, j = 1, var_rank(i)
                  edge(j) = 0
4           continue
            err = iPutVarm($1)(BAD_ID, i,
     +            start, edge, stride, imap, value,reqid(1))
            if (err .ne. NF_EBADID)
     +          call errore('bad ncid: ', err)
            err = iPutVarm($1)(ncid, BAD_VARID,
     +            start, edge, stride, imap, value,reqid(1))
            if (err .ne. NF_ENOTVAR)
     +          call errore('bad var id: ', err)
            do 5, j = 1, var_rank(i)
                if (var_dimid(j,i) .EQ. RECDIM) goto 5 ! skip record dim
                start(j) = var_shape(j,i) + 1
                err = iPutVarm($1)(ncid, i,
     +                start, edge, stride, imap, value,reqid(1))
                if (.not. canConvert) then
                    if (err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                else
#ifdef RELAX_COORD_BOUND
                    if (err .ne. NF_NOERR)
     +                  call error(ErrFunc(err))
#else
                    if (err .ne. NF_EINVALCOORDS)
     +                  call errore('bad start: ', err)
#endif
                endif
                start(j) = var_shape(j,i) + 2
                err = iPutVarm($1)(ncid, i,
     +                start, edge, stride, imap, value,reqid(1))
                if (.not. canConvert) then
                    if (err .ne. NF_ECHAR)
     +                  call errore('wrong type: ', err)
                else
                    if (err .ne. NF_EINVALCOORDS)
     +                  call errore('bad start: ', err)
                endif
                start(j) = 1
5           continue
            MAKE_TYPE2($1, value, 0)
            err = iPutVarm($1)(ncid, i,
     +            start, edge, stride, imap, value, reqid(1))
            if (canConvert) then
                if (err .ne. NF_NOERR)
     +              call error(ErrFunc(err))
                err = APIFunc(wait_all)(ncid,1,reqid,st)
                if (err .ne. NF_NOERR)
     +              call error(ErrFunc(err))
                if (st(1) .ne. NF_NOERR)
     +              call error(ErrFunc(st(1)))
            else
                if (err .ne. NF_ECHAR)
     +              call errore('wrong type: ', err)
            endif
            do 6, j = 1, var_rank(i)
                  edge(j) = 1
6           continue

            !/* Choose a random point dividing each dim into 2 parts */
            !/* Put 2^rank (nslabs) slabs so defined */
            nslabs = 1
            do 7, j = 1, var_rank(i)
                mid(j) = roll( var_shape(j,i) )
                nslabs = nslabs * 2
7           continue
            !/* bits of k determine whether to put lower or upper part of dim */
            !/* choose random stride from 1 to edge */
            do 8, k = 1, nslabs
                nstarts = 1
                do 9, j = 1, var_rank(i)
                    if (mod(ud_shift(k-1, -(j-1)), 2) .eq. 1) then
                        start(j) = 1
                        edge(j) = mid(j)
                    else
                        start(j) = 1 + mid(j)
                        edge(j) = var_shape(j,i) - mid(j)
                    end if
                    if (edge(j) .gt. 0) then
                        stride(j) = 1+roll(edge(j))
                    else
                        stride(j) = 1
                    end if
                    sstride(j) = stride(j)
                    nstarts = nstarts * int(stride(j))
9               continue
                do 10, m = 1, nstarts
                    err = index2indexes(m, var_rank(i), sstride, index)
                    if (err .ne. NF_NOERR)
     +                  call error('error in index2indexes')
                    nels = 1
                    do 11, j = 1, var_rank(i)
                        count(j) = 1 + (edge(j) - index(j)) / stride(j)
                        nels = nels * int(count(j))
                        index(j) = index(j) + start(j) - 1
11                  continue
                    !/* Random choice of forward or backward */
C/* TODO
C                   if ( roll(2) ) then
C                       do 12, j = 1, var_rank(i)
C                           index(j) = index(j) +
C     +                         (count(j) - 1) * stride(j)
C                           stride(j) = -stride(j)
C12                     continue
C                   end if
C*/
                    if (var_rank(i) .gt. 0) then
                        imap(1) = 1
                        do 13, j = 2, var_rank(i)
                            imap(j) = imap(j-1) * count(j-1)
13                      continue
                    end if
                    allInExtRange = .true.
                    do 14 j = 1, nels
                        err = index2indexes(j, var_rank(i), count,
     +                                      index2)
                        if (err .ne. NF_NOERR)
     +                      call error('error in index2indexes')
                        do 15, d = 1, var_rank(i)
                            index2(d) = index(d) +
     +                          (index2(d)-1) * stride(d)
15                      continue
                        val = hash_$1(var_type(i),var_rank(i),
     +                                index2, NFT_ITYPE($1))
                        MAKE_TYPE2($1, VAR_ELEM($1, value, j), val)
                        val = ARITH3($1, value, j)
                        allInExtRange = allInExtRange .and.
     +                      inRange3(val, var_type(i),
     +                               NFT_ITYPE($1))
14                  continue
                    err = iPutVarm($1)(ncid,i,
     +                   index,count, stride,imap, value,reqid(1))
                    if (bb_enable) then
                        if (err .NE. NF_ECHAR .AND. err .NE. NF_NOERR)
     +                      call errore('iPutVarm($1) : ',err)
                    endif
                    if (err .eq. NF_NOERR .or. err .eq. NF_ERANGE) then
                        ! NF_ERANGE is not a fatal error, still call wait
                        ! Flush the burst buffer to reveal potential error
                        err_w = APIFunc(wait_all)(ncid,1,reqid,st)
                        if (bb_enable) then
                            err = err_w
                        else
                            if (err_w .NE. NF_NOERR)
     +                          call errore('APIFunc(wait_all) : ', err)
                        end if
                    endif
                    if (canConvert) then
                        if (allInExtRange) then
                            if (st(1) .ne. NF_NOERR)
     +                          call error(ErrFunc(st(1)))
                        else
                            if (err .ne. NF_ERANGE)
     +                          call errore('range error: ', err)
                        end if
                    else
                        if (nels .gt. 0 .and. err .ne. NF_ECHAR)
     +                      call errore('wrong type: ', err)
                    end if
10              continue
8           continue
1       continue

        err = FileClose(ncid)
        if (err .ne. NF_NOERR)
     +      call errore('APIFunc(close): ', err)

        call check_vars_$1(scratch)

        err = FileDelete(scratch, info)
        if (err .ne. NF_NOERR)
     +      call errorc('delete of scratch file failed:',
     +          scratch)
        end
])dnl


dnl divert(0)dnl

TEST_NFMPI_IPUT_VAR1(text)
#ifdef NF_INT1_T
TEST_NFMPI_IPUT_VAR1(int1)
#endif
#ifdef NF_INT2_T
TEST_NFMPI_IPUT_VAR1(int2)
#endif
TEST_NFMPI_IPUT_VAR1(int)
TEST_NFMPI_IPUT_VAR1(int8)
TEST_NFMPI_IPUT_VAR1(real)
TEST_NFMPI_IPUT_VAR1(double)

TEST_NFMPI_IPUT_VAR(text)
#ifdef NF_INT1_T
TEST_NFMPI_IPUT_VAR(int1)
#endif
#ifdef NF_INT2_T
TEST_NFMPI_IPUT_VAR(int2)
#endif
TEST_NFMPI_IPUT_VAR(int)
TEST_NFMPI_IPUT_VAR(int8)
TEST_NFMPI_IPUT_VAR(real)
TEST_NFMPI_IPUT_VAR(double)

TEST_NFMPI_IPUT_VARA(text)
#ifdef NF_INT1_T
TEST_NFMPI_IPUT_VARA(int1)
#endif
#ifdef NF_INT2_T
TEST_NFMPI_IPUT_VARA(int2)
#endif
TEST_NFMPI_IPUT_VARA(int)
TEST_NFMPI_IPUT_VARA(int8)
TEST_NFMPI_IPUT_VARA(real)
TEST_NFMPI_IPUT_VARA(double)

TEST_NFMPI_IPUT_VARS(text)
#ifdef NF_INT1_T
TEST_NFMPI_IPUT_VARS(int1)
#endif
#ifdef NF_INT2_T
TEST_NFMPI_IPUT_VARS(int2)
#endif
TEST_NFMPI_IPUT_VARS(int)
TEST_NFMPI_IPUT_VARS(int8)
TEST_NFMPI_IPUT_VARS(real)
TEST_NFMPI_IPUT_VARS(double)

TEST_NFMPI_IPUT_VARM(text)
#ifdef NF_INT1_T
TEST_NFMPI_IPUT_VARM(int1)
#endif
#ifdef NF_INT2_T
TEST_NFMPI_IPUT_VARM(int2)
#endif
TEST_NFMPI_IPUT_VARM(int)
TEST_NFMPI_IPUT_VARM(int8)
TEST_NFMPI_IPUT_VARM(real)
TEST_NFMPI_IPUT_VARM(double)
