###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mmc-wizard MDVA-2010:096-1 (mmc-wizard)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830947);
  script_version("$Revision: 7452 $: 1.0");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDVA", value: "2010:096-1");
  script_name("Mandriva Update for mmc-wizard MDVA-2010:096-1 (mmc-wizard)");
  desc = "

  Vulnerability Insight:

  Revert third party integration for now as some issues were discovered.
  
  Update:
  
  The mmc-wizard-1.0-13.10mdvmes5 update packages brought new
  unresolved dependancies wich prevented it from installing using
  MandrivaUpdate. This advisory resolves this problem by providing the
  missing packages.

  Affected Software/OS:
  mmc-wizard on Mandriva Enterprise Server 5,
  Mandriva Enterprise Server 5/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-03/msg00019.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mmc-wizard");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_mes5")
{

  if(isrpmvuln(pkg:"libcap2", rpm:"libcap2~2.10~1.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcap-devel", rpm:"libcap-devel~2.10~1.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcap-utils", rpm:"libcap-utils~2.10~1.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pam_cap", rpm:"pam_cap~2.10~1.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-pear-Console_ProgressBar", rpm:"php-pear-Console_ProgressBar~0.2~10.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-pear-HTTP_Request", rpm:"php-pear-HTTP_Request~1.4.3~1.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-pear-Net_URL", rpm:"php-pear-Net_URL~1.0.15~1.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcap", rpm:"libcap~2.10~1.1mdvmes2009.0", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cap2", rpm:"lib64cap2~2.10~1.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64cap-devel", rpm:"lib64cap-devel~2.10~1.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
