###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for ekiga FEDORA-2007-263
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861295);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-263");
  script_name( "Fedora Update for ekiga FEDORA-2007-263");
  desc = "

  Vulnerability Insight:
  Ekiga is a tool to communicate with video and audio over the internet.
  It uses the standard SIP and H323 protocols.


  Affected Software/OS:
  ekiga on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-February/msg00120.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of ekiga");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"ekiga", rpm:"ekiga~2.0.5~2.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/ekiga", rpm:"x86_64/ekiga~2.0.5~2.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/ekiga-debuginfo", rpm:"x86_64/debug/ekiga-debuginfo~2.0.5~2.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/ekiga", rpm:"i386/ekiga~2.0.5~2.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/ekiga-debuginfo", rpm:"i386/debug/ekiga-debuginfo~2.0.5~2.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}