---
id: fast-foundation.optional
title: optional variable
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [optional](./fast-foundation.optional.md)

## optional variable

A decorator that allows you to optionally inject a dependency depending on whether the \[\[`Key`<!-- -->\]\] is present, for example:

<b>Signature:</b>

```typescript
optional: (key: any) => any
```

## Example 1


```ts
class Foo {
  constructor( @inject('mystring') public str: string = 'somestring' )
}
container.get(Foo); // throws

```
would fail

## Example 2


```ts
class Foo {
  constructor( @optional('mystring') public str: string = 'somestring' )
}
container.get(Foo).str // somestring

```
if you use it without a default it will inject `undefined`<!-- -->, so remember to mark your input type as possibly `undefined`<!-- -->!
