// Type definitions for node-emoji 1.8
// Project: https://github.com/omnidan/node-emoji#readme
// Definitions by: Tristan Jones <https://github.com/jonestristand>
//                 styu <https://github.com/styu>
//                 rimiti <https://github.com/rimiti>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped

export const emoji: {
    "+1": string;
    "-1": string;
    "100": string;
    "1234": string;
    "8ball": string;
    a: string;
    ab: string;
    abc: string;
    abcd: string;
    accept: string;
    admission_tickets: string;
    aerial_tramway: string;
    airplane: string;
    airplane_arriving: string;
    airplane_departure: string;
    alarm_clock: string;
    alembic: string;
    alien: string;
    ambulance: string;
    amphora: string;
    anchor: string;
    angel: string;
    anger: string;
    angry: string;
    anguished: string;
    ant: string;
    apple: string;
    aquarius: string;
    aries: string;
    arrow_backward: string;
    arrow_double_down: string;
    arrow_double_up: string;
    arrow_down: string;
    arrow_down_small: string;
    arrow_forward: string;
    arrow_heading_down: string;
    arrow_heading_up: string;
    arrow_left: string;
    arrow_lower_left: string;
    arrow_lower_right: string;
    arrow_right: string;
    arrow_right_hook: string;
    arrow_up: string;
    arrow_up_down: string;
    arrow_up_small: string;
    arrow_upper_left: string;
    arrow_upper_right: string;
    arrows_clockwise: string;
    arrows_counterclockwise: string;
    art: string;
    articulated_lorry: string;
    astonished: string;
    athletic_shoe: string;
    atm: string;
    atom_symbol: string;
    b: string;
    baby: string;
    baby_bottle: string;
    baby_chick: string;
    baby_symbol: string;
    back: string;
    badminton_racquet_and_shuttlecock: string;
    baggage_claim: string;
    balloon: string;
    ballot_box_with_ballot: string;
    ballot_box_with_check: string;
    bamboo: string;
    banana: string;
    bangbang: string;
    bank: string;
    bar_chart: string;
    barber: string;
    barely_sunny: string;
    baseball: string;
    basketball: string;
    bath: string;
    bathtub: string;
    battery: string;
    beach_with_umbrella: string;
    bear: string;
    bed: string;
    bee: string;
    beer: string;
    beers: string;
    beetle: string;
    beginner: string;
    bell: string;
    bellhop_bell: string;
    bento: string;
    bicyclist: string;
    bike: string;
    bikini: string;
    biohazard_sign: string;
    bird: string;
    birthday: string;
    black_circle: string;
    black_circle_for_record: string;
    black_joker: string;
    black_large_square: string;
    black_left_pointing_double_triangle_with_vertical_bar: string;
    black_medium_small_square: string;
    black_medium_square: string;
    black_nib: string;
    black_right_pointing_double_triangle_with_vertical_bar: string;
    black_right_pointing_triangle_with_double_vertical_bar: string;
    black_small_square: string;
    black_square_button: string;
    black_square_for_stop: string;
    blossom: string;
    blowfish: string;
    blue_book: string;
    blue_car: string;
    blue_heart: string;
    blush: string;
    boar: string;
    boat: string;
    bomb: string;
    book: string;
    bookmark: string;
    bookmark_tabs: string;
    books: string;
    boom: string;
    boot: string;
    bouquet: string;
    bow: string;
    bow_and_arrow: string;
    bowling: string;
    boy: string;
    bread: string;
    bride_with_veil: string;
    bridge_at_night: string;
    briefcase: string;
    broken_heart: string;
    bug: string;
    building_construction: string;
    bulb: string;
    bullettrain_front: string;
    bullettrain_side: string;
    burrito: string;
    bus: string;
    busstop: string;
    bust_in_silhouette: string;
    busts_in_silhouette: string;
    cactus: string;
    cake: string;
    calendar: string;
    calling: string;
    camel: string;
    camera: string;
    camera_with_flash: string;
    camping: string;
    cancer: string;
    candle: string;
    candy: string;
    capital_abcd: string;
    capricorn: string;
    car: string;
    card_file_box: string;
    card_index: string;
    card_index_dividers: string;
    carousel_horse: string;
    cat: string;
    cat2: string;
    cd: string;
    chains: string;
    champagne: string;
    chart: string;
    chart_with_downwards_trend: string;
    chart_with_upwards_trend: string;
    checkered_flag: string;
    cheese_wedge: string;
    cherries: string;
    cherry_blossom: string;
    chestnut: string;
    chicken: string;
    children_crossing: string;
    chipmunk: string;
    chocolate_bar: string;
    christmas_tree: string;
    church: string;
    cinema: string;
    circus_tent: string;
    city_sunrise: string;
    city_sunset: string;
    cityscape: string;
    cl: string;
    clap: string;
    clapper: string;
    classical_building: string;
    clipboard: string;
    clock1: string;
    clock10: string;
    clock1030: string;
    clock11: string;
    clock1130: string;
    clock12: string;
    clock1230: string;
    clock130: string;
    clock2: string;
    clock230: string;
    clock3: string;
    clock330: string;
    clock4: string;
    clock430: string;
    clock5: string;
    clock530: string;
    clock6: string;
    clock630: string;
    clock7: string;
    clock730: string;
    clock8: string;
    clock830: string;
    clock9: string;
    clock930: string;
    closed_book: string;
    closed_lock_with_key: string;
    closed_umbrella: string;
    cloud: string;
    clubs: string;
    cn: string;
    cocktail: string;
    coffee: string;
    coffin: string;
    cold_sweat: string;
    collision: string;
    comet: string;
    compression: string;
    computer: string;
    confetti_ball: string;
    confounded: string;
    confused: string;
    congratulations: string;
    construction: string;
    construction_worker: string;
    control_knobs: string;
    convenience_store: string;
    cookie: string;
    cool: string;
    cop: string;
    copyright: string;
    corn: string;
    couch_and_lamp: string;
    couple: string;
    couple_with_heart: string;
    couplekiss: string;
    cow: string;
    cow2: string;
    crab: string;
    credit_card: string;
    crescent_moon: string;
    cricket_bat_and_ball: string;
    crocodile: string;
    crossed_flags: string;
    crossed_swords: string;
    crown: string;
    cry: string;
    crying_cat_face: string;
    crystal_ball: string;
    cupid: string;
    curly_loop: string;
    currency_exchange: string;
    curry: string;
    custard: string;
    customs: string;
    cyclone: string;
    dagger_knife: string;
    dancer: string;
    dancers: string;
    dango: string;
    dark_sunglasses: string;
    dart: string;
    dash: string;
    date: string;
    de: string;
    deciduous_tree: string;
    department_store: string;
    derelict_house_building: string;
    desert: string;
    desert_island: string;
    desktop_computer: string;
    diamond_shape_with_a_dot_inside: string;
    diamonds: string;
    disappointed: string;
    disappointed_relieved: string;
    dizzy: string;
    dizzy_face: string;
    do_not_litter: string;
    dog: string;
    dog2: string;
    dollar: string;
    dolls: string;
    dolphin: string;
    door: string;
    double_vertical_bar: string;
    doughnut: string;
    dove_of_peace: string;
    dragon: string;
    dragon_face: string;
    dress: string;
    dromedary_camel: string;
    droplet: string;
    dvd: string;
    "e-mail": string;
    ear: string;
    ear_of_rice: string;
    earth_africa: string;
    earth_americas: string;
    earth_asia: string;
    egg: string;
    eggplant: string;
    eight: string;
    eight_pointed_black_star: string;
    eight_spoked_asterisk: string;
    electric_plug: string;
    elephant: string;
    email: string;
    end: string;
    envelope: string;
    envelope_with_arrow: string;
    es: string;
    euro: string;
    european_castle: string;
    european_post_office: string;
    evergreen_tree: string;
    exclamation: string;
    expressionless: string;
    eye: string;
    eyeglasses: string;
    eyes: string;
    face_with_head_bandage: string;
    face_with_rolling_eyes: string;
    face_with_thermometer: string;
    facepunch: string;
    factory: string;
    fallen_leaf: string;
    family: string;
    fast_forward: string;
    fax: string;
    fearful: string;
    feet: string;
    ferris_wheel: string;
    ferry: string;
    field_hockey_stick_and_ball: string;
    file_cabinet: string;
    file_folder: string;
    film_frames: string;
    film_projector: string;
    fire: string;
    fire_engine: string;
    fireworks: string;
    first_quarter_moon: string;
    first_quarter_moon_with_face: string;
    fish: string;
    fish_cake: string;
    fishing_pole_and_fish: string;
    fist: string;
    five: string;
    "flag-ac": string;
    "flag-ad": string;
    "flag-ae": string;
    "flag-af": string;
    "flag-ag": string;
    "flag-ai": string;
    "flag-al": string;
    "flag-am": string;
    "flag-ao": string;
    "flag-aq": string;
    "flag-ar": string;
    "flag-as": string;
    "flag-at": string;
    "flag-au": string;
    "flag-aw": string;
    "flag-ax": string;
    "flag-az": string;
    "flag-ba": string;
    "flag-bb": string;
    "flag-bd": string;
    "flag-be": string;
    "flag-bf": string;
    "flag-bg": string;
    "flag-bh": string;
    "flag-bi": string;
    "flag-bj": string;
    "flag-bl": string;
    "flag-bm": string;
    "flag-bn": string;
    "flag-bo": string;
    "flag-bq": string;
    "flag-br": string;
    "flag-bs": string;
    "flag-bt": string;
    "flag-bv": string;
    "flag-bw": string;
    "flag-by": string;
    "flag-bz": string;
    "flag-ca": string;
    "flag-cc": string;
    "flag-cd": string;
    "flag-cf": string;
    "flag-cg": string;
    "flag-ch": string;
    "flag-ci": string;
    "flag-ck": string;
    "flag-cl": string;
    "flag-cm": string;
    "flag-cn": string;
    "flag-co": string;
    "flag-cp": string;
    "flag-cr": string;
    "flag-cu": string;
    "flag-cv": string;
    "flag-cw": string;
    "flag-cx": string;
    "flag-cy": string;
    "flag-cz": string;
    "flag-de": string;
    "flag-dg": string;
    "flag-dj": string;
    "flag-dk": string;
    "flag-dm": string;
    "flag-do": string;
    "flag-dz": string;
    "flag-ea": string;
    "flag-ec": string;
    "flag-ee": string;
    "flag-eg": string;
    "flag-eh": string;
    "flag-er": string;
    "flag-es": string;
    "flag-et": string;
    "flag-eu": string;
    "flag-fi": string;
    "flag-fj": string;
    "flag-fk": string;
    "flag-fm": string;
    "flag-fo": string;
    "flag-fr": string;
    "flag-ga": string;
    "flag-gb": string;
    "flag-gd": string;
    "flag-ge": string;
    "flag-gf": string;
    "flag-gg": string;
    "flag-gh": string;
    "flag-gi": string;
    "flag-gl": string;
    "flag-gm": string;
    "flag-gn": string;
    "flag-gp": string;
    "flag-gq": string;
    "flag-gr": string;
    "flag-gs": string;
    "flag-gt": string;
    "flag-gu": string;
    "flag-gw": string;
    "flag-gy": string;
    "flag-hk": string;
    "flag-hm": string;
    "flag-hn": string;
    "flag-hr": string;
    "flag-ht": string;
    "flag-hu": string;
    "flag-ic": string;
    "flag-id": string;
    "flag-ie": string;
    "flag-il": string;
    "flag-im": string;
    "flag-in": string;
    "flag-io": string;
    "flag-iq": string;
    "flag-ir": string;
    "flag-is": string;
    "flag-it": string;
    "flag-je": string;
    "flag-jm": string;
    "flag-jo": string;
    "flag-jp": string;
    "flag-ke": string;
    "flag-kg": string;
    "flag-kh": string;
    "flag-ki": string;
    "flag-km": string;
    "flag-kn": string;
    "flag-kp": string;
    "flag-kr": string;
    "flag-kw": string;
    "flag-ky": string;
    "flag-kz": string;
    "flag-la": string;
    "flag-lb": string;
    "flag-lc": string;
    "flag-li": string;
    "flag-lk": string;
    "flag-lr": string;
    "flag-ls": string;
    "flag-lt": string;
    "flag-lu": string;
    "flag-lv": string;
    "flag-ly": string;
    "flag-ma": string;
    "flag-mc": string;
    "flag-md": string;
    "flag-me": string;
    "flag-mf": string;
    "flag-mg": string;
    "flag-mh": string;
    "flag-mk": string;
    "flag-ml": string;
    "flag-mm": string;
    "flag-mn": string;
    "flag-mo": string;
    "flag-mp": string;
    "flag-mq": string;
    "flag-mr": string;
    "flag-ms": string;
    "flag-mt": string;
    "flag-mu": string;
    "flag-mv": string;
    "flag-mw": string;
    "flag-mx": string;
    "flag-my": string;
    "flag-mz": string;
    "flag-na": string;
    "flag-nc": string;
    "flag-ne": string;
    "flag-nf": string;
    "flag-ng": string;
    "flag-ni": string;
    "flag-nl": string;
    "flag-no": string;
    "flag-np": string;
    "flag-nr": string;
    "flag-nu": string;
    "flag-nz": string;
    "flag-om": string;
    "flag-pa": string;
    "flag-pe": string;
    "flag-pf": string;
    "flag-pg": string;
    "flag-ph": string;
    "flag-pk": string;
    "flag-pl": string;
    "flag-pm": string;
    "flag-pn": string;
    "flag-pr": string;
    "flag-ps": string;
    "flag-pt": string;
    "flag-pw": string;
    "flag-py": string;
    "flag-qa": string;
    "flag-re": string;
    "flag-ro": string;
    "flag-rs": string;
    "flag-ru": string;
    "flag-rw": string;
    "flag-sa": string;
    "flag-sb": string;
    "flag-sc": string;
    "flag-sd": string;
    "flag-se": string;
    "flag-sg": string;
    "flag-sh": string;
    "flag-si": string;
    "flag-sj": string;
    "flag-sk": string;
    "flag-sl": string;
    "flag-sm": string;
    "flag-sn": string;
    "flag-so": string;
    "flag-sr": string;
    "flag-ss": string;
    "flag-st": string;
    "flag-sv": string;
    "flag-sx": string;
    "flag-sy": string;
    "flag-sz": string;
    "flag-ta": string;
    "flag-tc": string;
    "flag-td": string;
    "flag-tf": string;
    "flag-tg": string;
    "flag-th": string;
    "flag-tj": string;
    "flag-tk": string;
    "flag-tl": string;
    "flag-tm": string;
    "flag-tn": string;
    "flag-to": string;
    "flag-tr": string;
    "flag-tt": string;
    "flag-tv": string;
    "flag-tw": string;
    "flag-tz": string;
    "flag-ua": string;
    "flag-ug": string;
    "flag-um": string;
    "flag-us": string;
    "flag-uy": string;
    "flag-uz": string;
    "flag-va": string;
    "flag-vc": string;
    "flag-ve": string;
    "flag-vg": string;
    "flag-vi": string;
    "flag-vn": string;
    "flag-vu": string;
    "flag-wf": string;
    "flag-ws": string;
    "flag-xk": string;
    "flag-ye": string;
    "flag-yt": string;
    "flag-za": string;
    "flag-zm": string;
    "flag-zw": string;
    flags: string;
    flashlight: string;
    fleur_de_lis: string;
    flipper: string;
    floppy_disk: string;
    flower_playing_cards: string;
    flushed: string;
    fog: string;
    foggy: string;
    football: string;
    footprints: string;
    fork_and_knife: string;
    fountain: string;
    four: string;
    four_leaf_clover: string;
    fr: string;
    frame_with_picture: string;
    free: string;
    fried_shrimp: string;
    fries: string;
    frog: string;
    frowning: string;
    fuelpump: string;
    full_moon: string;
    full_moon_with_face: string;
    funeral_urn: string;
    game_die: string;
    gb: string;
    gear: string;
    gem: string;
    gemini: string;
    ghost: string;
    gift: string;
    gift_heart: string;
    girl: string;
    globe_with_meridians: string;
    goat: string;
    golf: string;
    golfer: string;
    grapes: string;
    green_apple: string;
    green_book: string;
    green_heart: string;
    grey_exclamation: string;
    grey_question: string;
    grimacing: string;
    grin: string;
    grinning: string;
    guardsman: string;
    guitar: string;
    gun: string;
    haircut: string;
    hamburger: string;
    hammer: string;
    hammer_and_pick: string;
    hammer_and_wrench: string;
    hamster: string;
    hand: string;
    handbag: string;
    hankey: string;
    hash: string;
    hatched_chick: string;
    hatching_chick: string;
    headphones: string;
    hear_no_evil: string;
    heart: string;
    heart_decoration: string;
    heart_eyes: string;
    heart_eyes_cat: string;
    heartbeat: string;
    heartpulse: string;
    hearts: string;
    heavy_check_mark: string;
    heavy_division_sign: string;
    heavy_dollar_sign: string;
    heavy_exclamation_mark: string;
    heavy_heart_exclamation_mark_ornament: string;
    heavy_minus_sign: string;
    heavy_multiplication_x: string;
    heavy_plus_sign: string;
    helicopter: string;
    helmet_with_white_cross: string;
    herb: string;
    hibiscus: string;
    high_brightness: string;
    high_heel: string;
    hocho: string;
    hole: string;
    honey_pot: string;
    honeybee: string;
    horse: string;
    horse_racing: string;
    hospital: string;
    hot_pepper: string;
    hotdog: string;
    hotel: string;
    hotsprings: string;
    hourglass: string;
    hourglass_flowing_sand: string;
    house: string;
    house_buildings: string;
    house_with_garden: string;
    hugging_face: string;
    hushed: string;
    ice_cream: string;
    ice_hockey_stick_and_puck: string;
    ice_skate: string;
    icecream: string;
    id: string;
    ideograph_advantage: string;
    imp: string;
    inbox_tray: string;
    incoming_envelope: string;
    information_desk_person: string;
    information_source: string;
    innocent: string;
    interrobang: string;
    iphone: string;
    it: string;
    izakaya_lantern: string;
    jack_o_lantern: string;
    japan: string;
    japanese_castle: string;
    japanese_goblin: string;
    japanese_ogre: string;
    jeans: string;
    joy: string;
    joy_cat: string;
    joystick: string;
    jp: string;
    kaaba: string;
    key: string;
    keyboard: string;
    keycap_star: string;
    keycap_ten: string;
    kimono: string;
    kiss: string;
    kissing: string;
    kissing_cat: string;
    kissing_closed_eyes: string;
    kissing_heart: string;
    kissing_smiling_eyes: string;
    knife: string;
    knife_fork_plate: string;
    koala: string;
    koko: string;
    kr: string;
    label: string;
    lantern: string;
    large_blue_circle: string;
    large_blue_diamond: string;
    large_orange_diamond: string;
    last_quarter_moon: string;
    last_quarter_moon_with_face: string;
    latin_cross: string;
    laughing: string;
    leaves: string;
    ledger: string;
    left_luggage: string;
    left_right_arrow: string;
    left_speech_bubble: string;
    leftwards_arrow_with_hook: string;
    lemon: string;
    leo: string;
    leopard: string;
    level_slider: string;
    libra: string;
    light_rail: string;
    lightning: string;
    lightning_cloud: string;
    link: string;
    linked_paperclips: string;
    lion_face: string;
    lips: string;
    lipstick: string;
    lock: string;
    lock_with_ink_pen: string;
    lollipop: string;
    loop: string;
    loud_sound: string;
    loudspeaker: string;
    love_hotel: string;
    love_letter: string;
    low_brightness: string;
    lower_left_ballpoint_pen: string;
    lower_left_crayon: string;
    lower_left_fountain_pen: string;
    lower_left_paintbrush: string;
    m: string;
    mag: string;
    mag_right: string;
    mahjong: string;
    mailbox: string;
    mailbox_closed: string;
    mailbox_with_mail: string;
    mailbox_with_no_mail: string;
    man: string;
    "man-heart-man": string;
    "man-kiss-man": string;
    "man-man-boy": string;
    "man-man-boy-boy": string;
    "man-man-girl": string;
    "man-man-girl-boy": string;
    "man-man-girl-girl": string;
    "man-woman-boy": string;
    "man-woman-boy-boy": string;
    "man-woman-girl": string;
    "man-woman-girl-boy": string;
    "man-woman-girl-girl": string;
    man_and_woman_holding_hands: string;
    man_in_business_suit_levitating: string;
    man_with_gua_pi_mao: string;
    man_with_turban: string;
    mans_shoe: string;
    mantelpiece_clock: string;
    maple_leaf: string;
    mask: string;
    massage: string;
    meat_on_bone: string;
    medal: string;
    mega: string;
    melon: string;
    memo: string;
    menorah_with_nine_branches: string;
    mens: string;
    metro: string;
    microphone: string;
    microscope: string;
    middle_finger: string;
    milky_way: string;
    minibus: string;
    minidisc: string;
    mobile_phone_off: string;
    money_mouth_face: string;
    money_with_wings: string;
    moneybag: string;
    monkey: string;
    monkey_face: string;
    monorail: string;
    moon: string;
    mortar_board: string;
    mosque: string;
    mostly_sunny: string;
    motor_boat: string;
    motorway: string;
    mount_fuji: string;
    mountain: string;
    mountain_bicyclist: string;
    mountain_cableway: string;
    mountain_railway: string;
    mouse: string;
    mouse2: string;
    movie_camera: string;
    moyai: string;
    muscle: string;
    mushroom: string;
    musical_keyboard: string;
    musical_note: string;
    musical_score: string;
    mute: string;
    nail_care: string;
    name_badge: string;
    national_park: string;
    necktie: string;
    negative_squared_cross_mark: string;
    nerd_face: string;
    neutral_face: string;
    new: string;
    new_moon: string;
    new_moon_with_face: string;
    newspaper: string;
    ng: string;
    night_with_stars: string;
    nine: string;
    no_bell: string;
    no_bicycles: string;
    no_entry: string;
    no_entry_sign: string;
    no_good: string;
    no_mobile_phones: string;
    no_mouth: string;
    no_pedestrians: string;
    no_smoking: string;
    "non-potable_water": string;
    nose: string;
    notebook: string;
    notebook_with_decorative_cover: string;
    notes: string;
    nut_and_bolt: string;
    o: string;
    o2: string;
    ocean: string;
    octopus: string;
    oden: string;
    office: string;
    oil_drum: string;
    ok: string;
    ok_hand: string;
    ok_woman: string;
    old_key: string;
    older_man: string;
    older_woman: string;
    om_symbol: string;
    on: string;
    oncoming_automobile: string;
    oncoming_bus: string;
    oncoming_police_car: string;
    oncoming_taxi: string;
    one: string;
    open_book: string;
    open_file_folder: string;
    open_hands: string;
    open_mouth: string;
    ophiuchus: string;
    orange_book: string;
    orthodox_cross: string;
    outbox_tray: string;
    ox: string;
    package: string;
    page_facing_up: string;
    page_with_curl: string;
    pager: string;
    palm_tree: string;
    panda_face: string;
    paperclip: string;
    parking: string;
    part_alternation_mark: string;
    partly_sunny: string;
    partly_sunny_rain: string;
    passenger_ship: string;
    passport_control: string;
    paw_prints: string;
    peace_symbol: string;
    peach: string;
    pear: string;
    pencil: string;
    pencil2: string;
    penguin: string;
    pensive: string;
    performing_arts: string;
    persevere: string;
    person_frowning: string;
    person_with_ball: string;
    person_with_blond_hair: string;
    person_with_pouting_face: string;
    phone: string;
    pick: string;
    pig: string;
    pig2: string;
    pig_nose: string;
    pill: string;
    pineapple: string;
    pisces: string;
    pizza: string;
    place_of_worship: string;
    point_down: string;
    point_left: string;
    point_right: string;
    point_up: string;
    point_up_2: string;
    police_car: string;
    poodle: string;
    poop: string;
    popcorn: string;
    post_office: string;
    postal_horn: string;
    postbox: string;
    potable_water: string;
    pouch: string;
    poultry_leg: string;
    pound: string;
    pouting_cat: string;
    pray: string;
    prayer_beads: string;
    princess: string;
    printer: string;
    punch: string;
    purple_heart: string;
    purse: string;
    pushpin: string;
    put_litter_in_its_place: string;
    question: string;
    rabbit: string;
    rabbit2: string;
    racehorse: string;
    racing_car: string;
    racing_motorcycle: string;
    radio: string;
    radio_button: string;
    radioactive_sign: string;
    rage: string;
    railway_car: string;
    railway_track: string;
    rain_cloud: string;
    rainbow: string;
    raised_hand: string;
    raised_hand_with_fingers_splayed: string;
    raised_hands: string;
    raising_hand: string;
    ram: string;
    ramen: string;
    rat: string;
    recycle: string;
    red_car: string;
    red_circle: string;
    registered: string;
    relaxed: string;
    relieved: string;
    reminder_ribbon: string;
    repeat: string;
    repeat_one: string;
    restroom: string;
    reversed_hand_with_middle_finger_extended: string;
    revolving_hearts: string;
    rewind: string;
    ribbon: string;
    rice: string;
    rice_ball: string;
    rice_cracker: string;
    rice_scene: string;
    right_anger_bubble: string;
    ring: string;
    robot_face: string;
    rocket: string;
    rolled_up_newspaper: string;
    roller_coaster: string;
    rooster: string;
    rose: string;
    rosette: string;
    rotating_light: string;
    round_pushpin: string;
    rowboat: string;
    ru: string;
    rugby_football: string;
    runner: string;
    running: string;
    running_shirt_with_sash: string;
    sa: string;
    sagittarius: string;
    sailboat: string;
    sake: string;
    sandal: string;
    santa: string;
    satellite: string;
    satisfied: string;
    saxophone: string;
    scales: string;
    school: string;
    school_satchel: string;
    scissors: string;
    scorpion: string;
    scorpius: string;
    scream: string;
    scream_cat: string;
    scroll: string;
    seat: string;
    secret: string;
    see_no_evil: string;
    seedling: string;
    seven: string;
    shamrock: string;
    shaved_ice: string;
    sheep: string;
    shell: string;
    shield: string;
    shinto_shrine: string;
    ship: string;
    shirt: string;
    shit: string;
    shoe: string;
    shopping_bags: string;
    shower: string;
    showman: string;
    sign_of_the_horns: string;
    signal_strength: string;
    six: string;
    six_pointed_star: string;
    ski: string;
    skier: string;
    "skin-tone-2": string;
    "skin-tone-3": string;
    "skin-tone-4": string;
    "skin-tone-5": string;
    "skin-tone-6": string;
    skull: string;
    skull_and_crossbones: string;
    sleeping: string;
    sleeping_accommodation: string;
    sleepy: string;
    sleuth_or_spy: string;
    slightly_frowning_face: string;
    slightly_smiling_face: string;
    slot_machine: string;
    small_airplane: string;
    small_blue_diamond: string;
    small_orange_diamond: string;
    small_red_triangle: string;
    small_red_triangle_down: string;
    smile: string;
    smile_cat: string;
    smiley: string;
    smiley_cat: string;
    smiling_imp: string;
    smirk: string;
    smirk_cat: string;
    smoking: string;
    snail: string;
    snake: string;
    snow_capped_mountain: string;
    snow_cloud: string;
    snowboarder: string;
    snowflake: string;
    snowman: string;
    sob: string;
    soccer: string;
    soon: string;
    sos: string;
    sound: string;
    space_invader: string;
    spades: string;
    spaghetti: string;
    sparkle: string;
    sparkler: string;
    sparkles: string;
    sparkling_heart: string;
    speak_no_evil: string;
    speaker: string;
    speaking_head_in_silhouette: string;
    speech_balloon: string;
    speedboat: string;
    spider: string;
    spider_web: string;
    spiral_calendar_pad: string;
    spiral_note_pad: string;
    "spock-hand": string;
    sports_medal: string;
    stadium: string;
    star: string;
    star2: string;
    star_and_crescent: string;
    star_of_david: string;
    stars: string;
    station: string;
    statue_of_liberty: string;
    steam_locomotive: string;
    stew: string;
    stopwatch: string;
    straight_ruler: string;
    strawberry: string;
    stuck_out_tongue: string;
    stuck_out_tongue_closed_eyes: string;
    stuck_out_tongue_winking_eye: string;
    studio_microphone: string;
    sun_behind_cloud: string;
    sun_behind_rain_cloud: string;
    sun_small_cloud: string;
    sun_with_face: string;
    sunflower: string;
    sunglasses: string;
    sunny: string;
    sunrise: string;
    sunrise_over_mountains: string;
    surfer: string;
    sushi: string;
    suspension_railway: string;
    sweat: string;
    sweat_drops: string;
    sweat_smile: string;
    sweet_potato: string;
    swimmer: string;
    symbols: string;
    synagogue: string;
    syringe: string;
    table_tennis_paddle_and_ball: string;
    taco: string;
    tada: string;
    tanabata_tree: string;
    tangerine: string;
    taurus: string;
    taxi: string;
    tea: string;
    telephone: string;
    telephone_receiver: string;
    telescope: string;
    tennis: string;
    tent: string;
    the_horns: string;
    thermometer: string;
    thinking_face: string;
    thought_balloon: string;
    three: string;
    three_button_mouse: string;
    thumbsdown: string;
    thumbsup: string;
    thunder_cloud_and_rain: string;
    ticket: string;
    tiger: string;
    tiger2: string;
    timer_clock: string;
    tired_face: string;
    tm: string;
    toilet: string;
    tokyo_tower: string;
    tomato: string;
    tongue: string;
    top: string;
    tophat: string;
    tornado: string;
    tornado_cloud: string;
    trackball: string;
    tractor: string;
    traffic_light: string;
    train: string;
    train2: string;
    tram: string;
    triangular_flag_on_post: string;
    triangular_ruler: string;
    trident: string;
    triumph: string;
    trolleybus: string;
    trophy: string;
    tropical_drink: string;
    tropical_fish: string;
    truck: string;
    trumpet: string;
    tshirt: string;
    tulip: string;
    turkey: string;
    turtle: string;
    tv: string;
    twisted_rightwards_arrows: string;
    two: string;
    two_hearts: string;
    two_men_holding_hands: string;
    two_women_holding_hands: string;
    u5272: string;
    u5408: string;
    u55b6: string;
    u6307: string;
    u6708: string;
    u6709: string;
    u6e80: string;
    u7121: string;
    u7533: string;
    u7981: string;
    u7a7a: string;
    uk: string;
    umbrella: string;
    umbrella_on_ground: string;
    unamused: string;
    underage: string;
    unicorn_face: string;
    unlock: string;
    up: string;
    upside_down_face: string;
    us: string;
    v: string;
    vertical_traffic_light: string;
    vhs: string;
    vibration_mode: string;
    video_camera: string;
    video_game: string;
    violin: string;
    virgo: string;
    volcano: string;
    volleyball: string;
    vs: string;
    walking: string;
    waning_crescent_moon: string;
    waning_gibbous_moon: string;
    warning: string;
    wastebasket: string;
    watch: string;
    water_buffalo: string;
    watermelon: string;
    wave: string;
    waving_black_flag: string;
    waving_white_flag: string;
    wavy_dash: string;
    waxing_crescent_moon: string;
    waxing_gibbous_moon: string;
    wc: string;
    weary: string;
    wedding: string;
    weight_lifter: string;
    whale: string;
    whale2: string;
    wheel_of_dharma: string;
    wheelchair: string;
    white_check_mark: string;
    white_circle: string;
    white_flower: string;
    white_frowning_face: string;
    white_large_square: string;
    white_medium_small_square: string;
    white_medium_square: string;
    white_small_square: string;
    white_square_button: string;
    wind_blowing_face: string;
    wind_chime: string;
    wine_glass: string;
    wink: string;
    wolf: string;
    woman: string;
    "woman-heart-woman": string;
    "woman-kiss-woman": string;
    "woman-woman-boy": string;
    "woman-woman-boy-boy": string;
    "woman-woman-girl": string;
    "woman-woman-girl-boy": string;
    "woman-woman-girl-girl": string;
    womans_clothes: string;
    womans_hat: string;
    womens: string;
    world_map: string;
    worried: string;
    wrench: string;
    writing_hand: string;
    x: string;
    yellow_heart: string;
    yen: string;
    yin_yang: string;
    yum: string;
    zap: string;
    zero: string;
    zipper_mouth_face: string;
    zzz: string;
};

export interface Emoji {
    emoji: string;
    key: string;
}

export function emojify(str: string, on_missing?: (emoji_name: string) => string, format?: (code: string, name: string) => string): string;
export function get(emoji: string): string;
export function random(): Emoji;
export function search(searchTerm: string): Emoji[];
export function which(emoji_code: string): string;
export function unemojify(str: string): string;
export function find(emoji: string): Emoji;
export function hasEmoji(str: string): boolean;
export function strip(str: string): string;
export function replace(str: string, replacement: ((emoji: Emoji) => string) | string, cleanSpaces?: boolean): string;
