/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.send;

import java.io.IOException;
import java.io.OutputStream;
import org.mariadb.jdbc.internal.packet.send.AbstractAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.packet.send.InterfaceAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class SendOldPasswordAuthPacket
extends AbstractAuthSwitchSendResponsePacket
implements InterfaceAuthSwitchSendResponsePacket {
    public SendOldPasswordAuthPacket(String password, byte[] authData, int packSeq) {
        super(packSeq, authData, password);
    }

    @Override
    public void send(OutputStream os) throws IOException {
        PacketOutputStream pos = (PacketOutputStream)os;
        pos.startPacket(this.packSeq);
        pos.writeByteArray(this.cryptOldFormatPassword(this.password, new String(this.authData))).writeByte((byte)0);
        pos.finishPacket();
    }

    private byte[] cryptOldFormatPassword(String password, String seed) {
        byte[] result = new byte[seed.length()];
        if (password == null || password.length() == 0) {
            return new byte[0];
        }
        long[] seedHash = this.hashPassword(seed);
        long[] passHash = this.hashPassword(password);
        RandStruct randSeed = new RandStruct(seedHash[0] ^ passHash[0], seedHash[1] ^ passHash[1]);
        for (int i2 = 0; i2 < seed.length(); ++i2) {
            result[i2] = (byte)Math.floor(this.random(randSeed) * 31.0 + 64.0);
        }
        byte extra = (byte)Math.floor(this.random(randSeed) * 31.0);
        int i3 = 0;
        while (i3 < seed.length()) {
            int n2 = i3++;
            result[n2] = (byte)(result[n2] ^ extra);
        }
        return result;
    }

    private double random(RandStruct rand) {
        rand.seed1 = (rand.seed1 * 3L + rand.seed2) % rand.maxValue;
        rand.seed2 = (rand.seed1 + rand.seed2 + 33L) % rand.maxValue;
        double d2 = rand.seed1;
        rand.getClass();
        return d2 / 1.073741823E9;
    }

    private long[] hashPassword(String password) {
        long nr = 1345345333L;
        long nr2 = 305419889L;
        long add = 7L;
        for (int i2 = 0; i2 < password.length(); ++i2) {
            char currChar = password.charAt(i2);
            if (currChar == ' ' || currChar == '\t') continue;
            long tmp = currChar;
            nr ^= ((nr & 0x3FL) + add) * tmp + (nr << 8);
            nr2 += nr2 << 8 ^ nr;
            add += tmp;
        }
        return new long[]{nr & Integer.MAX_VALUE, nr2 & Integer.MAX_VALUE};
    }

    private class RandStruct {
        final long maxValue = 0x3FFFFFFFL;
        long seed1;
        long seed2;

        public RandStruct(long seed1, long seed2) {
            this.seed1 = seed1 % 0x3FFFFFFFL;
            this.seed2 = seed2 % 0x3FFFFFFFL;
        }
    }
}

