/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2018 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * scale vary V2.12.- based on DarkBeam's maths
 * @reference
 * http://www.fractalforums.com/mandelbulb-3d/custom-formulas-and-transforms-release-t17106/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "TransfScaleVaryV212Iteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfScaleVaryV212Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (aux->i >= fractal->transformCommon.startIterations
			&& aux->i < fractal->transformCommon.stopIterations)
	{
		if (fractal->transformCommon.functionEnabledBxFalse)
		{
			aux->actualScaleA = fabs(aux->actualScaleA);
		}
		aux->actualScaleA = mad(
			aux->actualScaleA, fractal->transformCommon.scaleVary0, fractal->transformCommon.scaleMain2);
		REAL temp = aux->actualScaleA;
		if (fractal->transformCommon.functionEnabledByFalse) // limits
		{
			if (aux->actualScaleA < fractal->transformCommon.offset0)
				temp = fractal->transformCommon.offset0;
			if (aux->actualScaleA > fractal->transformCommon.offset4)
				temp = fractal->transformCommon.offset4;
		}

		z *= temp;
		aux->DE = mad(aux->DE, fabs(temp), 1.0f);
	}

	else if (aux->i < fractal->transformCommon.startIterations)
	{
		z *= fractal->transformCommon.scaleMain2;
		aux->DE = aux->DE * fabs(fractal->transformCommon.scaleMain2 + 1.0f);
	}
	else
	{
		if (fractal->transformCommon.functionEnabledBzFalse)
		{
			aux->actualScaleA = fractal->transformCommon.scaleMain2;
		}
		z *= aux->actualScaleA;
		aux->DE = aux->DE * fabs(aux->actualScaleA + 1.0f);
	}
	return z;
}