/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once


/////////////////////// Qt includes
#include <QString>
#include <QList>
#include <QDomElement>


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

#include "MsXpS/libXpertMassCore/globals.hpp"


namespace MsXpS
{

namespace libXpertMassCore
{


class DECLSPEC ChemicalGroupRule
{
  public:
  ChemicalGroupRule(const QString &name    = QString(),
                    const QString &entity  = QString(),
                    Enums::ChemicalGroupFate fate = Enums::ChemicalGroupFate::LOST);
  ChemicalGroupRule(const ChemicalGroupRule &other);
  ~ChemicalGroupRule();

  void setEntity(const QString &entity);
  QString getEntity();

  void setName(const QString &name);
  QString getName();

  void setFate(Enums::ChemicalGroupFate);
  Enums::ChemicalGroupFate getFate();

  ChemicalGroupRule &operator = (const ChemicalGroupRule &other);
  bool validate(ErrorList *error_list_p) const;
  bool isValid() const;

  bool renderXmlElement(const QDomElement &element);

  protected:
  QString m_name;
  QString m_entity;
  Enums::ChemicalGroupFate m_chemicalGroupFate;
  mutable bool m_isValid = false;
};

typedef std::shared_ptr<ChemicalGroupRule> ChemicalGroupRuleSPtr;

} // namespace libXpertMassCore

} // namespace MsXpS
