/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2008  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
#include "syncml.h"
#include "sml_error.h"
#include "sml_error_internals.h"

#include "syncml_internals.h"

static SmlBool _smlBase64DecodeBinary(const char *input, unsigned int size, char **output, unsigned int *outsize, SmlError **error);
static SmlBool _smlBase64EncodeBinary(const char *input, unsigned int size, char **output, SmlError **error);

/* FIXME: DEPRECATED*/
SmlBool smlBase64Decode(const char *input, char **output, unsigned int *outsize, SmlError **error)
{
	smlTrace(TRACE_ENTRY, "%s(%p, %p, %p, %p)", __func__, input, output, outsize, error);
	CHECK_ERROR_REF
	smlAssert(output);
	smlAssert(outsize);
	
	if (!input) {
		*output = NULL;
		*outsize = 0;
		goto out;
	}
	
	if (!_smlBase64DecodeBinary(input, strlen(input), output, outsize, error))
		goto error;

out:
	smlTrace(TRACE_EXIT, "%s", __func__);
	return TRUE;
error:	
	smlTrace(TRACE_EXIT_ERROR, "%s: %s", __func__, smlErrorPrint(error));
	return FALSE;
}

/* FIXME: DEPRECATED*/
SmlBool smlBase64DecodeBinary(const char *input, unsigned int size, char **output, unsigned int *outsize, SmlError **error)
{
	return _smlBase64DecodeBinary(input, size, output, outsize, error);
}

/* The only reason for this internal function is
 * to avoid compiler warnings during the normal build process
 * even if the whole base64 API is deprecated.
 */
static SmlBool _smlBase64DecodeBinary(const char *input, unsigned int size, char **output, unsigned int *outsize, SmlError **error)
{
	smlTrace(TRACE_ENTRY, "%s(%p, %i, %p, %p, %p)", __func__, input, size, output, outsize, error);
	CHECK_ERROR_REF

	if (!input || !size) {
		*output = NULL;
		*outsize = 0;
		goto out;
	}

	size_t length = 0;
	*output = (char *) g_base64_decode(input, &length);
	if (length < 1) {
		smlErrorSet(error, SML_ERROR_GENERIC, "Invalid base64 input");
		goto error;
	}
	*outsize = length;

	/* This is some kind of special for libsyncml.
	 * We have to add a padding NULL byte.
	 */
	char *result = smlTryMalloc0(*outsize + 1, error);
	if (result == NULL)
		goto error;
	memcpy(result, *output, *outsize);
	g_free(*output);
	*output = result;
	*outsize = *outsize + 1;
out:
	smlTrace(TRACE_EXIT, "%s", __func__);
	return TRUE;
error:
	*output = NULL;
	*outsize = 0;
	smlTrace(TRACE_EXIT_ERROR, "%s: %s", __func__, smlErrorPrint(error));
	return FALSE;
}

/* FIXME: DEPRECATED*/
SmlBool smlBase64Encode(const char *input, char **output, SmlError **error)
{
	smlTrace(TRACE_ENTRY, "%s(%p, %p, %p)", __func__, input, output, error);
	CHECK_ERROR_REF
	smlAssert(output);
	
	if (!input) {
		*output = NULL;
		smlTrace(TRACE_EXIT, "%s", __func__);
		return TRUE;
	}
	
	if (_smlBase64EncodeBinary(input, strlen(input), output, error)) {
		smlTrace(TRACE_EXIT, "%s", __func__);
		return TRUE;
	}
	
	smlTrace(TRACE_EXIT_ERROR, "%s: %s", __func__, smlErrorPrint(error));
	return FALSE;
}
 
/* FIXME: DEPRECATED*/
SmlBool smlBase64EncodeBinary(const char *input, unsigned int size, char **output, SmlError **error)
{
	return _smlBase64EncodeBinary(input, size, output, error);
}

/* The only reason for this internal function is
 * to avoid compiler warnings during the normal build process
 * even if the whole base64 API is deprecated.
 */
static SmlBool _smlBase64EncodeBinary(const char *input, unsigned int size, char **output, SmlError **error)
{
	smlTrace(TRACE_ENTRY, "%s(%p, %i, %p, %p)", __func__, input, size, output, error);
	CHECK_ERROR_REF
	smlAssert(output);

	
	if (!input) {
		*output = NULL;
		goto out;
	}
	
	*output = g_base64_encode((const unsigned char *) input, size);
	if (!*output) {
		smlErrorSet(error, SML_ERROR_GENERIC, "Base64 encoding failed.");
		goto error;
	}
out:
	smlTrace(TRACE_EXIT, "%s", __func__);
	return TRUE;

error:
	smlTrace(TRACE_EXIT_ERROR, "%s: %s", __func__, smlErrorPrint(error));
	return FALSE;
}
