import unittest
from support import GNATCOLL_TestCase, chdir, pathsep
import glob
import os
import sys


class Test(GNATCOLL_TestCase):
    @chdir("traces1")
    def test_traces1(self):
        self.gprbuild()
        self.runexec("obj/traces1", "traces1.out")

        # Check that we do not link with python
        if sys.platform.find("linux") != -1:
            out = self.runexec(["ldd", "obj/traces1"])
            self.assertEqual(-1, out.find("libpython"),
                             "Should not link with python")

            out = self.runexec(["nm", "obj/traces1"])
            self.assertEqual(-1, out.find("Py"),
                             "Should not have python symbols")

    @chdir("traces2")
    def test_traces2(self):
        self.unlink_if_exists("outfile")
        self.gprbuild()
        self.runexec("obj/traces2", "traces2.out")
        self.diff(expected="outfile.out", actual=file("outfile").read())

    @chdir("traces4")
    def test_append_to_file(self):
        self.unlink_if_exists("traces4.out")
        self.unlink_if_exists("traces4.out2")
        self.gprbuild()
        self.runexec("obj/traces4", "")

        # Run a second time to test when we append to an existing file
        self.runexec("obj/traces4", "")
        self.diff(expected="traces4.expected",
                  actual=file("traces4.out").read())

    @chdir("wildcard")
    def test_wildcard(self):
        self.gprbuild()
        self.runexec("obj/wildcard", "")
        self.diff(expected="wildcard.expected",
                  actual=file("wildcard.out").read())
        self.diff(expected="wildcard.expected2",
                  actual=file("wildcard.out2").read())

    @chdir("L320-007")
    def test_L320_007(self):
        self.gprbuild()
        self.runexec("obj/main", "SUCCESS")

    @chdir("L401-004")
    def test_L401_004(self):
        self.gprbuild()
        self.runexec("obj/main", "test.out")

    @chdir("MA08-038")
    def test_MA08_038(self):
        self.gprbuild()
        self.runexec("nofile", "")

    @chdir("blocks")
    def test_blocks(self):
        self.gprbuild()
        self.runexec("obj/test_block", "test.out")

    @chdir("O523-004")
    def test_O523_004(self):
        self.gprbuild()
        os.environ['FOO'] = 'BAR'
        map(os.unlink, glob.glob("log_*"))
        self.unlink_if_exists("tracename.pid")
        self.runexec("obj/tracename", "")
        pid = int(open('tracename.pid').readline())
        for pat in ['log_pid.%d' % pid,
                    'log_D.[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]',
                    'log_T.[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]' +
                    'T[0-9][0-9][0-9][0-9][0-9][0-9]',
                    'log_FOO.BAR']:
            files = glob.glob(pat)
            self.assertEqual(len(files), 1,
                             "expected 1 file matching %s, found %d"
                             % (pat, len(files)))
            fnam = files[0]
            self.assert_("hello from %d" % pid in open(fnam).readline(),
                         "Marker not found in %s" % fnam)

    @chdir("predecorator")
    def test_Q124_002(self):
        self.gprbuild()
        self.runexec("obj/predec", "test.out")
