# LCMS2_INCLUDE_DIR = fftw3.h
# LCMS2_LIBRARIES = libfftw3.a
# LCMS2_FOUND = true if FFTW3 is found

IF(LCMS2_INCLUDE_DIRS)
  FIND_PATH(LCMS2_INCLUDE_DIR lcms2.h ${LCMS2_INCLUDE_DIRS})
  FIND_LIBRARY(LCMS2_LIBRARY  lcms2 ${LCMS2_LIBRARY_DIRS})
ELSE(LCMS2_INCLUDE_DIRS)
    SET(TRIAL_PATHS
      $ENV{LCMS2_HOME}/include
      /usr/include
      /usr/local/include
      /opt/include
      /usr/apps/include
      /opt/local
    )

    SET(TRIAL_LIBRARY_PATHS
      $ENV{LCMS2_HOME}/lib
      /usr/lib
      /usr/local/lib
      /opt/lib
      /sw/lib
      /opt/local
      )

  FIND_PATH(LCMS2_INCLUDE_DIR lcms2.h ${TRIAL_PATHS})
  FIND_LIBRARY(LCMS2_LIBRARIES lcms2 ${TRIAL_LIBRARY_PATHS})
ENDIF(LCMS2_INCLUDE_DIRS)


IF(LCMS2_INCLUDE_DIR AND LCMS2_LIBRARIES)
  SET(LCMS2_FOUND TRUE)
ELSE()
  SET(LCMS2_FOUND FALSE)
ENDIF()

IF(LCMS2_FOUND)
  SET(LCMS2_LIBRARIES ${LCMS2_LIBRARIES})

  MESSAGE(STATUS "Found LCMS2 (LCMS2_INCLUDE_DIR = ${LCMS2_INCLUDE_DIR})")
  MESSAGE(STATUS "Found LCMS2 (LCMS2_LIBRARIES = ${LCMS2_LIBRARIES})")
ELSE()
  MESSAGE(FATAL_ERROR "Could not find LCMS2")
ENDIF()

MARK_AS_ADVANCED(
   LCMS2_INCLUDE_DIR
   LCMS2_LIBRARIES
   LCMS2_FOUND
)
