<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	require_once 'Node.php';
	require_once 'functions.php';
	
	/*
	*  Nodes editor class
	*
	* Allow to move only one node
	*
	* Author: Nicolas Dufresne
	*/

	class NodesMoveCmd{
	    var $node;
	    var $dest;
	    var $errors;
	    var $isError;
	    
	    function NodesMoveCmd($node,$dest) {
		if ($node->isError OR $dest->isError) {
		    $this->isError = true;
		    return;
		}
		
		/////////////////////////////
		// Actions
		/////////////////////////////

		// Cancel
		if (isset($_POST['ne_cancel'])) {
		    unset($GLOBALS['_POST']);
		}

		// Move
		elseif (isset($_POST['ne_move'])) {
		    if ($node->isError()) $this->errors[] = $node->lastError()." : id=".$id;
		    elseif (!$node->setParent($dest->getID())) {
			$this->errors[] = $node->lastError()." : id=".$id;
		    }
		}
		
		$this->node = $node;
		$this->dest = $dest;
		if (!isset($_POST['ne_node_name'])) $_POST['ne_node_name'] = $node->getName();
	    }
	    
	    /**
	    * Print errors
	    *
	    * @access public
	    */
	    function printErrors() {
			if (isset($this->errors[0])) print "<p>\n";
			else return;
			foreach ($this->errors as $error) {
				print "<font color=\"red\" size=\"-1\">".$error."</font><br>\n";
			}
			print "</p>\n";
	    }

	    /**
	    * Print the browser HTML view
	    *
	    * @access public
	    * @return stdout
	    */
	    function printView() {
		if ($this->isError) {
		    $this->printErrors();
		}
		else {
		    include 'nodesMoveCmdView.php';
		}
	    }
	}
?>


