#!/bin/sh

test_description="simple tests for mmafm - part of LCDF Typetools"

. /usr/share/sharness/sharness.sh

OTF=/usr/share/fonts/truetype/noto/NotoSans-Regular.ttf

test_expect_success "mmafm version" "
    mmafm --version > out &&
    grep -x 'mmafm (LCDF typetools) [0-9.]\+' out
"

test_expect_success "mmafm help" "
    mmafm --help > out &&
    grep -Fx 'Usage: mmafm [OPTION | FONT]...' out
"

test_expect_success "mmafm fail parse OpenType" "
    test_expect_code 1 mmafm $OTF
"

test_done
