require File.expand_path('../../../spec_helper', __FILE__)
require File.expand_path('../fixtures/classes', __FILE__)

describe "Method#receiver" do
  it "returns the receiver of the method" do
    s = "abc"
    s.method(:upcase).receiver.should equal(s)
  end

  it "returns the right receiver even when aliased" do
    obj = MethodSpecs::Methods.new
    obj.method(:foo).receiver.should equal(obj)
    obj.method(:bar).receiver.should equal(obj)
  end

  describe "for a Method generated by respond_to_missing?" do
    it "returns the receiver of the method" do
      m = MethodSpecs::Methods.new
      m.method(:handled_via_method_missing).receiver.should equal(m)
    end
  end
end
