/***************************************************************************
 * C++ Implementation:                                                     *
 * Copyright (C) 2012-2014 by Eduard Kalinowski                            *
 * Germany, Lower Saxony, Hanover                                          *
 * eduard_kalinowski@yahoo.de                                              *
 *                                                                         *
 * HTTraQt is free software; you can redistribute it and/or                *
 * modify it under the terms of the GNU Lesser General Public              *
 * License as published by the Free Software Foundation; either            *
 * version 3 of the License, or (at your option) any later version.        *
 *                                                                         *
 * HTTraQt is distributed in the hope that it will be useful, but          *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    *
 *                                                                         *
 * See the GNU Lesser General Public License for more details.             *
 *                                                                         *
 * You should have received a copy of the GNU Lesser General Public        *
 * License along with HTTraQt. If not, see  http://www.gnu.org/licenses    *
 ***************************************************************************/

#include "includes/OptionsDialog.h"
#include "includes/optionsproxy.h"
#include "../main/includes/httraqt.h"

optionsProxy::optionsProxy(QWidget* parent, Qt::WindowFlags fl)
    : QWidget(parent, fl), Ui::proxyForm()
{
    setupUi(this);

    this->parent = static_cast<OptionsDialog*>(parent);

    opts = &(static_cast<OptionsDialog*>(this->parent))->_tabTextInfos;

    connect(proxyForm::labelHide, SIGNAL(toggled(bool)), this, SLOT(hidePass(bool)));

    initTextPoints();
}


optionsProxy::~optionsProxy()
{
}


void optionsProxy::hidePass(bool f)
{
    if (f == true) {
        proxyForm::editPass->setEchoMode(QLineEdit::Password);
    } else {
        proxyForm::editPass->setEchoMode(QLineEdit::Normal);
    }
}


void optionsProxy::initTextPoints()
{
    *opts << (trWidgets) {
        proxyForm::labelProxy, _PROX_ADDR, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        proxyForm::groupLogin, _PROX_DEFINE, "", GROUPBOX, NOTYPE, 0
    };
    *opts << (trWidgets) {
        proxyForm::labelLogin, _LOGIN, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        proxyForm::labelPort, _PROX_PORT, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        proxyForm::labelPass, _PASS, "", LABEL, NOTYPE, 0
    };
    *opts << (trWidgets) {
        proxyForm::labelHide, _HIDE_PASS, "", CHECKBOX, NOTYPE, 0
    };
    *opts << (trWidgets) {
        proxyForm::labelFtp, _USE_PROXY, "UseHTTPProxyForFTP", CHECKBOX, BOOLEAN, 0
    };
    *opts << (trWidgets) {
        proxyForm::editProxy, -1, "Proxy", EDITLINE, TEXT, ""
    };
    *opts << (trWidgets) {
        proxyForm::editPort, -1, "ProxyPort", EDITLINE, TEXT, ""
    };
    *opts << (trWidgets) {
        proxyForm::editLogin, -1, "ProxyLogin", EDITLINE, TEXT, ""
    };
    *opts << (trWidgets) {
        proxyForm::editPass, -1, "ProxyPass", EDITLINE, TEXT, ""
    };
}



/*$SPECIALIZATION$*/


