/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * An optional setting on the ChartData of the domain of a data source chart that defines buckets
 * for the values in the domain rather than breaking out each individual value. For example, when
 * plotting a data source chart, you can specify a histogram rule on the domain (it should only
 * contain numeric values), grouping its values into buckets. Any values of a chart series that fall
 * into the same bucket are aggregated based on the aggregate_type.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChartGroupRule extends com.google.api.client.json.GenericJson {

  /**
   * A ChartDateTimeRule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChartDateTimeRule dateTimeRule;

  /**
   * A ChartHistogramRule
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChartHistogramRule histogramRule;

  /**
   * A ChartDateTimeRule.
   * @return value or {@code null} for none
   */
  public ChartDateTimeRule getDateTimeRule() {
    return dateTimeRule;
  }

  /**
   * A ChartDateTimeRule.
   * @param dateTimeRule dateTimeRule or {@code null} for none
   */
  public ChartGroupRule setDateTimeRule(ChartDateTimeRule dateTimeRule) {
    this.dateTimeRule = dateTimeRule;
    return this;
  }

  /**
   * A ChartHistogramRule
   * @return value or {@code null} for none
   */
  public ChartHistogramRule getHistogramRule() {
    return histogramRule;
  }

  /**
   * A ChartHistogramRule
   * @param histogramRule histogramRule or {@code null} for none
   */
  public ChartGroupRule setHistogramRule(ChartHistogramRule histogramRule) {
    this.histogramRule = histogramRule;
    return this;
  }

  @Override
  public ChartGroupRule set(String fieldName, Object value) {
    return (ChartGroupRule) super.set(fieldName, value);
  }

  @Override
  public ChartGroupRule clone() {
    return (ChartGroupRule) super.clone();
  }

}
