// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: agent/agent.proto

/*
	Package agent is a generated protocol buffer package.

	It is generated from these files:
		agent/agent.proto

	It has these top-level messages:
		Call
		Response
		ProcessIO
*/
package agent

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import mesos "github.com/mesos/mesos-go/api/v1/lib"
import _ "github.com/gogo/protobuf/gogoproto"

import strconv "strconv"

import bytes "bytes"

import strings "strings"
import reflect "reflect"

import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// If a call of type `Call::FOO` requires additional parameters they can be
// included in the corresponding `Call::Foo` message. Similarly, if a call
// receives a synchronous response it will be returned as a `Response`
// message of type `Response::FOO`; see `Call::LaunchNestedContainerSession`
// and `Call::AttachContainerOutput` for exceptions.
type Call_Type int32

const (
	Call_UNKNOWN           Call_Type = 0
	Call_GET_HEALTH        Call_Type = 1
	Call_GET_FLAGS         Call_Type = 2
	Call_GET_VERSION       Call_Type = 3
	Call_GET_METRICS       Call_Type = 4
	Call_GET_LOGGING_LEVEL Call_Type = 5
	Call_SET_LOGGING_LEVEL Call_Type = 6
	Call_LIST_FILES        Call_Type = 7
	Call_READ_FILE         Call_Type = 8
	Call_GET_STATE         Call_Type = 9
	Call_GET_CONTAINERS    Call_Type = 10
	Call_GET_FRAMEWORKS    Call_Type = 11
	Call_GET_EXECUTORS     Call_Type = 12
	Call_GET_TASKS         Call_Type = 13
	Call_GET_AGENT         Call_Type = 20
	// Calls for managing nested containers underneath an executor's container.
	Call_LAUNCH_NESTED_CONTAINER Call_Type = 14
	Call_WAIT_NESTED_CONTAINER   Call_Type = 15
	Call_KILL_NESTED_CONTAINER   Call_Type = 16
	Call_REMOVE_NESTED_CONTAINER Call_Type = 21
	// See 'LaunchNestedContainerSession' below.
	Call_LAUNCH_NESTED_CONTAINER_SESSION Call_Type = 17
	Call_ATTACH_CONTAINER_INPUT          Call_Type = 18
	Call_ATTACH_CONTAINER_OUTPUT         Call_Type = 19
)

var Call_Type_name = map[int32]string{
	0:  "UNKNOWN",
	1:  "GET_HEALTH",
	2:  "GET_FLAGS",
	3:  "GET_VERSION",
	4:  "GET_METRICS",
	5:  "GET_LOGGING_LEVEL",
	6:  "SET_LOGGING_LEVEL",
	7:  "LIST_FILES",
	8:  "READ_FILE",
	9:  "GET_STATE",
	10: "GET_CONTAINERS",
	11: "GET_FRAMEWORKS",
	12: "GET_EXECUTORS",
	13: "GET_TASKS",
	20: "GET_AGENT",
	14: "LAUNCH_NESTED_CONTAINER",
	15: "WAIT_NESTED_CONTAINER",
	16: "KILL_NESTED_CONTAINER",
	21: "REMOVE_NESTED_CONTAINER",
	17: "LAUNCH_NESTED_CONTAINER_SESSION",
	18: "ATTACH_CONTAINER_INPUT",
	19: "ATTACH_CONTAINER_OUTPUT",
}
var Call_Type_value = map[string]int32{
	"UNKNOWN":                         0,
	"GET_HEALTH":                      1,
	"GET_FLAGS":                       2,
	"GET_VERSION":                     3,
	"GET_METRICS":                     4,
	"GET_LOGGING_LEVEL":               5,
	"SET_LOGGING_LEVEL":               6,
	"LIST_FILES":                      7,
	"READ_FILE":                       8,
	"GET_STATE":                       9,
	"GET_CONTAINERS":                  10,
	"GET_FRAMEWORKS":                  11,
	"GET_EXECUTORS":                   12,
	"GET_TASKS":                       13,
	"GET_AGENT":                       20,
	"LAUNCH_NESTED_CONTAINER":         14,
	"WAIT_NESTED_CONTAINER":           15,
	"KILL_NESTED_CONTAINER":           16,
	"REMOVE_NESTED_CONTAINER":         21,
	"LAUNCH_NESTED_CONTAINER_SESSION": 17,
	"ATTACH_CONTAINER_INPUT":          18,
	"ATTACH_CONTAINER_OUTPUT":         19,
}

func (x Call_Type) Enum() *Call_Type {
	p := new(Call_Type)
	*p = x
	return p
}
func (x Call_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Call_Type_name, int32(x))
}
func (x *Call_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Call_Type_value, data, "Call_Type")
	if err != nil {
		return err
	}
	*x = Call_Type(value)
	return nil
}
func (Call_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorAgent, []int{0, 0} }

type Call_AttachContainerInput_Type int32

const (
	Call_AttachContainerInput_UNKNOWN      Call_AttachContainerInput_Type = 0
	Call_AttachContainerInput_CONTAINER_ID Call_AttachContainerInput_Type = 1
	Call_AttachContainerInput_PROCESS_IO   Call_AttachContainerInput_Type = 2
)

var Call_AttachContainerInput_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "CONTAINER_ID",
	2: "PROCESS_IO",
}
var Call_AttachContainerInput_Type_value = map[string]int32{
	"UNKNOWN":      0,
	"CONTAINER_ID": 1,
	"PROCESS_IO":   2,
}

func (x Call_AttachContainerInput_Type) Enum() *Call_AttachContainerInput_Type {
	p := new(Call_AttachContainerInput_Type)
	*p = x
	return p
}
func (x Call_AttachContainerInput_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Call_AttachContainerInput_Type_name, int32(x))
}
func (x *Call_AttachContainerInput_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Call_AttachContainerInput_Type_value, data, "Call_AttachContainerInput_Type")
	if err != nil {
		return err
	}
	*x = Call_AttachContainerInput_Type(value)
	return nil
}
func (Call_AttachContainerInput_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorAgent, []int{0, 9, 0}
}

// Each of the responses of type `FOO` corresponds to `Foo` message below.
type Response_Type int32

const (
	Response_UNKNOWN               Response_Type = 0
	Response_GET_HEALTH            Response_Type = 1
	Response_GET_FLAGS             Response_Type = 2
	Response_GET_VERSION           Response_Type = 3
	Response_GET_METRICS           Response_Type = 4
	Response_GET_LOGGING_LEVEL     Response_Type = 5
	Response_LIST_FILES            Response_Type = 6
	Response_READ_FILE             Response_Type = 7
	Response_GET_STATE             Response_Type = 8
	Response_GET_CONTAINERS        Response_Type = 9
	Response_GET_FRAMEWORKS        Response_Type = 10
	Response_GET_EXECUTORS         Response_Type = 11
	Response_GET_TASKS             Response_Type = 12
	Response_GET_AGENT             Response_Type = 14
	Response_WAIT_NESTED_CONTAINER Response_Type = 13
)

var Response_Type_name = map[int32]string{
	0:  "UNKNOWN",
	1:  "GET_HEALTH",
	2:  "GET_FLAGS",
	3:  "GET_VERSION",
	4:  "GET_METRICS",
	5:  "GET_LOGGING_LEVEL",
	6:  "LIST_FILES",
	7:  "READ_FILE",
	8:  "GET_STATE",
	9:  "GET_CONTAINERS",
	10: "GET_FRAMEWORKS",
	11: "GET_EXECUTORS",
	12: "GET_TASKS",
	14: "GET_AGENT",
	13: "WAIT_NESTED_CONTAINER",
}
var Response_Type_value = map[string]int32{
	"UNKNOWN":               0,
	"GET_HEALTH":            1,
	"GET_FLAGS":             2,
	"GET_VERSION":           3,
	"GET_METRICS":           4,
	"GET_LOGGING_LEVEL":     5,
	"LIST_FILES":            6,
	"READ_FILE":             7,
	"GET_STATE":             8,
	"GET_CONTAINERS":        9,
	"GET_FRAMEWORKS":        10,
	"GET_EXECUTORS":         11,
	"GET_TASKS":             12,
	"GET_AGENT":             14,
	"WAIT_NESTED_CONTAINER": 13,
}

func (x Response_Type) Enum() *Response_Type {
	p := new(Response_Type)
	*p = x
	return p
}
func (x Response_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Response_Type_name, int32(x))
}
func (x *Response_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Response_Type_value, data, "Response_Type")
	if err != nil {
		return err
	}
	*x = Response_Type(value)
	return nil
}
func (Response_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorAgent, []int{1, 0} }

type ProcessIO_Type int32

const (
	ProcessIO_UNKNOWN ProcessIO_Type = 0
	ProcessIO_DATA    ProcessIO_Type = 1
	ProcessIO_CONTROL ProcessIO_Type = 2
)

var ProcessIO_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "DATA",
	2: "CONTROL",
}
var ProcessIO_Type_value = map[string]int32{
	"UNKNOWN": 0,
	"DATA":    1,
	"CONTROL": 2,
}

func (x ProcessIO_Type) Enum() *ProcessIO_Type {
	p := new(ProcessIO_Type)
	*p = x
	return p
}
func (x ProcessIO_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(ProcessIO_Type_name, int32(x))
}
func (x *ProcessIO_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ProcessIO_Type_value, data, "ProcessIO_Type")
	if err != nil {
		return err
	}
	*x = ProcessIO_Type(value)
	return nil
}
func (ProcessIO_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorAgent, []int{2, 0} }

type ProcessIO_Data_Type int32

const (
	ProcessIO_Data_UNKNOWN ProcessIO_Data_Type = 0
	ProcessIO_Data_STDIN   ProcessIO_Data_Type = 1
	ProcessIO_Data_STDOUT  ProcessIO_Data_Type = 2
	ProcessIO_Data_STDERR  ProcessIO_Data_Type = 3
)

var ProcessIO_Data_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "STDIN",
	2: "STDOUT",
	3: "STDERR",
}
var ProcessIO_Data_Type_value = map[string]int32{
	"UNKNOWN": 0,
	"STDIN":   1,
	"STDOUT":  2,
	"STDERR":  3,
}

func (x ProcessIO_Data_Type) Enum() *ProcessIO_Data_Type {
	p := new(ProcessIO_Data_Type)
	*p = x
	return p
}
func (x ProcessIO_Data_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(ProcessIO_Data_Type_name, int32(x))
}
func (x *ProcessIO_Data_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ProcessIO_Data_Type_value, data, "ProcessIO_Data_Type")
	if err != nil {
		return err
	}
	*x = ProcessIO_Data_Type(value)
	return nil
}
func (ProcessIO_Data_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorAgent, []int{2, 0, 0}
}

type ProcessIO_Control_Type int32

const (
	ProcessIO_Control_UNKNOWN   ProcessIO_Control_Type = 0
	ProcessIO_Control_TTY_INFO  ProcessIO_Control_Type = 1
	ProcessIO_Control_HEARTBEAT ProcessIO_Control_Type = 2
)

var ProcessIO_Control_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "TTY_INFO",
	2: "HEARTBEAT",
}
var ProcessIO_Control_Type_value = map[string]int32{
	"UNKNOWN":   0,
	"TTY_INFO":  1,
	"HEARTBEAT": 2,
}

func (x ProcessIO_Control_Type) Enum() *ProcessIO_Control_Type {
	p := new(ProcessIO_Control_Type)
	*p = x
	return p
}
func (x ProcessIO_Control_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(ProcessIO_Control_Type_name, int32(x))
}
func (x *ProcessIO_Control_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ProcessIO_Control_Type_value, data, "ProcessIO_Control_Type")
	if err != nil {
		return err
	}
	*x = ProcessIO_Control_Type(value)
	return nil
}
func (ProcessIO_Control_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorAgent, []int{2, 1, 0}
}

// *
// Calls that can be sent to the v1 agent API.
//
// A call is described using the standard protocol buffer "union"
// trick, see
// https://developers.google.com/protocol-buffers/docs/techniques#union.
type Call struct {
	Type                         Call_Type                          `protobuf:"varint,1,opt,name=type,enum=mesos.agent.Call_Type" json:"type"`
	GetMetrics                   *Call_GetMetrics                   `protobuf:"bytes,2,opt,name=get_metrics,json=getMetrics" json:"get_metrics,omitempty"`
	SetLoggingLevel              *Call_SetLoggingLevel              `protobuf:"bytes,3,opt,name=set_logging_level,json=setLoggingLevel" json:"set_logging_level,omitempty"`
	ListFiles                    *Call_ListFiles                    `protobuf:"bytes,4,opt,name=list_files,json=listFiles" json:"list_files,omitempty"`
	ReadFile                     *Call_ReadFile                     `protobuf:"bytes,5,opt,name=read_file,json=readFile" json:"read_file,omitempty"`
	LaunchNestedContainer        *Call_LaunchNestedContainer        `protobuf:"bytes,6,opt,name=launch_nested_container,json=launchNestedContainer" json:"launch_nested_container,omitempty"`
	WaitNestedContainer          *Call_WaitNestedContainer          `protobuf:"bytes,7,opt,name=wait_nested_container,json=waitNestedContainer" json:"wait_nested_container,omitempty"`
	KillNestedContainer          *Call_KillNestedContainer          `protobuf:"bytes,8,opt,name=kill_nested_container,json=killNestedContainer" json:"kill_nested_container,omitempty"`
	RemoveNestedContainer        *Call_RemoveNestedContainer        `protobuf:"bytes,12,opt,name=remove_nested_container,json=removeNestedContainer" json:"remove_nested_container,omitempty"`
	LaunchNestedContainerSession *Call_LaunchNestedContainerSession `protobuf:"bytes,9,opt,name=launch_nested_container_session,json=launchNestedContainerSession" json:"launch_nested_container_session,omitempty"`
	AttachContainerInput         *Call_AttachContainerInput         `protobuf:"bytes,10,opt,name=attach_container_input,json=attachContainerInput" json:"attach_container_input,omitempty"`
	AttachContainerOutput        *Call_AttachContainerOutput        `protobuf:"bytes,11,opt,name=attach_container_output,json=attachContainerOutput" json:"attach_container_output,omitempty"`
}

func (m *Call) Reset()                    { *m = Call{} }
func (*Call) ProtoMessage()               {}
func (*Call) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{0} }

func (m *Call) GetType() Call_Type {
	if m != nil {
		return m.Type
	}
	return Call_UNKNOWN
}

func (m *Call) GetGetMetrics() *Call_GetMetrics {
	if m != nil {
		return m.GetMetrics
	}
	return nil
}

func (m *Call) GetSetLoggingLevel() *Call_SetLoggingLevel {
	if m != nil {
		return m.SetLoggingLevel
	}
	return nil
}

func (m *Call) GetListFiles() *Call_ListFiles {
	if m != nil {
		return m.ListFiles
	}
	return nil
}

func (m *Call) GetReadFile() *Call_ReadFile {
	if m != nil {
		return m.ReadFile
	}
	return nil
}

func (m *Call) GetLaunchNestedContainer() *Call_LaunchNestedContainer {
	if m != nil {
		return m.LaunchNestedContainer
	}
	return nil
}

func (m *Call) GetWaitNestedContainer() *Call_WaitNestedContainer {
	if m != nil {
		return m.WaitNestedContainer
	}
	return nil
}

func (m *Call) GetKillNestedContainer() *Call_KillNestedContainer {
	if m != nil {
		return m.KillNestedContainer
	}
	return nil
}

func (m *Call) GetRemoveNestedContainer() *Call_RemoveNestedContainer {
	if m != nil {
		return m.RemoveNestedContainer
	}
	return nil
}

func (m *Call) GetLaunchNestedContainerSession() *Call_LaunchNestedContainerSession {
	if m != nil {
		return m.LaunchNestedContainerSession
	}
	return nil
}

func (m *Call) GetAttachContainerInput() *Call_AttachContainerInput {
	if m != nil {
		return m.AttachContainerInput
	}
	return nil
}

func (m *Call) GetAttachContainerOutput() *Call_AttachContainerOutput {
	if m != nil {
		return m.AttachContainerOutput
	}
	return nil
}

// Provides a snapshot of the current metrics tracked by the agent.
type Call_GetMetrics struct {
	// If set, `timeout` would be used to determines the maximum amount of time
	// the API will take to respond. If the timeout is exceeded, some metrics
	// may not be included in the response.
	Timeout *mesos.DurationInfo `protobuf:"bytes,1,opt,name=timeout" json:"timeout,omitempty"`
}

func (m *Call_GetMetrics) Reset()                    { *m = Call_GetMetrics{} }
func (*Call_GetMetrics) ProtoMessage()               {}
func (*Call_GetMetrics) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{0, 0} }

func (m *Call_GetMetrics) GetTimeout() *mesos.DurationInfo {
	if m != nil {
		return m.Timeout
	}
	return nil
}

// Sets the logging verbosity level for a specified duration. Mesos uses
// [glog](https://github.com/google/glog) for logging. The library only uses
// verbose logging which means nothing will be output unless the verbosity
// level is set (by default it's 0, libprocess uses levels 1, 2, and 3).
type Call_SetLoggingLevel struct {
	// The verbosity level.
	Level uint32 `protobuf:"varint,1,req,name=level" json:"level"`
	// The duration to keep verbosity level toggled. After this duration, the
	// verbosity level of log would revert to the original level.
	Duration mesos.DurationInfo `protobuf:"bytes,2,req,name=duration" json:"duration"`
}

func (m *Call_SetLoggingLevel) Reset()                    { *m = Call_SetLoggingLevel{} }
func (*Call_SetLoggingLevel) ProtoMessage()               {}
func (*Call_SetLoggingLevel) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{0, 1} }

func (m *Call_SetLoggingLevel) GetLevel() uint32 {
	if m != nil {
		return m.Level
	}
	return 0
}

func (m *Call_SetLoggingLevel) GetDuration() mesos.DurationInfo {
	if m != nil {
		return m.Duration
	}
	return mesos.DurationInfo{}
}

// Provides the file listing for a directory.
type Call_ListFiles struct {
	Path string `protobuf:"bytes,1,req,name=path" json:"path"`
}

func (m *Call_ListFiles) Reset()                    { *m = Call_ListFiles{} }
func (*Call_ListFiles) ProtoMessage()               {}
func (*Call_ListFiles) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{0, 2} }

func (m *Call_ListFiles) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// Reads data from a file.
type Call_ReadFile struct {
	// The path of file.
	Path string `protobuf:"bytes,1,req,name=path" json:"path"`
	// Initial offset in file to start reading from.
	Offset uint64 `protobuf:"varint,2,req,name=offset" json:"offset"`
	// The maximum number of bytes to read. The read length is capped at 16
	// memory pages.
	Length *uint64 `protobuf:"varint,3,opt,name=length" json:"length,omitempty"`
}

func (m *Call_ReadFile) Reset()                    { *m = Call_ReadFile{} }
func (*Call_ReadFile) ProtoMessage()               {}
func (*Call_ReadFile) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{0, 3} }

func (m *Call_ReadFile) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *Call_ReadFile) GetOffset() uint64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *Call_ReadFile) GetLength() uint64 {
	if m != nil && m.Length != nil {
		return *m.Length
	}
	return 0
}

// Launches a nested container within an executor's tree of containers.
type Call_LaunchNestedContainer struct {
	ContainerID mesos.ContainerID    `protobuf:"bytes,1,req,name=container_id,json=containerId" json:"container_id"`
	Command     *mesos.CommandInfo   `protobuf:"bytes,2,opt,name=command" json:"command,omitempty"`
	Container   *mesos.ContainerInfo `protobuf:"bytes,3,opt,name=container" json:"container,omitempty"`
}

func (m *Call_LaunchNestedContainer) Reset()      { *m = Call_LaunchNestedContainer{} }
func (*Call_LaunchNestedContainer) ProtoMessage() {}
func (*Call_LaunchNestedContainer) Descriptor() ([]byte, []int) {
	return fileDescriptorAgent, []int{0, 4}
}

func (m *Call_LaunchNestedContainer) GetContainerID() mesos.ContainerID {
	if m != nil {
		return m.ContainerID
	}
	return mesos.ContainerID{}
}

func (m *Call_LaunchNestedContainer) GetCommand() *mesos.CommandInfo {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *Call_LaunchNestedContainer) GetContainer() *mesos.ContainerInfo {
	if m != nil {
		return m.Container
	}
	return nil
}

// Waits for the nested container to terminate and receives the exit status.
type Call_WaitNestedContainer struct {
	ContainerID mesos.ContainerID `protobuf:"bytes,1,req,name=container_id,json=containerId" json:"container_id"`
}

func (m *Call_WaitNestedContainer) Reset()                    { *m = Call_WaitNestedContainer{} }
func (*Call_WaitNestedContainer) ProtoMessage()               {}
func (*Call_WaitNestedContainer) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{0, 5} }

func (m *Call_WaitNestedContainer) GetContainerID() mesos.ContainerID {
	if m != nil {
		return m.ContainerID
	}
	return mesos.ContainerID{}
}

// Kills the nested container. The signal (e.g., SIGTERM, SIGKILL, etc.)
// to be sent to the container can be specified in the 'signal' field.
// If 'signal' is not set, SIGKILL is used by default.
type Call_KillNestedContainer struct {
	ContainerID mesos.ContainerID `protobuf:"bytes,1,req,name=container_id,json=containerId" json:"container_id"`
	Signal      *int32            `protobuf:"varint,2,opt,name=signal" json:"signal,omitempty"`
}

func (m *Call_KillNestedContainer) Reset()                    { *m = Call_KillNestedContainer{} }
func (*Call_KillNestedContainer) ProtoMessage()               {}
func (*Call_KillNestedContainer) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{0, 6} }

func (m *Call_KillNestedContainer) GetContainerID() mesos.ContainerID {
	if m != nil {
		return m.ContainerID
	}
	return mesos.ContainerID{}
}

func (m *Call_KillNestedContainer) GetSignal() int32 {
	if m != nil && m.Signal != nil {
		return *m.Signal
	}
	return 0
}

// Removes a nested container and its artifacts (runtime and sandbox
// directories).
type Call_RemoveNestedContainer struct {
	ContainerID mesos.ContainerID `protobuf:"bytes,1,req,name=container_id,json=containerId" json:"container_id"`
}

func (m *Call_RemoveNestedContainer) Reset()      { *m = Call_RemoveNestedContainer{} }
func (*Call_RemoveNestedContainer) ProtoMessage() {}
func (*Call_RemoveNestedContainer) Descriptor() ([]byte, []int) {
	return fileDescriptorAgent, []int{0, 7}
}

func (m *Call_RemoveNestedContainer) GetContainerID() mesos.ContainerID {
	if m != nil {
		return m.ContainerID
	}
	return mesos.ContainerID{}
}

// Launches a nested container within an executor's tree of containers.
// The differences between this call and `LaunchNestedContainer` are:
// 1) The container's life-cycle is tied to the lifetime of the
//    connection used to make this call, i.e., if the connection ever
//    breaks, the container will be destroyed.
// 2) The nested container shares the same namespaces and cgroups as
//    its parent container.
// 3) Results in a streaming response of type `ProcessIO`. So the call
//    needs to be made on a persistent connection.
type Call_LaunchNestedContainerSession struct {
	ContainerID mesos.ContainerID    `protobuf:"bytes,1,req,name=container_id,json=containerId" json:"container_id"`
	Command     *mesos.CommandInfo   `protobuf:"bytes,2,opt,name=command" json:"command,omitempty"`
	Container   *mesos.ContainerInfo `protobuf:"bytes,3,opt,name=container" json:"container,omitempty"`
}

func (m *Call_LaunchNestedContainerSession) Reset()      { *m = Call_LaunchNestedContainerSession{} }
func (*Call_LaunchNestedContainerSession) ProtoMessage() {}
func (*Call_LaunchNestedContainerSession) Descriptor() ([]byte, []int) {
	return fileDescriptorAgent, []int{0, 8}
}

func (m *Call_LaunchNestedContainerSession) GetContainerID() mesos.ContainerID {
	if m != nil {
		return m.ContainerID
	}
	return mesos.ContainerID{}
}

func (m *Call_LaunchNestedContainerSession) GetCommand() *mesos.CommandInfo {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *Call_LaunchNestedContainerSession) GetContainer() *mesos.ContainerInfo {
	if m != nil {
		return m.Container
	}
	return nil
}

// Attaches the caller to the STDIN of the entry point of the container.
// Clients can use this to stream input data to a container.
// Note that this call needs to be made on a persistent connection by
// streaming a CONTAINER_ID message followed by one or more PROCESS_IO
// messages.
type Call_AttachContainerInput struct {
	Type        Call_AttachContainerInput_Type `protobuf:"varint,1,opt,name=type,enum=mesos.agent.Call_AttachContainerInput_Type" json:"type"`
	ContainerID *mesos.ContainerID             `protobuf:"bytes,2,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
	ProcessIO   *ProcessIO                     `protobuf:"bytes,3,opt,name=process_io,json=processIo" json:"process_io,omitempty"`
}

func (m *Call_AttachContainerInput) Reset()      { *m = Call_AttachContainerInput{} }
func (*Call_AttachContainerInput) ProtoMessage() {}
func (*Call_AttachContainerInput) Descriptor() ([]byte, []int) {
	return fileDescriptorAgent, []int{0, 9}
}

func (m *Call_AttachContainerInput) GetType() Call_AttachContainerInput_Type {
	if m != nil {
		return m.Type
	}
	return Call_AttachContainerInput_UNKNOWN
}

func (m *Call_AttachContainerInput) GetContainerID() *mesos.ContainerID {
	if m != nil {
		return m.ContainerID
	}
	return nil
}

func (m *Call_AttachContainerInput) GetProcessIO() *ProcessIO {
	if m != nil {
		return m.ProcessIO
	}
	return nil
}

// Attaches the caller to the STDOUT and STDERR of the entrypoint of
// the container. Clients can use this to stream output/error from the
// container. This call will result in a streaming response of `ProcessIO`;
// so this call needs to be made on a persistent connection.
type Call_AttachContainerOutput struct {
	ContainerID mesos.ContainerID `protobuf:"bytes,1,req,name=container_id,json=containerId" json:"container_id"`
}

func (m *Call_AttachContainerOutput) Reset()      { *m = Call_AttachContainerOutput{} }
func (*Call_AttachContainerOutput) ProtoMessage() {}
func (*Call_AttachContainerOutput) Descriptor() ([]byte, []int) {
	return fileDescriptorAgent, []int{0, 10}
}

func (m *Call_AttachContainerOutput) GetContainerID() mesos.ContainerID {
	if m != nil {
		return m.ContainerID
	}
	return mesos.ContainerID{}
}

// *
// Synchronous responses for all calls made to the v1 agent API.
type Response struct {
	Type                Response_Type                 `protobuf:"varint,1,opt,name=type,enum=mesos.agent.Response_Type" json:"type"`
	GetHealth           *Response_GetHealth           `protobuf:"bytes,2,opt,name=get_health,json=getHealth" json:"get_health,omitempty"`
	GetFlags            *Response_GetFlags            `protobuf:"bytes,3,opt,name=get_flags,json=getFlags" json:"get_flags,omitempty"`
	GetVersion          *Response_GetVersion          `protobuf:"bytes,4,opt,name=get_version,json=getVersion" json:"get_version,omitempty"`
	GetMetrics          *Response_GetMetrics          `protobuf:"bytes,5,opt,name=get_metrics,json=getMetrics" json:"get_metrics,omitempty"`
	GetLoggingLevel     *Response_GetLoggingLevel     `protobuf:"bytes,6,opt,name=get_logging_level,json=getLoggingLevel" json:"get_logging_level,omitempty"`
	ListFiles           *Response_ListFiles           `protobuf:"bytes,7,opt,name=list_files,json=listFiles" json:"list_files,omitempty"`
	ReadFile            *Response_ReadFile            `protobuf:"bytes,8,opt,name=read_file,json=readFile" json:"read_file,omitempty"`
	GetState            *Response_GetState            `protobuf:"bytes,9,opt,name=get_state,json=getState" json:"get_state,omitempty"`
	GetContainers       *Response_GetContainers       `protobuf:"bytes,10,opt,name=get_containers,json=getContainers" json:"get_containers,omitempty"`
	GetFrameworks       *Response_GetFrameworks       `protobuf:"bytes,11,opt,name=get_frameworks,json=getFrameworks" json:"get_frameworks,omitempty"`
	GetExecutors        *Response_GetExecutors        `protobuf:"bytes,12,opt,name=get_executors,json=getExecutors" json:"get_executors,omitempty"`
	GetTasks            *Response_GetTasks            `protobuf:"bytes,13,opt,name=get_tasks,json=getTasks" json:"get_tasks,omitempty"`
	GetAgent            *Response_GetAgent            `protobuf:"bytes,15,opt,name=get_agent,json=getAgent" json:"get_agent,omitempty"`
	WaitNestedContainer *Response_WaitNestedContainer `protobuf:"bytes,14,opt,name=wait_nested_container,json=waitNestedContainer" json:"wait_nested_container,omitempty"`
}

func (m *Response) Reset()                    { *m = Response{} }
func (*Response) ProtoMessage()               {}
func (*Response) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{1} }

func (m *Response) GetType() Response_Type {
	if m != nil {
		return m.Type
	}
	return Response_UNKNOWN
}

func (m *Response) GetGetHealth() *Response_GetHealth {
	if m != nil {
		return m.GetHealth
	}
	return nil
}

func (m *Response) GetGetFlags() *Response_GetFlags {
	if m != nil {
		return m.GetFlags
	}
	return nil
}

func (m *Response) GetGetVersion() *Response_GetVersion {
	if m != nil {
		return m.GetVersion
	}
	return nil
}

func (m *Response) GetGetMetrics() *Response_GetMetrics {
	if m != nil {
		return m.GetMetrics
	}
	return nil
}

func (m *Response) GetGetLoggingLevel() *Response_GetLoggingLevel {
	if m != nil {
		return m.GetLoggingLevel
	}
	return nil
}

func (m *Response) GetListFiles() *Response_ListFiles {
	if m != nil {
		return m.ListFiles
	}
	return nil
}

func (m *Response) GetReadFile() *Response_ReadFile {
	if m != nil {
		return m.ReadFile
	}
	return nil
}

func (m *Response) GetGetState() *Response_GetState {
	if m != nil {
		return m.GetState
	}
	return nil
}

func (m *Response) GetGetContainers() *Response_GetContainers {
	if m != nil {
		return m.GetContainers
	}
	return nil
}

func (m *Response) GetGetFrameworks() *Response_GetFrameworks {
	if m != nil {
		return m.GetFrameworks
	}
	return nil
}

func (m *Response) GetGetExecutors() *Response_GetExecutors {
	if m != nil {
		return m.GetExecutors
	}
	return nil
}

func (m *Response) GetGetTasks() *Response_GetTasks {
	if m != nil {
		return m.GetTasks
	}
	return nil
}

func (m *Response) GetGetAgent() *Response_GetAgent {
	if m != nil {
		return m.GetAgent
	}
	return nil
}

func (m *Response) GetWaitNestedContainer() *Response_WaitNestedContainer {
	if m != nil {
		return m.WaitNestedContainer
	}
	return nil
}

// `healthy` would be true if the agent is healthy. Delayed responses are also
// indicative of the poor health of the agent.
type Response_GetHealth struct {
	Healthy bool `protobuf:"varint,1,req,name=healthy" json:"healthy"`
}

func (m *Response_GetHealth) Reset()                    { *m = Response_GetHealth{} }
func (*Response_GetHealth) ProtoMessage()               {}
func (*Response_GetHealth) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{1, 0} }

func (m *Response_GetHealth) GetHealthy() bool {
	if m != nil {
		return m.Healthy
	}
	return false
}

// Contains the flag configuration of the agent.
type Response_GetFlags struct {
	Flags []mesos.Flag `protobuf:"bytes,1,rep,name=flags" json:"flags"`
}

func (m *Response_GetFlags) Reset()                    { *m = Response_GetFlags{} }
func (*Response_GetFlags) ProtoMessage()               {}
func (*Response_GetFlags) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{1, 1} }

func (m *Response_GetFlags) GetFlags() []mesos.Flag {
	if m != nil {
		return m.Flags
	}
	return nil
}

// Contains the version information of the agent.
type Response_GetVersion struct {
	VersionInfo mesos.VersionInfo `protobuf:"bytes,1,req,name=version_info,json=versionInfo" json:"version_info"`
}

func (m *Response_GetVersion) Reset()                    { *m = Response_GetVersion{} }
func (*Response_GetVersion) ProtoMessage()               {}
func (*Response_GetVersion) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{1, 2} }

func (m *Response_GetVersion) GetVersionInfo() mesos.VersionInfo {
	if m != nil {
		return m.VersionInfo
	}
	return mesos.VersionInfo{}
}

// Contains a snapshot of the current metrics.
type Response_GetMetrics struct {
	Metrics []mesos.Metric `protobuf:"bytes,1,rep,name=metrics" json:"metrics"`
}

func (m *Response_GetMetrics) Reset()                    { *m = Response_GetMetrics{} }
func (*Response_GetMetrics) ProtoMessage()               {}
func (*Response_GetMetrics) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{1, 3} }

func (m *Response_GetMetrics) GetMetrics() []mesos.Metric {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// Contains the logging level of the agent.
type Response_GetLoggingLevel struct {
	Level uint32 `protobuf:"varint,1,req,name=level" json:"level"`
}

func (m *Response_GetLoggingLevel) Reset()                    { *m = Response_GetLoggingLevel{} }
func (*Response_GetLoggingLevel) ProtoMessage()               {}
func (*Response_GetLoggingLevel) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{1, 4} }

func (m *Response_GetLoggingLevel) GetLevel() uint32 {
	if m != nil {
		return m.Level
	}
	return 0
}

// Contains the file listing(similar to `ls -l`) for a directory.
type Response_ListFiles struct {
	FileInfos []mesos.FileInfo `protobuf:"bytes,1,rep,name=file_infos,json=fileInfos" json:"file_infos"`
}

func (m *Response_ListFiles) Reset()                    { *m = Response_ListFiles{} }
func (*Response_ListFiles) ProtoMessage()               {}
func (*Response_ListFiles) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{1, 5} }

func (m *Response_ListFiles) GetFileInfos() []mesos.FileInfo {
	if m != nil {
		return m.FileInfos
	}
	return nil
}

// Contains the file data.
type Response_ReadFile struct {
	// The size of file (in bytes).
	Size uint64 `protobuf:"varint,1,req,name=size" json:"size"`
	Data []byte `protobuf:"bytes,2,req,name=data" json:"data,omitempty"`
}

func (m *Response_ReadFile) Reset()                    { *m = Response_ReadFile{} }
func (*Response_ReadFile) ProtoMessage()               {}
func (*Response_ReadFile) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{1, 6} }

func (m *Response_ReadFile) GetSize() uint64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *Response_ReadFile) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// Contains full state of the agent i.e. information about the tasks,
// frameworks and executors running in the cluster.
type Response_GetState struct {
	GetTasks      *Response_GetTasks      `protobuf:"bytes,1,opt,name=get_tasks,json=getTasks" json:"get_tasks,omitempty"`
	GetExecutors  *Response_GetExecutors  `protobuf:"bytes,2,opt,name=get_executors,json=getExecutors" json:"get_executors,omitempty"`
	GetFrameworks *Response_GetFrameworks `protobuf:"bytes,3,opt,name=get_frameworks,json=getFrameworks" json:"get_frameworks,omitempty"`
}

func (m *Response_GetState) Reset()                    { *m = Response_GetState{} }
func (*Response_GetState) ProtoMessage()               {}
func (*Response_GetState) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{1, 7} }

func (m *Response_GetState) GetGetTasks() *Response_GetTasks {
	if m != nil {
		return m.GetTasks
	}
	return nil
}

func (m *Response_GetState) GetGetExecutors() *Response_GetExecutors {
	if m != nil {
		return m.GetExecutors
	}
	return nil
}

func (m *Response_GetState) GetGetFrameworks() *Response_GetFrameworks {
	if m != nil {
		return m.GetFrameworks
	}
	return nil
}

// Information about containers running on this agent. It contains
// ContainerStatus and ResourceStatistics along with some metadata
// of the containers.
type Response_GetContainers struct {
	Containers []Response_GetContainers_Container `protobuf:"bytes,1,rep,name=containers" json:"containers"`
}

func (m *Response_GetContainers) Reset()                    { *m = Response_GetContainers{} }
func (*Response_GetContainers) ProtoMessage()               {}
func (*Response_GetContainers) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{1, 8} }

func (m *Response_GetContainers) GetContainers() []Response_GetContainers_Container {
	if m != nil {
		return m.Containers
	}
	return nil
}

type Response_GetContainers_Container struct {
	FrameworkID        mesos.FrameworkID         `protobuf:"bytes,1,req,name=framework_id,json=frameworkId" json:"framework_id"`
	ExecutorID         mesos.ExecutorID          `protobuf:"bytes,2,req,name=executor_id,json=executorId" json:"executor_id"`
	ExecutorName       string                    `protobuf:"bytes,3,req,name=executor_name,json=executorName" json:"executor_name"`
	ContainerID        mesos.ContainerID         `protobuf:"bytes,4,req,name=container_id,json=containerId" json:"container_id"`
	ContainerStatus    *mesos.ContainerStatus    `protobuf:"bytes,5,opt,name=container_status,json=containerStatus" json:"container_status,omitempty"`
	ResourceStatistics *mesos.ResourceStatistics `protobuf:"bytes,6,opt,name=resource_statistics,json=resourceStatistics" json:"resource_statistics,omitempty"`
}

func (m *Response_GetContainers_Container) Reset()      { *m = Response_GetContainers_Container{} }
func (*Response_GetContainers_Container) ProtoMessage() {}
func (*Response_GetContainers_Container) Descriptor() ([]byte, []int) {
	return fileDescriptorAgent, []int{1, 8, 0}
}

func (m *Response_GetContainers_Container) GetFrameworkID() mesos.FrameworkID {
	if m != nil {
		return m.FrameworkID
	}
	return mesos.FrameworkID{}
}

func (m *Response_GetContainers_Container) GetExecutorID() mesos.ExecutorID {
	if m != nil {
		return m.ExecutorID
	}
	return mesos.ExecutorID{}
}

func (m *Response_GetContainers_Container) GetExecutorName() string {
	if m != nil {
		return m.ExecutorName
	}
	return ""
}

func (m *Response_GetContainers_Container) GetContainerID() mesos.ContainerID {
	if m != nil {
		return m.ContainerID
	}
	return mesos.ContainerID{}
}

func (m *Response_GetContainers_Container) GetContainerStatus() *mesos.ContainerStatus {
	if m != nil {
		return m.ContainerStatus
	}
	return nil
}

func (m *Response_GetContainers_Container) GetResourceStatistics() *mesos.ResourceStatistics {
	if m != nil {
		return m.ResourceStatistics
	}
	return nil
}

// Information about all the frameworks known to the agent at the current
// time.
type Response_GetFrameworks struct {
	Frameworks          []Response_GetFrameworks_Framework `protobuf:"bytes,1,rep,name=frameworks" json:"frameworks"`
	CompletedFrameworks []Response_GetFrameworks_Framework `protobuf:"bytes,2,rep,name=completed_frameworks,json=completedFrameworks" json:"completed_frameworks"`
}

func (m *Response_GetFrameworks) Reset()                    { *m = Response_GetFrameworks{} }
func (*Response_GetFrameworks) ProtoMessage()               {}
func (*Response_GetFrameworks) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{1, 9} }

func (m *Response_GetFrameworks) GetFrameworks() []Response_GetFrameworks_Framework {
	if m != nil {
		return m.Frameworks
	}
	return nil
}

func (m *Response_GetFrameworks) GetCompletedFrameworks() []Response_GetFrameworks_Framework {
	if m != nil {
		return m.CompletedFrameworks
	}
	return nil
}

type Response_GetFrameworks_Framework struct {
	FrameworkInfo mesos.FrameworkInfo `protobuf:"bytes,1,req,name=framework_info,json=frameworkInfo" json:"framework_info"`
}

func (m *Response_GetFrameworks_Framework) Reset()      { *m = Response_GetFrameworks_Framework{} }
func (*Response_GetFrameworks_Framework) ProtoMessage() {}
func (*Response_GetFrameworks_Framework) Descriptor() ([]byte, []int) {
	return fileDescriptorAgent, []int{1, 9, 0}
}

func (m *Response_GetFrameworks_Framework) GetFrameworkInfo() mesos.FrameworkInfo {
	if m != nil {
		return m.FrameworkInfo
	}
	return mesos.FrameworkInfo{}
}

// Lists information about all the executors known to the agent at the
// current time.
type Response_GetExecutors struct {
	Executors          []Response_GetExecutors_Executor `protobuf:"bytes,1,rep,name=executors" json:"executors"`
	CompletedExecutors []Response_GetExecutors_Executor `protobuf:"bytes,2,rep,name=completed_executors,json=completedExecutors" json:"completed_executors"`
}

func (m *Response_GetExecutors) Reset()                    { *m = Response_GetExecutors{} }
func (*Response_GetExecutors) ProtoMessage()               {}
func (*Response_GetExecutors) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{1, 10} }

func (m *Response_GetExecutors) GetExecutors() []Response_GetExecutors_Executor {
	if m != nil {
		return m.Executors
	}
	return nil
}

func (m *Response_GetExecutors) GetCompletedExecutors() []Response_GetExecutors_Executor {
	if m != nil {
		return m.CompletedExecutors
	}
	return nil
}

type Response_GetExecutors_Executor struct {
	ExecutorInfo mesos.ExecutorInfo `protobuf:"bytes,1,req,name=executor_info,json=executorInfo" json:"executor_info"`
}

func (m *Response_GetExecutors_Executor) Reset()      { *m = Response_GetExecutors_Executor{} }
func (*Response_GetExecutors_Executor) ProtoMessage() {}
func (*Response_GetExecutors_Executor) Descriptor() ([]byte, []int) {
	return fileDescriptorAgent, []int{1, 10, 0}
}

func (m *Response_GetExecutors_Executor) GetExecutorInfo() mesos.ExecutorInfo {
	if m != nil {
		return m.ExecutorInfo
	}
	return mesos.ExecutorInfo{}
}

// Lists information about all the tasks known to the agent at the current
// time.
type Response_GetTasks struct {
	// Tasks that are pending in the agent's queue before an executor is
	// launched.
	PendingTasks []mesos.Task `protobuf:"bytes,1,rep,name=pending_tasks,json=pendingTasks" json:"pending_tasks"`
	// Tasks that are enqueued for a launched executor that has not yet
	// registered.
	QueuedTasks []mesos.Task `protobuf:"bytes,2,rep,name=queued_tasks,json=queuedTasks" json:"queued_tasks"`
	// Tasks that are running.
	LaunchedTasks []mesos.Task `protobuf:"bytes,3,rep,name=launched_tasks,json=launchedTasks" json:"launched_tasks"`
	// Tasks that are terminated but pending updates.
	TerminatedTasks []mesos.Task `protobuf:"bytes,4,rep,name=terminated_tasks,json=terminatedTasks" json:"terminated_tasks"`
	// Tasks that are terminated and updates acked.
	CompletedTasks []mesos.Task `protobuf:"bytes,5,rep,name=completed_tasks,json=completedTasks" json:"completed_tasks"`
}

func (m *Response_GetTasks) Reset()                    { *m = Response_GetTasks{} }
func (*Response_GetTasks) ProtoMessage()               {}
func (*Response_GetTasks) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{1, 11} }

func (m *Response_GetTasks) GetPendingTasks() []mesos.Task {
	if m != nil {
		return m.PendingTasks
	}
	return nil
}

func (m *Response_GetTasks) GetQueuedTasks() []mesos.Task {
	if m != nil {
		return m.QueuedTasks
	}
	return nil
}

func (m *Response_GetTasks) GetLaunchedTasks() []mesos.Task {
	if m != nil {
		return m.LaunchedTasks
	}
	return nil
}

func (m *Response_GetTasks) GetTerminatedTasks() []mesos.Task {
	if m != nil {
		return m.TerminatedTasks
	}
	return nil
}

func (m *Response_GetTasks) GetCompletedTasks() []mesos.Task {
	if m != nil {
		return m.CompletedTasks
	}
	return nil
}

// Contains the agent's information.
type Response_GetAgent struct {
	AgentInfo *mesos.AgentInfo `protobuf:"bytes,1,opt,name=agent_info,json=agentInfo" json:"agent_info,omitempty"`
}

func (m *Response_GetAgent) Reset()                    { *m = Response_GetAgent{} }
func (*Response_GetAgent) ProtoMessage()               {}
func (*Response_GetAgent) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{1, 12} }

func (m *Response_GetAgent) GetAgentInfo() *mesos.AgentInfo {
	if m != nil {
		return m.AgentInfo
	}
	return nil
}

// Returns termination information about the nested container.
type Response_WaitNestedContainer struct {
	ExitStatus *int32 `protobuf:"varint,1,opt,name=exit_status,json=exitStatus" json:"exit_status,omitempty"`
}

func (m *Response_WaitNestedContainer) Reset()      { *m = Response_WaitNestedContainer{} }
func (*Response_WaitNestedContainer) ProtoMessage() {}
func (*Response_WaitNestedContainer) Descriptor() ([]byte, []int) {
	return fileDescriptorAgent, []int{1, 13}
}

func (m *Response_WaitNestedContainer) GetExitStatus() int32 {
	if m != nil && m.ExitStatus != nil {
		return *m.ExitStatus
	}
	return 0
}

// *
// Streaming response to `Call::LAUNCH_NESTED_CONTAINER_SESSION` and
// `Call::ATTACH_CONTAINER_OUTPUT`.
//
// This message is also used to stream request data for
// `Call::ATTACH_CONTAINER_INPUT`.
type ProcessIO struct {
	Type    ProcessIO_Type     `protobuf:"varint,1,opt,name=type,enum=mesos.agent.ProcessIO_Type" json:"type"`
	Data    *ProcessIO_Data    `protobuf:"bytes,2,opt,name=data" json:"data,omitempty"`
	Control *ProcessIO_Control `protobuf:"bytes,3,opt,name=control" json:"control,omitempty"`
}

func (m *ProcessIO) Reset()                    { *m = ProcessIO{} }
func (*ProcessIO) ProtoMessage()               {}
func (*ProcessIO) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{2} }

func (m *ProcessIO) GetType() ProcessIO_Type {
	if m != nil {
		return m.Type
	}
	return ProcessIO_UNKNOWN
}

func (m *ProcessIO) GetData() *ProcessIO_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *ProcessIO) GetControl() *ProcessIO_Control {
	if m != nil {
		return m.Control
	}
	return nil
}

type ProcessIO_Data struct {
	Type ProcessIO_Data_Type `protobuf:"varint,1,opt,name=type,enum=mesos.agent.ProcessIO_Data_Type" json:"type"`
	Data []byte              `protobuf:"bytes,2,opt,name=data" json:"data,omitempty"`
}

func (m *ProcessIO_Data) Reset()                    { *m = ProcessIO_Data{} }
func (*ProcessIO_Data) ProtoMessage()               {}
func (*ProcessIO_Data) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{2, 0} }

func (m *ProcessIO_Data) GetType() ProcessIO_Data_Type {
	if m != nil {
		return m.Type
	}
	return ProcessIO_Data_UNKNOWN
}

func (m *ProcessIO_Data) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type ProcessIO_Control struct {
	Type      ProcessIO_Control_Type       `protobuf:"varint,1,opt,name=type,enum=mesos.agent.ProcessIO_Control_Type" json:"type"`
	TTYInfo   *mesos.TTYInfo               `protobuf:"bytes,2,opt,name=tty_info,json=ttyInfo" json:"tty_info,omitempty"`
	Heartbeat *ProcessIO_Control_Heartbeat `protobuf:"bytes,3,opt,name=heartbeat" json:"heartbeat,omitempty"`
}

func (m *ProcessIO_Control) Reset()                    { *m = ProcessIO_Control{} }
func (*ProcessIO_Control) ProtoMessage()               {}
func (*ProcessIO_Control) Descriptor() ([]byte, []int) { return fileDescriptorAgent, []int{2, 1} }

func (m *ProcessIO_Control) GetType() ProcessIO_Control_Type {
	if m != nil {
		return m.Type
	}
	return ProcessIO_Control_UNKNOWN
}

func (m *ProcessIO_Control) GetTTYInfo() *mesos.TTYInfo {
	if m != nil {
		return m.TTYInfo
	}
	return nil
}

func (m *ProcessIO_Control) GetHeartbeat() *ProcessIO_Control_Heartbeat {
	if m != nil {
		return m.Heartbeat
	}
	return nil
}

type ProcessIO_Control_Heartbeat struct {
	Interval *mesos.DurationInfo `protobuf:"bytes,1,opt,name=interval" json:"interval,omitempty"`
}

func (m *ProcessIO_Control_Heartbeat) Reset()      { *m = ProcessIO_Control_Heartbeat{} }
func (*ProcessIO_Control_Heartbeat) ProtoMessage() {}
func (*ProcessIO_Control_Heartbeat) Descriptor() ([]byte, []int) {
	return fileDescriptorAgent, []int{2, 1, 0}
}

func (m *ProcessIO_Control_Heartbeat) GetInterval() *mesos.DurationInfo {
	if m != nil {
		return m.Interval
	}
	return nil
}

func init() {
	proto.RegisterType((*Call)(nil), "mesos.agent.Call")
	proto.RegisterType((*Call_GetMetrics)(nil), "mesos.agent.Call.GetMetrics")
	proto.RegisterType((*Call_SetLoggingLevel)(nil), "mesos.agent.Call.SetLoggingLevel")
	proto.RegisterType((*Call_ListFiles)(nil), "mesos.agent.Call.ListFiles")
	proto.RegisterType((*Call_ReadFile)(nil), "mesos.agent.Call.ReadFile")
	proto.RegisterType((*Call_LaunchNestedContainer)(nil), "mesos.agent.Call.LaunchNestedContainer")
	proto.RegisterType((*Call_WaitNestedContainer)(nil), "mesos.agent.Call.WaitNestedContainer")
	proto.RegisterType((*Call_KillNestedContainer)(nil), "mesos.agent.Call.KillNestedContainer")
	proto.RegisterType((*Call_RemoveNestedContainer)(nil), "mesos.agent.Call.RemoveNestedContainer")
	proto.RegisterType((*Call_LaunchNestedContainerSession)(nil), "mesos.agent.Call.LaunchNestedContainerSession")
	proto.RegisterType((*Call_AttachContainerInput)(nil), "mesos.agent.Call.AttachContainerInput")
	proto.RegisterType((*Call_AttachContainerOutput)(nil), "mesos.agent.Call.AttachContainerOutput")
	proto.RegisterType((*Response)(nil), "mesos.agent.Response")
	proto.RegisterType((*Response_GetHealth)(nil), "mesos.agent.Response.GetHealth")
	proto.RegisterType((*Response_GetFlags)(nil), "mesos.agent.Response.GetFlags")
	proto.RegisterType((*Response_GetVersion)(nil), "mesos.agent.Response.GetVersion")
	proto.RegisterType((*Response_GetMetrics)(nil), "mesos.agent.Response.GetMetrics")
	proto.RegisterType((*Response_GetLoggingLevel)(nil), "mesos.agent.Response.GetLoggingLevel")
	proto.RegisterType((*Response_ListFiles)(nil), "mesos.agent.Response.ListFiles")
	proto.RegisterType((*Response_ReadFile)(nil), "mesos.agent.Response.ReadFile")
	proto.RegisterType((*Response_GetState)(nil), "mesos.agent.Response.GetState")
	proto.RegisterType((*Response_GetContainers)(nil), "mesos.agent.Response.GetContainers")
	proto.RegisterType((*Response_GetContainers_Container)(nil), "mesos.agent.Response.GetContainers.Container")
	proto.RegisterType((*Response_GetFrameworks)(nil), "mesos.agent.Response.GetFrameworks")
	proto.RegisterType((*Response_GetFrameworks_Framework)(nil), "mesos.agent.Response.GetFrameworks.Framework")
	proto.RegisterType((*Response_GetExecutors)(nil), "mesos.agent.Response.GetExecutors")
	proto.RegisterType((*Response_GetExecutors_Executor)(nil), "mesos.agent.Response.GetExecutors.Executor")
	proto.RegisterType((*Response_GetTasks)(nil), "mesos.agent.Response.GetTasks")
	proto.RegisterType((*Response_GetAgent)(nil), "mesos.agent.Response.GetAgent")
	proto.RegisterType((*Response_WaitNestedContainer)(nil), "mesos.agent.Response.WaitNestedContainer")
	proto.RegisterType((*ProcessIO)(nil), "mesos.agent.ProcessIO")
	proto.RegisterType((*ProcessIO_Data)(nil), "mesos.agent.ProcessIO.Data")
	proto.RegisterType((*ProcessIO_Control)(nil), "mesos.agent.ProcessIO.Control")
	proto.RegisterType((*ProcessIO_Control_Heartbeat)(nil), "mesos.agent.ProcessIO.Control.Heartbeat")
	proto.RegisterEnum("mesos.agent.Call_Type", Call_Type_name, Call_Type_value)
	proto.RegisterEnum("mesos.agent.Call_AttachContainerInput_Type", Call_AttachContainerInput_Type_name, Call_AttachContainerInput_Type_value)
	proto.RegisterEnum("mesos.agent.Response_Type", Response_Type_name, Response_Type_value)
	proto.RegisterEnum("mesos.agent.ProcessIO_Type", ProcessIO_Type_name, ProcessIO_Type_value)
	proto.RegisterEnum("mesos.agent.ProcessIO_Data_Type", ProcessIO_Data_Type_name, ProcessIO_Data_Type_value)
	proto.RegisterEnum("mesos.agent.ProcessIO_Control_Type", ProcessIO_Control_Type_name, ProcessIO_Control_Type_value)
}
func (x Call_Type) String() string {
	s, ok := Call_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Call_AttachContainerInput_Type) String() string {
	s, ok := Call_AttachContainerInput_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Response_Type) String() string {
	s, ok := Response_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x ProcessIO_Type) String() string {
	s, ok := ProcessIO_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x ProcessIO_Data_Type) String() string {
	s, ok := ProcessIO_Data_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x ProcessIO_Control_Type) String() string {
	s, ok := ProcessIO_Control_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (this *Call) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call)
	if !ok {
		that2, ok := that.(Call)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.GetMetrics.Equal(that1.GetMetrics) {
		return fmt.Errorf("GetMetrics this(%v) Not Equal that(%v)", this.GetMetrics, that1.GetMetrics)
	}
	if !this.SetLoggingLevel.Equal(that1.SetLoggingLevel) {
		return fmt.Errorf("SetLoggingLevel this(%v) Not Equal that(%v)", this.SetLoggingLevel, that1.SetLoggingLevel)
	}
	if !this.ListFiles.Equal(that1.ListFiles) {
		return fmt.Errorf("ListFiles this(%v) Not Equal that(%v)", this.ListFiles, that1.ListFiles)
	}
	if !this.ReadFile.Equal(that1.ReadFile) {
		return fmt.Errorf("ReadFile this(%v) Not Equal that(%v)", this.ReadFile, that1.ReadFile)
	}
	if !this.LaunchNestedContainer.Equal(that1.LaunchNestedContainer) {
		return fmt.Errorf("LaunchNestedContainer this(%v) Not Equal that(%v)", this.LaunchNestedContainer, that1.LaunchNestedContainer)
	}
	if !this.WaitNestedContainer.Equal(that1.WaitNestedContainer) {
		return fmt.Errorf("WaitNestedContainer this(%v) Not Equal that(%v)", this.WaitNestedContainer, that1.WaitNestedContainer)
	}
	if !this.KillNestedContainer.Equal(that1.KillNestedContainer) {
		return fmt.Errorf("KillNestedContainer this(%v) Not Equal that(%v)", this.KillNestedContainer, that1.KillNestedContainer)
	}
	if !this.RemoveNestedContainer.Equal(that1.RemoveNestedContainer) {
		return fmt.Errorf("RemoveNestedContainer this(%v) Not Equal that(%v)", this.RemoveNestedContainer, that1.RemoveNestedContainer)
	}
	if !this.LaunchNestedContainerSession.Equal(that1.LaunchNestedContainerSession) {
		return fmt.Errorf("LaunchNestedContainerSession this(%v) Not Equal that(%v)", this.LaunchNestedContainerSession, that1.LaunchNestedContainerSession)
	}
	if !this.AttachContainerInput.Equal(that1.AttachContainerInput) {
		return fmt.Errorf("AttachContainerInput this(%v) Not Equal that(%v)", this.AttachContainerInput, that1.AttachContainerInput)
	}
	if !this.AttachContainerOutput.Equal(that1.AttachContainerOutput) {
		return fmt.Errorf("AttachContainerOutput this(%v) Not Equal that(%v)", this.AttachContainerOutput, that1.AttachContainerOutput)
	}
	return nil
}
func (this *Call) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call)
	if !ok {
		that2, ok := that.(Call)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.GetMetrics.Equal(that1.GetMetrics) {
		return false
	}
	if !this.SetLoggingLevel.Equal(that1.SetLoggingLevel) {
		return false
	}
	if !this.ListFiles.Equal(that1.ListFiles) {
		return false
	}
	if !this.ReadFile.Equal(that1.ReadFile) {
		return false
	}
	if !this.LaunchNestedContainer.Equal(that1.LaunchNestedContainer) {
		return false
	}
	if !this.WaitNestedContainer.Equal(that1.WaitNestedContainer) {
		return false
	}
	if !this.KillNestedContainer.Equal(that1.KillNestedContainer) {
		return false
	}
	if !this.RemoveNestedContainer.Equal(that1.RemoveNestedContainer) {
		return false
	}
	if !this.LaunchNestedContainerSession.Equal(that1.LaunchNestedContainerSession) {
		return false
	}
	if !this.AttachContainerInput.Equal(that1.AttachContainerInput) {
		return false
	}
	if !this.AttachContainerOutput.Equal(that1.AttachContainerOutput) {
		return false
	}
	return true
}
func (this *Call_GetMetrics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_GetMetrics)
	if !ok {
		that2, ok := that.(Call_GetMetrics)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_GetMetrics")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_GetMetrics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_GetMetrics but is not nil && this == nil")
	}
	if !this.Timeout.Equal(that1.Timeout) {
		return fmt.Errorf("Timeout this(%v) Not Equal that(%v)", this.Timeout, that1.Timeout)
	}
	return nil
}
func (this *Call_GetMetrics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_GetMetrics)
	if !ok {
		that2, ok := that.(Call_GetMetrics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Timeout.Equal(that1.Timeout) {
		return false
	}
	return true
}
func (this *Call_SetLoggingLevel) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_SetLoggingLevel)
	if !ok {
		that2, ok := that.(Call_SetLoggingLevel)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_SetLoggingLevel")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_SetLoggingLevel but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_SetLoggingLevel but is not nil && this == nil")
	}
	if this.Level != that1.Level {
		return fmt.Errorf("Level this(%v) Not Equal that(%v)", this.Level, that1.Level)
	}
	if !this.Duration.Equal(&that1.Duration) {
		return fmt.Errorf("Duration this(%v) Not Equal that(%v)", this.Duration, that1.Duration)
	}
	return nil
}
func (this *Call_SetLoggingLevel) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_SetLoggingLevel)
	if !ok {
		that2, ok := that.(Call_SetLoggingLevel)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Level != that1.Level {
		return false
	}
	if !this.Duration.Equal(&that1.Duration) {
		return false
	}
	return true
}
func (this *Call_ListFiles) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_ListFiles)
	if !ok {
		that2, ok := that.(Call_ListFiles)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_ListFiles")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_ListFiles but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_ListFiles but is not nil && this == nil")
	}
	if this.Path != that1.Path {
		return fmt.Errorf("Path this(%v) Not Equal that(%v)", this.Path, that1.Path)
	}
	return nil
}
func (this *Call_ListFiles) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_ListFiles)
	if !ok {
		that2, ok := that.(Call_ListFiles)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	return true
}
func (this *Call_ReadFile) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_ReadFile)
	if !ok {
		that2, ok := that.(Call_ReadFile)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_ReadFile")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_ReadFile but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_ReadFile but is not nil && this == nil")
	}
	if this.Path != that1.Path {
		return fmt.Errorf("Path this(%v) Not Equal that(%v)", this.Path, that1.Path)
	}
	if this.Offset != that1.Offset {
		return fmt.Errorf("Offset this(%v) Not Equal that(%v)", this.Offset, that1.Offset)
	}
	if this.Length != nil && that1.Length != nil {
		if *this.Length != *that1.Length {
			return fmt.Errorf("Length this(%v) Not Equal that(%v)", *this.Length, *that1.Length)
		}
	} else if this.Length != nil {
		return fmt.Errorf("this.Length == nil && that.Length != nil")
	} else if that1.Length != nil {
		return fmt.Errorf("Length this(%v) Not Equal that(%v)", this.Length, that1.Length)
	}
	return nil
}
func (this *Call_ReadFile) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_ReadFile)
	if !ok {
		that2, ok := that.(Call_ReadFile)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if this.Offset != that1.Offset {
		return false
	}
	if this.Length != nil && that1.Length != nil {
		if *this.Length != *that1.Length {
			return false
		}
	} else if this.Length != nil {
		return false
	} else if that1.Length != nil {
		return false
	}
	return true
}
func (this *Call_LaunchNestedContainer) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_LaunchNestedContainer)
	if !ok {
		that2, ok := that.(Call_LaunchNestedContainer)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_LaunchNestedContainer")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_LaunchNestedContainer but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_LaunchNestedContainer but is not nil && this == nil")
	}
	if !this.ContainerID.Equal(&that1.ContainerID) {
		return fmt.Errorf("ContainerID this(%v) Not Equal that(%v)", this.ContainerID, that1.ContainerID)
	}
	if !this.Command.Equal(that1.Command) {
		return fmt.Errorf("Command this(%v) Not Equal that(%v)", this.Command, that1.Command)
	}
	if !this.Container.Equal(that1.Container) {
		return fmt.Errorf("Container this(%v) Not Equal that(%v)", this.Container, that1.Container)
	}
	return nil
}
func (this *Call_LaunchNestedContainer) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_LaunchNestedContainer)
	if !ok {
		that2, ok := that.(Call_LaunchNestedContainer)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ContainerID.Equal(&that1.ContainerID) {
		return false
	}
	if !this.Command.Equal(that1.Command) {
		return false
	}
	if !this.Container.Equal(that1.Container) {
		return false
	}
	return true
}
func (this *Call_WaitNestedContainer) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_WaitNestedContainer)
	if !ok {
		that2, ok := that.(Call_WaitNestedContainer)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_WaitNestedContainer")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_WaitNestedContainer but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_WaitNestedContainer but is not nil && this == nil")
	}
	if !this.ContainerID.Equal(&that1.ContainerID) {
		return fmt.Errorf("ContainerID this(%v) Not Equal that(%v)", this.ContainerID, that1.ContainerID)
	}
	return nil
}
func (this *Call_WaitNestedContainer) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_WaitNestedContainer)
	if !ok {
		that2, ok := that.(Call_WaitNestedContainer)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ContainerID.Equal(&that1.ContainerID) {
		return false
	}
	return true
}
func (this *Call_KillNestedContainer) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_KillNestedContainer)
	if !ok {
		that2, ok := that.(Call_KillNestedContainer)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_KillNestedContainer")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_KillNestedContainer but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_KillNestedContainer but is not nil && this == nil")
	}
	if !this.ContainerID.Equal(&that1.ContainerID) {
		return fmt.Errorf("ContainerID this(%v) Not Equal that(%v)", this.ContainerID, that1.ContainerID)
	}
	if this.Signal != nil && that1.Signal != nil {
		if *this.Signal != *that1.Signal {
			return fmt.Errorf("Signal this(%v) Not Equal that(%v)", *this.Signal, *that1.Signal)
		}
	} else if this.Signal != nil {
		return fmt.Errorf("this.Signal == nil && that.Signal != nil")
	} else if that1.Signal != nil {
		return fmt.Errorf("Signal this(%v) Not Equal that(%v)", this.Signal, that1.Signal)
	}
	return nil
}
func (this *Call_KillNestedContainer) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_KillNestedContainer)
	if !ok {
		that2, ok := that.(Call_KillNestedContainer)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ContainerID.Equal(&that1.ContainerID) {
		return false
	}
	if this.Signal != nil && that1.Signal != nil {
		if *this.Signal != *that1.Signal {
			return false
		}
	} else if this.Signal != nil {
		return false
	} else if that1.Signal != nil {
		return false
	}
	return true
}
func (this *Call_RemoveNestedContainer) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_RemoveNestedContainer)
	if !ok {
		that2, ok := that.(Call_RemoveNestedContainer)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_RemoveNestedContainer")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_RemoveNestedContainer but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_RemoveNestedContainer but is not nil && this == nil")
	}
	if !this.ContainerID.Equal(&that1.ContainerID) {
		return fmt.Errorf("ContainerID this(%v) Not Equal that(%v)", this.ContainerID, that1.ContainerID)
	}
	return nil
}
func (this *Call_RemoveNestedContainer) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_RemoveNestedContainer)
	if !ok {
		that2, ok := that.(Call_RemoveNestedContainer)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ContainerID.Equal(&that1.ContainerID) {
		return false
	}
	return true
}
func (this *Call_LaunchNestedContainerSession) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_LaunchNestedContainerSession)
	if !ok {
		that2, ok := that.(Call_LaunchNestedContainerSession)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_LaunchNestedContainerSession")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_LaunchNestedContainerSession but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_LaunchNestedContainerSession but is not nil && this == nil")
	}
	if !this.ContainerID.Equal(&that1.ContainerID) {
		return fmt.Errorf("ContainerID this(%v) Not Equal that(%v)", this.ContainerID, that1.ContainerID)
	}
	if !this.Command.Equal(that1.Command) {
		return fmt.Errorf("Command this(%v) Not Equal that(%v)", this.Command, that1.Command)
	}
	if !this.Container.Equal(that1.Container) {
		return fmt.Errorf("Container this(%v) Not Equal that(%v)", this.Container, that1.Container)
	}
	return nil
}
func (this *Call_LaunchNestedContainerSession) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_LaunchNestedContainerSession)
	if !ok {
		that2, ok := that.(Call_LaunchNestedContainerSession)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ContainerID.Equal(&that1.ContainerID) {
		return false
	}
	if !this.Command.Equal(that1.Command) {
		return false
	}
	if !this.Container.Equal(that1.Container) {
		return false
	}
	return true
}
func (this *Call_AttachContainerInput) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_AttachContainerInput)
	if !ok {
		that2, ok := that.(Call_AttachContainerInput)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_AttachContainerInput")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_AttachContainerInput but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_AttachContainerInput but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.ContainerID.Equal(that1.ContainerID) {
		return fmt.Errorf("ContainerID this(%v) Not Equal that(%v)", this.ContainerID, that1.ContainerID)
	}
	if !this.ProcessIO.Equal(that1.ProcessIO) {
		return fmt.Errorf("ProcessIO this(%v) Not Equal that(%v)", this.ProcessIO, that1.ProcessIO)
	}
	return nil
}
func (this *Call_AttachContainerInput) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_AttachContainerInput)
	if !ok {
		that2, ok := that.(Call_AttachContainerInput)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.ContainerID.Equal(that1.ContainerID) {
		return false
	}
	if !this.ProcessIO.Equal(that1.ProcessIO) {
		return false
	}
	return true
}
func (this *Call_AttachContainerOutput) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_AttachContainerOutput)
	if !ok {
		that2, ok := that.(Call_AttachContainerOutput)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_AttachContainerOutput")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_AttachContainerOutput but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_AttachContainerOutput but is not nil && this == nil")
	}
	if !this.ContainerID.Equal(&that1.ContainerID) {
		return fmt.Errorf("ContainerID this(%v) Not Equal that(%v)", this.ContainerID, that1.ContainerID)
	}
	return nil
}
func (this *Call_AttachContainerOutput) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_AttachContainerOutput)
	if !ok {
		that2, ok := that.(Call_AttachContainerOutput)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ContainerID.Equal(&that1.ContainerID) {
		return false
	}
	return true
}
func (this *Response) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response)
	if !ok {
		that2, ok := that.(Response)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.GetHealth.Equal(that1.GetHealth) {
		return fmt.Errorf("GetHealth this(%v) Not Equal that(%v)", this.GetHealth, that1.GetHealth)
	}
	if !this.GetFlags.Equal(that1.GetFlags) {
		return fmt.Errorf("GetFlags this(%v) Not Equal that(%v)", this.GetFlags, that1.GetFlags)
	}
	if !this.GetVersion.Equal(that1.GetVersion) {
		return fmt.Errorf("GetVersion this(%v) Not Equal that(%v)", this.GetVersion, that1.GetVersion)
	}
	if !this.GetMetrics.Equal(that1.GetMetrics) {
		return fmt.Errorf("GetMetrics this(%v) Not Equal that(%v)", this.GetMetrics, that1.GetMetrics)
	}
	if !this.GetLoggingLevel.Equal(that1.GetLoggingLevel) {
		return fmt.Errorf("GetLoggingLevel this(%v) Not Equal that(%v)", this.GetLoggingLevel, that1.GetLoggingLevel)
	}
	if !this.ListFiles.Equal(that1.ListFiles) {
		return fmt.Errorf("ListFiles this(%v) Not Equal that(%v)", this.ListFiles, that1.ListFiles)
	}
	if !this.ReadFile.Equal(that1.ReadFile) {
		return fmt.Errorf("ReadFile this(%v) Not Equal that(%v)", this.ReadFile, that1.ReadFile)
	}
	if !this.GetState.Equal(that1.GetState) {
		return fmt.Errorf("GetState this(%v) Not Equal that(%v)", this.GetState, that1.GetState)
	}
	if !this.GetContainers.Equal(that1.GetContainers) {
		return fmt.Errorf("GetContainers this(%v) Not Equal that(%v)", this.GetContainers, that1.GetContainers)
	}
	if !this.GetFrameworks.Equal(that1.GetFrameworks) {
		return fmt.Errorf("GetFrameworks this(%v) Not Equal that(%v)", this.GetFrameworks, that1.GetFrameworks)
	}
	if !this.GetExecutors.Equal(that1.GetExecutors) {
		return fmt.Errorf("GetExecutors this(%v) Not Equal that(%v)", this.GetExecutors, that1.GetExecutors)
	}
	if !this.GetTasks.Equal(that1.GetTasks) {
		return fmt.Errorf("GetTasks this(%v) Not Equal that(%v)", this.GetTasks, that1.GetTasks)
	}
	if !this.GetAgent.Equal(that1.GetAgent) {
		return fmt.Errorf("GetAgent this(%v) Not Equal that(%v)", this.GetAgent, that1.GetAgent)
	}
	if !this.WaitNestedContainer.Equal(that1.WaitNestedContainer) {
		return fmt.Errorf("WaitNestedContainer this(%v) Not Equal that(%v)", this.WaitNestedContainer, that1.WaitNestedContainer)
	}
	return nil
}
func (this *Response) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response)
	if !ok {
		that2, ok := that.(Response)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.GetHealth.Equal(that1.GetHealth) {
		return false
	}
	if !this.GetFlags.Equal(that1.GetFlags) {
		return false
	}
	if !this.GetVersion.Equal(that1.GetVersion) {
		return false
	}
	if !this.GetMetrics.Equal(that1.GetMetrics) {
		return false
	}
	if !this.GetLoggingLevel.Equal(that1.GetLoggingLevel) {
		return false
	}
	if !this.ListFiles.Equal(that1.ListFiles) {
		return false
	}
	if !this.ReadFile.Equal(that1.ReadFile) {
		return false
	}
	if !this.GetState.Equal(that1.GetState) {
		return false
	}
	if !this.GetContainers.Equal(that1.GetContainers) {
		return false
	}
	if !this.GetFrameworks.Equal(that1.GetFrameworks) {
		return false
	}
	if !this.GetExecutors.Equal(that1.GetExecutors) {
		return false
	}
	if !this.GetTasks.Equal(that1.GetTasks) {
		return false
	}
	if !this.GetAgent.Equal(that1.GetAgent) {
		return false
	}
	if !this.WaitNestedContainer.Equal(that1.WaitNestedContainer) {
		return false
	}
	return true
}
func (this *Response_GetHealth) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetHealth)
	if !ok {
		that2, ok := that.(Response_GetHealth)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetHealth")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetHealth but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetHealth but is not nil && this == nil")
	}
	if this.Healthy != that1.Healthy {
		return fmt.Errorf("Healthy this(%v) Not Equal that(%v)", this.Healthy, that1.Healthy)
	}
	return nil
}
func (this *Response_GetHealth) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetHealth)
	if !ok {
		that2, ok := that.(Response_GetHealth)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Healthy != that1.Healthy {
		return false
	}
	return true
}
func (this *Response_GetFlags) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetFlags)
	if !ok {
		that2, ok := that.(Response_GetFlags)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetFlags")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetFlags but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetFlags but is not nil && this == nil")
	}
	if len(this.Flags) != len(that1.Flags) {
		return fmt.Errorf("Flags this(%v) Not Equal that(%v)", len(this.Flags), len(that1.Flags))
	}
	for i := range this.Flags {
		if !this.Flags[i].Equal(&that1.Flags[i]) {
			return fmt.Errorf("Flags this[%v](%v) Not Equal that[%v](%v)", i, this.Flags[i], i, that1.Flags[i])
		}
	}
	return nil
}
func (this *Response_GetFlags) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetFlags)
	if !ok {
		that2, ok := that.(Response_GetFlags)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Flags) != len(that1.Flags) {
		return false
	}
	for i := range this.Flags {
		if !this.Flags[i].Equal(&that1.Flags[i]) {
			return false
		}
	}
	return true
}
func (this *Response_GetVersion) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetVersion)
	if !ok {
		that2, ok := that.(Response_GetVersion)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetVersion")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetVersion but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetVersion but is not nil && this == nil")
	}
	if !this.VersionInfo.Equal(&that1.VersionInfo) {
		return fmt.Errorf("VersionInfo this(%v) Not Equal that(%v)", this.VersionInfo, that1.VersionInfo)
	}
	return nil
}
func (this *Response_GetVersion) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetVersion)
	if !ok {
		that2, ok := that.(Response_GetVersion)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.VersionInfo.Equal(&that1.VersionInfo) {
		return false
	}
	return true
}
func (this *Response_GetMetrics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetMetrics)
	if !ok {
		that2, ok := that.(Response_GetMetrics)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetMetrics")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetMetrics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetMetrics but is not nil && this == nil")
	}
	if len(this.Metrics) != len(that1.Metrics) {
		return fmt.Errorf("Metrics this(%v) Not Equal that(%v)", len(this.Metrics), len(that1.Metrics))
	}
	for i := range this.Metrics {
		if !this.Metrics[i].Equal(&that1.Metrics[i]) {
			return fmt.Errorf("Metrics this[%v](%v) Not Equal that[%v](%v)", i, this.Metrics[i], i, that1.Metrics[i])
		}
	}
	return nil
}
func (this *Response_GetMetrics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetMetrics)
	if !ok {
		that2, ok := that.(Response_GetMetrics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Metrics) != len(that1.Metrics) {
		return false
	}
	for i := range this.Metrics {
		if !this.Metrics[i].Equal(&that1.Metrics[i]) {
			return false
		}
	}
	return true
}
func (this *Response_GetLoggingLevel) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetLoggingLevel)
	if !ok {
		that2, ok := that.(Response_GetLoggingLevel)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetLoggingLevel")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetLoggingLevel but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetLoggingLevel but is not nil && this == nil")
	}
	if this.Level != that1.Level {
		return fmt.Errorf("Level this(%v) Not Equal that(%v)", this.Level, that1.Level)
	}
	return nil
}
func (this *Response_GetLoggingLevel) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetLoggingLevel)
	if !ok {
		that2, ok := that.(Response_GetLoggingLevel)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Level != that1.Level {
		return false
	}
	return true
}
func (this *Response_ListFiles) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_ListFiles)
	if !ok {
		that2, ok := that.(Response_ListFiles)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_ListFiles")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_ListFiles but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_ListFiles but is not nil && this == nil")
	}
	if len(this.FileInfos) != len(that1.FileInfos) {
		return fmt.Errorf("FileInfos this(%v) Not Equal that(%v)", len(this.FileInfos), len(that1.FileInfos))
	}
	for i := range this.FileInfos {
		if !this.FileInfos[i].Equal(&that1.FileInfos[i]) {
			return fmt.Errorf("FileInfos this[%v](%v) Not Equal that[%v](%v)", i, this.FileInfos[i], i, that1.FileInfos[i])
		}
	}
	return nil
}
func (this *Response_ListFiles) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_ListFiles)
	if !ok {
		that2, ok := that.(Response_ListFiles)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.FileInfos) != len(that1.FileInfos) {
		return false
	}
	for i := range this.FileInfos {
		if !this.FileInfos[i].Equal(&that1.FileInfos[i]) {
			return false
		}
	}
	return true
}
func (this *Response_ReadFile) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_ReadFile)
	if !ok {
		that2, ok := that.(Response_ReadFile)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_ReadFile")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_ReadFile but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_ReadFile but is not nil && this == nil")
	}
	if this.Size != that1.Size {
		return fmt.Errorf("Size this(%v) Not Equal that(%v)", this.Size, that1.Size)
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	return nil
}
func (this *Response_ReadFile) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_ReadFile)
	if !ok {
		that2, ok := that.(Response_ReadFile)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Size != that1.Size {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	return true
}
func (this *Response_GetState) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetState)
	if !ok {
		that2, ok := that.(Response_GetState)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetState")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetState but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetState but is not nil && this == nil")
	}
	if !this.GetTasks.Equal(that1.GetTasks) {
		return fmt.Errorf("GetTasks this(%v) Not Equal that(%v)", this.GetTasks, that1.GetTasks)
	}
	if !this.GetExecutors.Equal(that1.GetExecutors) {
		return fmt.Errorf("GetExecutors this(%v) Not Equal that(%v)", this.GetExecutors, that1.GetExecutors)
	}
	if !this.GetFrameworks.Equal(that1.GetFrameworks) {
		return fmt.Errorf("GetFrameworks this(%v) Not Equal that(%v)", this.GetFrameworks, that1.GetFrameworks)
	}
	return nil
}
func (this *Response_GetState) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetState)
	if !ok {
		that2, ok := that.(Response_GetState)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.GetTasks.Equal(that1.GetTasks) {
		return false
	}
	if !this.GetExecutors.Equal(that1.GetExecutors) {
		return false
	}
	if !this.GetFrameworks.Equal(that1.GetFrameworks) {
		return false
	}
	return true
}
func (this *Response_GetContainers) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetContainers)
	if !ok {
		that2, ok := that.(Response_GetContainers)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetContainers")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetContainers but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetContainers but is not nil && this == nil")
	}
	if len(this.Containers) != len(that1.Containers) {
		return fmt.Errorf("Containers this(%v) Not Equal that(%v)", len(this.Containers), len(that1.Containers))
	}
	for i := range this.Containers {
		if !this.Containers[i].Equal(&that1.Containers[i]) {
			return fmt.Errorf("Containers this[%v](%v) Not Equal that[%v](%v)", i, this.Containers[i], i, that1.Containers[i])
		}
	}
	return nil
}
func (this *Response_GetContainers) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetContainers)
	if !ok {
		that2, ok := that.(Response_GetContainers)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Containers) != len(that1.Containers) {
		return false
	}
	for i := range this.Containers {
		if !this.Containers[i].Equal(&that1.Containers[i]) {
			return false
		}
	}
	return true
}
func (this *Response_GetContainers_Container) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetContainers_Container)
	if !ok {
		that2, ok := that.(Response_GetContainers_Container)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetContainers_Container")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetContainers_Container but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetContainers_Container but is not nil && this == nil")
	}
	if !this.FrameworkID.Equal(&that1.FrameworkID) {
		return fmt.Errorf("FrameworkID this(%v) Not Equal that(%v)", this.FrameworkID, that1.FrameworkID)
	}
	if !this.ExecutorID.Equal(&that1.ExecutorID) {
		return fmt.Errorf("ExecutorID this(%v) Not Equal that(%v)", this.ExecutorID, that1.ExecutorID)
	}
	if this.ExecutorName != that1.ExecutorName {
		return fmt.Errorf("ExecutorName this(%v) Not Equal that(%v)", this.ExecutorName, that1.ExecutorName)
	}
	if !this.ContainerID.Equal(&that1.ContainerID) {
		return fmt.Errorf("ContainerID this(%v) Not Equal that(%v)", this.ContainerID, that1.ContainerID)
	}
	if !this.ContainerStatus.Equal(that1.ContainerStatus) {
		return fmt.Errorf("ContainerStatus this(%v) Not Equal that(%v)", this.ContainerStatus, that1.ContainerStatus)
	}
	if !this.ResourceStatistics.Equal(that1.ResourceStatistics) {
		return fmt.Errorf("ResourceStatistics this(%v) Not Equal that(%v)", this.ResourceStatistics, that1.ResourceStatistics)
	}
	return nil
}
func (this *Response_GetContainers_Container) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetContainers_Container)
	if !ok {
		that2, ok := that.(Response_GetContainers_Container)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.FrameworkID.Equal(&that1.FrameworkID) {
		return false
	}
	if !this.ExecutorID.Equal(&that1.ExecutorID) {
		return false
	}
	if this.ExecutorName != that1.ExecutorName {
		return false
	}
	if !this.ContainerID.Equal(&that1.ContainerID) {
		return false
	}
	if !this.ContainerStatus.Equal(that1.ContainerStatus) {
		return false
	}
	if !this.ResourceStatistics.Equal(that1.ResourceStatistics) {
		return false
	}
	return true
}
func (this *Response_GetFrameworks) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetFrameworks)
	if !ok {
		that2, ok := that.(Response_GetFrameworks)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetFrameworks")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetFrameworks but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetFrameworks but is not nil && this == nil")
	}
	if len(this.Frameworks) != len(that1.Frameworks) {
		return fmt.Errorf("Frameworks this(%v) Not Equal that(%v)", len(this.Frameworks), len(that1.Frameworks))
	}
	for i := range this.Frameworks {
		if !this.Frameworks[i].Equal(&that1.Frameworks[i]) {
			return fmt.Errorf("Frameworks this[%v](%v) Not Equal that[%v](%v)", i, this.Frameworks[i], i, that1.Frameworks[i])
		}
	}
	if len(this.CompletedFrameworks) != len(that1.CompletedFrameworks) {
		return fmt.Errorf("CompletedFrameworks this(%v) Not Equal that(%v)", len(this.CompletedFrameworks), len(that1.CompletedFrameworks))
	}
	for i := range this.CompletedFrameworks {
		if !this.CompletedFrameworks[i].Equal(&that1.CompletedFrameworks[i]) {
			return fmt.Errorf("CompletedFrameworks this[%v](%v) Not Equal that[%v](%v)", i, this.CompletedFrameworks[i], i, that1.CompletedFrameworks[i])
		}
	}
	return nil
}
func (this *Response_GetFrameworks) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetFrameworks)
	if !ok {
		that2, ok := that.(Response_GetFrameworks)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Frameworks) != len(that1.Frameworks) {
		return false
	}
	for i := range this.Frameworks {
		if !this.Frameworks[i].Equal(&that1.Frameworks[i]) {
			return false
		}
	}
	if len(this.CompletedFrameworks) != len(that1.CompletedFrameworks) {
		return false
	}
	for i := range this.CompletedFrameworks {
		if !this.CompletedFrameworks[i].Equal(&that1.CompletedFrameworks[i]) {
			return false
		}
	}
	return true
}
func (this *Response_GetFrameworks_Framework) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetFrameworks_Framework)
	if !ok {
		that2, ok := that.(Response_GetFrameworks_Framework)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetFrameworks_Framework")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetFrameworks_Framework but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetFrameworks_Framework but is not nil && this == nil")
	}
	if !this.FrameworkInfo.Equal(&that1.FrameworkInfo) {
		return fmt.Errorf("FrameworkInfo this(%v) Not Equal that(%v)", this.FrameworkInfo, that1.FrameworkInfo)
	}
	return nil
}
func (this *Response_GetFrameworks_Framework) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetFrameworks_Framework)
	if !ok {
		that2, ok := that.(Response_GetFrameworks_Framework)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.FrameworkInfo.Equal(&that1.FrameworkInfo) {
		return false
	}
	return true
}
func (this *Response_GetExecutors) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetExecutors)
	if !ok {
		that2, ok := that.(Response_GetExecutors)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetExecutors")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetExecutors but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetExecutors but is not nil && this == nil")
	}
	if len(this.Executors) != len(that1.Executors) {
		return fmt.Errorf("Executors this(%v) Not Equal that(%v)", len(this.Executors), len(that1.Executors))
	}
	for i := range this.Executors {
		if !this.Executors[i].Equal(&that1.Executors[i]) {
			return fmt.Errorf("Executors this[%v](%v) Not Equal that[%v](%v)", i, this.Executors[i], i, that1.Executors[i])
		}
	}
	if len(this.CompletedExecutors) != len(that1.CompletedExecutors) {
		return fmt.Errorf("CompletedExecutors this(%v) Not Equal that(%v)", len(this.CompletedExecutors), len(that1.CompletedExecutors))
	}
	for i := range this.CompletedExecutors {
		if !this.CompletedExecutors[i].Equal(&that1.CompletedExecutors[i]) {
			return fmt.Errorf("CompletedExecutors this[%v](%v) Not Equal that[%v](%v)", i, this.CompletedExecutors[i], i, that1.CompletedExecutors[i])
		}
	}
	return nil
}
func (this *Response_GetExecutors) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetExecutors)
	if !ok {
		that2, ok := that.(Response_GetExecutors)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Executors) != len(that1.Executors) {
		return false
	}
	for i := range this.Executors {
		if !this.Executors[i].Equal(&that1.Executors[i]) {
			return false
		}
	}
	if len(this.CompletedExecutors) != len(that1.CompletedExecutors) {
		return false
	}
	for i := range this.CompletedExecutors {
		if !this.CompletedExecutors[i].Equal(&that1.CompletedExecutors[i]) {
			return false
		}
	}
	return true
}
func (this *Response_GetExecutors_Executor) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetExecutors_Executor)
	if !ok {
		that2, ok := that.(Response_GetExecutors_Executor)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetExecutors_Executor")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetExecutors_Executor but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetExecutors_Executor but is not nil && this == nil")
	}
	if !this.ExecutorInfo.Equal(&that1.ExecutorInfo) {
		return fmt.Errorf("ExecutorInfo this(%v) Not Equal that(%v)", this.ExecutorInfo, that1.ExecutorInfo)
	}
	return nil
}
func (this *Response_GetExecutors_Executor) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetExecutors_Executor)
	if !ok {
		that2, ok := that.(Response_GetExecutors_Executor)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ExecutorInfo.Equal(&that1.ExecutorInfo) {
		return false
	}
	return true
}
func (this *Response_GetTasks) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetTasks)
	if !ok {
		that2, ok := that.(Response_GetTasks)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetTasks")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetTasks but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetTasks but is not nil && this == nil")
	}
	if len(this.PendingTasks) != len(that1.PendingTasks) {
		return fmt.Errorf("PendingTasks this(%v) Not Equal that(%v)", len(this.PendingTasks), len(that1.PendingTasks))
	}
	for i := range this.PendingTasks {
		if !this.PendingTasks[i].Equal(&that1.PendingTasks[i]) {
			return fmt.Errorf("PendingTasks this[%v](%v) Not Equal that[%v](%v)", i, this.PendingTasks[i], i, that1.PendingTasks[i])
		}
	}
	if len(this.QueuedTasks) != len(that1.QueuedTasks) {
		return fmt.Errorf("QueuedTasks this(%v) Not Equal that(%v)", len(this.QueuedTasks), len(that1.QueuedTasks))
	}
	for i := range this.QueuedTasks {
		if !this.QueuedTasks[i].Equal(&that1.QueuedTasks[i]) {
			return fmt.Errorf("QueuedTasks this[%v](%v) Not Equal that[%v](%v)", i, this.QueuedTasks[i], i, that1.QueuedTasks[i])
		}
	}
	if len(this.LaunchedTasks) != len(that1.LaunchedTasks) {
		return fmt.Errorf("LaunchedTasks this(%v) Not Equal that(%v)", len(this.LaunchedTasks), len(that1.LaunchedTasks))
	}
	for i := range this.LaunchedTasks {
		if !this.LaunchedTasks[i].Equal(&that1.LaunchedTasks[i]) {
			return fmt.Errorf("LaunchedTasks this[%v](%v) Not Equal that[%v](%v)", i, this.LaunchedTasks[i], i, that1.LaunchedTasks[i])
		}
	}
	if len(this.TerminatedTasks) != len(that1.TerminatedTasks) {
		return fmt.Errorf("TerminatedTasks this(%v) Not Equal that(%v)", len(this.TerminatedTasks), len(that1.TerminatedTasks))
	}
	for i := range this.TerminatedTasks {
		if !this.TerminatedTasks[i].Equal(&that1.TerminatedTasks[i]) {
			return fmt.Errorf("TerminatedTasks this[%v](%v) Not Equal that[%v](%v)", i, this.TerminatedTasks[i], i, that1.TerminatedTasks[i])
		}
	}
	if len(this.CompletedTasks) != len(that1.CompletedTasks) {
		return fmt.Errorf("CompletedTasks this(%v) Not Equal that(%v)", len(this.CompletedTasks), len(that1.CompletedTasks))
	}
	for i := range this.CompletedTasks {
		if !this.CompletedTasks[i].Equal(&that1.CompletedTasks[i]) {
			return fmt.Errorf("CompletedTasks this[%v](%v) Not Equal that[%v](%v)", i, this.CompletedTasks[i], i, that1.CompletedTasks[i])
		}
	}
	return nil
}
func (this *Response_GetTasks) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetTasks)
	if !ok {
		that2, ok := that.(Response_GetTasks)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.PendingTasks) != len(that1.PendingTasks) {
		return false
	}
	for i := range this.PendingTasks {
		if !this.PendingTasks[i].Equal(&that1.PendingTasks[i]) {
			return false
		}
	}
	if len(this.QueuedTasks) != len(that1.QueuedTasks) {
		return false
	}
	for i := range this.QueuedTasks {
		if !this.QueuedTasks[i].Equal(&that1.QueuedTasks[i]) {
			return false
		}
	}
	if len(this.LaunchedTasks) != len(that1.LaunchedTasks) {
		return false
	}
	for i := range this.LaunchedTasks {
		if !this.LaunchedTasks[i].Equal(&that1.LaunchedTasks[i]) {
			return false
		}
	}
	if len(this.TerminatedTasks) != len(that1.TerminatedTasks) {
		return false
	}
	for i := range this.TerminatedTasks {
		if !this.TerminatedTasks[i].Equal(&that1.TerminatedTasks[i]) {
			return false
		}
	}
	if len(this.CompletedTasks) != len(that1.CompletedTasks) {
		return false
	}
	for i := range this.CompletedTasks {
		if !this.CompletedTasks[i].Equal(&that1.CompletedTasks[i]) {
			return false
		}
	}
	return true
}
func (this *Response_GetAgent) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_GetAgent)
	if !ok {
		that2, ok := that.(Response_GetAgent)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_GetAgent")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_GetAgent but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_GetAgent but is not nil && this == nil")
	}
	if !this.AgentInfo.Equal(that1.AgentInfo) {
		return fmt.Errorf("AgentInfo this(%v) Not Equal that(%v)", this.AgentInfo, that1.AgentInfo)
	}
	return nil
}
func (this *Response_GetAgent) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_GetAgent)
	if !ok {
		that2, ok := that.(Response_GetAgent)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.AgentInfo.Equal(that1.AgentInfo) {
		return false
	}
	return true
}
func (this *Response_WaitNestedContainer) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Response_WaitNestedContainer)
	if !ok {
		that2, ok := that.(Response_WaitNestedContainer)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Response_WaitNestedContainer")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Response_WaitNestedContainer but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Response_WaitNestedContainer but is not nil && this == nil")
	}
	if this.ExitStatus != nil && that1.ExitStatus != nil {
		if *this.ExitStatus != *that1.ExitStatus {
			return fmt.Errorf("ExitStatus this(%v) Not Equal that(%v)", *this.ExitStatus, *that1.ExitStatus)
		}
	} else if this.ExitStatus != nil {
		return fmt.Errorf("this.ExitStatus == nil && that.ExitStatus != nil")
	} else if that1.ExitStatus != nil {
		return fmt.Errorf("ExitStatus this(%v) Not Equal that(%v)", this.ExitStatus, that1.ExitStatus)
	}
	return nil
}
func (this *Response_WaitNestedContainer) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Response_WaitNestedContainer)
	if !ok {
		that2, ok := that.(Response_WaitNestedContainer)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.ExitStatus != nil && that1.ExitStatus != nil {
		if *this.ExitStatus != *that1.ExitStatus {
			return false
		}
	} else if this.ExitStatus != nil {
		return false
	} else if that1.ExitStatus != nil {
		return false
	}
	return true
}
func (this *ProcessIO) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ProcessIO)
	if !ok {
		that2, ok := that.(ProcessIO)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ProcessIO")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ProcessIO but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ProcessIO but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Data.Equal(that1.Data) {
		return fmt.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	if !this.Control.Equal(that1.Control) {
		return fmt.Errorf("Control this(%v) Not Equal that(%v)", this.Control, that1.Control)
	}
	return nil
}
func (this *ProcessIO) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ProcessIO)
	if !ok {
		that2, ok := that.(ProcessIO)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.Data.Equal(that1.Data) {
		return false
	}
	if !this.Control.Equal(that1.Control) {
		return false
	}
	return true
}
func (this *ProcessIO_Data) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ProcessIO_Data)
	if !ok {
		that2, ok := that.(ProcessIO_Data)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ProcessIO_Data")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ProcessIO_Data but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ProcessIO_Data but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	return nil
}
func (this *ProcessIO_Data) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ProcessIO_Data)
	if !ok {
		that2, ok := that.(ProcessIO_Data)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	return true
}
func (this *ProcessIO_Control) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ProcessIO_Control)
	if !ok {
		that2, ok := that.(ProcessIO_Control)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ProcessIO_Control")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ProcessIO_Control but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ProcessIO_Control but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.TTYInfo.Equal(that1.TTYInfo) {
		return fmt.Errorf("TTYInfo this(%v) Not Equal that(%v)", this.TTYInfo, that1.TTYInfo)
	}
	if !this.Heartbeat.Equal(that1.Heartbeat) {
		return fmt.Errorf("Heartbeat this(%v) Not Equal that(%v)", this.Heartbeat, that1.Heartbeat)
	}
	return nil
}
func (this *ProcessIO_Control) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ProcessIO_Control)
	if !ok {
		that2, ok := that.(ProcessIO_Control)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.TTYInfo.Equal(that1.TTYInfo) {
		return false
	}
	if !this.Heartbeat.Equal(that1.Heartbeat) {
		return false
	}
	return true
}
func (this *ProcessIO_Control_Heartbeat) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ProcessIO_Control_Heartbeat)
	if !ok {
		that2, ok := that.(ProcessIO_Control_Heartbeat)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *ProcessIO_Control_Heartbeat")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ProcessIO_Control_Heartbeat but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ProcessIO_Control_Heartbeat but is not nil && this == nil")
	}
	if !this.Interval.Equal(that1.Interval) {
		return fmt.Errorf("Interval this(%v) Not Equal that(%v)", this.Interval, that1.Interval)
	}
	return nil
}
func (this *ProcessIO_Control_Heartbeat) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ProcessIO_Control_Heartbeat)
	if !ok {
		that2, ok := that.(ProcessIO_Control_Heartbeat)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Interval.Equal(that1.Interval) {
		return false
	}
	return true
}
func (this *Call) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 16)
	s = append(s, "&agent.Call{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.GetMetrics != nil {
		s = append(s, "GetMetrics: "+fmt.Sprintf("%#v", this.GetMetrics)+",\n")
	}
	if this.SetLoggingLevel != nil {
		s = append(s, "SetLoggingLevel: "+fmt.Sprintf("%#v", this.SetLoggingLevel)+",\n")
	}
	if this.ListFiles != nil {
		s = append(s, "ListFiles: "+fmt.Sprintf("%#v", this.ListFiles)+",\n")
	}
	if this.ReadFile != nil {
		s = append(s, "ReadFile: "+fmt.Sprintf("%#v", this.ReadFile)+",\n")
	}
	if this.LaunchNestedContainer != nil {
		s = append(s, "LaunchNestedContainer: "+fmt.Sprintf("%#v", this.LaunchNestedContainer)+",\n")
	}
	if this.WaitNestedContainer != nil {
		s = append(s, "WaitNestedContainer: "+fmt.Sprintf("%#v", this.WaitNestedContainer)+",\n")
	}
	if this.KillNestedContainer != nil {
		s = append(s, "KillNestedContainer: "+fmt.Sprintf("%#v", this.KillNestedContainer)+",\n")
	}
	if this.RemoveNestedContainer != nil {
		s = append(s, "RemoveNestedContainer: "+fmt.Sprintf("%#v", this.RemoveNestedContainer)+",\n")
	}
	if this.LaunchNestedContainerSession != nil {
		s = append(s, "LaunchNestedContainerSession: "+fmt.Sprintf("%#v", this.LaunchNestedContainerSession)+",\n")
	}
	if this.AttachContainerInput != nil {
		s = append(s, "AttachContainerInput: "+fmt.Sprintf("%#v", this.AttachContainerInput)+",\n")
	}
	if this.AttachContainerOutput != nil {
		s = append(s, "AttachContainerOutput: "+fmt.Sprintf("%#v", this.AttachContainerOutput)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_GetMetrics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.Call_GetMetrics{")
	if this.Timeout != nil {
		s = append(s, "Timeout: "+fmt.Sprintf("%#v", this.Timeout)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_SetLoggingLevel) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&agent.Call_SetLoggingLevel{")
	s = append(s, "Level: "+fmt.Sprintf("%#v", this.Level)+",\n")
	s = append(s, "Duration: "+strings.Replace(this.Duration.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_ListFiles) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.Call_ListFiles{")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_ReadFile) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&agent.Call_ReadFile{")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "Offset: "+fmt.Sprintf("%#v", this.Offset)+",\n")
	if this.Length != nil {
		s = append(s, "Length: "+valueToGoStringAgent(this.Length, "uint64")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_LaunchNestedContainer) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&agent.Call_LaunchNestedContainer{")
	s = append(s, "ContainerID: "+strings.Replace(this.ContainerID.GoString(), `&`, ``, 1)+",\n")
	if this.Command != nil {
		s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	}
	if this.Container != nil {
		s = append(s, "Container: "+fmt.Sprintf("%#v", this.Container)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_WaitNestedContainer) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.Call_WaitNestedContainer{")
	s = append(s, "ContainerID: "+strings.Replace(this.ContainerID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_KillNestedContainer) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&agent.Call_KillNestedContainer{")
	s = append(s, "ContainerID: "+strings.Replace(this.ContainerID.GoString(), `&`, ``, 1)+",\n")
	if this.Signal != nil {
		s = append(s, "Signal: "+valueToGoStringAgent(this.Signal, "int32")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_RemoveNestedContainer) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.Call_RemoveNestedContainer{")
	s = append(s, "ContainerID: "+strings.Replace(this.ContainerID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_LaunchNestedContainerSession) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&agent.Call_LaunchNestedContainerSession{")
	s = append(s, "ContainerID: "+strings.Replace(this.ContainerID.GoString(), `&`, ``, 1)+",\n")
	if this.Command != nil {
		s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	}
	if this.Container != nil {
		s = append(s, "Container: "+fmt.Sprintf("%#v", this.Container)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_AttachContainerInput) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&agent.Call_AttachContainerInput{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.ContainerID != nil {
		s = append(s, "ContainerID: "+fmt.Sprintf("%#v", this.ContainerID)+",\n")
	}
	if this.ProcessIO != nil {
		s = append(s, "ProcessIO: "+fmt.Sprintf("%#v", this.ProcessIO)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_AttachContainerOutput) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.Call_AttachContainerOutput{")
	s = append(s, "ContainerID: "+strings.Replace(this.ContainerID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 19)
	s = append(s, "&agent.Response{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.GetHealth != nil {
		s = append(s, "GetHealth: "+fmt.Sprintf("%#v", this.GetHealth)+",\n")
	}
	if this.GetFlags != nil {
		s = append(s, "GetFlags: "+fmt.Sprintf("%#v", this.GetFlags)+",\n")
	}
	if this.GetVersion != nil {
		s = append(s, "GetVersion: "+fmt.Sprintf("%#v", this.GetVersion)+",\n")
	}
	if this.GetMetrics != nil {
		s = append(s, "GetMetrics: "+fmt.Sprintf("%#v", this.GetMetrics)+",\n")
	}
	if this.GetLoggingLevel != nil {
		s = append(s, "GetLoggingLevel: "+fmt.Sprintf("%#v", this.GetLoggingLevel)+",\n")
	}
	if this.ListFiles != nil {
		s = append(s, "ListFiles: "+fmt.Sprintf("%#v", this.ListFiles)+",\n")
	}
	if this.ReadFile != nil {
		s = append(s, "ReadFile: "+fmt.Sprintf("%#v", this.ReadFile)+",\n")
	}
	if this.GetState != nil {
		s = append(s, "GetState: "+fmt.Sprintf("%#v", this.GetState)+",\n")
	}
	if this.GetContainers != nil {
		s = append(s, "GetContainers: "+fmt.Sprintf("%#v", this.GetContainers)+",\n")
	}
	if this.GetFrameworks != nil {
		s = append(s, "GetFrameworks: "+fmt.Sprintf("%#v", this.GetFrameworks)+",\n")
	}
	if this.GetExecutors != nil {
		s = append(s, "GetExecutors: "+fmt.Sprintf("%#v", this.GetExecutors)+",\n")
	}
	if this.GetTasks != nil {
		s = append(s, "GetTasks: "+fmt.Sprintf("%#v", this.GetTasks)+",\n")
	}
	if this.GetAgent != nil {
		s = append(s, "GetAgent: "+fmt.Sprintf("%#v", this.GetAgent)+",\n")
	}
	if this.WaitNestedContainer != nil {
		s = append(s, "WaitNestedContainer: "+fmt.Sprintf("%#v", this.WaitNestedContainer)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetHealth) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.Response_GetHealth{")
	s = append(s, "Healthy: "+fmt.Sprintf("%#v", this.Healthy)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetFlags) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.Response_GetFlags{")
	if this.Flags != nil {
		s = append(s, "Flags: "+fmt.Sprintf("%#v", this.Flags)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetVersion) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.Response_GetVersion{")
	s = append(s, "VersionInfo: "+strings.Replace(this.VersionInfo.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetMetrics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.Response_GetMetrics{")
	if this.Metrics != nil {
		s = append(s, "Metrics: "+fmt.Sprintf("%#v", this.Metrics)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetLoggingLevel) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.Response_GetLoggingLevel{")
	s = append(s, "Level: "+fmt.Sprintf("%#v", this.Level)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_ListFiles) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.Response_ListFiles{")
	if this.FileInfos != nil {
		s = append(s, "FileInfos: "+fmt.Sprintf("%#v", this.FileInfos)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_ReadFile) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&agent.Response_ReadFile{")
	s = append(s, "Size: "+fmt.Sprintf("%#v", this.Size)+",\n")
	if this.Data != nil {
		s = append(s, "Data: "+valueToGoStringAgent(this.Data, "byte")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetState) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&agent.Response_GetState{")
	if this.GetTasks != nil {
		s = append(s, "GetTasks: "+fmt.Sprintf("%#v", this.GetTasks)+",\n")
	}
	if this.GetExecutors != nil {
		s = append(s, "GetExecutors: "+fmt.Sprintf("%#v", this.GetExecutors)+",\n")
	}
	if this.GetFrameworks != nil {
		s = append(s, "GetFrameworks: "+fmt.Sprintf("%#v", this.GetFrameworks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetContainers) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.Response_GetContainers{")
	if this.Containers != nil {
		s = append(s, "Containers: "+fmt.Sprintf("%#v", this.Containers)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetContainers_Container) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&agent.Response_GetContainers_Container{")
	s = append(s, "FrameworkID: "+strings.Replace(this.FrameworkID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "ExecutorID: "+strings.Replace(this.ExecutorID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "ExecutorName: "+fmt.Sprintf("%#v", this.ExecutorName)+",\n")
	s = append(s, "ContainerID: "+strings.Replace(this.ContainerID.GoString(), `&`, ``, 1)+",\n")
	if this.ContainerStatus != nil {
		s = append(s, "ContainerStatus: "+fmt.Sprintf("%#v", this.ContainerStatus)+",\n")
	}
	if this.ResourceStatistics != nil {
		s = append(s, "ResourceStatistics: "+fmt.Sprintf("%#v", this.ResourceStatistics)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetFrameworks) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&agent.Response_GetFrameworks{")
	if this.Frameworks != nil {
		s = append(s, "Frameworks: "+fmt.Sprintf("%#v", this.Frameworks)+",\n")
	}
	if this.CompletedFrameworks != nil {
		s = append(s, "CompletedFrameworks: "+fmt.Sprintf("%#v", this.CompletedFrameworks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetFrameworks_Framework) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.Response_GetFrameworks_Framework{")
	s = append(s, "FrameworkInfo: "+strings.Replace(this.FrameworkInfo.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetExecutors) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&agent.Response_GetExecutors{")
	if this.Executors != nil {
		s = append(s, "Executors: "+fmt.Sprintf("%#v", this.Executors)+",\n")
	}
	if this.CompletedExecutors != nil {
		s = append(s, "CompletedExecutors: "+fmt.Sprintf("%#v", this.CompletedExecutors)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetExecutors_Executor) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.Response_GetExecutors_Executor{")
	s = append(s, "ExecutorInfo: "+strings.Replace(this.ExecutorInfo.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetTasks) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&agent.Response_GetTasks{")
	if this.PendingTasks != nil {
		s = append(s, "PendingTasks: "+fmt.Sprintf("%#v", this.PendingTasks)+",\n")
	}
	if this.QueuedTasks != nil {
		s = append(s, "QueuedTasks: "+fmt.Sprintf("%#v", this.QueuedTasks)+",\n")
	}
	if this.LaunchedTasks != nil {
		s = append(s, "LaunchedTasks: "+fmt.Sprintf("%#v", this.LaunchedTasks)+",\n")
	}
	if this.TerminatedTasks != nil {
		s = append(s, "TerminatedTasks: "+fmt.Sprintf("%#v", this.TerminatedTasks)+",\n")
	}
	if this.CompletedTasks != nil {
		s = append(s, "CompletedTasks: "+fmt.Sprintf("%#v", this.CompletedTasks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_GetAgent) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.Response_GetAgent{")
	if this.AgentInfo != nil {
		s = append(s, "AgentInfo: "+fmt.Sprintf("%#v", this.AgentInfo)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Response_WaitNestedContainer) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.Response_WaitNestedContainer{")
	if this.ExitStatus != nil {
		s = append(s, "ExitStatus: "+valueToGoStringAgent(this.ExitStatus, "int32")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ProcessIO) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&agent.ProcessIO{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.Data != nil {
		s = append(s, "Data: "+fmt.Sprintf("%#v", this.Data)+",\n")
	}
	if this.Control != nil {
		s = append(s, "Control: "+fmt.Sprintf("%#v", this.Control)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ProcessIO_Data) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&agent.ProcessIO_Data{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.Data != nil {
		s = append(s, "Data: "+valueToGoStringAgent(this.Data, "byte")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ProcessIO_Control) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&agent.ProcessIO_Control{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.TTYInfo != nil {
		s = append(s, "TTYInfo: "+fmt.Sprintf("%#v", this.TTYInfo)+",\n")
	}
	if this.Heartbeat != nil {
		s = append(s, "Heartbeat: "+fmt.Sprintf("%#v", this.Heartbeat)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ProcessIO_Control_Heartbeat) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&agent.ProcessIO_Control_Heartbeat{")
	if this.Interval != nil {
		s = append(s, "Interval: "+fmt.Sprintf("%#v", this.Interval)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringAgent(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *Call) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.Type))
	if m.GetMetrics != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.GetMetrics.ProtoSize()))
		n1, err := m.GetMetrics.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.SetLoggingLevel != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.SetLoggingLevel.ProtoSize()))
		n2, err := m.SetLoggingLevel.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.ListFiles != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.ListFiles.ProtoSize()))
		n3, err := m.ListFiles.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.ReadFile != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.ReadFile.ProtoSize()))
		n4, err := m.ReadFile.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.LaunchNestedContainer != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.LaunchNestedContainer.ProtoSize()))
		n5, err := m.LaunchNestedContainer.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.WaitNestedContainer != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.WaitNestedContainer.ProtoSize()))
		n6, err := m.WaitNestedContainer.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.KillNestedContainer != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.KillNestedContainer.ProtoSize()))
		n7, err := m.KillNestedContainer.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.LaunchNestedContainerSession != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.LaunchNestedContainerSession.ProtoSize()))
		n8, err := m.LaunchNestedContainerSession.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.AttachContainerInput != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.AttachContainerInput.ProtoSize()))
		n9, err := m.AttachContainerInput.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.AttachContainerOutput != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.AttachContainerOutput.ProtoSize()))
		n10, err := m.AttachContainerOutput.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.RemoveNestedContainer != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.RemoveNestedContainer.ProtoSize()))
		n11, err := m.RemoveNestedContainer.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}

func (m *Call_GetMetrics) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_GetMetrics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Timeout != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Timeout.ProtoSize()))
		n12, err := m.Timeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}

func (m *Call_SetLoggingLevel) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_SetLoggingLevel) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.Level))
	dAtA[i] = 0x12
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.Duration.ProtoSize()))
	n13, err := m.Duration.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n13
	return i, nil
}

func (m *Call_ListFiles) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_ListFiles) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAgent(dAtA, i, uint64(len(m.Path)))
	i += copy(dAtA[i:], m.Path)
	return i, nil
}

func (m *Call_ReadFile) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_ReadFile) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAgent(dAtA, i, uint64(len(m.Path)))
	i += copy(dAtA[i:], m.Path)
	dAtA[i] = 0x10
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.Offset))
	if m.Length != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAgent(dAtA, i, uint64(*m.Length))
	}
	return i, nil
}

func (m *Call_LaunchNestedContainer) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_LaunchNestedContainer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.ContainerID.ProtoSize()))
	n14, err := m.ContainerID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n14
	if m.Command != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Command.ProtoSize()))
		n15, err := m.Command.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.Container != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Container.ProtoSize()))
		n16, err := m.Container.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}

func (m *Call_WaitNestedContainer) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_WaitNestedContainer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.ContainerID.ProtoSize()))
	n17, err := m.ContainerID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n17
	return i, nil
}

func (m *Call_KillNestedContainer) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_KillNestedContainer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.ContainerID.ProtoSize()))
	n18, err := m.ContainerID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	if m.Signal != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintAgent(dAtA, i, uint64(*m.Signal))
	}
	return i, nil
}

func (m *Call_RemoveNestedContainer) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_RemoveNestedContainer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.ContainerID.ProtoSize()))
	n19, err := m.ContainerID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n19
	return i, nil
}

func (m *Call_LaunchNestedContainerSession) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_LaunchNestedContainerSession) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.ContainerID.ProtoSize()))
	n20, err := m.ContainerID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n20
	if m.Command != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Command.ProtoSize()))
		n21, err := m.Command.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if m.Container != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Container.ProtoSize()))
		n22, err := m.Container.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	return i, nil
}

func (m *Call_AttachContainerInput) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_AttachContainerInput) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.Type))
	if m.ContainerID != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.ContainerID.ProtoSize()))
		n23, err := m.ContainerID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if m.ProcessIO != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.ProcessIO.ProtoSize()))
		n24, err := m.ProcessIO.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	return i, nil
}

func (m *Call_AttachContainerOutput) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_AttachContainerOutput) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.ContainerID.ProtoSize()))
	n25, err := m.ContainerID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n25
	return i, nil
}

func (m *Response) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.Type))
	if m.GetHealth != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.GetHealth.ProtoSize()))
		n26, err := m.GetHealth.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	if m.GetFlags != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.GetFlags.ProtoSize()))
		n27, err := m.GetFlags.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	if m.GetVersion != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.GetVersion.ProtoSize()))
		n28, err := m.GetVersion.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	if m.GetMetrics != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.GetMetrics.ProtoSize()))
		n29, err := m.GetMetrics.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	if m.GetLoggingLevel != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.GetLoggingLevel.ProtoSize()))
		n30, err := m.GetLoggingLevel.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n30
	}
	if m.ListFiles != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.ListFiles.ProtoSize()))
		n31, err := m.ListFiles.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	if m.ReadFile != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.ReadFile.ProtoSize()))
		n32, err := m.ReadFile.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n32
	}
	if m.GetState != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.GetState.ProtoSize()))
		n33, err := m.GetState.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n33
	}
	if m.GetContainers != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.GetContainers.ProtoSize()))
		n34, err := m.GetContainers.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n34
	}
	if m.GetFrameworks != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.GetFrameworks.ProtoSize()))
		n35, err := m.GetFrameworks.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n35
	}
	if m.GetExecutors != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.GetExecutors.ProtoSize()))
		n36, err := m.GetExecutors.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n36
	}
	if m.GetTasks != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.GetTasks.ProtoSize()))
		n37, err := m.GetTasks.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n37
	}
	if m.WaitNestedContainer != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.WaitNestedContainer.ProtoSize()))
		n38, err := m.WaitNestedContainer.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n38
	}
	if m.GetAgent != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.GetAgent.ProtoSize()))
		n39, err := m.GetAgent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n39
	}
	return i, nil
}

func (m *Response_GetHealth) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetHealth) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	if m.Healthy {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *Response_GetFlags) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetFlags) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Flags) > 0 {
		for _, msg := range m.Flags {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAgent(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_GetVersion) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetVersion) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.VersionInfo.ProtoSize()))
	n40, err := m.VersionInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n40
	return i, nil
}

func (m *Response_GetMetrics) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetMetrics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Metrics) > 0 {
		for _, msg := range m.Metrics {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAgent(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_GetLoggingLevel) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetLoggingLevel) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.Level))
	return i, nil
}

func (m *Response_ListFiles) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_ListFiles) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.FileInfos) > 0 {
		for _, msg := range m.FileInfos {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAgent(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_ReadFile) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_ReadFile) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.Size))
	if m.Data == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("data")
	} else {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *Response_GetState) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetState) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.GetTasks != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.GetTasks.ProtoSize()))
		n41, err := m.GetTasks.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n41
	}
	if m.GetExecutors != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.GetExecutors.ProtoSize()))
		n42, err := m.GetExecutors.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n42
	}
	if m.GetFrameworks != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.GetFrameworks.ProtoSize()))
		n43, err := m.GetFrameworks.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n43
	}
	return i, nil
}

func (m *Response_GetContainers) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetContainers) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Containers) > 0 {
		for _, msg := range m.Containers {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAgent(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_GetContainers_Container) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetContainers_Container) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.FrameworkID.ProtoSize()))
	n44, err := m.FrameworkID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n44
	dAtA[i] = 0x12
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.ExecutorID.ProtoSize()))
	n45, err := m.ExecutorID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n45
	dAtA[i] = 0x1a
	i++
	i = encodeVarintAgent(dAtA, i, uint64(len(m.ExecutorName)))
	i += copy(dAtA[i:], m.ExecutorName)
	dAtA[i] = 0x22
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.ContainerID.ProtoSize()))
	n46, err := m.ContainerID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n46
	if m.ContainerStatus != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.ContainerStatus.ProtoSize()))
		n47, err := m.ContainerStatus.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n47
	}
	if m.ResourceStatistics != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.ResourceStatistics.ProtoSize()))
		n48, err := m.ResourceStatistics.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n48
	}
	return i, nil
}

func (m *Response_GetFrameworks) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetFrameworks) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Frameworks) > 0 {
		for _, msg := range m.Frameworks {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAgent(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.CompletedFrameworks) > 0 {
		for _, msg := range m.CompletedFrameworks {
			dAtA[i] = 0x12
			i++
			i = encodeVarintAgent(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_GetFrameworks_Framework) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetFrameworks_Framework) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.FrameworkInfo.ProtoSize()))
	n49, err := m.FrameworkInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n49
	return i, nil
}

func (m *Response_GetExecutors) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetExecutors) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Executors) > 0 {
		for _, msg := range m.Executors {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAgent(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.CompletedExecutors) > 0 {
		for _, msg := range m.CompletedExecutors {
			dAtA[i] = 0x12
			i++
			i = encodeVarintAgent(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_GetExecutors_Executor) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetExecutors_Executor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.ExecutorInfo.ProtoSize()))
	n50, err := m.ExecutorInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n50
	return i, nil
}

func (m *Response_GetTasks) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetTasks) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.PendingTasks) > 0 {
		for _, msg := range m.PendingTasks {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAgent(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.QueuedTasks) > 0 {
		for _, msg := range m.QueuedTasks {
			dAtA[i] = 0x12
			i++
			i = encodeVarintAgent(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.LaunchedTasks) > 0 {
		for _, msg := range m.LaunchedTasks {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintAgent(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.TerminatedTasks) > 0 {
		for _, msg := range m.TerminatedTasks {
			dAtA[i] = 0x22
			i++
			i = encodeVarintAgent(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.CompletedTasks) > 0 {
		for _, msg := range m.CompletedTasks {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintAgent(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response_GetAgent) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_GetAgent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.AgentInfo != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.AgentInfo.ProtoSize()))
		n51, err := m.AgentInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n51
	}
	return i, nil
}

func (m *Response_WaitNestedContainer) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response_WaitNestedContainer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ExitStatus != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAgent(dAtA, i, uint64(*m.ExitStatus))
	}
	return i, nil
}

func (m *ProcessIO) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessIO) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.Type))
	if m.Data != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Data.ProtoSize()))
		n52, err := m.Data.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n52
	}
	if m.Control != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Control.ProtoSize()))
		n53, err := m.Control.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n53
	}
	return i, nil
}

func (m *ProcessIO_Data) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessIO_Data) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.Type))
	if m.Data != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAgent(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *ProcessIO_Control) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessIO_Control) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAgent(dAtA, i, uint64(m.Type))
	if m.TTYInfo != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.TTYInfo.ProtoSize()))
		n54, err := m.TTYInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n54
	}
	if m.Heartbeat != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Heartbeat.ProtoSize()))
		n55, err := m.Heartbeat.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n55
	}
	return i, nil
}

func (m *ProcessIO_Control_Heartbeat) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessIO_Control_Heartbeat) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Interval != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAgent(dAtA, i, uint64(m.Interval.ProtoSize()))
		n56, err := m.Interval.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n56
	}
	return i, nil
}

func encodeFixed64Agent(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Agent(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintAgent(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedCall(r randyAgent, easy bool) *Call {
	this := &Call{}
	this.Type = Call_Type([]int32{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 20, 14, 15, 16, 21, 17, 18, 19}[r.Intn(22)])
	if r.Intn(10) != 0 {
		this.GetMetrics = NewPopulatedCall_GetMetrics(r, easy)
	}
	if r.Intn(10) != 0 {
		this.SetLoggingLevel = NewPopulatedCall_SetLoggingLevel(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ListFiles = NewPopulatedCall_ListFiles(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ReadFile = NewPopulatedCall_ReadFile(r, easy)
	}
	if r.Intn(10) == 0 {
		this.LaunchNestedContainer = NewPopulatedCall_LaunchNestedContainer(r, easy)
	}
	if r.Intn(10) == 0 {
		this.WaitNestedContainer = NewPopulatedCall_WaitNestedContainer(r, easy)
	}
	if r.Intn(10) == 0 {
		this.KillNestedContainer = NewPopulatedCall_KillNestedContainer(r, easy)
	}
	if r.Intn(10) == 0 {
		this.LaunchNestedContainerSession = NewPopulatedCall_LaunchNestedContainerSession(r, easy)
	}
	if r.Intn(10) == 0 {
		this.AttachContainerInput = NewPopulatedCall_AttachContainerInput(r, easy)
	}
	if r.Intn(10) == 0 {
		this.AttachContainerOutput = NewPopulatedCall_AttachContainerOutput(r, easy)
	}
	if r.Intn(10) == 0 {
		this.RemoveNestedContainer = NewPopulatedCall_RemoveNestedContainer(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_GetMetrics(r randyAgent, easy bool) *Call_GetMetrics {
	this := &Call_GetMetrics{}
	if r.Intn(10) != 0 {
		this.Timeout = mesos.NewPopulatedDurationInfo(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_SetLoggingLevel(r randyAgent, easy bool) *Call_SetLoggingLevel {
	this := &Call_SetLoggingLevel{}
	this.Level = uint32(r.Uint32())
	v1 := mesos.NewPopulatedDurationInfo(r, easy)
	this.Duration = *v1
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_ListFiles(r randyAgent, easy bool) *Call_ListFiles {
	this := &Call_ListFiles{}
	this.Path = string(randStringAgent(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_ReadFile(r randyAgent, easy bool) *Call_ReadFile {
	this := &Call_ReadFile{}
	this.Path = string(randStringAgent(r))
	this.Offset = uint64(uint64(r.Uint32()))
	if r.Intn(10) != 0 {
		v2 := uint64(uint64(r.Uint32()))
		this.Length = &v2
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_LaunchNestedContainer(r randyAgent, easy bool) *Call_LaunchNestedContainer {
	this := &Call_LaunchNestedContainer{}
	v3 := mesos.NewPopulatedContainerID(r, easy)
	this.ContainerID = *v3
	if r.Intn(10) != 0 {
		this.Command = mesos.NewPopulatedCommandInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Container = mesos.NewPopulatedContainerInfo(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_WaitNestedContainer(r randyAgent, easy bool) *Call_WaitNestedContainer {
	this := &Call_WaitNestedContainer{}
	v4 := mesos.NewPopulatedContainerID(r, easy)
	this.ContainerID = *v4
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_KillNestedContainer(r randyAgent, easy bool) *Call_KillNestedContainer {
	this := &Call_KillNestedContainer{}
	v5 := mesos.NewPopulatedContainerID(r, easy)
	this.ContainerID = *v5
	if r.Intn(10) != 0 {
		v6 := int32(r.Int31())
		if r.Intn(2) == 0 {
			v6 *= -1
		}
		this.Signal = &v6
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_RemoveNestedContainer(r randyAgent, easy bool) *Call_RemoveNestedContainer {
	this := &Call_RemoveNestedContainer{}
	v7 := mesos.NewPopulatedContainerID(r, easy)
	this.ContainerID = *v7
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_LaunchNestedContainerSession(r randyAgent, easy bool) *Call_LaunchNestedContainerSession {
	this := &Call_LaunchNestedContainerSession{}
	v8 := mesos.NewPopulatedContainerID(r, easy)
	this.ContainerID = *v8
	if r.Intn(10) != 0 {
		this.Command = mesos.NewPopulatedCommandInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Container = mesos.NewPopulatedContainerInfo(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_AttachContainerInput(r randyAgent, easy bool) *Call_AttachContainerInput {
	this := &Call_AttachContainerInput{}
	this.Type = Call_AttachContainerInput_Type([]int32{0, 1, 2}[r.Intn(3)])
	if r.Intn(10) == 0 {
		this.ContainerID = mesos.NewPopulatedContainerID(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ProcessIO = NewPopulatedProcessIO(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_AttachContainerOutput(r randyAgent, easy bool) *Call_AttachContainerOutput {
	this := &Call_AttachContainerOutput{}
	v9 := mesos.NewPopulatedContainerID(r, easy)
	this.ContainerID = *v9
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse(r randyAgent, easy bool) *Response {
	this := &Response{}
	this.Type = Response_Type([]int32{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 13}[r.Intn(15)])
	if r.Intn(10) != 0 {
		this.GetHealth = NewPopulatedResponse_GetHealth(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetFlags = NewPopulatedResponse_GetFlags(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetVersion = NewPopulatedResponse_GetVersion(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetMetrics = NewPopulatedResponse_GetMetrics(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetLoggingLevel = NewPopulatedResponse_GetLoggingLevel(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ListFiles = NewPopulatedResponse_ListFiles(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ReadFile = NewPopulatedResponse_ReadFile(r, easy)
	}
	if r.Intn(10) == 0 {
		this.GetState = NewPopulatedResponse_GetState(r, easy)
	}
	if r.Intn(10) == 0 {
		this.GetContainers = NewPopulatedResponse_GetContainers(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetFrameworks = NewPopulatedResponse_GetFrameworks(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetExecutors = NewPopulatedResponse_GetExecutors(r, easy)
	}
	if r.Intn(10) == 0 {
		this.GetTasks = NewPopulatedResponse_GetTasks(r, easy)
	}
	if r.Intn(10) != 0 {
		this.WaitNestedContainer = NewPopulatedResponse_WaitNestedContainer(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetAgent = NewPopulatedResponse_GetAgent(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetHealth(r randyAgent, easy bool) *Response_GetHealth {
	this := &Response_GetHealth{}
	this.Healthy = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetFlags(r randyAgent, easy bool) *Response_GetFlags {
	this := &Response_GetFlags{}
	if r.Intn(10) != 0 {
		v10 := r.Intn(5)
		this.Flags = make([]mesos.Flag, v10)
		for i := 0; i < v10; i++ {
			v11 := mesos.NewPopulatedFlag(r, easy)
			this.Flags[i] = *v11
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetVersion(r randyAgent, easy bool) *Response_GetVersion {
	this := &Response_GetVersion{}
	v12 := mesos.NewPopulatedVersionInfo(r, easy)
	this.VersionInfo = *v12
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetMetrics(r randyAgent, easy bool) *Response_GetMetrics {
	this := &Response_GetMetrics{}
	if r.Intn(10) != 0 {
		v13 := r.Intn(5)
		this.Metrics = make([]mesos.Metric, v13)
		for i := 0; i < v13; i++ {
			v14 := mesos.NewPopulatedMetric(r, easy)
			this.Metrics[i] = *v14
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetLoggingLevel(r randyAgent, easy bool) *Response_GetLoggingLevel {
	this := &Response_GetLoggingLevel{}
	this.Level = uint32(r.Uint32())
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_ListFiles(r randyAgent, easy bool) *Response_ListFiles {
	this := &Response_ListFiles{}
	if r.Intn(10) != 0 {
		v15 := r.Intn(5)
		this.FileInfos = make([]mesos.FileInfo, v15)
		for i := 0; i < v15; i++ {
			v16 := mesos.NewPopulatedFileInfo(r, easy)
			this.FileInfos[i] = *v16
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_ReadFile(r randyAgent, easy bool) *Response_ReadFile {
	this := &Response_ReadFile{}
	this.Size = uint64(uint64(r.Uint32()))
	v17 := r.Intn(100)
	this.Data = make([]byte, v17)
	for i := 0; i < v17; i++ {
		this.Data[i] = byte(r.Intn(256))
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetState(r randyAgent, easy bool) *Response_GetState {
	this := &Response_GetState{}
	if r.Intn(10) == 0 {
		this.GetTasks = NewPopulatedResponse_GetTasks(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetExecutors = NewPopulatedResponse_GetExecutors(r, easy)
	}
	if r.Intn(10) != 0 {
		this.GetFrameworks = NewPopulatedResponse_GetFrameworks(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetContainers(r randyAgent, easy bool) *Response_GetContainers {
	this := &Response_GetContainers{}
	if r.Intn(10) == 0 {
		v18 := r.Intn(5)
		this.Containers = make([]Response_GetContainers_Container, v18)
		for i := 0; i < v18; i++ {
			v19 := NewPopulatedResponse_GetContainers_Container(r, easy)
			this.Containers[i] = *v19
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetContainers_Container(r randyAgent, easy bool) *Response_GetContainers_Container {
	this := &Response_GetContainers_Container{}
	v20 := mesos.NewPopulatedFrameworkID(r, easy)
	this.FrameworkID = *v20
	v21 := mesos.NewPopulatedExecutorID(r, easy)
	this.ExecutorID = *v21
	this.ExecutorName = string(randStringAgent(r))
	v22 := mesos.NewPopulatedContainerID(r, easy)
	this.ContainerID = *v22
	if r.Intn(10) == 0 {
		this.ContainerStatus = mesos.NewPopulatedContainerStatus(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ResourceStatistics = mesos.NewPopulatedResourceStatistics(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetFrameworks(r randyAgent, easy bool) *Response_GetFrameworks {
	this := &Response_GetFrameworks{}
	if r.Intn(10) != 0 {
		v23 := r.Intn(5)
		this.Frameworks = make([]Response_GetFrameworks_Framework, v23)
		for i := 0; i < v23; i++ {
			v24 := NewPopulatedResponse_GetFrameworks_Framework(r, easy)
			this.Frameworks[i] = *v24
		}
	}
	if r.Intn(10) != 0 {
		v25 := r.Intn(5)
		this.CompletedFrameworks = make([]Response_GetFrameworks_Framework, v25)
		for i := 0; i < v25; i++ {
			v26 := NewPopulatedResponse_GetFrameworks_Framework(r, easy)
			this.CompletedFrameworks[i] = *v26
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetFrameworks_Framework(r randyAgent, easy bool) *Response_GetFrameworks_Framework {
	this := &Response_GetFrameworks_Framework{}
	v27 := mesos.NewPopulatedFrameworkInfo(r, easy)
	this.FrameworkInfo = *v27
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetExecutors(r randyAgent, easy bool) *Response_GetExecutors {
	this := &Response_GetExecutors{}
	if r.Intn(10) != 0 {
		v28 := r.Intn(5)
		this.Executors = make([]Response_GetExecutors_Executor, v28)
		for i := 0; i < v28; i++ {
			v29 := NewPopulatedResponse_GetExecutors_Executor(r, easy)
			this.Executors[i] = *v29
		}
	}
	if r.Intn(10) != 0 {
		v30 := r.Intn(5)
		this.CompletedExecutors = make([]Response_GetExecutors_Executor, v30)
		for i := 0; i < v30; i++ {
			v31 := NewPopulatedResponse_GetExecutors_Executor(r, easy)
			this.CompletedExecutors[i] = *v31
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetExecutors_Executor(r randyAgent, easy bool) *Response_GetExecutors_Executor {
	this := &Response_GetExecutors_Executor{}
	v32 := mesos.NewPopulatedExecutorInfo(r, easy)
	this.ExecutorInfo = *v32
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetTasks(r randyAgent, easy bool) *Response_GetTasks {
	this := &Response_GetTasks{}
	if r.Intn(10) == 0 {
		v33 := r.Intn(5)
		this.PendingTasks = make([]mesos.Task, v33)
		for i := 0; i < v33; i++ {
			v34 := mesos.NewPopulatedTask(r, easy)
			this.PendingTasks[i] = *v34
		}
	}
	if r.Intn(10) == 0 {
		v35 := r.Intn(5)
		this.QueuedTasks = make([]mesos.Task, v35)
		for i := 0; i < v35; i++ {
			v36 := mesos.NewPopulatedTask(r, easy)
			this.QueuedTasks[i] = *v36
		}
	}
	if r.Intn(10) == 0 {
		v37 := r.Intn(5)
		this.LaunchedTasks = make([]mesos.Task, v37)
		for i := 0; i < v37; i++ {
			v38 := mesos.NewPopulatedTask(r, easy)
			this.LaunchedTasks[i] = *v38
		}
	}
	if r.Intn(10) == 0 {
		v39 := r.Intn(5)
		this.TerminatedTasks = make([]mesos.Task, v39)
		for i := 0; i < v39; i++ {
			v40 := mesos.NewPopulatedTask(r, easy)
			this.TerminatedTasks[i] = *v40
		}
	}
	if r.Intn(10) == 0 {
		v41 := r.Intn(5)
		this.CompletedTasks = make([]mesos.Task, v41)
		for i := 0; i < v41; i++ {
			v42 := mesos.NewPopulatedTask(r, easy)
			this.CompletedTasks[i] = *v42
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_GetAgent(r randyAgent, easy bool) *Response_GetAgent {
	this := &Response_GetAgent{}
	if r.Intn(10) != 0 {
		this.AgentInfo = mesos.NewPopulatedAgentInfo(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedResponse_WaitNestedContainer(r randyAgent, easy bool) *Response_WaitNestedContainer {
	this := &Response_WaitNestedContainer{}
	if r.Intn(10) != 0 {
		v43 := int32(r.Int31())
		if r.Intn(2) == 0 {
			v43 *= -1
		}
		this.ExitStatus = &v43
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedProcessIO(r randyAgent, easy bool) *ProcessIO {
	this := &ProcessIO{}
	this.Type = ProcessIO_Type([]int32{0, 1, 2}[r.Intn(3)])
	if r.Intn(10) != 0 {
		this.Data = NewPopulatedProcessIO_Data(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Control = NewPopulatedProcessIO_Control(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedProcessIO_Data(r randyAgent, easy bool) *ProcessIO_Data {
	this := &ProcessIO_Data{}
	this.Type = ProcessIO_Data_Type([]int32{0, 1, 2, 3}[r.Intn(4)])
	if r.Intn(10) != 0 {
		v44 := r.Intn(100)
		this.Data = make([]byte, v44)
		for i := 0; i < v44; i++ {
			this.Data[i] = byte(r.Intn(256))
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedProcessIO_Control(r randyAgent, easy bool) *ProcessIO_Control {
	this := &ProcessIO_Control{}
	this.Type = ProcessIO_Control_Type([]int32{0, 1, 2}[r.Intn(3)])
	if r.Intn(10) != 0 {
		this.TTYInfo = mesos.NewPopulatedTTYInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Heartbeat = NewPopulatedProcessIO_Control_Heartbeat(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedProcessIO_Control_Heartbeat(r randyAgent, easy bool) *ProcessIO_Control_Heartbeat {
	this := &ProcessIO_Control_Heartbeat{}
	if r.Intn(10) != 0 {
		this.Interval = mesos.NewPopulatedDurationInfo(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyAgent interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneAgent(r randyAgent) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringAgent(r randyAgent) string {
	v45 := r.Intn(100)
	tmps := make([]rune, v45)
	for i := 0; i < v45; i++ {
		tmps[i] = randUTF8RuneAgent(r)
	}
	return string(tmps)
}
func randUnrecognizedAgent(r randyAgent, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldAgent(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldAgent(dAtA []byte, r randyAgent, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateAgent(dAtA, uint64(key))
		v46 := r.Int63()
		if r.Intn(2) == 0 {
			v46 *= -1
		}
		dAtA = encodeVarintPopulateAgent(dAtA, uint64(v46))
	case 1:
		dAtA = encodeVarintPopulateAgent(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateAgent(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateAgent(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateAgent(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateAgent(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Call) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovAgent(uint64(m.Type))
	if m.GetMetrics != nil {
		l = m.GetMetrics.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.SetLoggingLevel != nil {
		l = m.SetLoggingLevel.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.ListFiles != nil {
		l = m.ListFiles.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.ReadFile != nil {
		l = m.ReadFile.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.LaunchNestedContainer != nil {
		l = m.LaunchNestedContainer.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.WaitNestedContainer != nil {
		l = m.WaitNestedContainer.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.KillNestedContainer != nil {
		l = m.KillNestedContainer.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.LaunchNestedContainerSession != nil {
		l = m.LaunchNestedContainerSession.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.AttachContainerInput != nil {
		l = m.AttachContainerInput.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.AttachContainerOutput != nil {
		l = m.AttachContainerOutput.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.RemoveNestedContainer != nil {
		l = m.RemoveNestedContainer.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *Call_GetMetrics) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Timeout != nil {
		l = m.Timeout.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *Call_SetLoggingLevel) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovAgent(uint64(m.Level))
	l = m.Duration.ProtoSize()
	n += 1 + l + sovAgent(uint64(l))
	return n
}

func (m *Call_ListFiles) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Path)
	n += 1 + l + sovAgent(uint64(l))
	return n
}

func (m *Call_ReadFile) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Path)
	n += 1 + l + sovAgent(uint64(l))
	n += 1 + sovAgent(uint64(m.Offset))
	if m.Length != nil {
		n += 1 + sovAgent(uint64(*m.Length))
	}
	return n
}

func (m *Call_LaunchNestedContainer) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.ContainerID.ProtoSize()
	n += 1 + l + sovAgent(uint64(l))
	if m.Command != nil {
		l = m.Command.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Container != nil {
		l = m.Container.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *Call_WaitNestedContainer) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.ContainerID.ProtoSize()
	n += 1 + l + sovAgent(uint64(l))
	return n
}

func (m *Call_KillNestedContainer) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.ContainerID.ProtoSize()
	n += 1 + l + sovAgent(uint64(l))
	if m.Signal != nil {
		n += 1 + sovAgent(uint64(*m.Signal))
	}
	return n
}

func (m *Call_RemoveNestedContainer) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.ContainerID.ProtoSize()
	n += 1 + l + sovAgent(uint64(l))
	return n
}

func (m *Call_LaunchNestedContainerSession) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.ContainerID.ProtoSize()
	n += 1 + l + sovAgent(uint64(l))
	if m.Command != nil {
		l = m.Command.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Container != nil {
		l = m.Container.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *Call_AttachContainerInput) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovAgent(uint64(m.Type))
	if m.ContainerID != nil {
		l = m.ContainerID.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.ProcessIO != nil {
		l = m.ProcessIO.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *Call_AttachContainerOutput) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.ContainerID.ProtoSize()
	n += 1 + l + sovAgent(uint64(l))
	return n
}

func (m *Response) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovAgent(uint64(m.Type))
	if m.GetHealth != nil {
		l = m.GetHealth.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GetFlags != nil {
		l = m.GetFlags.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GetVersion != nil {
		l = m.GetVersion.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GetMetrics != nil {
		l = m.GetMetrics.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GetLoggingLevel != nil {
		l = m.GetLoggingLevel.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.ListFiles != nil {
		l = m.ListFiles.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.ReadFile != nil {
		l = m.ReadFile.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GetState != nil {
		l = m.GetState.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GetContainers != nil {
		l = m.GetContainers.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GetFrameworks != nil {
		l = m.GetFrameworks.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GetExecutors != nil {
		l = m.GetExecutors.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GetTasks != nil {
		l = m.GetTasks.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.WaitNestedContainer != nil {
		l = m.WaitNestedContainer.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GetAgent != nil {
		l = m.GetAgent.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *Response_GetHealth) ProtoSize() (n int) {
	var l int
	_ = l
	n += 2
	return n
}

func (m *Response_GetFlags) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Flags) > 0 {
		for _, e := range m.Flags {
			l = e.ProtoSize()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	return n
}

func (m *Response_GetVersion) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.VersionInfo.ProtoSize()
	n += 1 + l + sovAgent(uint64(l))
	return n
}

func (m *Response_GetMetrics) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Metrics) > 0 {
		for _, e := range m.Metrics {
			l = e.ProtoSize()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	return n
}

func (m *Response_GetLoggingLevel) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovAgent(uint64(m.Level))
	return n
}

func (m *Response_ListFiles) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.FileInfos) > 0 {
		for _, e := range m.FileInfos {
			l = e.ProtoSize()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	return n
}

func (m *Response_ReadFile) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovAgent(uint64(m.Size))
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *Response_GetState) ProtoSize() (n int) {
	var l int
	_ = l
	if m.GetTasks != nil {
		l = m.GetTasks.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GetExecutors != nil {
		l = m.GetExecutors.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.GetFrameworks != nil {
		l = m.GetFrameworks.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *Response_GetContainers) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Containers) > 0 {
		for _, e := range m.Containers {
			l = e.ProtoSize()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	return n
}

func (m *Response_GetContainers_Container) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.FrameworkID.ProtoSize()
	n += 1 + l + sovAgent(uint64(l))
	l = m.ExecutorID.ProtoSize()
	n += 1 + l + sovAgent(uint64(l))
	l = len(m.ExecutorName)
	n += 1 + l + sovAgent(uint64(l))
	l = m.ContainerID.ProtoSize()
	n += 1 + l + sovAgent(uint64(l))
	if m.ContainerStatus != nil {
		l = m.ContainerStatus.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.ResourceStatistics != nil {
		l = m.ResourceStatistics.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *Response_GetFrameworks) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Frameworks) > 0 {
		for _, e := range m.Frameworks {
			l = e.ProtoSize()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.CompletedFrameworks) > 0 {
		for _, e := range m.CompletedFrameworks {
			l = e.ProtoSize()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	return n
}

func (m *Response_GetFrameworks_Framework) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.FrameworkInfo.ProtoSize()
	n += 1 + l + sovAgent(uint64(l))
	return n
}

func (m *Response_GetExecutors) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.Executors) > 0 {
		for _, e := range m.Executors {
			l = e.ProtoSize()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.CompletedExecutors) > 0 {
		for _, e := range m.CompletedExecutors {
			l = e.ProtoSize()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	return n
}

func (m *Response_GetExecutors_Executor) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.ExecutorInfo.ProtoSize()
	n += 1 + l + sovAgent(uint64(l))
	return n
}

func (m *Response_GetTasks) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.PendingTasks) > 0 {
		for _, e := range m.PendingTasks {
			l = e.ProtoSize()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.QueuedTasks) > 0 {
		for _, e := range m.QueuedTasks {
			l = e.ProtoSize()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.LaunchedTasks) > 0 {
		for _, e := range m.LaunchedTasks {
			l = e.ProtoSize()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.TerminatedTasks) > 0 {
		for _, e := range m.TerminatedTasks {
			l = e.ProtoSize()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	if len(m.CompletedTasks) > 0 {
		for _, e := range m.CompletedTasks {
			l = e.ProtoSize()
			n += 1 + l + sovAgent(uint64(l))
		}
	}
	return n
}

func (m *Response_GetAgent) ProtoSize() (n int) {
	var l int
	_ = l
	if m.AgentInfo != nil {
		l = m.AgentInfo.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *Response_WaitNestedContainer) ProtoSize() (n int) {
	var l int
	_ = l
	if m.ExitStatus != nil {
		n += 1 + sovAgent(uint64(*m.ExitStatus))
	}
	return n
}

func (m *ProcessIO) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovAgent(uint64(m.Type))
	if m.Data != nil {
		l = m.Data.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Control != nil {
		l = m.Control.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *ProcessIO_Data) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovAgent(uint64(m.Type))
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *ProcessIO_Control) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovAgent(uint64(m.Type))
	if m.TTYInfo != nil {
		l = m.TTYInfo.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	if m.Heartbeat != nil {
		l = m.Heartbeat.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func (m *ProcessIO_Control_Heartbeat) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Interval != nil {
		l = m.Interval.ProtoSize()
		n += 1 + l + sovAgent(uint64(l))
	}
	return n
}

func sovAgent(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAgent(x uint64) (n int) {
	return sovAgent(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Call) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`GetMetrics:` + strings.Replace(fmt.Sprintf("%v", this.GetMetrics), "Call_GetMetrics", "Call_GetMetrics", 1) + `,`,
		`SetLoggingLevel:` + strings.Replace(fmt.Sprintf("%v", this.SetLoggingLevel), "Call_SetLoggingLevel", "Call_SetLoggingLevel", 1) + `,`,
		`ListFiles:` + strings.Replace(fmt.Sprintf("%v", this.ListFiles), "Call_ListFiles", "Call_ListFiles", 1) + `,`,
		`ReadFile:` + strings.Replace(fmt.Sprintf("%v", this.ReadFile), "Call_ReadFile", "Call_ReadFile", 1) + `,`,
		`LaunchNestedContainer:` + strings.Replace(fmt.Sprintf("%v", this.LaunchNestedContainer), "Call_LaunchNestedContainer", "Call_LaunchNestedContainer", 1) + `,`,
		`WaitNestedContainer:` + strings.Replace(fmt.Sprintf("%v", this.WaitNestedContainer), "Call_WaitNestedContainer", "Call_WaitNestedContainer", 1) + `,`,
		`KillNestedContainer:` + strings.Replace(fmt.Sprintf("%v", this.KillNestedContainer), "Call_KillNestedContainer", "Call_KillNestedContainer", 1) + `,`,
		`LaunchNestedContainerSession:` + strings.Replace(fmt.Sprintf("%v", this.LaunchNestedContainerSession), "Call_LaunchNestedContainerSession", "Call_LaunchNestedContainerSession", 1) + `,`,
		`AttachContainerInput:` + strings.Replace(fmt.Sprintf("%v", this.AttachContainerInput), "Call_AttachContainerInput", "Call_AttachContainerInput", 1) + `,`,
		`AttachContainerOutput:` + strings.Replace(fmt.Sprintf("%v", this.AttachContainerOutput), "Call_AttachContainerOutput", "Call_AttachContainerOutput", 1) + `,`,
		`RemoveNestedContainer:` + strings.Replace(fmt.Sprintf("%v", this.RemoveNestedContainer), "Call_RemoveNestedContainer", "Call_RemoveNestedContainer", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_GetMetrics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_GetMetrics{`,
		`Timeout:` + strings.Replace(fmt.Sprintf("%v", this.Timeout), "DurationInfo", "mesos.DurationInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_SetLoggingLevel) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_SetLoggingLevel{`,
		`Level:` + fmt.Sprintf("%v", this.Level) + `,`,
		`Duration:` + strings.Replace(strings.Replace(this.Duration.String(), "DurationInfo", "mesos.DurationInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_ListFiles) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_ListFiles{`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_ReadFile) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_ReadFile{`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`Offset:` + fmt.Sprintf("%v", this.Offset) + `,`,
		`Length:` + valueToStringAgent(this.Length) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_LaunchNestedContainer) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_LaunchNestedContainer{`,
		`ContainerID:` + strings.Replace(strings.Replace(this.ContainerID.String(), "ContainerID", "mesos.ContainerID", 1), `&`, ``, 1) + `,`,
		`Command:` + strings.Replace(fmt.Sprintf("%v", this.Command), "CommandInfo", "mesos.CommandInfo", 1) + `,`,
		`Container:` + strings.Replace(fmt.Sprintf("%v", this.Container), "ContainerInfo", "mesos.ContainerInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_WaitNestedContainer) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_WaitNestedContainer{`,
		`ContainerID:` + strings.Replace(strings.Replace(this.ContainerID.String(), "ContainerID", "mesos.ContainerID", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_KillNestedContainer) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_KillNestedContainer{`,
		`ContainerID:` + strings.Replace(strings.Replace(this.ContainerID.String(), "ContainerID", "mesos.ContainerID", 1), `&`, ``, 1) + `,`,
		`Signal:` + valueToStringAgent(this.Signal) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_RemoveNestedContainer) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_RemoveNestedContainer{`,
		`ContainerID:` + strings.Replace(strings.Replace(this.ContainerID.String(), "ContainerID", "mesos.ContainerID", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_LaunchNestedContainerSession) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_LaunchNestedContainerSession{`,
		`ContainerID:` + strings.Replace(strings.Replace(this.ContainerID.String(), "ContainerID", "mesos.ContainerID", 1), `&`, ``, 1) + `,`,
		`Command:` + strings.Replace(fmt.Sprintf("%v", this.Command), "CommandInfo", "mesos.CommandInfo", 1) + `,`,
		`Container:` + strings.Replace(fmt.Sprintf("%v", this.Container), "ContainerInfo", "mesos.ContainerInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_AttachContainerInput) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_AttachContainerInput{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`ContainerID:` + strings.Replace(fmt.Sprintf("%v", this.ContainerID), "ContainerID", "mesos.ContainerID", 1) + `,`,
		`ProcessIO:` + strings.Replace(fmt.Sprintf("%v", this.ProcessIO), "ProcessIO", "ProcessIO", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_AttachContainerOutput) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_AttachContainerOutput{`,
		`ContainerID:` + strings.Replace(strings.Replace(this.ContainerID.String(), "ContainerID", "mesos.ContainerID", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`GetHealth:` + strings.Replace(fmt.Sprintf("%v", this.GetHealth), "Response_GetHealth", "Response_GetHealth", 1) + `,`,
		`GetFlags:` + strings.Replace(fmt.Sprintf("%v", this.GetFlags), "Response_GetFlags", "Response_GetFlags", 1) + `,`,
		`GetVersion:` + strings.Replace(fmt.Sprintf("%v", this.GetVersion), "Response_GetVersion", "Response_GetVersion", 1) + `,`,
		`GetMetrics:` + strings.Replace(fmt.Sprintf("%v", this.GetMetrics), "Response_GetMetrics", "Response_GetMetrics", 1) + `,`,
		`GetLoggingLevel:` + strings.Replace(fmt.Sprintf("%v", this.GetLoggingLevel), "Response_GetLoggingLevel", "Response_GetLoggingLevel", 1) + `,`,
		`ListFiles:` + strings.Replace(fmt.Sprintf("%v", this.ListFiles), "Response_ListFiles", "Response_ListFiles", 1) + `,`,
		`ReadFile:` + strings.Replace(fmt.Sprintf("%v", this.ReadFile), "Response_ReadFile", "Response_ReadFile", 1) + `,`,
		`GetState:` + strings.Replace(fmt.Sprintf("%v", this.GetState), "Response_GetState", "Response_GetState", 1) + `,`,
		`GetContainers:` + strings.Replace(fmt.Sprintf("%v", this.GetContainers), "Response_GetContainers", "Response_GetContainers", 1) + `,`,
		`GetFrameworks:` + strings.Replace(fmt.Sprintf("%v", this.GetFrameworks), "Response_GetFrameworks", "Response_GetFrameworks", 1) + `,`,
		`GetExecutors:` + strings.Replace(fmt.Sprintf("%v", this.GetExecutors), "Response_GetExecutors", "Response_GetExecutors", 1) + `,`,
		`GetTasks:` + strings.Replace(fmt.Sprintf("%v", this.GetTasks), "Response_GetTasks", "Response_GetTasks", 1) + `,`,
		`WaitNestedContainer:` + strings.Replace(fmt.Sprintf("%v", this.WaitNestedContainer), "Response_WaitNestedContainer", "Response_WaitNestedContainer", 1) + `,`,
		`GetAgent:` + strings.Replace(fmt.Sprintf("%v", this.GetAgent), "Response_GetAgent", "Response_GetAgent", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetHealth) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetHealth{`,
		`Healthy:` + fmt.Sprintf("%v", this.Healthy) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetFlags) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetFlags{`,
		`Flags:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Flags), "Flag", "mesos.Flag", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetVersion) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetVersion{`,
		`VersionInfo:` + strings.Replace(strings.Replace(this.VersionInfo.String(), "VersionInfo", "mesos.VersionInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetMetrics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetMetrics{`,
		`Metrics:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Metrics), "Metric", "mesos.Metric", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetLoggingLevel) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetLoggingLevel{`,
		`Level:` + fmt.Sprintf("%v", this.Level) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_ListFiles) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_ListFiles{`,
		`FileInfos:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.FileInfos), "FileInfo", "mesos.FileInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_ReadFile) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_ReadFile{`,
		`Size:` + fmt.Sprintf("%v", this.Size) + `,`,
		`Data:` + valueToStringAgent(this.Data) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetState) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetState{`,
		`GetTasks:` + strings.Replace(fmt.Sprintf("%v", this.GetTasks), "Response_GetTasks", "Response_GetTasks", 1) + `,`,
		`GetExecutors:` + strings.Replace(fmt.Sprintf("%v", this.GetExecutors), "Response_GetExecutors", "Response_GetExecutors", 1) + `,`,
		`GetFrameworks:` + strings.Replace(fmt.Sprintf("%v", this.GetFrameworks), "Response_GetFrameworks", "Response_GetFrameworks", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetContainers) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetContainers{`,
		`Containers:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Containers), "Response_GetContainers_Container", "Response_GetContainers_Container", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetContainers_Container) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetContainers_Container{`,
		`FrameworkID:` + strings.Replace(strings.Replace(this.FrameworkID.String(), "FrameworkID", "mesos.FrameworkID", 1), `&`, ``, 1) + `,`,
		`ExecutorID:` + strings.Replace(strings.Replace(this.ExecutorID.String(), "ExecutorID", "mesos.ExecutorID", 1), `&`, ``, 1) + `,`,
		`ExecutorName:` + fmt.Sprintf("%v", this.ExecutorName) + `,`,
		`ContainerID:` + strings.Replace(strings.Replace(this.ContainerID.String(), "ContainerID", "mesos.ContainerID", 1), `&`, ``, 1) + `,`,
		`ContainerStatus:` + strings.Replace(fmt.Sprintf("%v", this.ContainerStatus), "ContainerStatus", "mesos.ContainerStatus", 1) + `,`,
		`ResourceStatistics:` + strings.Replace(fmt.Sprintf("%v", this.ResourceStatistics), "ResourceStatistics", "mesos.ResourceStatistics", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetFrameworks) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetFrameworks{`,
		`Frameworks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Frameworks), "Response_GetFrameworks_Framework", "Response_GetFrameworks_Framework", 1), `&`, ``, 1) + `,`,
		`CompletedFrameworks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.CompletedFrameworks), "Response_GetFrameworks_Framework", "Response_GetFrameworks_Framework", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetFrameworks_Framework) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetFrameworks_Framework{`,
		`FrameworkInfo:` + strings.Replace(strings.Replace(this.FrameworkInfo.String(), "FrameworkInfo", "mesos.FrameworkInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetExecutors) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetExecutors{`,
		`Executors:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Executors), "Response_GetExecutors_Executor", "Response_GetExecutors_Executor", 1), `&`, ``, 1) + `,`,
		`CompletedExecutors:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.CompletedExecutors), "Response_GetExecutors_Executor", "Response_GetExecutors_Executor", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetExecutors_Executor) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetExecutors_Executor{`,
		`ExecutorInfo:` + strings.Replace(strings.Replace(this.ExecutorInfo.String(), "ExecutorInfo", "mesos.ExecutorInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetTasks) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetTasks{`,
		`PendingTasks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.PendingTasks), "Task", "mesos.Task", 1), `&`, ``, 1) + `,`,
		`QueuedTasks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.QueuedTasks), "Task", "mesos.Task", 1), `&`, ``, 1) + `,`,
		`LaunchedTasks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.LaunchedTasks), "Task", "mesos.Task", 1), `&`, ``, 1) + `,`,
		`TerminatedTasks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.TerminatedTasks), "Task", "mesos.Task", 1), `&`, ``, 1) + `,`,
		`CompletedTasks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.CompletedTasks), "Task", "mesos.Task", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_GetAgent) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_GetAgent{`,
		`AgentInfo:` + strings.Replace(fmt.Sprintf("%v", this.AgentInfo), "AgentInfo", "mesos.AgentInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Response_WaitNestedContainer) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Response_WaitNestedContainer{`,
		`ExitStatus:` + valueToStringAgent(this.ExitStatus) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ProcessIO) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ProcessIO{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Data:` + strings.Replace(fmt.Sprintf("%v", this.Data), "ProcessIO_Data", "ProcessIO_Data", 1) + `,`,
		`Control:` + strings.Replace(fmt.Sprintf("%v", this.Control), "ProcessIO_Control", "ProcessIO_Control", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ProcessIO_Data) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ProcessIO_Data{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Data:` + valueToStringAgent(this.Data) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ProcessIO_Control) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ProcessIO_Control{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`TTYInfo:` + strings.Replace(fmt.Sprintf("%v", this.TTYInfo), "TTYInfo", "mesos.TTYInfo", 1) + `,`,
		`Heartbeat:` + strings.Replace(fmt.Sprintf("%v", this.Heartbeat), "ProcessIO_Control_Heartbeat", "ProcessIO_Control_Heartbeat", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ProcessIO_Control_Heartbeat) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ProcessIO_Control_Heartbeat{`,
		`Interval:` + strings.Replace(fmt.Sprintf("%v", this.Interval), "DurationInfo", "mesos.DurationInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringAgent(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Call) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Call: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Call: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Call_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetMetrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetMetrics == nil {
				m.GetMetrics = &Call_GetMetrics{}
			}
			if err := m.GetMetrics.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SetLoggingLevel", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SetLoggingLevel == nil {
				m.SetLoggingLevel = &Call_SetLoggingLevel{}
			}
			if err := m.SetLoggingLevel.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListFiles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ListFiles == nil {
				m.ListFiles = &Call_ListFiles{}
			}
			if err := m.ListFiles.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadFile", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReadFile == nil {
				m.ReadFile = &Call_ReadFile{}
			}
			if err := m.ReadFile.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LaunchNestedContainer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LaunchNestedContainer == nil {
				m.LaunchNestedContainer = &Call_LaunchNestedContainer{}
			}
			if err := m.LaunchNestedContainer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WaitNestedContainer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WaitNestedContainer == nil {
				m.WaitNestedContainer = &Call_WaitNestedContainer{}
			}
			if err := m.WaitNestedContainer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KillNestedContainer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KillNestedContainer == nil {
				m.KillNestedContainer = &Call_KillNestedContainer{}
			}
			if err := m.KillNestedContainer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LaunchNestedContainerSession", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LaunchNestedContainerSession == nil {
				m.LaunchNestedContainerSession = &Call_LaunchNestedContainerSession{}
			}
			if err := m.LaunchNestedContainerSession.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttachContainerInput", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AttachContainerInput == nil {
				m.AttachContainerInput = &Call_AttachContainerInput{}
			}
			if err := m.AttachContainerInput.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttachContainerOutput", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AttachContainerOutput == nil {
				m.AttachContainerOutput = &Call_AttachContainerOutput{}
			}
			if err := m.AttachContainerOutput.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoveNestedContainer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RemoveNestedContainer == nil {
				m.RemoveNestedContainer = &Call_RemoveNestedContainer{}
			}
			if err := m.RemoveNestedContainer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_GetMetrics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetMetrics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetMetrics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timeout == nil {
				m.Timeout = &mesos.DurationInfo{}
			}
			if err := m.Timeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_SetLoggingLevel) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SetLoggingLevel: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SetLoggingLevel: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Level", wireType)
			}
			m.Level = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Level |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Duration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("level")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("duration")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_ListFiles) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListFiles: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListFiles: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("path")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_ReadFile) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadFile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadFile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Offset |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Length", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Length = &v
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("path")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("offset")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_LaunchNestedContainer) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LaunchNestedContainer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LaunchNestedContainer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ContainerID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Command == nil {
				m.Command = &mesos.CommandInfo{}
			}
			if err := m.Command.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Container == nil {
				m.Container = &mesos.ContainerInfo{}
			}
			if err := m.Container.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_WaitNestedContainer) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WaitNestedContainer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WaitNestedContainer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ContainerID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_KillNestedContainer) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KillNestedContainer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KillNestedContainer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ContainerID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Signal", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Signal = &v
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_RemoveNestedContainer) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveNestedContainer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveNestedContainer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ContainerID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_LaunchNestedContainerSession) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LaunchNestedContainerSession: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LaunchNestedContainerSession: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ContainerID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Command == nil {
				m.Command = &mesos.CommandInfo{}
			}
			if err := m.Command.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Container == nil {
				m.Container = &mesos.ContainerInfo{}
			}
			if err := m.Container.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_AttachContainerInput) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttachContainerInput: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttachContainerInput: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Call_AttachContainerInput_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContainerID == nil {
				m.ContainerID = &mesos.ContainerID{}
			}
			if err := m.ContainerID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessIO", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProcessIO == nil {
				m.ProcessIO = &ProcessIO{}
			}
			if err := m.ProcessIO.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_AttachContainerOutput) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttachContainerOutput: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttachContainerOutput: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ContainerID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Response: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Response: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Response_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetHealth", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetHealth == nil {
				m.GetHealth = &Response_GetHealth{}
			}
			if err := m.GetHealth.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetFlags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetFlags == nil {
				m.GetFlags = &Response_GetFlags{}
			}
			if err := m.GetFlags.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetVersion", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetVersion == nil {
				m.GetVersion = &Response_GetVersion{}
			}
			if err := m.GetVersion.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetMetrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetMetrics == nil {
				m.GetMetrics = &Response_GetMetrics{}
			}
			if err := m.GetMetrics.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetLoggingLevel", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetLoggingLevel == nil {
				m.GetLoggingLevel = &Response_GetLoggingLevel{}
			}
			if err := m.GetLoggingLevel.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListFiles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ListFiles == nil {
				m.ListFiles = &Response_ListFiles{}
			}
			if err := m.ListFiles.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadFile", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReadFile == nil {
				m.ReadFile = &Response_ReadFile{}
			}
			if err := m.ReadFile.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetState == nil {
				m.GetState = &Response_GetState{}
			}
			if err := m.GetState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetContainers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetContainers == nil {
				m.GetContainers = &Response_GetContainers{}
			}
			if err := m.GetContainers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetFrameworks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetFrameworks == nil {
				m.GetFrameworks = &Response_GetFrameworks{}
			}
			if err := m.GetFrameworks.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetExecutors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetExecutors == nil {
				m.GetExecutors = &Response_GetExecutors{}
			}
			if err := m.GetExecutors.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetTasks == nil {
				m.GetTasks = &Response_GetTasks{}
			}
			if err := m.GetTasks.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WaitNestedContainer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WaitNestedContainer == nil {
				m.WaitNestedContainer = &Response_WaitNestedContainer{}
			}
			if err := m.WaitNestedContainer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetAgent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetAgent == nil {
				m.GetAgent = &Response_GetAgent{}
			}
			if err := m.GetAgent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetHealth) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetHealth: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetHealth: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Healthy", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Healthy = bool(v != 0)
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("healthy")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetFlags) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetFlags: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetFlags: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Flags = append(m.Flags, mesos.Flag{})
			if err := m.Flags[len(m.Flags)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetVersion) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetVersion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetVersion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.VersionInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("version_info")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetMetrics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetMetrics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetMetrics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metrics = append(m.Metrics, mesos.Metric{})
			if err := m.Metrics[len(m.Metrics)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetLoggingLevel) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetLoggingLevel: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetLoggingLevel: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Level", wireType)
			}
			m.Level = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Level |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("level")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_ListFiles) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListFiles: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListFiles: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FileInfos = append(m.FileInfos, mesos.FileInfo{})
			if err := m.FileInfos[len(m.FileInfos)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_ReadFile) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadFile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadFile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size", wireType)
			}
			m.Size = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Size |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("size")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("data")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetTasks == nil {
				m.GetTasks = &Response_GetTasks{}
			}
			if err := m.GetTasks.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetExecutors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetExecutors == nil {
				m.GetExecutors = &Response_GetExecutors{}
			}
			if err := m.GetExecutors.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetFrameworks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GetFrameworks == nil {
				m.GetFrameworks = &Response_GetFrameworks{}
			}
			if err := m.GetFrameworks.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetContainers) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetContainers: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetContainers: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Containers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Containers = append(m.Containers, Response_GetContainers_Container{})
			if err := m.Containers[len(m.Containers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetContainers_Container) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Container: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Container: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FrameworkID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ExecutorID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExecutorName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ContainerID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000008)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContainerStatus == nil {
				m.ContainerStatus = &mesos.ContainerStatus{}
			}
			if err := m.ContainerStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceStatistics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResourceStatistics == nil {
				m.ResourceStatistics = &mesos.ResourceStatistics{}
			}
			if err := m.ResourceStatistics.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("executor_id")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("executor_name")
	}
	if hasFields[0]&uint64(0x00000008) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetFrameworks) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetFrameworks: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetFrameworks: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Frameworks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Frameworks = append(m.Frameworks, Response_GetFrameworks_Framework{})
			if err := m.Frameworks[len(m.Frameworks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletedFrameworks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CompletedFrameworks = append(m.CompletedFrameworks, Response_GetFrameworks_Framework{})
			if err := m.CompletedFrameworks[len(m.CompletedFrameworks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetFrameworks_Framework) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Framework: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Framework: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FrameworkInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_info")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetExecutors) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetExecutors: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetExecutors: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Executors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Executors = append(m.Executors, Response_GetExecutors_Executor{})
			if err := m.Executors[len(m.Executors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletedExecutors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CompletedExecutors = append(m.CompletedExecutors, Response_GetExecutors_Executor{})
			if err := m.CompletedExecutors[len(m.CompletedExecutors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetExecutors_Executor) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Executor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Executor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ExecutorInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("executor_info")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetTasks) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetTasks: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetTasks: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PendingTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PendingTasks = append(m.PendingTasks, mesos.Task{})
			if err := m.PendingTasks[len(m.PendingTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueuedTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.QueuedTasks = append(m.QueuedTasks, mesos.Task{})
			if err := m.QueuedTasks[len(m.QueuedTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LaunchedTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LaunchedTasks = append(m.LaunchedTasks, mesos.Task{})
			if err := m.LaunchedTasks[len(m.LaunchedTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TerminatedTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TerminatedTasks = append(m.TerminatedTasks, mesos.Task{})
			if err := m.TerminatedTasks[len(m.TerminatedTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletedTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CompletedTasks = append(m.CompletedTasks, mesos.Task{})
			if err := m.CompletedTasks[len(m.CompletedTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_GetAgent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetAgent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetAgent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AgentInfo == nil {
				m.AgentInfo = &mesos.AgentInfo{}
			}
			if err := m.AgentInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response_WaitNestedContainer) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WaitNestedContainer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WaitNestedContainer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExitStatus", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ExitStatus = &v
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessIO) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessIO: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessIO: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (ProcessIO_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Data == nil {
				m.Data = &ProcessIO_Data{}
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Control", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Control == nil {
				m.Control = &ProcessIO_Control{}
			}
			if err := m.Control.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessIO_Data) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Data: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Data: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (ProcessIO_Data_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessIO_Control) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Control: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Control: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (ProcessIO_Control_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TTYInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TTYInfo == nil {
				m.TTYInfo = &mesos.TTYInfo{}
			}
			if err := m.TTYInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Heartbeat", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Heartbeat == nil {
				m.Heartbeat = &ProcessIO_Control_Heartbeat{}
			}
			if err := m.Heartbeat.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessIO_Control_Heartbeat) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Heartbeat: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Heartbeat: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAgent
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Interval == nil {
				m.Interval = &mesos.DurationInfo{}
			}
			if err := m.Interval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAgent(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAgent
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAgent(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAgent
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAgent
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthAgent
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAgent
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAgent(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAgent = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAgent   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("agent/agent.proto", fileDescriptorAgent) }

var fileDescriptorAgent = []byte{
	// 2295 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x59, 0x4d, 0x6c, 0xdb, 0xc8,
	0x15, 0x36, 0x65, 0xd9, 0x92, 0x9e, 0x24, 0x9b, 0x1e, 0xff, 0xac, 0x96, 0x1b, 0xc8, 0xae, 0x17,
	0xdb, 0xcd, 0x62, 0x1b, 0x3b, 0x75, 0xb3, 0x69, 0x10, 0x67, 0x03, 0xd0, 0x36, 0x6d, 0x33, 0x51,
	0xa4, 0x94, 0xa4, 0x93, 0x66, 0xd1, 0x42, 0x60, 0xa4, 0x91, 0x4c, 0x84, 0x12, 0x5d, 0x71, 0xe4,
	0xd4, 0x3d, 0xf5, 0xd8, 0x43, 0x81, 0x16, 0x68, 0x8f, 0x3d, 0x14, 0x28, 0x0a, 0xec, 0xa1, 0xf7,
	0xf6, 0x54, 0xf4, 0x52, 0x60, 0x0f, 0x3d, 0xec, 0xb1, 0x05, 0xda, 0xa0, 0xd1, 0x5e, 0x7a, 0xdc,
	0x63, 0x7b, 0x2b, 0x66, 0x38, 0x43, 0x52, 0x26, 0x65, 0xa7, 0x69, 0x50, 0xa0, 0x17, 0x61, 0xe6,
	0xcd, 0xf7, 0xbe, 0x19, 0xbe, 0x79, 0xef, 0xf1, 0x3d, 0x0a, 0x16, 0xec, 0x2e, 0xee, 0x93, 0x4d,
	0xf6, 0xbb, 0x71, 0x32, 0xf0, 0x88, 0x87, 0x8a, 0x3d, 0xec, 0x7b, 0xfe, 0x06, 0x13, 0x29, 0xd7,
	0xbb, 0x0e, 0x39, 0x1e, 0x3e, 0xdd, 0x68, 0x79, 0xbd, 0x4d, 0x26, 0x0f, 0x7e, 0xaf, 0x75, 0xbd,
	0x4d, 0xfb, 0xc4, 0xd9, 0x3c, 0xfd, 0xfa, 0xa6, 0xeb, 0x3c, 0x0d, 0x64, 0x81, 0xba, 0x72, 0x2d,
	0xa6, 0xd1, 0xf5, 0xba, 0xde, 0x26, 0x13, 0x3f, 0x1d, 0x76, 0xd8, 0x8c, 0x4d, 0xd8, 0x28, 0x80,
	0xaf, 0xff, 0x65, 0x05, 0xb2, 0xbb, 0xb6, 0xeb, 0xa2, 0xeb, 0x90, 0x25, 0x67, 0x27, 0xb8, 0x22,
	0xad, 0x49, 0x57, 0xe7, 0xb6, 0x56, 0x36, 0x62, 0xa7, 0xd8, 0xa0, 0x80, 0x0d, 0xeb, 0xec, 0x04,
	0xef, 0x64, 0x3f, 0x7b, 0xb1, 0x3a, 0x65, 0x30, 0x24, 0xfa, 0x18, 0x8a, 0x5d, 0x4c, 0x9a, 0x3d,
	0x4c, 0x06, 0x4e, 0xcb, 0xaf, 0x64, 0xd6, 0xa4, 0xab, 0xc5, 0xad, 0x2b, 0x49, 0xc5, 0x03, 0x4c,
	0x1e, 0x04, 0x18, 0x03, 0xba, 0xe1, 0x18, 0x3d, 0x80, 0x05, 0x1f, 0x93, 0xa6, 0xeb, 0x75, 0xbb,
	0x4e, 0xbf, 0xdb, 0x74, 0xf1, 0x29, 0x76, 0x2b, 0xd3, 0x8c, 0xe4, 0x2b, 0x49, 0x12, 0x13, 0x93,
	0x5a, 0x80, 0xac, 0x51, 0xa0, 0x31, 0xef, 0x8f, 0x0b, 0xd0, 0x6d, 0x00, 0xd7, 0xf1, 0x49, 0xb3,
	0xe3, 0xb8, 0xd8, 0xaf, 0x64, 0x19, 0xcf, 0x3b, 0x49, 0x9e, 0x9a, 0xe3, 0x93, 0x7d, 0x0a, 0x31,
	0x0a, 0xae, 0x18, 0xa2, 0x6f, 0x42, 0x61, 0x80, 0xed, 0x36, 0xd3, 0xad, 0xcc, 0x30, 0x55, 0x25,
	0xa9, 0x6a, 0x60, 0xbb, 0x4d, 0xf1, 0x46, 0x7e, 0xc0, 0x47, 0xa8, 0x09, 0x6f, 0xb9, 0xf6, 0xb0,
	0xdf, 0x3a, 0x6e, 0xf6, 0xb1, 0x4f, 0x70, 0xbb, 0xd9, 0xf2, 0xfa, 0xc4, 0x76, 0xfa, 0x78, 0x50,
	0x99, 0x65, 0x34, 0xef, 0xa7, 0x9c, 0x80, 0x29, 0xd4, 0x19, 0x7e, 0x57, 0xc0, 0x8d, 0x65, 0x37,
	0x4d, 0x8c, 0x9e, 0xc0, 0xf2, 0x73, 0xdb, 0x21, 0x49, 0xfa, 0x1c, 0xa3, 0x7f, 0x2f, 0x49, 0xff,
	0xd8, 0x76, 0xc8, 0x79, 0xf2, 0xc5, 0xe7, 0x49, 0x21, 0xa5, 0x7e, 0xe6, 0xb8, 0x6e, 0x92, 0x3a,
	0x3f, 0x89, 0xfa, 0xbe, 0xe3, 0xba, 0x09, 0xea, 0x67, 0x49, 0x21, 0x1a, 0xc2, 0xea, 0x04, 0xb3,
	0x34, 0x7d, 0xec, 0xfb, 0x8e, 0xd7, 0xaf, 0x14, 0xd8, 0x26, 0x1b, 0xaf, 0x68, 0x1e, 0x33, 0xd0,
	0x32, 0xae, 0xb8, 0x17, 0xac, 0xa2, 0xef, 0xc0, 0x8a, 0x4d, 0x88, 0xdd, 0x3a, 0x8e, 0xed, 0xe7,
	0xf4, 0x4f, 0x86, 0xa4, 0x02, 0x6c, 0xb7, 0xaf, 0x26, 0x77, 0x53, 0x19, 0x3e, 0x64, 0xd2, 0x29,
	0xda, 0x58, 0xb2, 0x53, 0xa4, 0xf4, 0xae, 0x13, 0xec, 0xde, 0x90, 0x50, 0xfa, 0xe2, 0xa4, 0xbb,
	0x3e, 0x47, 0xdf, 0x60, 0x70, 0x63, 0xd9, 0x4e, 0x13, 0xd3, 0x0d, 0x06, 0xb8, 0xe7, 0x9d, 0xe2,
	0xe4, 0x95, 0x94, 0x26, 0x6d, 0x60, 0x30, 0x85, 0x84, 0x33, 0x0d, 0xd2, 0xc4, 0xca, 0x36, 0x40,
	0x14, 0x8b, 0xe8, 0x1a, 0xe4, 0x88, 0xd3, 0xc3, 0xde, 0x90, 0xb0, 0x98, 0x2f, 0x6e, 0x2d, 0x72,
	0xfa, 0xbd, 0xe1, 0xc0, 0x26, 0x8e, 0xd7, 0xd7, 0xfb, 0x1d, 0xcf, 0x10, 0x18, 0xa5, 0x0d, 0xf3,
	0xe7, 0x62, 0x10, 0x29, 0x30, 0x13, 0x44, 0xad, 0xb4, 0x96, 0xb9, 0x5a, 0xe6, 0xb9, 0x21, 0x10,
	0xa1, 0x8f, 0x20, 0xdf, 0xe6, 0x3c, 0x95, 0xcc, 0x5a, 0x66, 0x02, 0x3d, 0xd7, 0x09, 0xa1, 0xca,
	0x7b, 0x50, 0x08, 0x23, 0x14, 0x55, 0x20, 0x7b, 0x62, 0x93, 0x63, 0x46, 0x5f, 0x10, 0xa9, 0x87,
	0x4a, 0x94, 0x4f, 0x20, 0x2f, 0xa2, 0x71, 0x32, 0x0a, 0x5d, 0x81, 0x59, 0xaf, 0xd3, 0xf1, 0x31,
	0x61, 0x27, 0xc8, 0xf2, 0x35, 0x2e, 0x43, 0x2b, 0x30, 0xeb, 0xe2, 0x7e, 0x97, 0x1c, 0xb3, 0xa4,
	0x93, 0x35, 0xf8, 0x4c, 0xf9, 0xa3, 0x04, 0xcb, 0xa9, 0x4e, 0x88, 0xee, 0x41, 0x29, 0xe6, 0x58,
	0x6d, 0xb6, 0x63, 0x71, 0x0b, 0xf1, 0xe7, 0x8a, 0xdc, 0x65, 0x6f, 0x67, 0x91, 0xee, 0x34, 0x7a,
	0xb1, 0x5a, 0x8c, 0x09, 0x8d, 0x62, 0xa8, 0xac, 0xb7, 0xd1, 0xd7, 0x20, 0xd7, 0xf2, 0x7a, 0x3d,
	0xbb, 0xdf, 0xe6, 0x89, 0x33, 0xa2, 0x61, 0xd2, 0xc0, 0xf8, 0x1c, 0x82, 0xb6, 0xa0, 0x10, 0x39,
	0x43, 0x90, 0x23, 0x97, 0x12, 0xdb, 0x52, 0x8d, 0x08, 0xa6, 0xd8, 0xb0, 0x98, 0x92, 0x0b, 0xde,
	0xe4, 0x43, 0x28, 0x67, 0xb0, 0x98, 0x92, 0x13, 0xde, 0xa8, 0x9d, 0x56, 0x60, 0xd6, 0x77, 0xba,
	0x7d, 0xdb, 0x65, 0x66, 0x9a, 0x31, 0xf8, 0x4c, 0x69, 0xc1, 0x72, 0xaa, 0xef, 0xbf, 0xd1, 0xe7,
	0xfb, 0x93, 0x04, 0x57, 0x2e, 0xca, 0x47, 0xff, 0x67, 0x1e, 0xf1, 0x69, 0x06, 0x96, 0xd2, 0x12,
	0x1e, 0xd2, 0xc6, 0xde, 0xfd, 0x1f, 0xbe, 0x5a, 0x9a, 0x4c, 0x16, 0x04, 0xfb, 0xe7, 0xac, 0x71,
	0xfe, 0x31, 0x22, 0x6b, 0xcc, 0x5f, 0x68, 0x89, 0x3d, 0x80, 0x93, 0x81, 0xd7, 0xc2, 0xbe, 0xdf,
	0x74, 0x3c, 0xfe, 0x70, 0xe3, 0x05, 0xc9, 0xc3, 0x60, 0x59, 0x6f, 0xec, 0x94, 0x47, 0x2f, 0x56,
	0x0b, 0xe1, 0xd4, 0x28, 0x70, 0x45, 0xdd, 0x5b, 0xdf, 0x86, 0x2c, 0x3d, 0x21, 0x2a, 0x42, 0xee,
	0xa8, 0x7e, 0xbf, 0xde, 0x78, 0x5c, 0x97, 0xa7, 0x90, 0x0c, 0xa5, 0xdd, 0x46, 0xdd, 0x52, 0xf5,
	0xba, 0x66, 0x34, 0xf5, 0x3d, 0x59, 0x42, 0x73, 0x00, 0x0f, 0x8d, 0xc6, 0xae, 0x66, 0x9a, 0x4d,
	0xbd, 0x21, 0x67, 0x94, 0xec, 0x8f, 0x7e, 0x55, 0x95, 0xa8, 0x7b, 0xa5, 0xe6, 0xee, 0x37, 0x79,
	0xe3, 0xeb, 0x7f, 0x9b, 0x4e, 0x3b, 0xe2, 0x1c, 0xc0, 0x81, 0x66, 0x35, 0x0f, 0x35, 0xb5, 0x66,
	0x1d, 0xca, 0x12, 0x2a, 0x43, 0x81, 0xce, 0xf7, 0x6b, 0xea, 0x81, 0x29, 0x67, 0xd0, 0x3c, 0x14,
	0xe9, 0xf4, 0x91, 0x66, 0x98, 0x7a, 0xa3, 0x2e, 0x4f, 0x0b, 0xc1, 0x03, 0xcd, 0x32, 0xf4, 0x5d,
	0x53, 0xce, 0xa2, 0x65, 0x58, 0xa0, 0x82, 0x5a, 0xe3, 0xe0, 0x40, 0xaf, 0x1f, 0x34, 0x6b, 0xda,
	0x23, 0xad, 0x26, 0xcf, 0x50, 0xb1, 0x99, 0x10, 0xcf, 0xd2, 0xed, 0x6a, 0xba, 0x69, 0x35, 0xf7,
	0xf5, 0x9a, 0x66, 0xca, 0x39, 0xba, 0x9d, 0xa1, 0xa9, 0x7b, 0x6c, 0x2e, 0xe7, 0xc5, 0xee, 0xa6,
	0xa5, 0x5a, 0x9a, 0x5c, 0x40, 0x08, 0xe6, 0xe8, 0x34, 0xb4, 0xa1, 0x29, 0x83, 0x90, 0xed, 0x1b,
	0xea, 0x03, 0xed, 0x71, 0xc3, 0xb8, 0x6f, 0xca, 0x45, 0xb4, 0x00, 0x65, 0x2a, 0xd3, 0xbe, 0xad,
	0xed, 0x1e, 0x59, 0x0d, 0xc3, 0x94, 0x4b, 0x82, 0xc9, 0x52, 0xcd, 0xfb, 0xa6, 0x5c, 0x16, 0x53,
	0xf5, 0x40, 0xab, 0x5b, 0xf2, 0x12, 0x7a, 0x07, 0xde, 0xaa, 0xa9, 0x47, 0xf5, 0xdd, 0xc3, 0x66,
	0x5d, 0x33, 0x2d, 0x6d, 0x2f, 0xda, 0x42, 0x9e, 0x43, 0x6f, 0xc3, 0xf2, 0x63, 0x55, 0xb7, 0x92,
	0x4b, 0xf3, 0x74, 0xe9, 0xbe, 0x5e, 0xab, 0x25, 0x97, 0x64, 0x4a, 0x69, 0x68, 0x0f, 0x1a, 0x8f,
	0xb4, 0xe4, 0xe2, 0x32, 0x7a, 0x17, 0x56, 0x27, 0xec, 0xd7, 0x34, 0x35, 0x93, 0x99, 0x76, 0x01,
	0x29, 0xb0, 0xa2, 0x5a, 0x96, 0xba, 0x7b, 0x18, 0x5b, 0xd5, 0xeb, 0x0f, 0x8f, 0x2c, 0x19, 0x51,
	0xf6, 0xc4, 0x5a, 0xe3, 0xc8, 0xa2, 0x8b, 0x8b, 0x81, 0x13, 0xad, 0xff, 0x4b, 0xa1, 0xaf, 0x29,
	0xff, 0xc4, 0xeb, 0xfb, 0x18, 0xdd, 0x18, 0x8b, 0xb1, 0xf1, 0xf2, 0x52, 0x80, 0x92, 0x21, 0x75,
	0x17, 0x68, 0xc9, 0xdc, 0x3c, 0xc6, 0xb6, 0x4b, 0x8e, 0x79, 0x40, 0xad, 0xa6, 0xeb, 0x1e, 0x60,
	0x72, 0xc8, 0x60, 0x46, 0xa1, 0x2b, 0x86, 0x68, 0x1b, 0xe8, 0xa4, 0xd9, 0x71, 0xed, 0xae, 0xcf,
	0x23, 0xa9, 0x3a, 0x51, 0x7d, 0x9f, 0xa2, 0x8c, 0x7c, 0x97, 0x8f, 0x90, 0x1a, 0x14, 0xf8, 0xa7,
	0x78, 0xc0, 0x4a, 0xb6, 0xa0, 0xa6, 0x5e, 0x9b, 0xa8, 0xfe, 0x28, 0xc0, 0xb1, 0x22, 0x9f, 0x8f,
	0x05, 0x85, 0xe8, 0x11, 0x66, 0x2e, 0xa1, 0x48, 0xeb, 0x13, 0xbe, 0x05, 0x0b, 0xdd, 0x44, 0x9f,
	0x30, 0x9b, 0x52, 0xa3, 0xc6, 0x89, 0xc6, 0x7b, 0x85, 0xee, 0xb9, 0xc2, 0xe5, 0xee, 0x58, 0xaf,
	0x90, 0xbb, 0xc8, 0xaa, 0xa9, 0xfd, 0xc2, 0x76, 0xbc, 0x5f, 0xc8, 0x5f, 0x64, 0xd5, 0x94, 0x9e,
	0x81, 0x5f, 0x89, 0x4f, 0x6c, 0x82, 0x79, 0x19, 0x3c, 0xf9, 0x4a, 0x4c, 0x8a, 0x62, 0x57, 0xc2,
	0x46, 0xe8, 0x1e, 0xcc, 0x51, 0xe5, 0x30, 0x8b, 0xf8, 0xbc, 0xb4, 0x7d, 0x77, 0x22, 0x43, 0x98,
	0x7d, 0x7c, 0xa3, 0xdc, 0x8d, 0x4f, 0x05, 0x57, 0x67, 0x60, 0xf7, 0xf0, 0x73, 0x6f, 0xf0, 0xcc,
	0xe7, 0x75, 0xec, 0x64, 0xae, 0xfd, 0x10, 0xca, 0xb8, 0xa2, 0x29, 0x3a, 0x00, 0x2a, 0x68, 0xe2,
	0xef, 0xe3, 0xd6, 0x90, 0x78, 0x03, 0x9f, 0x57, 0xac, 0xeb, 0x13, 0xa9, 0x34, 0x81, 0x34, 0x4a,
	0xdd, 0xd8, 0x4c, 0x58, 0x87, 0xd8, 0xfe, 0x33, 0xbf, 0x52, 0xbe, 0xc4, 0x3a, 0x16, 0x45, 0x31,
	0xeb, 0xb0, 0x11, 0xfa, 0xee, 0xa4, 0x6e, 0x69, 0x8e, 0x11, 0x7d, 0x90, 0x4e, 0xf4, 0xca, 0x1d,
	0x13, 0x3f, 0x1b, 0x53, 0xaf, 0xcc, 0x5f, 0x72, 0x36, 0x95, 0x4a, 0xd8, 0xd9, 0xd8, 0x48, 0xf9,
	0x10, 0x0a, 0x61, 0x84, 0xa2, 0x2a, 0xe4, 0x82, 0x90, 0x3e, 0x63, 0x2f, 0x90, 0x3c, 0x8f, 0x79,
	0x21, 0x54, 0xbe, 0x01, 0x79, 0x11, 0x8f, 0xe8, 0x7d, 0x98, 0x09, 0xc2, 0x57, 0x5a, 0x9b, 0xbe,
	0x5a, 0xdc, 0x2a, 0xf2, 0x1d, 0xe9, 0xa2, 0x28, 0xb9, 0xd9, 0xba, 0xa2, 0xb3, 0xf2, 0x5e, 0x44,
	0xde, 0x36, 0x94, 0x78, 0xe0, 0x36, 0x9d, 0x7e, 0xc7, 0x3b, 0xf7, 0xa2, 0xe2, 0xa8, 0x58, 0x0d,
	0x5e, 0x3c, 0x8d, 0x44, 0xc9, 0x4e, 0x41, 0x04, 0x70, 0x70, 0x86, 0x32, 0x67, 0x09, 0x00, 0xe2,
	0xf0, 0x1c, 0xa3, 0x5c, 0x83, 0xf9, 0x83, 0x57, 0xef, 0x14, 0x14, 0x35, 0x5e, 0xf2, 0xdf, 0x00,
	0xa0, 0x41, 0xc5, 0x8e, 0x2c, 0x76, 0x9b, 0x17, 0x4f, 0xec, 0xb8, 0x38, 0x76, 0xe0, 0x42, 0x87,
	0xcf, 0x7d, 0xe5, 0xd6, 0x78, 0x3b, 0xe0, 0x3b, 0x3f, 0xc0, 0x6c, 0x27, 0x51, 0xf2, 0x33, 0x09,
	0x42, 0x90, 0x6d, 0xdb, 0xc4, 0x66, 0xcd, 0x40, 0xc9, 0x60, 0x63, 0xe5, 0xaf, 0x12, 0xb3, 0x74,
	0x10, 0x5c, 0x63, 0xbe, 0x27, 0xfd, 0x87, 0xbe, 0x97, 0x88, 0x80, 0xcc, 0x6b, 0x46, 0x40, 0x32,
	0x2c, 0xa7, 0x5f, 0x37, 0x2c, 0x95, 0x1f, 0x67, 0xa1, 0x3c, 0x96, 0x03, 0x90, 0x09, 0x10, 0x4b,
	0x1e, 0x81, 0x81, 0xaf, 0xbd, 0x42, 0xf2, 0x88, 0x4a, 0x1b, 0x6e, 0xd3, 0x18, 0x8d, 0xf2, 0xeb,
	0x69, 0x28, 0x8c, 0x55, 0xe0, 0xe1, 0xe1, 0x93, 0x25, 0x52, 0x78, 0xba, 0x78, 0x89, 0x14, 0x13,
	0x1a, 0xc5, 0x50, 0x59, 0x6f, 0xa3, 0x7d, 0x28, 0x0a, 0x8b, 0x06, 0x15, 0x25, 0xa5, 0x5a, 0xe0,
	0x54, 0xc2, 0x66, 0xfa, 0xde, 0x0e, 0xe2, 0x4c, 0x10, 0xc9, 0x0c, 0x10, 0x9a, 0x7a, 0x1b, 0x7d,
	0x00, 0xe5, 0x90, 0xa7, 0x6f, 0xf7, 0x70, 0x65, 0x3a, 0xd6, 0x2d, 0x96, 0xc4, 0x52, 0xdd, 0xee,
	0xe1, 0x44, 0x85, 0x97, 0xfd, 0x2f, 0x6a, 0x7a, 0x15, 0xe4, 0xd8, 0xa7, 0x0f, 0x62, 0x93, 0xa1,
	0x78, 0x07, 0xae, 0x9c, 0xe7, 0x33, 0xd9, 0xaa, 0x31, 0xdf, 0x1a, 0x17, 0xa0, 0x7b, 0xb0, 0x38,
	0xc0, 0xbe, 0x37, 0x1c, 0xb4, 0x30, 0x63, 0x70, 0x7c, 0x42, 0x03, 0x31, 0x78, 0x01, 0xbe, 0xcd,
	0x59, 0x0c, 0x8e, 0x30, 0x43, 0x80, 0x81, 0x06, 0x09, 0x99, 0xf2, 0x8b, 0x0c, 0x73, 0x87, 0x58,
	0xde, 0x36, 0x01, 0x62, 0x8e, 0x76, 0x99, 0x3b, 0x44, 0x8a, 0xd1, 0x35, 0x0a, 0x77, 0x88, 0x68,
	0x50, 0x07, 0x96, 0x5a, 0x5e, 0xef, 0xc4, 0xc5, 0x34, 0x09, 0xc7, 0xe8, 0x33, 0xaf, 0x4f, 0xbf,
	0x18, 0x12, 0xc6, 0xbc, 0xbb, 0x0e, 0x85, 0x70, 0x86, 0x54, 0x98, 0x8b, 0x79, 0x5d, 0x94, 0xf1,
	0x96, 0x12, 0x7e, 0x17, 0xa5, 0x90, 0x72, 0x27, 0x2e, 0x54, 0x7e, 0x92, 0x81, 0x52, 0x3c, 0x30,
	0x51, 0x03, 0x0a, 0x51, 0x3c, 0x07, 0xc6, 0xf9, 0xf0, 0xf2, 0x78, 0x0e, 0xfd, 0x52, 0x24, 0xaa,
	0x90, 0x03, 0x3d, 0x85, 0xe8, 0x41, 0xc6, 0x52, 0xc5, 0x6b, 0x52, 0xa3, 0x90, 0x2d, 0x84, 0x28,
	0xf7, 0x20, 0x2f, 0x26, 0xe8, 0x6e, 0xcc, 0xed, 0x63, 0x36, 0x59, 0x3c, 0x1f, 0x40, 0x91, 0x49,
	0xc2, 0x58, 0x60, 0x16, 0xf9, 0x4d, 0x86, 0xa5, 0xc7, 0x20, 0xc3, 0xdd, 0x84, 0xf2, 0x09, 0xee,
	0xb7, 0x69, 0x11, 0x26, 0x52, 0x64, 0xfc, 0x85, 0x44, 0x41, 0x82, 0x84, 0xe3, 0x02, 0xbd, 0x1b,
	0x50, 0xfa, 0xde, 0x10, 0x0f, 0x71, 0x9b, 0xab, 0x65, 0x26, 0xa9, 0x15, 0x03, 0x58, 0xa0, 0x75,
	0x0b, 0xe6, 0x82, 0x8f, 0x7d, 0xa1, 0xde, 0xf4, 0x24, 0xbd, 0xb2, 0x00, 0x06, 0x9a, 0x77, 0x40,
	0x26, 0x78, 0xd0, 0x73, 0xfa, 0x36, 0x09, 0x75, 0xb3, 0x93, 0x74, 0xe7, 0x23, 0x68, 0xa0, 0x7d,
	0x1b, 0xe6, 0xa3, 0x2b, 0x0a, 0x94, 0x67, 0x26, 0x29, 0xcf, 0x85, 0x48, 0xa6, 0xab, 0x6c, 0x33,
	0x6b, 0xb1, 0xf7, 0x3d, 0xda, 0x04, 0x60, 0x17, 0x29, 0xec, 0x4e, 0xc3, 0x55, 0xe6, 0x14, 0x0c,
	0x11, 0x74, 0xe7, 0xb6, 0x18, 0x2a, 0x37, 0xd3, 0xbf, 0xd7, 0xac, 0xd2, 0x0c, 0xe8, 0x10, 0x91,
	0x3d, 0x24, 0xf6, 0x15, 0x04, 0xa8, 0x28, 0x48, 0x10, 0xeb, 0x3f, 0xcb, 0xfc, 0x2f, 0xbb, 0xc8,
	0xf1, 0x76, 0x71, 0x76, 0xbc, 0x5d, 0xcc, 0x8d, 0xb7, 0x8b, 0xf9, 0x94, 0x76, 0xb1, 0x90, 0xd2,
	0x2e, 0x42, 0xb2, 0x5d, 0x2c, 0x8e, 0xb7, 0x8b, 0xa5, 0xf1, 0x76, 0xf1, 0x82, 0x8e, 0xb0, 0xcc,
	0x7b, 0xaf, 0xdf, 0xce, 0x40, 0xf4, 0x59, 0x00, 0x7d, 0x34, 0xd6, 0x7c, 0xbd, 0x93, 0xfe, 0x2d,
	0x21, 0xd9, 0x7d, 0x6d, 0x86, 0x15, 0x43, 0xf2, 0xdf, 0x84, 0x48, 0x6d, 0xcf, 0x26, 0x76, 0x50,
	0x4e, 0xa0, 0x5b, 0x90, 0xa3, 0xf9, 0x7b, 0xe0, 0xb9, 0xa9, 0xcd, 0x56, 0xa4, 0xb3, 0x1b, 0xa0,
	0x0c, 0x01, 0x57, 0x7e, 0x2e, 0x41, 0x96, 0x12, 0xa1, 0xdb, 0x63, 0x47, 0x5d, 0xbb, 0x60, 0xcf,
	0xe4, 0x79, 0x51, 0xec, 0xbc, 0xbc, 0xc2, 0x59, 0xbf, 0x93, 0xe6, 0x1d, 0x05, 0x98, 0x31, 0xad,
	0x3d, 0xbd, 0x2e, 0x4b, 0x08, 0x60, 0xd6, 0xb4, 0xf6, 0x1a, 0x47, 0x96, 0x9c, 0xe1, 0x63, 0xcd,
	0x30, 0xe4, 0x69, 0xfe, 0x1d, 0xe4, 0xf7, 0x19, 0xc8, 0xf1, 0xb3, 0xa2, 0x8f, 0xc7, 0x4e, 0xf6,
	0xee, 0xc5, 0x4f, 0x96, 0x3c, 0xdc, 0x4d, 0xc8, 0x13, 0x72, 0x16, 0x84, 0x43, 0x60, 0xd0, 0x39,
	0x11, 0x51, 0xd6, 0x13, 0x96, 0x81, 0x8a, 0xa3, 0x17, 0xab, 0x39, 0x3e, 0x31, 0x72, 0x84, 0x9c,
	0xd1, 0x01, 0xda, 0x87, 0xc2, 0x31, 0xb6, 0x07, 0xe4, 0x29, 0xb6, 0x09, 0xb7, 0xea, 0xd5, 0x4b,
	0xf6, 0x3e, 0x14, 0x78, 0x23, 0x52, 0x55, 0xee, 0x40, 0x21, 0x94, 0xa3, 0x4d, 0xc8, 0x3b, 0x7d,
	0x82, 0x07, 0xa7, 0xb6, 0x7b, 0xd1, 0xd7, 0xef, 0x10, 0xb4, 0x7e, 0x33, 0xcd, 0x8c, 0x25, 0xc8,
	0x5b, 0xd6, 0x93, 0xa6, 0x5e, 0xdf, 0x6f, 0x04, 0x21, 0x76, 0xa8, 0xa9, 0x86, 0xb5, 0xa3, 0xa9,
	0x96, 0xf8, 0x90, 0xb4, 0x7e, 0x3d, 0x4d, 0x2f, 0x0f, 0xd9, 0x3d, 0xd5, 0x52, 0x65, 0x89, 0x8a,
	0xa9, 0xef, 0x1a, 0x8d, 0x9a, 0xd0, 0xd8, 0xd9, 0xfd, 0xfc, 0x65, 0x75, 0xea, 0xcf, 0x2f, 0xab,
	0x53, 0x7f, 0x7f, 0x59, 0x95, 0xbe, 0x7c, 0x59, 0x95, 0xfe, 0xf9, 0xb2, 0x2a, 0xfd, 0x70, 0x54,
	0x95, 0x3e, 0x1d, 0x55, 0xa5, 0xdf, 0x8d, 0xaa, 0xd2, 0x1f, 0x46, 0x55, 0xe9, 0xb3, 0x51, 0x55,
	0xfa, 0x7c, 0x54, 0x95, 0xfe, 0x31, 0xaa, 0x4e, 0x7d, 0x39, 0xaa, 0x4a, 0x3f, 0xfd, 0xa2, 0x3a,
	0xf5, 0xcb, 0x2f, 0xaa, 0xd2, 0x27, 0x33, 0xcc, 0x26, 0xff, 0x0e, 0x00, 0x00, 0xff, 0xff, 0x8f,
	0xc3, 0x46, 0xfa, 0x58, 0x1c, 0x00, 0x00,
}
