package containerservice

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/containerservice/mgmt/2022-02-01/containerservice"

// AccessProfile profile for enabling a user to access a managed cluster.
type AccessProfile struct {
	// KubeConfig - Base64-encoded Kubernetes configuration file.
	KubeConfig *[]byte `json:"kubeConfig,omitempty"`
}

// AgentPool agent Pool.
type AgentPool struct {
	autorest.Response `json:"-"`
	// ManagedClusterAgentPoolProfileProperties - Properties of an agent pool.
	*ManagedClusterAgentPoolProfileProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AgentPool.
func (ap AgentPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.ManagedClusterAgentPoolProfileProperties != nil {
		objectMap["properties"] = ap.ManagedClusterAgentPoolProfileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AgentPool struct.
func (ap *AgentPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedClusterAgentPoolProfileProperties ManagedClusterAgentPoolProfileProperties
				err = json.Unmarshal(*v, &managedClusterAgentPoolProfileProperties)
				if err != nil {
					return err
				}
				ap.ManagedClusterAgentPoolProfileProperties = &managedClusterAgentPoolProfileProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ap.Type = &typeVar
			}
		}
	}

	return nil
}

// AgentPoolAvailableVersions the list of available versions for an agent pool.
type AgentPoolAvailableVersions struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The ID of the agent pool version list.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the agent pool version list.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the agent pool version list.
	Type *string `json:"type,omitempty"`
	// AgentPoolAvailableVersionsProperties - Properties of agent pool available versions.
	*AgentPoolAvailableVersionsProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AgentPoolAvailableVersions.
func (apav AgentPoolAvailableVersions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apav.AgentPoolAvailableVersionsProperties != nil {
		objectMap["properties"] = apav.AgentPoolAvailableVersionsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AgentPoolAvailableVersions struct.
func (apav *AgentPoolAvailableVersions) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				apav.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				apav.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				apav.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var agentPoolAvailableVersionsProperties AgentPoolAvailableVersionsProperties
				err = json.Unmarshal(*v, &agentPoolAvailableVersionsProperties)
				if err != nil {
					return err
				}
				apav.AgentPoolAvailableVersionsProperties = &agentPoolAvailableVersionsProperties
			}
		}
	}

	return nil
}

// AgentPoolAvailableVersionsProperties the list of available agent pool versions.
type AgentPoolAvailableVersionsProperties struct {
	// AgentPoolVersions - List of versions available for agent pool.
	AgentPoolVersions *[]AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem `json:"agentPoolVersions,omitempty"`
}

// AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem ...
type AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem struct {
	// Default - Whether this version is the default agent pool version.
	Default *bool `json:"default,omitempty"`
	// KubernetesVersion - The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// IsPreview - Whether Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`
}

// AgentPoolListResult the response from the List Agent Pools operation.
type AgentPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of agent pools.
	Value *[]AgentPool `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of agent pool results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AgentPoolListResult.
func (aplr AgentPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aplr.Value != nil {
		objectMap["value"] = aplr.Value
	}
	return json.Marshal(objectMap)
}

// AgentPoolListResultIterator provides access to a complete listing of AgentPool values.
type AgentPoolListResultIterator struct {
	i    int
	page AgentPoolListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AgentPoolListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AgentPoolListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AgentPoolListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AgentPoolListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AgentPoolListResultIterator) Response() AgentPoolListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AgentPoolListResultIterator) Value() AgentPool {
	if !iter.page.NotDone() {
		return AgentPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AgentPoolListResultIterator type.
func NewAgentPoolListResultIterator(page AgentPoolListResultPage) AgentPoolListResultIterator {
	return AgentPoolListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aplr AgentPoolListResult) IsEmpty() bool {
	return aplr.Value == nil || len(*aplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aplr AgentPoolListResult) hasNextLink() bool {
	return aplr.NextLink != nil && len(*aplr.NextLink) != 0
}

// agentPoolListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aplr AgentPoolListResult) agentPoolListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aplr.NextLink)))
}

// AgentPoolListResultPage contains a page of AgentPool values.
type AgentPoolListResultPage struct {
	fn   func(context.Context, AgentPoolListResult) (AgentPoolListResult, error)
	aplr AgentPoolListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AgentPoolListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AgentPoolListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aplr)
		if err != nil {
			return err
		}
		page.aplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AgentPoolListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AgentPoolListResultPage) NotDone() bool {
	return !page.aplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AgentPoolListResultPage) Response() AgentPoolListResult {
	return page.aplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AgentPoolListResultPage) Values() []AgentPool {
	if page.aplr.IsEmpty() {
		return nil
	}
	return *page.aplr.Value
}

// Creates a new instance of the AgentPoolListResultPage type.
func NewAgentPoolListResultPage(cur AgentPoolListResult, getNextPage func(context.Context, AgentPoolListResult) (AgentPoolListResult, error)) AgentPoolListResultPage {
	return AgentPoolListResultPage{
		fn:   getNextPage,
		aplr: cur,
	}
}

// AgentPoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AgentPoolsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AgentPoolsClient) (AgentPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AgentPoolsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AgentPoolsCreateOrUpdateFuture.Result.
func (future *AgentPoolsCreateOrUpdateFuture) result(client AgentPoolsClient) (ap AgentPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.AgentPoolsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ap.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.AgentPoolsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ap.Response.Response, err = future.GetResult(sender); err == nil && ap.Response.Response.StatusCode != http.StatusNoContent {
		ap, err = client.CreateOrUpdateResponder(ap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerservice.AgentPoolsCreateOrUpdateFuture", "Result", ap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AgentPoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AgentPoolsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AgentPoolsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AgentPoolsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AgentPoolsDeleteFuture.Result.
func (future *AgentPoolsDeleteFuture) result(client AgentPoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.AgentPoolsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.AgentPoolsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AgentPoolsUpgradeNodeImageVersionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AgentPoolsUpgradeNodeImageVersionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AgentPoolsClient) (AgentPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AgentPoolsUpgradeNodeImageVersionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AgentPoolsUpgradeNodeImageVersionFuture.Result.
func (future *AgentPoolsUpgradeNodeImageVersionFuture) result(client AgentPoolsClient) (ap AgentPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.AgentPoolsUpgradeNodeImageVersionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ap.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.AgentPoolsUpgradeNodeImageVersionFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ap.Response.Response, err = future.GetResult(sender); err == nil && ap.Response.Response.StatusCode != http.StatusNoContent {
		ap, err = client.UpgradeNodeImageVersionResponder(ap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerservice.AgentPoolsUpgradeNodeImageVersionFuture", "Result", ap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AgentPoolUpgradeProfile the list of available upgrades for an agent pool.
type AgentPoolUpgradeProfile struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The ID of the agent pool upgrade profile.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the agent pool upgrade profile.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the agent pool upgrade profile.
	Type *string `json:"type,omitempty"`
	// AgentPoolUpgradeProfileProperties - The properties of the agent pool upgrade profile.
	*AgentPoolUpgradeProfileProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AgentPoolUpgradeProfile.
func (apup AgentPoolUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apup.AgentPoolUpgradeProfileProperties != nil {
		objectMap["properties"] = apup.AgentPoolUpgradeProfileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AgentPoolUpgradeProfile struct.
func (apup *AgentPoolUpgradeProfile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				apup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				apup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				apup.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var agentPoolUpgradeProfileProperties AgentPoolUpgradeProfileProperties
				err = json.Unmarshal(*v, &agentPoolUpgradeProfileProperties)
				if err != nil {
					return err
				}
				apup.AgentPoolUpgradeProfileProperties = &agentPoolUpgradeProfileProperties
			}
		}
	}

	return nil
}

// AgentPoolUpgradeProfileProperties the list of available upgrade versions.
type AgentPoolUpgradeProfileProperties struct {
	// KubernetesVersion - The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// OsType - Possible values include: 'OSTypeLinux', 'OSTypeWindows'
	OsType OSType `json:"osType,omitempty"`
	// Upgrades - List of orchestrator types and versions available for upgrade.
	Upgrades *[]AgentPoolUpgradeProfilePropertiesUpgradesItem `json:"upgrades,omitempty"`
	// LatestNodeImageVersion - The latest AKS supported node image version.
	LatestNodeImageVersion *string `json:"latestNodeImageVersion,omitempty"`
}

// AgentPoolUpgradeProfilePropertiesUpgradesItem ...
type AgentPoolUpgradeProfilePropertiesUpgradesItem struct {
	// KubernetesVersion - The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// IsPreview - Whether the Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`
}

// AgentPoolUpgradeSettings settings for upgrading an agentpool
type AgentPoolUpgradeSettings struct {
	// MaxSurge - This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the percentage of the total agent pool size at the time of the upgrade. For percentages, fractional nodes are rounded up. If not specified, the default is 1. For more information, including best practices, see: https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade
	MaxSurge *string `json:"maxSurge,omitempty"`
}

// CloudError an error response from the Container service.
type CloudError struct {
	// Error - Details about the error.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the Container service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// CommandResultProperties the results of a run command
type CommandResultProperties struct {
	// ProvisioningState - READ-ONLY; provisioning State
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ExitCode - READ-ONLY; The exit code of the command
	ExitCode *int32 `json:"exitCode,omitempty"`
	// StartedAt - READ-ONLY; The time when the command started.
	StartedAt *date.Time `json:"startedAt,omitempty"`
	// FinishedAt - READ-ONLY; The time when the command finished.
	FinishedAt *date.Time `json:"finishedAt,omitempty"`
	// Logs - READ-ONLY; The command output.
	Logs *string `json:"logs,omitempty"`
	// Reason - READ-ONLY; An explanation of why provisioningState is set to failed (if so).
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for CommandResultProperties.
func (crp CommandResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CreationData data used when creating a target resource from a source resource.
type CreationData struct {
	// SourceResourceID - This is the ARM ID of the source object to be used to create the target object.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
}

// CredentialResult the credential result response.
type CredentialResult struct {
	// Name - READ-ONLY; The name of the credential.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; Base64-encoded Kubernetes configuration file.
	Value *[]byte `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for CredentialResult.
func (cr CredentialResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CredentialResults the list credential result response.
type CredentialResults struct {
	autorest.Response `json:"-"`
	// Kubeconfigs - READ-ONLY; Base64-encoded Kubernetes configuration file.
	Kubeconfigs *[]CredentialResult `json:"kubeconfigs,omitempty"`
}

// MarshalJSON is the custom marshaler for CredentialResults.
func (cr CredentialResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DiagnosticsProfile profile for diagnostics on the container service cluster.
type DiagnosticsProfile struct {
	// VMDiagnostics - Profile for diagnostics on the container service VMs.
	VMDiagnostics *VMDiagnostics `json:"vmDiagnostics,omitempty"`
}

// EndpointDependency a domain name that AKS agent nodes are reaching at.
type EndpointDependency struct {
	// DomainName - The domain name of the dependency.
	DomainName *string `json:"domainName,omitempty"`
	// EndpointDetails - The Ports and Protocols used when connecting to domainName.
	EndpointDetails *[]EndpointDetail `json:"endpointDetails,omitempty"`
}

// EndpointDetail connect information from the AKS agent nodes to a single endpoint.
type EndpointDetail struct {
	// IPAddress - An IP Address that Domain Name currently resolves to.
	IPAddress *string `json:"ipAddress,omitempty"`
	// Port - The port an endpoint is connected to.
	Port *int32 `json:"port,omitempty"`
	// Protocol - The protocol used for connection
	Protocol *string `json:"protocol,omitempty"`
	// Description - Description of the detail
	Description *string `json:"description,omitempty"`
}

// ExtendedLocation the complex type of the extended location.
type ExtendedLocation struct {
	// Name - The name of the extended location.
	Name *string `json:"name,omitempty"`
	// Type - The type of the extended location. Possible values include: 'ExtendedLocationTypesEdgeZone'
	Type ExtendedLocationTypes `json:"type,omitempty"`
}

// KubeletConfig see [AKS custom node
// configuration](https://docs.microsoft.com/azure/aks/custom-node-configuration) for more details.
type KubeletConfig struct {
	// CPUManagerPolicy - The default is 'none'. See [Kubernetes CPU management policies](https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/#cpu-management-policies) for more information. Allowed values are 'none' and 'static'.
	CPUManagerPolicy *string `json:"cpuManagerPolicy,omitempty"`
	// CPUCfsQuota - The default is true.
	CPUCfsQuota *bool `json:"cpuCfsQuota,omitempty"`
	// CPUCfsQuotaPeriod - The default is '100ms.' Valid values are a sequence of decimal numbers with an optional fraction and a unit suffix. For example: '300ms', '2h45m'. Supported units are 'ns', 'us', 'ms', 's', 'm', and 'h'.
	CPUCfsQuotaPeriod *string `json:"cpuCfsQuotaPeriod,omitempty"`
	// ImageGcHighThreshold - To disable image garbage collection, set to 100. The default is 85%
	ImageGcHighThreshold *int32 `json:"imageGcHighThreshold,omitempty"`
	// ImageGcLowThreshold - This cannot be set higher than imageGcHighThreshold. The default is 80%
	ImageGcLowThreshold *int32 `json:"imageGcLowThreshold,omitempty"`
	// TopologyManagerPolicy - For more information see [Kubernetes Topology Manager](https://kubernetes.io/docs/tasks/administer-cluster/topology-manager). The default is 'none'. Allowed values are 'none', 'best-effort', 'restricted', and 'single-numa-node'.
	TopologyManagerPolicy *string `json:"topologyManagerPolicy,omitempty"`
	// AllowedUnsafeSysctls - Allowed list of unsafe sysctls or unsafe sysctl patterns (ending in `*`).
	AllowedUnsafeSysctls *[]string `json:"allowedUnsafeSysctls,omitempty"`
	// FailSwapOn - If set to true it will make the Kubelet fail to start if swap is enabled on the node.
	FailSwapOn *bool `json:"failSwapOn,omitempty"`
	// ContainerLogMaxSizeMB - The maximum size (e.g. 10Mi) of container log file before it is rotated.
	ContainerLogMaxSizeMB *int32 `json:"containerLogMaxSizeMB,omitempty"`
	// ContainerLogMaxFiles - The maximum number of container log files that can be present for a container. The number must be ≥ 2.
	ContainerLogMaxFiles *int32 `json:"containerLogMaxFiles,omitempty"`
	// PodMaxPids - The maximum number of processes per pod.
	PodMaxPids *int32 `json:"podMaxPids,omitempty"`
}

// LinuxOSConfig see [AKS custom node
// configuration](https://docs.microsoft.com/azure/aks/custom-node-configuration) for more details.
type LinuxOSConfig struct {
	// Sysctls - Sysctl settings for Linux agent nodes.
	Sysctls *SysctlConfig `json:"sysctls,omitempty"`
	// TransparentHugePageEnabled - Valid values are 'always', 'madvise', and 'never'. The default is 'always'. For more information see [Transparent Hugepages](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge).
	TransparentHugePageEnabled *string `json:"transparentHugePageEnabled,omitempty"`
	// TransparentHugePageDefrag - Valid values are 'always', 'defer', 'defer+madvise', 'madvise' and 'never'. The default is 'madvise'. For more information see [Transparent Hugepages](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge).
	TransparentHugePageDefrag *string `json:"transparentHugePageDefrag,omitempty"`
	// SwapFileSizeMB - The size in MB of a swap file that will be created on each node.
	SwapFileSizeMB *int32 `json:"swapFileSizeMB,omitempty"`
}

// LinuxProfile profile for Linux VMs in the container service cluster.
type LinuxProfile struct {
	// AdminUsername - The administrator username to use for Linux VMs.
	AdminUsername *string `json:"adminUsername,omitempty"`
	// SSH - The SSH configuration for Linux-based VMs running on Azure.
	SSH *SSHConfiguration `json:"ssh,omitempty"`
}

// MaintenanceConfiguration see [planned
// maintenance](https://docs.microsoft.com/azure/aks/planned-maintenance) for more information about
// planned maintenance.
type MaintenanceConfiguration struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// MaintenanceConfigurationProperties - Properties of a default maintenance configuration.
	*MaintenanceConfigurationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MaintenanceConfiguration.
func (mc MaintenanceConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mc.MaintenanceConfigurationProperties != nil {
		objectMap["properties"] = mc.MaintenanceConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MaintenanceConfiguration struct.
func (mc *MaintenanceConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mc.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var maintenanceConfigurationProperties MaintenanceConfigurationProperties
				err = json.Unmarshal(*v, &maintenanceConfigurationProperties)
				if err != nil {
					return err
				}
				mc.MaintenanceConfigurationProperties = &maintenanceConfigurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mc.Type = &typeVar
			}
		}
	}

	return nil
}

// MaintenanceConfigurationListResult the response from the List maintenance configurations operation.
type MaintenanceConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of maintenance configurations.
	Value *[]MaintenanceConfiguration `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of maintenance configuration results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for MaintenanceConfigurationListResult.
func (mclr MaintenanceConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mclr.Value != nil {
		objectMap["value"] = mclr.Value
	}
	return json.Marshal(objectMap)
}

// MaintenanceConfigurationListResultIterator provides access to a complete listing of
// MaintenanceConfiguration values.
type MaintenanceConfigurationListResultIterator struct {
	i    int
	page MaintenanceConfigurationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MaintenanceConfigurationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MaintenanceConfigurationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MaintenanceConfigurationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MaintenanceConfigurationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MaintenanceConfigurationListResultIterator) Response() MaintenanceConfigurationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MaintenanceConfigurationListResultIterator) Value() MaintenanceConfiguration {
	if !iter.page.NotDone() {
		return MaintenanceConfiguration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MaintenanceConfigurationListResultIterator type.
func NewMaintenanceConfigurationListResultIterator(page MaintenanceConfigurationListResultPage) MaintenanceConfigurationListResultIterator {
	return MaintenanceConfigurationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mclr MaintenanceConfigurationListResult) IsEmpty() bool {
	return mclr.Value == nil || len(*mclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mclr MaintenanceConfigurationListResult) hasNextLink() bool {
	return mclr.NextLink != nil && len(*mclr.NextLink) != 0
}

// maintenanceConfigurationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mclr MaintenanceConfigurationListResult) maintenanceConfigurationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mclr.NextLink)))
}

// MaintenanceConfigurationListResultPage contains a page of MaintenanceConfiguration values.
type MaintenanceConfigurationListResultPage struct {
	fn   func(context.Context, MaintenanceConfigurationListResult) (MaintenanceConfigurationListResult, error)
	mclr MaintenanceConfigurationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MaintenanceConfigurationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MaintenanceConfigurationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mclr)
		if err != nil {
			return err
		}
		page.mclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MaintenanceConfigurationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MaintenanceConfigurationListResultPage) NotDone() bool {
	return !page.mclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MaintenanceConfigurationListResultPage) Response() MaintenanceConfigurationListResult {
	return page.mclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MaintenanceConfigurationListResultPage) Values() []MaintenanceConfiguration {
	if page.mclr.IsEmpty() {
		return nil
	}
	return *page.mclr.Value
}

// Creates a new instance of the MaintenanceConfigurationListResultPage type.
func NewMaintenanceConfigurationListResultPage(cur MaintenanceConfigurationListResult, getNextPage func(context.Context, MaintenanceConfigurationListResult) (MaintenanceConfigurationListResult, error)) MaintenanceConfigurationListResultPage {
	return MaintenanceConfigurationListResultPage{
		fn:   getNextPage,
		mclr: cur,
	}
}

// MaintenanceConfigurationProperties properties used to configure planned maintenance for a Managed
// Cluster.
type MaintenanceConfigurationProperties struct {
	// TimeInWeek - If two array entries specify the same day of the week, the applied configuration is the union of times in both entries.
	TimeInWeek *[]TimeInWeek `json:"timeInWeek,omitempty"`
	// NotAllowedTime - Time slots on which upgrade is not allowed.
	NotAllowedTime *[]TimeSpan `json:"notAllowedTime,omitempty"`
}

// ManagedCluster managed cluster.
type ManagedCluster struct {
	autorest.Response `json:"-"`
	// Sku - The managed cluster SKU.
	Sku *ManagedClusterSKU `json:"sku,omitempty"`
	// ExtendedLocation - The extended location of the Virtual Machine.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`
	// Identity - The identity of the managed cluster, if configured.
	Identity *ManagedClusterIdentity `json:"identity,omitempty"`
	// ManagedClusterProperties - Properties of a managed cluster.
	*ManagedClusterProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedCluster.
func (mc ManagedCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mc.Sku != nil {
		objectMap["sku"] = mc.Sku
	}
	if mc.ExtendedLocation != nil {
		objectMap["extendedLocation"] = mc.ExtendedLocation
	}
	if mc.Identity != nil {
		objectMap["identity"] = mc.Identity
	}
	if mc.ManagedClusterProperties != nil {
		objectMap["properties"] = mc.ManagedClusterProperties
	}
	if mc.Location != nil {
		objectMap["location"] = mc.Location
	}
	if mc.Tags != nil {
		objectMap["tags"] = mc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedCluster struct.
func (mc *ManagedCluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku ManagedClusterSKU
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				mc.Sku = &sku
			}
		case "extendedLocation":
			if v != nil {
				var extendedLocation ExtendedLocation
				err = json.Unmarshal(*v, &extendedLocation)
				if err != nil {
					return err
				}
				mc.ExtendedLocation = &extendedLocation
			}
		case "identity":
			if v != nil {
				var identity ManagedClusterIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				mc.Identity = &identity
			}
		case "properties":
			if v != nil {
				var managedClusterProperties ManagedClusterProperties
				err = json.Unmarshal(*v, &managedClusterProperties)
				if err != nil {
					return err
				}
				mc.ManagedClusterProperties = &managedClusterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mc.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mc.SystemData = &systemData
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mc.Tags = tags
			}
		}
	}

	return nil
}

// ManagedClusterAADProfile for more details see [managed AAD on
// AKS](https://docs.microsoft.com/azure/aks/managed-aad).
type ManagedClusterAADProfile struct {
	// Managed - Whether to enable managed AAD.
	Managed *bool `json:"managed,omitempty"`
	// EnableAzureRBAC - Whether to enable Azure RBAC for Kubernetes authorization.
	EnableAzureRBAC *bool `json:"enableAzureRBAC,omitempty"`
	// AdminGroupObjectIDs - The list of AAD group object IDs that will have admin role of the cluster.
	AdminGroupObjectIDs *[]string `json:"adminGroupObjectIDs,omitempty"`
	// ClientAppID - The client AAD application ID.
	ClientAppID *string `json:"clientAppID,omitempty"`
	// ServerAppID - The server AAD application ID.
	ServerAppID *string `json:"serverAppID,omitempty"`
	// ServerAppSecret - The server AAD application secret.
	ServerAppSecret *string `json:"serverAppSecret,omitempty"`
	// TenantID - The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
	TenantID *string `json:"tenantID,omitempty"`
}

// ManagedClusterAccessProfile managed cluster Access Profile.
type ManagedClusterAccessProfile struct {
	autorest.Response `json:"-"`
	// AccessProfile - AccessProfile of a managed cluster.
	*AccessProfile `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedClusterAccessProfile.
func (mcap ManagedClusterAccessProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcap.AccessProfile != nil {
		objectMap["properties"] = mcap.AccessProfile
	}
	if mcap.Location != nil {
		objectMap["location"] = mcap.Location
	}
	if mcap.Tags != nil {
		objectMap["tags"] = mcap.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedClusterAccessProfile struct.
func (mcap *ManagedClusterAccessProfile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accessProfile AccessProfile
				err = json.Unmarshal(*v, &accessProfile)
				if err != nil {
					return err
				}
				mcap.AccessProfile = &accessProfile
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mcap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mcap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mcap.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mcap.SystemData = &systemData
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mcap.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mcap.Tags = tags
			}
		}
	}

	return nil
}

// ManagedClusterAddonProfile a Kubernetes add-on profile for a managed cluster.
type ManagedClusterAddonProfile struct {
	// Enabled - Whether the add-on is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// Config - Key-value pairs for configuring an add-on.
	Config map[string]*string `json:"config"`
	// Identity - READ-ONLY; Information of user assigned identity used by this add-on.
	Identity *ManagedClusterAddonProfileIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterAddonProfile.
func (mcap ManagedClusterAddonProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcap.Enabled != nil {
		objectMap["enabled"] = mcap.Enabled
	}
	if mcap.Config != nil {
		objectMap["config"] = mcap.Config
	}
	return json.Marshal(objectMap)
}

// ManagedClusterAddonProfileIdentity information of user assigned identity used by this add-on.
type ManagedClusterAddonProfileIdentity struct {
	// ResourceID - The resource ID of the user assigned identity.
	ResourceID *string `json:"resourceId,omitempty"`
	// ClientID - The client ID of the user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
	// ObjectID - The object ID of the user assigned identity.
	ObjectID *string `json:"objectId,omitempty"`
}

// ManagedClusterAgentPoolProfile profile for the container service agent pool.
type ManagedClusterAgentPoolProfile struct {
	// Name - Windows agent pool names must be 6 characters or less.
	Name *string `json:"name,omitempty"`
	// Count - Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default value is 1.
	Count *int32 `json:"count,omitempty"`
	// VMSize - VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions
	VMSize       *string `json:"vmSize,omitempty"`
	OsDiskSizeGB *int32  `json:"osDiskSizeGB,omitempty"`
	// OsDiskType - Possible values include: 'OSDiskTypeManaged', 'OSDiskTypeEphemeral'
	OsDiskType OSDiskType `json:"osDiskType,omitempty"`
	// KubeletDiskType - Possible values include: 'KubeletDiskTypeOS', 'KubeletDiskTypeTemporary'
	KubeletDiskType KubeletDiskType `json:"kubeletDiskType,omitempty"`
	// WorkloadRuntime - Possible values include: 'WorkloadRuntimeOCIContainer', 'WorkloadRuntimeWasmWasi'
	WorkloadRuntime WorkloadRuntime `json:"workloadRuntime,omitempty"`
	// VnetSubnetID - If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just nodes. This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`
	// PodSubnetID - If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	PodSubnetID *string `json:"podSubnetID,omitempty"`
	// MaxPods - The maximum number of pods that can run on a node.
	MaxPods *int32 `json:"maxPods,omitempty"`
	// OsType - Possible values include: 'OSTypeLinux', 'OSTypeWindows'
	OsType OSType `json:"osType,omitempty"`
	// OsSKU - Possible values include: 'OSSKUUbuntu', 'OSSKUCBLMariner'
	OsSKU OSSKU `json:"osSKU,omitempty"`
	// MaxCount - The maximum number of nodes for auto-scaling
	MaxCount *int32 `json:"maxCount,omitempty"`
	// MinCount - The minimum number of nodes for auto-scaling
	MinCount *int32 `json:"minCount,omitempty"`
	// EnableAutoScaling - Whether to enable auto-scaler
	EnableAutoScaling *bool `json:"enableAutoScaling,omitempty"`
	// ScaleDownMode - This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete. Possible values include: 'ScaleDownModeDelete', 'ScaleDownModeDeallocate'
	ScaleDownMode ScaleDownMode `json:"scaleDownMode,omitempty"`
	// Type - Possible values include: 'AgentPoolTypeVirtualMachineScaleSets', 'AgentPoolTypeAvailabilitySet'
	Type AgentPoolType `json:"type,omitempty"`
	// Mode - Possible values include: 'AgentPoolModeSystem', 'AgentPoolModeUser'
	Mode AgentPoolMode `json:"mode,omitempty"`
	// OrchestratorVersion - As a best practice, you should upgrade all node pools in an AKS cluster to the same Kubernetes version. The node pool version must have the same major version as the control plane. The node pool minor version must be within two minor versions of the control plane version. The node pool version cannot be greater than the control plane version. For more information see [upgrading a node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`
	// NodeImageVersion - READ-ONLY; The version of node image
	NodeImageVersion *string `json:"nodeImageVersion,omitempty"`
	// UpgradeSettings - Settings for upgrading the agentpool
	UpgradeSettings *AgentPoolUpgradeSettings `json:"upgradeSettings,omitempty"`
	// ProvisioningState - READ-ONLY; The current deployment or provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// PowerState - When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded
	PowerState *PowerState `json:"powerState,omitempty"`
	// AvailabilityZones - The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
	AvailabilityZones *[]string `json:"availabilityZones,omitempty"`
	// EnableNodePublicIP - Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is for gaming workloads, where a console needs to make a direct connection to a cloud virtual machine to minimize hops. For more information see [assigning a public IP per node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools). The default is false.
	EnableNodePublicIP *bool `json:"enableNodePublicIP,omitempty"`
	// NodePublicIPPrefixID - This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}
	NodePublicIPPrefixID *string `json:"nodePublicIPPrefixID,omitempty"`
	// ScaleSetPriority - The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'. Possible values include: 'ScaleSetPrioritySpot', 'ScaleSetPriorityRegular'
	ScaleSetPriority ScaleSetPriority `json:"scaleSetPriority,omitempty"`
	// ScaleSetEvictionPolicy - This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'. Possible values include: 'ScaleSetEvictionPolicyDelete', 'ScaleSetEvictionPolicyDeallocate'
	ScaleSetEvictionPolicy ScaleSetEvictionPolicy `json:"scaleSetEvictionPolicy,omitempty"`
	// SpotMaxPrice - Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price. For more details on spot pricing, see [spot VMs pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing)
	SpotMaxPrice *float64 `json:"spotMaxPrice,omitempty"`
	// Tags - The tags to be persisted on the agent pool virtual machine scale set.
	Tags map[string]*string `json:"tags"`
	// NodeLabels - The node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string `json:"nodeLabels"`
	// NodeTaints - The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints *[]string `json:"nodeTaints,omitempty"`
	// ProximityPlacementGroupID - The ID for Proximity Placement Group.
	ProximityPlacementGroupID *string `json:"proximityPlacementGroupID,omitempty"`
	// KubeletConfig - The Kubelet configuration on the agent pool nodes.
	KubeletConfig *KubeletConfig `json:"kubeletConfig,omitempty"`
	// LinuxOSConfig - The OS configuration of Linux agent nodes.
	LinuxOSConfig *LinuxOSConfig `json:"linuxOSConfig,omitempty"`
	// EnableEncryptionAtHost - This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption
	EnableEncryptionAtHost *bool `json:"enableEncryptionAtHost,omitempty"`
	// EnableUltraSSD - Whether to enable UltraSSD
	EnableUltraSSD *bool `json:"enableUltraSSD,omitempty"`
	// EnableFIPS - See [Add a FIPS-enabled node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for more details.
	EnableFIPS *bool `json:"enableFIPS,omitempty"`
	// GpuInstanceProfile - GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU. Possible values include: 'GPUInstanceProfileMIG1g', 'GPUInstanceProfileMIG2g', 'GPUInstanceProfileMIG3g', 'GPUInstanceProfileMIG4g', 'GPUInstanceProfileMIG7g'
	GpuInstanceProfile GPUInstanceProfile `json:"gpuInstanceProfile,omitempty"`
	// CreationData - CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
	CreationData *CreationData `json:"creationData,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterAgentPoolProfile.
func (mcapp ManagedClusterAgentPoolProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcapp.Name != nil {
		objectMap["name"] = mcapp.Name
	}
	if mcapp.Count != nil {
		objectMap["count"] = mcapp.Count
	}
	if mcapp.VMSize != nil {
		objectMap["vmSize"] = mcapp.VMSize
	}
	if mcapp.OsDiskSizeGB != nil {
		objectMap["osDiskSizeGB"] = mcapp.OsDiskSizeGB
	}
	if mcapp.OsDiskType != "" {
		objectMap["osDiskType"] = mcapp.OsDiskType
	}
	if mcapp.KubeletDiskType != "" {
		objectMap["kubeletDiskType"] = mcapp.KubeletDiskType
	}
	if mcapp.WorkloadRuntime != "" {
		objectMap["workloadRuntime"] = mcapp.WorkloadRuntime
	}
	if mcapp.VnetSubnetID != nil {
		objectMap["vnetSubnetID"] = mcapp.VnetSubnetID
	}
	if mcapp.PodSubnetID != nil {
		objectMap["podSubnetID"] = mcapp.PodSubnetID
	}
	if mcapp.MaxPods != nil {
		objectMap["maxPods"] = mcapp.MaxPods
	}
	if mcapp.OsType != "" {
		objectMap["osType"] = mcapp.OsType
	}
	if mcapp.OsSKU != "" {
		objectMap["osSKU"] = mcapp.OsSKU
	}
	if mcapp.MaxCount != nil {
		objectMap["maxCount"] = mcapp.MaxCount
	}
	if mcapp.MinCount != nil {
		objectMap["minCount"] = mcapp.MinCount
	}
	if mcapp.EnableAutoScaling != nil {
		objectMap["enableAutoScaling"] = mcapp.EnableAutoScaling
	}
	if mcapp.ScaleDownMode != "" {
		objectMap["scaleDownMode"] = mcapp.ScaleDownMode
	}
	if mcapp.Type != "" {
		objectMap["type"] = mcapp.Type
	}
	if mcapp.Mode != "" {
		objectMap["mode"] = mcapp.Mode
	}
	if mcapp.OrchestratorVersion != nil {
		objectMap["orchestratorVersion"] = mcapp.OrchestratorVersion
	}
	if mcapp.UpgradeSettings != nil {
		objectMap["upgradeSettings"] = mcapp.UpgradeSettings
	}
	if mcapp.PowerState != nil {
		objectMap["powerState"] = mcapp.PowerState
	}
	if mcapp.AvailabilityZones != nil {
		objectMap["availabilityZones"] = mcapp.AvailabilityZones
	}
	if mcapp.EnableNodePublicIP != nil {
		objectMap["enableNodePublicIP"] = mcapp.EnableNodePublicIP
	}
	if mcapp.NodePublicIPPrefixID != nil {
		objectMap["nodePublicIPPrefixID"] = mcapp.NodePublicIPPrefixID
	}
	if mcapp.ScaleSetPriority != "" {
		objectMap["scaleSetPriority"] = mcapp.ScaleSetPriority
	}
	if mcapp.ScaleSetEvictionPolicy != "" {
		objectMap["scaleSetEvictionPolicy"] = mcapp.ScaleSetEvictionPolicy
	}
	if mcapp.SpotMaxPrice != nil {
		objectMap["spotMaxPrice"] = mcapp.SpotMaxPrice
	}
	if mcapp.Tags != nil {
		objectMap["tags"] = mcapp.Tags
	}
	if mcapp.NodeLabels != nil {
		objectMap["nodeLabels"] = mcapp.NodeLabels
	}
	if mcapp.NodeTaints != nil {
		objectMap["nodeTaints"] = mcapp.NodeTaints
	}
	if mcapp.ProximityPlacementGroupID != nil {
		objectMap["proximityPlacementGroupID"] = mcapp.ProximityPlacementGroupID
	}
	if mcapp.KubeletConfig != nil {
		objectMap["kubeletConfig"] = mcapp.KubeletConfig
	}
	if mcapp.LinuxOSConfig != nil {
		objectMap["linuxOSConfig"] = mcapp.LinuxOSConfig
	}
	if mcapp.EnableEncryptionAtHost != nil {
		objectMap["enableEncryptionAtHost"] = mcapp.EnableEncryptionAtHost
	}
	if mcapp.EnableUltraSSD != nil {
		objectMap["enableUltraSSD"] = mcapp.EnableUltraSSD
	}
	if mcapp.EnableFIPS != nil {
		objectMap["enableFIPS"] = mcapp.EnableFIPS
	}
	if mcapp.GpuInstanceProfile != "" {
		objectMap["gpuInstanceProfile"] = mcapp.GpuInstanceProfile
	}
	if mcapp.CreationData != nil {
		objectMap["creationData"] = mcapp.CreationData
	}
	return json.Marshal(objectMap)
}

// ManagedClusterAgentPoolProfileProperties properties for the container service agent pool profile.
type ManagedClusterAgentPoolProfileProperties struct {
	// Count - Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default value is 1.
	Count *int32 `json:"count,omitempty"`
	// VMSize - VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions
	VMSize       *string `json:"vmSize,omitempty"`
	OsDiskSizeGB *int32  `json:"osDiskSizeGB,omitempty"`
	// OsDiskType - Possible values include: 'OSDiskTypeManaged', 'OSDiskTypeEphemeral'
	OsDiskType OSDiskType `json:"osDiskType,omitempty"`
	// KubeletDiskType - Possible values include: 'KubeletDiskTypeOS', 'KubeletDiskTypeTemporary'
	KubeletDiskType KubeletDiskType `json:"kubeletDiskType,omitempty"`
	// WorkloadRuntime - Possible values include: 'WorkloadRuntimeOCIContainer', 'WorkloadRuntimeWasmWasi'
	WorkloadRuntime WorkloadRuntime `json:"workloadRuntime,omitempty"`
	// VnetSubnetID - If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just nodes. This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`
	// PodSubnetID - If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	PodSubnetID *string `json:"podSubnetID,omitempty"`
	// MaxPods - The maximum number of pods that can run on a node.
	MaxPods *int32 `json:"maxPods,omitempty"`
	// OsType - Possible values include: 'OSTypeLinux', 'OSTypeWindows'
	OsType OSType `json:"osType,omitempty"`
	// OsSKU - Possible values include: 'OSSKUUbuntu', 'OSSKUCBLMariner'
	OsSKU OSSKU `json:"osSKU,omitempty"`
	// MaxCount - The maximum number of nodes for auto-scaling
	MaxCount *int32 `json:"maxCount,omitempty"`
	// MinCount - The minimum number of nodes for auto-scaling
	MinCount *int32 `json:"minCount,omitempty"`
	// EnableAutoScaling - Whether to enable auto-scaler
	EnableAutoScaling *bool `json:"enableAutoScaling,omitempty"`
	// ScaleDownMode - This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete. Possible values include: 'ScaleDownModeDelete', 'ScaleDownModeDeallocate'
	ScaleDownMode ScaleDownMode `json:"scaleDownMode,omitempty"`
	// Type - Possible values include: 'AgentPoolTypeVirtualMachineScaleSets', 'AgentPoolTypeAvailabilitySet'
	Type AgentPoolType `json:"type,omitempty"`
	// Mode - Possible values include: 'AgentPoolModeSystem', 'AgentPoolModeUser'
	Mode AgentPoolMode `json:"mode,omitempty"`
	// OrchestratorVersion - As a best practice, you should upgrade all node pools in an AKS cluster to the same Kubernetes version. The node pool version must have the same major version as the control plane. The node pool minor version must be within two minor versions of the control plane version. The node pool version cannot be greater than the control plane version. For more information see [upgrading a node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`
	// NodeImageVersion - READ-ONLY; The version of node image
	NodeImageVersion *string `json:"nodeImageVersion,omitempty"`
	// UpgradeSettings - Settings for upgrading the agentpool
	UpgradeSettings *AgentPoolUpgradeSettings `json:"upgradeSettings,omitempty"`
	// ProvisioningState - READ-ONLY; The current deployment or provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// PowerState - When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded
	PowerState *PowerState `json:"powerState,omitempty"`
	// AvailabilityZones - The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
	AvailabilityZones *[]string `json:"availabilityZones,omitempty"`
	// EnableNodePublicIP - Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is for gaming workloads, where a console needs to make a direct connection to a cloud virtual machine to minimize hops. For more information see [assigning a public IP per node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools). The default is false.
	EnableNodePublicIP *bool `json:"enableNodePublicIP,omitempty"`
	// NodePublicIPPrefixID - This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}
	NodePublicIPPrefixID *string `json:"nodePublicIPPrefixID,omitempty"`
	// ScaleSetPriority - The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'. Possible values include: 'ScaleSetPrioritySpot', 'ScaleSetPriorityRegular'
	ScaleSetPriority ScaleSetPriority `json:"scaleSetPriority,omitempty"`
	// ScaleSetEvictionPolicy - This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'. Possible values include: 'ScaleSetEvictionPolicyDelete', 'ScaleSetEvictionPolicyDeallocate'
	ScaleSetEvictionPolicy ScaleSetEvictionPolicy `json:"scaleSetEvictionPolicy,omitempty"`
	// SpotMaxPrice - Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price. For more details on spot pricing, see [spot VMs pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing)
	SpotMaxPrice *float64 `json:"spotMaxPrice,omitempty"`
	// Tags - The tags to be persisted on the agent pool virtual machine scale set.
	Tags map[string]*string `json:"tags"`
	// NodeLabels - The node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string `json:"nodeLabels"`
	// NodeTaints - The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints *[]string `json:"nodeTaints,omitempty"`
	// ProximityPlacementGroupID - The ID for Proximity Placement Group.
	ProximityPlacementGroupID *string `json:"proximityPlacementGroupID,omitempty"`
	// KubeletConfig - The Kubelet configuration on the agent pool nodes.
	KubeletConfig *KubeletConfig `json:"kubeletConfig,omitempty"`
	// LinuxOSConfig - The OS configuration of Linux agent nodes.
	LinuxOSConfig *LinuxOSConfig `json:"linuxOSConfig,omitempty"`
	// EnableEncryptionAtHost - This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption
	EnableEncryptionAtHost *bool `json:"enableEncryptionAtHost,omitempty"`
	// EnableUltraSSD - Whether to enable UltraSSD
	EnableUltraSSD *bool `json:"enableUltraSSD,omitempty"`
	// EnableFIPS - See [Add a FIPS-enabled node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for more details.
	EnableFIPS *bool `json:"enableFIPS,omitempty"`
	// GpuInstanceProfile - GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU. Possible values include: 'GPUInstanceProfileMIG1g', 'GPUInstanceProfileMIG2g', 'GPUInstanceProfileMIG3g', 'GPUInstanceProfileMIG4g', 'GPUInstanceProfileMIG7g'
	GpuInstanceProfile GPUInstanceProfile `json:"gpuInstanceProfile,omitempty"`
	// CreationData - CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
	CreationData *CreationData `json:"creationData,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterAgentPoolProfileProperties.
func (mcappp ManagedClusterAgentPoolProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcappp.Count != nil {
		objectMap["count"] = mcappp.Count
	}
	if mcappp.VMSize != nil {
		objectMap["vmSize"] = mcappp.VMSize
	}
	if mcappp.OsDiskSizeGB != nil {
		objectMap["osDiskSizeGB"] = mcappp.OsDiskSizeGB
	}
	if mcappp.OsDiskType != "" {
		objectMap["osDiskType"] = mcappp.OsDiskType
	}
	if mcappp.KubeletDiskType != "" {
		objectMap["kubeletDiskType"] = mcappp.KubeletDiskType
	}
	if mcappp.WorkloadRuntime != "" {
		objectMap["workloadRuntime"] = mcappp.WorkloadRuntime
	}
	if mcappp.VnetSubnetID != nil {
		objectMap["vnetSubnetID"] = mcappp.VnetSubnetID
	}
	if mcappp.PodSubnetID != nil {
		objectMap["podSubnetID"] = mcappp.PodSubnetID
	}
	if mcappp.MaxPods != nil {
		objectMap["maxPods"] = mcappp.MaxPods
	}
	if mcappp.OsType != "" {
		objectMap["osType"] = mcappp.OsType
	}
	if mcappp.OsSKU != "" {
		objectMap["osSKU"] = mcappp.OsSKU
	}
	if mcappp.MaxCount != nil {
		objectMap["maxCount"] = mcappp.MaxCount
	}
	if mcappp.MinCount != nil {
		objectMap["minCount"] = mcappp.MinCount
	}
	if mcappp.EnableAutoScaling != nil {
		objectMap["enableAutoScaling"] = mcappp.EnableAutoScaling
	}
	if mcappp.ScaleDownMode != "" {
		objectMap["scaleDownMode"] = mcappp.ScaleDownMode
	}
	if mcappp.Type != "" {
		objectMap["type"] = mcappp.Type
	}
	if mcappp.Mode != "" {
		objectMap["mode"] = mcappp.Mode
	}
	if mcappp.OrchestratorVersion != nil {
		objectMap["orchestratorVersion"] = mcappp.OrchestratorVersion
	}
	if mcappp.UpgradeSettings != nil {
		objectMap["upgradeSettings"] = mcappp.UpgradeSettings
	}
	if mcappp.PowerState != nil {
		objectMap["powerState"] = mcappp.PowerState
	}
	if mcappp.AvailabilityZones != nil {
		objectMap["availabilityZones"] = mcappp.AvailabilityZones
	}
	if mcappp.EnableNodePublicIP != nil {
		objectMap["enableNodePublicIP"] = mcappp.EnableNodePublicIP
	}
	if mcappp.NodePublicIPPrefixID != nil {
		objectMap["nodePublicIPPrefixID"] = mcappp.NodePublicIPPrefixID
	}
	if mcappp.ScaleSetPriority != "" {
		objectMap["scaleSetPriority"] = mcappp.ScaleSetPriority
	}
	if mcappp.ScaleSetEvictionPolicy != "" {
		objectMap["scaleSetEvictionPolicy"] = mcappp.ScaleSetEvictionPolicy
	}
	if mcappp.SpotMaxPrice != nil {
		objectMap["spotMaxPrice"] = mcappp.SpotMaxPrice
	}
	if mcappp.Tags != nil {
		objectMap["tags"] = mcappp.Tags
	}
	if mcappp.NodeLabels != nil {
		objectMap["nodeLabels"] = mcappp.NodeLabels
	}
	if mcappp.NodeTaints != nil {
		objectMap["nodeTaints"] = mcappp.NodeTaints
	}
	if mcappp.ProximityPlacementGroupID != nil {
		objectMap["proximityPlacementGroupID"] = mcappp.ProximityPlacementGroupID
	}
	if mcappp.KubeletConfig != nil {
		objectMap["kubeletConfig"] = mcappp.KubeletConfig
	}
	if mcappp.LinuxOSConfig != nil {
		objectMap["linuxOSConfig"] = mcappp.LinuxOSConfig
	}
	if mcappp.EnableEncryptionAtHost != nil {
		objectMap["enableEncryptionAtHost"] = mcappp.EnableEncryptionAtHost
	}
	if mcappp.EnableUltraSSD != nil {
		objectMap["enableUltraSSD"] = mcappp.EnableUltraSSD
	}
	if mcappp.EnableFIPS != nil {
		objectMap["enableFIPS"] = mcappp.EnableFIPS
	}
	if mcappp.GpuInstanceProfile != "" {
		objectMap["gpuInstanceProfile"] = mcappp.GpuInstanceProfile
	}
	if mcappp.CreationData != nil {
		objectMap["creationData"] = mcappp.CreationData
	}
	return json.Marshal(objectMap)
}

// ManagedClusterAPIServerAccessProfile access profile for managed cluster API server.
type ManagedClusterAPIServerAccessProfile struct {
	// AuthorizedIPRanges - IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with clusters that use Public IP Per Node, or clusters that are using a Basic Load Balancer. For more information see [API server authorized IP ranges](https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges).
	AuthorizedIPRanges *[]string `json:"authorizedIPRanges,omitempty"`
	// EnablePrivateCluster - For more details, see [Creating a private AKS cluster](https://docs.microsoft.com/azure/aks/private-clusters).
	EnablePrivateCluster *bool `json:"enablePrivateCluster,omitempty"`
	// PrivateDNSZone - The default is System. For more details see [configure private DNS zone](https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone). Allowed values are 'system' and 'none'.
	PrivateDNSZone *string `json:"privateDNSZone,omitempty"`
	// EnablePrivateClusterPublicFQDN - Whether to create additional public FQDN for private cluster or not.
	EnablePrivateClusterPublicFQDN *bool `json:"enablePrivateClusterPublicFQDN,omitempty"`
	// DisableRunCommand - Whether to disable run command for the cluster or not.
	DisableRunCommand *bool `json:"disableRunCommand,omitempty"`
}

// ManagedClusterAutoUpgradeProfile auto upgrade profile for a managed cluster.
type ManagedClusterAutoUpgradeProfile struct {
	// UpgradeChannel - For more information see [setting the AKS cluster auto-upgrade channel](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel). Possible values include: 'UpgradeChannelRapid', 'UpgradeChannelStable', 'UpgradeChannelPatch', 'UpgradeChannelNodeImage', 'UpgradeChannelNone'
	UpgradeChannel UpgradeChannel `json:"upgradeChannel,omitempty"`
}

// ManagedClusterHTTPProxyConfig cluster HTTP proxy configuration.
type ManagedClusterHTTPProxyConfig struct {
	// HTTPProxy - The HTTP proxy server endpoint to use.
	HTTPProxy *string `json:"httpProxy,omitempty"`
	// HTTPSProxy - The HTTPS proxy server endpoint to use.
	HTTPSProxy *string `json:"httpsProxy,omitempty"`
	// NoProxy - The endpoints that should not go through proxy.
	NoProxy *[]string `json:"noProxy,omitempty"`
	// TrustedCa - Alternative CA cert to use for connecting to proxy servers.
	TrustedCa *string `json:"trustedCa,omitempty"`
}

// ManagedClusterIdentity identity for the managed cluster.
type ManagedClusterIdentity struct {
	// PrincipalID - READ-ONLY; The principal id of the system assigned identity which is used by master components.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id of the system assigned identity which is used by master components.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - For more information see [use managed identities in AKS](https://docs.microsoft.com/azure/aks/use-managed-identity). Possible values include: 'ResourceIdentityTypeSystemAssigned', 'ResourceIdentityTypeUserAssigned', 'ResourceIdentityTypeNone'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The keys must be ARM resource IDs in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ManagedClusterIdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for ManagedClusterIdentity.
func (mci ManagedClusterIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mci.Type != "" {
		objectMap["type"] = mci.Type
	}
	if mci.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = mci.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// ManagedClusterIdentityUserAssignedIdentitiesValue ...
type ManagedClusterIdentityUserAssignedIdentitiesValue struct {
	// PrincipalID - READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterIdentityUserAssignedIdentitiesValue.
func (mciAiv ManagedClusterIdentityUserAssignedIdentitiesValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedClusterListResult the response from the List Managed Clusters operation.
type ManagedClusterListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of managed clusters.
	Value *[]ManagedCluster `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of managed cluster results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterListResult.
func (mclr ManagedClusterListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mclr.Value != nil {
		objectMap["value"] = mclr.Value
	}
	return json.Marshal(objectMap)
}

// ManagedClusterListResultIterator provides access to a complete listing of ManagedCluster values.
type ManagedClusterListResultIterator struct {
	i    int
	page ManagedClusterListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedClusterListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedClusterListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedClusterListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedClusterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedClusterListResultIterator) Response() ManagedClusterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedClusterListResultIterator) Value() ManagedCluster {
	if !iter.page.NotDone() {
		return ManagedCluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedClusterListResultIterator type.
func NewManagedClusterListResultIterator(page ManagedClusterListResultPage) ManagedClusterListResultIterator {
	return ManagedClusterListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mclr ManagedClusterListResult) IsEmpty() bool {
	return mclr.Value == nil || len(*mclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mclr ManagedClusterListResult) hasNextLink() bool {
	return mclr.NextLink != nil && len(*mclr.NextLink) != 0
}

// managedClusterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mclr ManagedClusterListResult) managedClusterListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mclr.NextLink)))
}

// ManagedClusterListResultPage contains a page of ManagedCluster values.
type ManagedClusterListResultPage struct {
	fn   func(context.Context, ManagedClusterListResult) (ManagedClusterListResult, error)
	mclr ManagedClusterListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedClusterListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedClusterListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mclr)
		if err != nil {
			return err
		}
		page.mclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedClusterListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedClusterListResultPage) NotDone() bool {
	return !page.mclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedClusterListResultPage) Response() ManagedClusterListResult {
	return page.mclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedClusterListResultPage) Values() []ManagedCluster {
	if page.mclr.IsEmpty() {
		return nil
	}
	return *page.mclr.Value
}

// Creates a new instance of the ManagedClusterListResultPage type.
func NewManagedClusterListResultPage(cur ManagedClusterListResult, getNextPage func(context.Context, ManagedClusterListResult) (ManagedClusterListResult, error)) ManagedClusterListResultPage {
	return ManagedClusterListResultPage{
		fn:   getNextPage,
		mclr: cur,
	}
}

// ManagedClusterLoadBalancerProfile profile of the managed cluster load balancer.
type ManagedClusterLoadBalancerProfile struct {
	// ManagedOutboundIPs - Desired managed outbound IPs for the cluster load balancer.
	ManagedOutboundIPs *ManagedClusterLoadBalancerProfileManagedOutboundIPs `json:"managedOutboundIPs,omitempty"`
	// OutboundIPPrefixes - Desired outbound IP Prefix resources for the cluster load balancer.
	OutboundIPPrefixes *ManagedClusterLoadBalancerProfileOutboundIPPrefixes `json:"outboundIPPrefixes,omitempty"`
	// OutboundIPs - Desired outbound IP resources for the cluster load balancer.
	OutboundIPs *ManagedClusterLoadBalancerProfileOutboundIPs `json:"outboundIPs,omitempty"`
	// EffectiveOutboundIPs - The effective outbound IP resources of the cluster load balancer.
	EffectiveOutboundIPs *[]ResourceReference `json:"effectiveOutboundIPs,omitempty"`
	// AllocatedOutboundPorts - The desired number of allocated SNAT ports per VM. Allowed values are in the range of 0 to 64000 (inclusive). The default value is 0 which results in Azure dynamically allocating ports.
	AllocatedOutboundPorts *int32 `json:"allocatedOutboundPorts,omitempty"`
	// IdleTimeoutInMinutes - Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value is 30 minutes.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// EnableMultipleStandardLoadBalancers - Enable multiple standard load balancers per AKS cluster or not.
	EnableMultipleStandardLoadBalancers *bool `json:"enableMultipleStandardLoadBalancers,omitempty"`
}

// ManagedClusterLoadBalancerProfileManagedOutboundIPs desired managed outbound IPs for the cluster load
// balancer.
type ManagedClusterLoadBalancerProfileManagedOutboundIPs struct {
	// Count - The desired number of IPv4 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
	Count *int32 `json:"count,omitempty"`
	// CountIPv6 - The desired number of IPv6 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 0 for single-stack and 1 for dual-stack.
	CountIPv6 *int32 `json:"countIPv6,omitempty"`
}

// ManagedClusterLoadBalancerProfileOutboundIPPrefixes desired outbound IP Prefix resources for the cluster
// load balancer.
type ManagedClusterLoadBalancerProfileOutboundIPPrefixes struct {
	// PublicIPPrefixes - A list of public IP prefix resources.
	PublicIPPrefixes *[]ResourceReference `json:"publicIPPrefixes,omitempty"`
}

// ManagedClusterLoadBalancerProfileOutboundIPs desired outbound IP resources for the cluster load
// balancer.
type ManagedClusterLoadBalancerProfileOutboundIPs struct {
	// PublicIPs - A list of public IP resources.
	PublicIPs *[]ResourceReference `json:"publicIPs,omitempty"`
}

// ManagedClusterManagedOutboundIPProfile profile of the managed outbound IP resources of the managed
// cluster.
type ManagedClusterManagedOutboundIPProfile struct {
	// Count - The desired number of outbound IPs created/managed by Azure. Allowed values must be in the range of 1 to 16 (inclusive). The default value is 1.
	Count *int32 `json:"count,omitempty"`
}

// ManagedClusterNATGatewayProfile profile of the managed cluster NAT gateway.
type ManagedClusterNATGatewayProfile struct {
	// ManagedOutboundIPProfile - Profile of the managed outbound IP resources of the cluster NAT gateway.
	ManagedOutboundIPProfile *ManagedClusterManagedOutboundIPProfile `json:"managedOutboundIPProfile,omitempty"`
	// EffectiveOutboundIPs - The effective outbound IP resources of the cluster NAT gateway.
	EffectiveOutboundIPs *[]ResourceReference `json:"effectiveOutboundIPs,omitempty"`
	// IdleTimeoutInMinutes - Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value is 4 minutes.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
}

// ManagedClusterPodIdentity details about the pod identity assigned to the Managed Cluster.
type ManagedClusterPodIdentity struct {
	// Name - The name of the pod identity.
	Name *string `json:"name,omitempty"`
	// Namespace - The namespace of the pod identity.
	Namespace *string `json:"namespace,omitempty"`
	// BindingSelector - The binding selector to use for the AzureIdentityBinding resource.
	BindingSelector *string `json:"bindingSelector,omitempty"`
	// Identity - The user assigned identity details.
	Identity *UserAssignedIdentity `json:"identity,omitempty"`
	// ProvisioningState - READ-ONLY; The current provisioning state of the pod identity. Possible values include: 'ManagedClusterPodIdentityProvisioningStateAssigned', 'ManagedClusterPodIdentityProvisioningStateUpdating', 'ManagedClusterPodIdentityProvisioningStateDeleting', 'ManagedClusterPodIdentityProvisioningStateFailed'
	ProvisioningState ManagedClusterPodIdentityProvisioningState `json:"provisioningState,omitempty"`
	// ProvisioningInfo - READ-ONLY
	ProvisioningInfo *ManagedClusterPodIdentityProvisioningInfo `json:"provisioningInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterPodIdentity.
func (mcpi ManagedClusterPodIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcpi.Name != nil {
		objectMap["name"] = mcpi.Name
	}
	if mcpi.Namespace != nil {
		objectMap["namespace"] = mcpi.Namespace
	}
	if mcpi.BindingSelector != nil {
		objectMap["bindingSelector"] = mcpi.BindingSelector
	}
	if mcpi.Identity != nil {
		objectMap["identity"] = mcpi.Identity
	}
	return json.Marshal(objectMap)
}

// ManagedClusterPodIdentityException see [disable AAD Pod Identity for a specific
// Pod/Application](https://azure.github.io/aad-pod-identity/docs/configure/application_exception/) for
// more details.
type ManagedClusterPodIdentityException struct {
	// Name - The name of the pod identity exception.
	Name *string `json:"name,omitempty"`
	// Namespace - The namespace of the pod identity exception.
	Namespace *string `json:"namespace,omitempty"`
	// PodLabels - The pod labels to match.
	PodLabels map[string]*string `json:"podLabels"`
}

// MarshalJSON is the custom marshaler for ManagedClusterPodIdentityException.
func (mcpie ManagedClusterPodIdentityException) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcpie.Name != nil {
		objectMap["name"] = mcpie.Name
	}
	if mcpie.Namespace != nil {
		objectMap["namespace"] = mcpie.Namespace
	}
	if mcpie.PodLabels != nil {
		objectMap["podLabels"] = mcpie.PodLabels
	}
	return json.Marshal(objectMap)
}

// ManagedClusterPodIdentityProfile see [use AAD pod
// identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on pod
// identity integration.
type ManagedClusterPodIdentityProfile struct {
	// Enabled - Whether the pod identity addon is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// AllowNetworkPluginKubenet - Running in Kubenet is disabled by default due to the security related nature of AAD Pod Identity and the risks of IP spoofing. See [using Kubenet network plugin with AAD Pod Identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity#using-kubenet-network-plugin-with-azure-active-directory-pod-managed-identities) for more information.
	AllowNetworkPluginKubenet *bool `json:"allowNetworkPluginKubenet,omitempty"`
	// UserAssignedIdentities - The pod identities to use in the cluster.
	UserAssignedIdentities *[]ManagedClusterPodIdentity `json:"userAssignedIdentities,omitempty"`
	// UserAssignedIdentityExceptions - The pod identity exceptions to allow.
	UserAssignedIdentityExceptions *[]ManagedClusterPodIdentityException `json:"userAssignedIdentityExceptions,omitempty"`
}

// ManagedClusterPodIdentityProvisioningError an error response from the pod identity provisioning.
type ManagedClusterPodIdentityProvisioningError struct {
	// Error - Details about the error.
	Error *ManagedClusterPodIdentityProvisioningErrorBody `json:"error,omitempty"`
}

// ManagedClusterPodIdentityProvisioningErrorBody an error response from the pod identity provisioning.
type ManagedClusterPodIdentityProvisioningErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]ManagedClusterPodIdentityProvisioningErrorBody `json:"details,omitempty"`
}

// ManagedClusterPodIdentityProvisioningInfo ...
type ManagedClusterPodIdentityProvisioningInfo struct {
	// Error - Pod identity assignment error (if any).
	Error *ManagedClusterPodIdentityProvisioningError `json:"error,omitempty"`
}

// ManagedClusterPoolUpgradeProfile the list of available upgrade versions.
type ManagedClusterPoolUpgradeProfile struct {
	// KubernetesVersion - The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// Name - The Agent Pool name.
	Name *string `json:"name,omitempty"`
	// OsType - Possible values include: 'OSTypeLinux', 'OSTypeWindows'
	OsType OSType `json:"osType,omitempty"`
	// Upgrades - List of orchestrator types and versions available for upgrade.
	Upgrades *[]ManagedClusterPoolUpgradeProfileUpgradesItem `json:"upgrades,omitempty"`
}

// ManagedClusterPoolUpgradeProfileUpgradesItem ...
type ManagedClusterPoolUpgradeProfileUpgradesItem struct {
	// KubernetesVersion - The Kubernetes version (major.minor.patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// IsPreview - Whether the Kubernetes version is currently in preview.
	IsPreview *bool `json:"isPreview,omitempty"`
}

// ManagedClusterProperties properties of the managed cluster.
type ManagedClusterProperties struct {
	// ProvisioningState - READ-ONLY; The current provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// PowerState - READ-ONLY; The Power State of the cluster.
	PowerState *PowerState `json:"powerState,omitempty"`
	// MaxAgentPools - READ-ONLY; The max number of agent pools for the managed cluster.
	MaxAgentPools *int32 `json:"maxAgentPools,omitempty"`
	// KubernetesVersion - When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed sequentially by major version number. For example, upgrades between 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See [upgrading an AKS cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// DNSPrefix - This cannot be updated once the Managed Cluster has been created.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`
	// FqdnSubdomain - This cannot be updated once the Managed Cluster has been created.
	FqdnSubdomain *string `json:"fqdnSubdomain,omitempty"`
	// Fqdn - READ-ONLY; The FQDN of the master pool.
	Fqdn *string `json:"fqdn,omitempty"`
	// PrivateFQDN - READ-ONLY; The FQDN of private cluster.
	PrivateFQDN *string `json:"privateFQDN,omitempty"`
	// AzurePortalFQDN - READ-ONLY; The Azure Portal requires certain Cross-Origin Resource Sharing (CORS) headers to be sent in some responses, which Kubernetes APIServer doesn't handle by default. This special FQDN supports CORS, allowing the Azure Portal to function properly.
	AzurePortalFQDN *string `json:"azurePortalFQDN,omitempty"`
	// AgentPoolProfiles - The agent pool properties.
	AgentPoolProfiles *[]ManagedClusterAgentPoolProfile `json:"agentPoolProfiles,omitempty"`
	// LinuxProfile - The profile for Linux VMs in the Managed Cluster.
	LinuxProfile *LinuxProfile `json:"linuxProfile,omitempty"`
	// WindowsProfile - The profile for Windows VMs in the Managed Cluster.
	WindowsProfile *ManagedClusterWindowsProfile `json:"windowsProfile,omitempty"`
	// ServicePrincipalProfile - Information about a service principal identity for the cluster to use for manipulating Azure APIs.
	ServicePrincipalProfile *ManagedClusterServicePrincipalProfile `json:"servicePrincipalProfile,omitempty"`
	// AddonProfiles - The profile of managed cluster add-on.
	AddonProfiles map[string]*ManagedClusterAddonProfile `json:"addonProfiles"`
	// PodIdentityProfile - See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity integration.
	PodIdentityProfile *ManagedClusterPodIdentityProfile `json:"podIdentityProfile,omitempty"`
	// NodeResourceGroup - The name of the resource group containing agent pool nodes.
	NodeResourceGroup *string `json:"nodeResourceGroup,omitempty"`
	// EnableRBAC - Whether to enable Kubernetes Role-Based Access Control.
	EnableRBAC *bool `json:"enableRBAC,omitempty"`
	// EnablePodSecurityPolicy - (DEPRECATING) Whether to enable Kubernetes pod security policy (preview). This feature is set for removal on October 15th, 2020. Learn more at aka.ms/aks/azpodpolicy.
	EnablePodSecurityPolicy *bool `json:"enablePodSecurityPolicy,omitempty"`
	// NetworkProfile - The network configuration profile.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`
	// AadProfile - The Azure Active Directory configuration.
	AadProfile *ManagedClusterAADProfile `json:"aadProfile,omitempty"`
	// AutoUpgradeProfile - The auto upgrade configuration.
	AutoUpgradeProfile *ManagedClusterAutoUpgradeProfile `json:"autoUpgradeProfile,omitempty"`
	// AutoScalerProfile - Parameters to be applied to the cluster-autoscaler when enabled
	AutoScalerProfile *ManagedClusterPropertiesAutoScalerProfile `json:"autoScalerProfile,omitempty"`
	// APIServerAccessProfile - The access profile for managed cluster API server.
	APIServerAccessProfile *ManagedClusterAPIServerAccessProfile `json:"apiServerAccessProfile,omitempty"`
	// DiskEncryptionSetID - This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
	DiskEncryptionSetID *string `json:"diskEncryptionSetID,omitempty"`
	// IdentityProfile - Identities associated with the cluster.
	IdentityProfile map[string]*UserAssignedIdentity `json:"identityProfile"`
	// PrivateLinkResources - Private link resources associated with the cluster.
	PrivateLinkResources *[]PrivateLinkResource `json:"privateLinkResources,omitempty"`
	// DisableLocalAccounts - If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters that are AAD enabled. For more details see [disable local accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
	DisableLocalAccounts *bool `json:"disableLocalAccounts,omitempty"`
	// HTTPProxyConfig - Configurations for provisioning the cluster with HTTP proxy servers.
	HTTPProxyConfig *ManagedClusterHTTPProxyConfig `json:"httpProxyConfig,omitempty"`
	// SecurityProfile - Security profile for the managed cluster.
	SecurityProfile *ManagedClusterSecurityProfile `json:"securityProfile,omitempty"`
	// PublicNetworkAccess - Allow or deny public network access for AKS. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterProperties.
func (mcp ManagedClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcp.KubernetesVersion != nil {
		objectMap["kubernetesVersion"] = mcp.KubernetesVersion
	}
	if mcp.DNSPrefix != nil {
		objectMap["dnsPrefix"] = mcp.DNSPrefix
	}
	if mcp.FqdnSubdomain != nil {
		objectMap["fqdnSubdomain"] = mcp.FqdnSubdomain
	}
	if mcp.AgentPoolProfiles != nil {
		objectMap["agentPoolProfiles"] = mcp.AgentPoolProfiles
	}
	if mcp.LinuxProfile != nil {
		objectMap["linuxProfile"] = mcp.LinuxProfile
	}
	if mcp.WindowsProfile != nil {
		objectMap["windowsProfile"] = mcp.WindowsProfile
	}
	if mcp.ServicePrincipalProfile != nil {
		objectMap["servicePrincipalProfile"] = mcp.ServicePrincipalProfile
	}
	if mcp.AddonProfiles != nil {
		objectMap["addonProfiles"] = mcp.AddonProfiles
	}
	if mcp.PodIdentityProfile != nil {
		objectMap["podIdentityProfile"] = mcp.PodIdentityProfile
	}
	if mcp.NodeResourceGroup != nil {
		objectMap["nodeResourceGroup"] = mcp.NodeResourceGroup
	}
	if mcp.EnableRBAC != nil {
		objectMap["enableRBAC"] = mcp.EnableRBAC
	}
	if mcp.EnablePodSecurityPolicy != nil {
		objectMap["enablePodSecurityPolicy"] = mcp.EnablePodSecurityPolicy
	}
	if mcp.NetworkProfile != nil {
		objectMap["networkProfile"] = mcp.NetworkProfile
	}
	if mcp.AadProfile != nil {
		objectMap["aadProfile"] = mcp.AadProfile
	}
	if mcp.AutoUpgradeProfile != nil {
		objectMap["autoUpgradeProfile"] = mcp.AutoUpgradeProfile
	}
	if mcp.AutoScalerProfile != nil {
		objectMap["autoScalerProfile"] = mcp.AutoScalerProfile
	}
	if mcp.APIServerAccessProfile != nil {
		objectMap["apiServerAccessProfile"] = mcp.APIServerAccessProfile
	}
	if mcp.DiskEncryptionSetID != nil {
		objectMap["diskEncryptionSetID"] = mcp.DiskEncryptionSetID
	}
	if mcp.IdentityProfile != nil {
		objectMap["identityProfile"] = mcp.IdentityProfile
	}
	if mcp.PrivateLinkResources != nil {
		objectMap["privateLinkResources"] = mcp.PrivateLinkResources
	}
	if mcp.DisableLocalAccounts != nil {
		objectMap["disableLocalAccounts"] = mcp.DisableLocalAccounts
	}
	if mcp.HTTPProxyConfig != nil {
		objectMap["httpProxyConfig"] = mcp.HTTPProxyConfig
	}
	if mcp.SecurityProfile != nil {
		objectMap["securityProfile"] = mcp.SecurityProfile
	}
	if mcp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = mcp.PublicNetworkAccess
	}
	return json.Marshal(objectMap)
}

// ManagedClusterPropertiesAutoScalerProfile parameters to be applied to the cluster-autoscaler when
// enabled
type ManagedClusterPropertiesAutoScalerProfile struct {
	// BalanceSimilarNodeGroups - Valid values are 'true' and 'false'
	BalanceSimilarNodeGroups *string `json:"balance-similar-node-groups,omitempty"`
	// Expander - If not specified, the default is 'random'. See [expanders](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders) for more information. Possible values include: 'ExpanderLeastWaste', 'ExpanderMostPods', 'ExpanderPriority', 'ExpanderRandom'
	Expander Expander `json:"expander,omitempty"`
	// MaxEmptyBulkDelete - The default is 10.
	MaxEmptyBulkDelete *string `json:"max-empty-bulk-delete,omitempty"`
	// MaxGracefulTerminationSec - The default is 600.
	MaxGracefulTerminationSec *string `json:"max-graceful-termination-sec,omitempty"`
	// MaxNodeProvisionTime - The default is '15m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	MaxNodeProvisionTime *string `json:"max-node-provision-time,omitempty"`
	// MaxTotalUnreadyPercentage - The default is 45. The maximum is 100 and the minimum is 0.
	MaxTotalUnreadyPercentage *string `json:"max-total-unready-percentage,omitempty"`
	// NewPodScaleUpDelay - For scenarios like burst/batch scale where you don't want CA to act before the kubernetes scheduler could schedule all the pods, you can tell CA to ignore unscheduled pods before they're a certain age. The default is '0s'. Values must be an integer followed by a unit ('s' for seconds, 'm' for minutes, 'h' for hours, etc).
	NewPodScaleUpDelay *string `json:"new-pod-scale-up-delay,omitempty"`
	// OkTotalUnreadyCount - This must be an integer. The default is 3.
	OkTotalUnreadyCount *string `json:"ok-total-unready-count,omitempty"`
	// ScanInterval - The default is '10'. Values must be an integer number of seconds.
	ScanInterval *string `json:"scan-interval,omitempty"`
	// ScaleDownDelayAfterAdd - The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownDelayAfterAdd *string `json:"scale-down-delay-after-add,omitempty"`
	// ScaleDownDelayAfterDelete - The default is the scan-interval. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownDelayAfterDelete *string `json:"scale-down-delay-after-delete,omitempty"`
	// ScaleDownDelayAfterFailure - The default is '3m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownDelayAfterFailure *string `json:"scale-down-delay-after-failure,omitempty"`
	// ScaleDownUnneededTime - The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownUnneededTime *string `json:"scale-down-unneeded-time,omitempty"`
	// ScaleDownUnreadyTime - The default is '20m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownUnreadyTime *string `json:"scale-down-unready-time,omitempty"`
	// ScaleDownUtilizationThreshold - The default is '0.5'.
	ScaleDownUtilizationThreshold *string `json:"scale-down-utilization-threshold,omitempty"`
	// SkipNodesWithLocalStorage - The default is true.
	SkipNodesWithLocalStorage *string `json:"skip-nodes-with-local-storage,omitempty"`
	// SkipNodesWithSystemPods - The default is true.
	SkipNodesWithSystemPods *string `json:"skip-nodes-with-system-pods,omitempty"`
}

// ManagedClustersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedClustersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (ManagedCluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersCreateOrUpdateFuture.Result.
func (future *ManagedClustersCreateOrUpdateFuture) result(client ManagedClustersClient) (mc ManagedCluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mc.Response.Response, err = future.GetResult(sender); err == nil && mc.Response.Response.StatusCode != http.StatusNoContent {
		mc, err = client.CreateOrUpdateResponder(mc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersCreateOrUpdateFuture", "Result", mc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedClustersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersDeleteFuture.Result.
func (future *ManagedClustersDeleteFuture) result(client ManagedClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedClusterSecurityProfile security profile for the container service cluster.
type ManagedClusterSecurityProfile struct {
	// AzureDefender - Azure Defender settings for the security profile.
	AzureDefender *ManagedClusterSecurityProfileAzureDefender `json:"azureDefender,omitempty"`
}

// ManagedClusterSecurityProfileAzureDefender azure Defender settings for the security profile.
type ManagedClusterSecurityProfileAzureDefender struct {
	// Enabled - Whether to enable Azure Defender
	Enabled *bool `json:"enabled,omitempty"`
	// LogAnalyticsWorkspaceResourceID - Resource ID of the Log Analytics workspace to be associated with Azure Defender.  When Azure Defender is enabled, this field is required and must be a valid workspace resource ID. When Azure Defender is disabled, leave the field empty.
	LogAnalyticsWorkspaceResourceID *string `json:"logAnalyticsWorkspaceResourceId,omitempty"`
}

// ManagedClusterServicePrincipalProfile information about a service principal identity for the cluster to
// use for manipulating Azure APIs.
type ManagedClusterServicePrincipalProfile struct {
	// ClientID - The ID for the service principal.
	ClientID *string `json:"clientId,omitempty"`
	// Secret - The secret password associated with the service principal in plain text.
	Secret *string `json:"secret,omitempty"`
}

// ManagedClusterSKU the SKU of a Managed Cluster.
type ManagedClusterSKU struct {
	// Name - The name of a managed cluster SKU. Possible values include: 'ManagedClusterSKUNameBasic'
	Name ManagedClusterSKUName `json:"name,omitempty"`
	// Tier - If not specified, the default is 'Free'. See [uptime SLA](https://docs.microsoft.com/azure/aks/uptime-sla) for more details. Possible values include: 'ManagedClusterSKUTierPaid', 'ManagedClusterSKUTierFree'
	Tier ManagedClusterSKUTier `json:"tier,omitempty"`
}

// ManagedClustersResetAADProfileFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedClustersResetAADProfileFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersResetAADProfileFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersResetAADProfileFuture.Result.
func (future *ManagedClustersResetAADProfileFuture) result(client ManagedClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersResetAADProfileFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersResetAADProfileFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedClustersResetServicePrincipalProfileFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedClustersResetServicePrincipalProfileFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersResetServicePrincipalProfileFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersResetServicePrincipalProfileFuture.Result.
func (future *ManagedClustersResetServicePrincipalProfileFuture) result(client ManagedClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersResetServicePrincipalProfileFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersResetServicePrincipalProfileFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedClustersRotateClusterCertificatesFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ManagedClustersRotateClusterCertificatesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersRotateClusterCertificatesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersRotateClusterCertificatesFuture.Result.
func (future *ManagedClustersRotateClusterCertificatesFuture) result(client ManagedClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersRotateClusterCertificatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersRotateClusterCertificatesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedClustersRunCommandFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedClustersRunCommandFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (RunCommandResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersRunCommandFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersRunCommandFuture.Result.
func (future *ManagedClustersRunCommandFuture) result(client ManagedClustersClient) (rcr RunCommandResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersRunCommandFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rcr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersRunCommandFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rcr.Response.Response, err = future.GetResult(sender); err == nil && rcr.Response.Response.StatusCode != http.StatusNoContent {
		rcr, err = client.RunCommandResponder(rcr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersRunCommandFuture", "Result", rcr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedClustersStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedClustersStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersStartFuture.Result.
func (future *ManagedClustersStartFuture) result(client ManagedClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedClustersStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedClustersStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersStopFuture.Result.
func (future *ManagedClustersStopFuture) result(client ManagedClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedClustersUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedClustersUpdateTagsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedClustersClient) (ManagedCluster, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedClustersUpdateTagsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedClustersUpdateTagsFuture.Result.
func (future *ManagedClustersUpdateTagsFuture) result(client ManagedClustersClient) (mc ManagedCluster, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersUpdateTagsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersUpdateTagsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mc.Response.Response, err = future.GetResult(sender); err == nil && mc.Response.Response.StatusCode != http.StatusNoContent {
		mc, err = client.UpdateTagsResponder(mc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersUpdateTagsFuture", "Result", mc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedClusterUpgradeProfile the list of available upgrades for compute pools.
type ManagedClusterUpgradeProfile struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The ID of the upgrade profile.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the upgrade profile.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the upgrade profile.
	Type *string `json:"type,omitempty"`
	// ManagedClusterUpgradeProfileProperties - The properties of the upgrade profile.
	*ManagedClusterUpgradeProfileProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterUpgradeProfile.
func (mcup ManagedClusterUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcup.ManagedClusterUpgradeProfileProperties != nil {
		objectMap["properties"] = mcup.ManagedClusterUpgradeProfileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedClusterUpgradeProfile struct.
func (mcup *ManagedClusterUpgradeProfile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mcup.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var managedClusterUpgradeProfileProperties ManagedClusterUpgradeProfileProperties
				err = json.Unmarshal(*v, &managedClusterUpgradeProfileProperties)
				if err != nil {
					return err
				}
				mcup.ManagedClusterUpgradeProfileProperties = &managedClusterUpgradeProfileProperties
			}
		}
	}

	return nil
}

// ManagedClusterUpgradeProfileProperties control plane and agent pool upgrade profiles.
type ManagedClusterUpgradeProfileProperties struct {
	// ControlPlaneProfile - The list of available upgrade versions for the control plane.
	ControlPlaneProfile *ManagedClusterPoolUpgradeProfile `json:"controlPlaneProfile,omitempty"`
	// AgentPoolProfiles - The list of available upgrade versions for agent pools.
	AgentPoolProfiles *[]ManagedClusterPoolUpgradeProfile `json:"agentPoolProfiles,omitempty"`
}

// ManagedClusterWindowsProfile profile for Windows VMs in the managed cluster.
type ManagedClusterWindowsProfile struct {
	// AdminUsername - Specifies the name of the administrator account. <br><br> **Restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length:** 1 character <br><br> **Max-length:** 20 characters
	AdminUsername *string `json:"adminUsername,omitempty"`
	// AdminPassword - Specifies the password of the administrator account. <br><br> **Minimum-length:** 8 characters <br><br> **Max-length:** 123 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
	AdminPassword *string `json:"adminPassword,omitempty"`
	// LicenseType - The license type to use for Windows VMs. See [Azure Hybrid User Benefits](https://azure.microsoft.com/pricing/hybrid-benefit/faq/) for more details. Possible values include: 'LicenseTypeNone', 'LicenseTypeWindowsServer'
	LicenseType LicenseType `json:"licenseType,omitempty"`
	// EnableCSIProxy - For more details on CSI proxy, see the [CSI proxy GitHub repo](https://github.com/kubernetes-csi/csi-proxy).
	EnableCSIProxy *bool `json:"enableCSIProxy,omitempty"`
	// GmsaProfile - The Windows gMSA Profile in the Managed Cluster.
	GmsaProfile *WindowsGmsaProfile `json:"gmsaProfile,omitempty"`
}

// MasterProfile profile for the container service master.
type MasterProfile struct {
	// Count - Number of masters (VMs) in the container service cluster. Allowed values are 1, 3, and 5. The default value is 1.
	Count *int32 `json:"count,omitempty"`
	// DNSPrefix - DNS prefix to be used to create the FQDN for the master pool.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`
	// VMSize - Size of agent VMs. Possible values include: 'VMSizeTypesStandardA1', 'VMSizeTypesStandardA10', 'VMSizeTypesStandardA11', 'VMSizeTypesStandardA1V2', 'VMSizeTypesStandardA2', 'VMSizeTypesStandardA2V2', 'VMSizeTypesStandardA2mV2', 'VMSizeTypesStandardA3', 'VMSizeTypesStandardA4', 'VMSizeTypesStandardA4V2', 'VMSizeTypesStandardA4mV2', 'VMSizeTypesStandardA5', 'VMSizeTypesStandardA6', 'VMSizeTypesStandardA7', 'VMSizeTypesStandardA8', 'VMSizeTypesStandardA8V2', 'VMSizeTypesStandardA8mV2', 'VMSizeTypesStandardA9', 'VMSizeTypesStandardB2ms', 'VMSizeTypesStandardB2s', 'VMSizeTypesStandardB4ms', 'VMSizeTypesStandardB8ms', 'VMSizeTypesStandardD1', 'VMSizeTypesStandardD11', 'VMSizeTypesStandardD11V2', 'VMSizeTypesStandardD11V2Promo', 'VMSizeTypesStandardD12', 'VMSizeTypesStandardD12V2', 'VMSizeTypesStandardD12V2Promo', 'VMSizeTypesStandardD13', 'VMSizeTypesStandardD13V2', 'VMSizeTypesStandardD13V2Promo', 'VMSizeTypesStandardD14', 'VMSizeTypesStandardD14V2', 'VMSizeTypesStandardD14V2Promo', 'VMSizeTypesStandardD15V2', 'VMSizeTypesStandardD16V3', 'VMSizeTypesStandardD16sV3', 'VMSizeTypesStandardD1V2', 'VMSizeTypesStandardD2', 'VMSizeTypesStandardD2V2', 'VMSizeTypesStandardD2V2Promo', 'VMSizeTypesStandardD2V3', 'VMSizeTypesStandardD2sV3', 'VMSizeTypesStandardD3', 'VMSizeTypesStandardD32V3', 'VMSizeTypesStandardD32sV3', 'VMSizeTypesStandardD3V2', 'VMSizeTypesStandardD3V2Promo', 'VMSizeTypesStandardD4', 'VMSizeTypesStandardD4V2', 'VMSizeTypesStandardD4V2Promo', 'VMSizeTypesStandardD4V3', 'VMSizeTypesStandardD4sV3', 'VMSizeTypesStandardD5V2', 'VMSizeTypesStandardD5V2Promo', 'VMSizeTypesStandardD64V3', 'VMSizeTypesStandardD64sV3', 'VMSizeTypesStandardD8V3', 'VMSizeTypesStandardD8sV3', 'VMSizeTypesStandardDS1', 'VMSizeTypesStandardDS11', 'VMSizeTypesStandardDS11V2', 'VMSizeTypesStandardDS11V2Promo', 'VMSizeTypesStandardDS12', 'VMSizeTypesStandardDS12V2', 'VMSizeTypesStandardDS12V2Promo', 'VMSizeTypesStandardDS13', 'VMSizeTypesStandardDS132V2', 'VMSizeTypesStandardDS134V2', 'VMSizeTypesStandardDS13V2', 'VMSizeTypesStandardDS13V2Promo', 'VMSizeTypesStandardDS14', 'VMSizeTypesStandardDS144V2', 'VMSizeTypesStandardDS148V2', 'VMSizeTypesStandardDS14V2', 'VMSizeTypesStandardDS14V2Promo', 'VMSizeTypesStandardDS15V2', 'VMSizeTypesStandardDS1V2', 'VMSizeTypesStandardDS2', 'VMSizeTypesStandardDS2V2', 'VMSizeTypesStandardDS2V2Promo', 'VMSizeTypesStandardDS3', 'VMSizeTypesStandardDS3V2', 'VMSizeTypesStandardDS3V2Promo', 'VMSizeTypesStandardDS4', 'VMSizeTypesStandardDS4V2', 'VMSizeTypesStandardDS4V2Promo', 'VMSizeTypesStandardDS5V2', 'VMSizeTypesStandardDS5V2Promo', 'VMSizeTypesStandardE16V3', 'VMSizeTypesStandardE16sV3', 'VMSizeTypesStandardE2V3', 'VMSizeTypesStandardE2sV3', 'VMSizeTypesStandardE3216sV3', 'VMSizeTypesStandardE328sV3', 'VMSizeTypesStandardE32V3', 'VMSizeTypesStandardE32sV3', 'VMSizeTypesStandardE4V3', 'VMSizeTypesStandardE4sV3', 'VMSizeTypesStandardE6416sV3', 'VMSizeTypesStandardE6432sV3', 'VMSizeTypesStandardE64V3', 'VMSizeTypesStandardE64sV3', 'VMSizeTypesStandardE8V3', 'VMSizeTypesStandardE8sV3', 'VMSizeTypesStandardF1', 'VMSizeTypesStandardF16', 'VMSizeTypesStandardF16s', 'VMSizeTypesStandardF16sV2', 'VMSizeTypesStandardF1s', 'VMSizeTypesStandardF2', 'VMSizeTypesStandardF2s', 'VMSizeTypesStandardF2sV2', 'VMSizeTypesStandardF32sV2', 'VMSizeTypesStandardF4', 'VMSizeTypesStandardF4s', 'VMSizeTypesStandardF4sV2', 'VMSizeTypesStandardF64sV2', 'VMSizeTypesStandardF72sV2', 'VMSizeTypesStandardF8', 'VMSizeTypesStandardF8s', 'VMSizeTypesStandardF8sV2', 'VMSizeTypesStandardG1', 'VMSizeTypesStandardG2', 'VMSizeTypesStandardG3', 'VMSizeTypesStandardG4', 'VMSizeTypesStandardG5', 'VMSizeTypesStandardGS1', 'VMSizeTypesStandardGS2', 'VMSizeTypesStandardGS3', 'VMSizeTypesStandardGS4', 'VMSizeTypesStandardGS44', 'VMSizeTypesStandardGS48', 'VMSizeTypesStandardGS5', 'VMSizeTypesStandardGS516', 'VMSizeTypesStandardGS58', 'VMSizeTypesStandardH16', 'VMSizeTypesStandardH16m', 'VMSizeTypesStandardH16mr', 'VMSizeTypesStandardH16r', 'VMSizeTypesStandardH8', 'VMSizeTypesStandardH8m', 'VMSizeTypesStandardL16s', 'VMSizeTypesStandardL32s', 'VMSizeTypesStandardL4s', 'VMSizeTypesStandardL8s', 'VMSizeTypesStandardM12832ms', 'VMSizeTypesStandardM12864ms', 'VMSizeTypesStandardM128ms', 'VMSizeTypesStandardM128s', 'VMSizeTypesStandardM6416ms', 'VMSizeTypesStandardM6432ms', 'VMSizeTypesStandardM64ms', 'VMSizeTypesStandardM64s', 'VMSizeTypesStandardNC12', 'VMSizeTypesStandardNC12sV2', 'VMSizeTypesStandardNC12sV3', 'VMSizeTypesStandardNC24', 'VMSizeTypesStandardNC24r', 'VMSizeTypesStandardNC24rsV2', 'VMSizeTypesStandardNC24rsV3', 'VMSizeTypesStandardNC24sV2', 'VMSizeTypesStandardNC24sV3', 'VMSizeTypesStandardNC6', 'VMSizeTypesStandardNC6sV2', 'VMSizeTypesStandardNC6sV3', 'VMSizeTypesStandardND12s', 'VMSizeTypesStandardND24rs', 'VMSizeTypesStandardND24s', 'VMSizeTypesStandardND6s', 'VMSizeTypesStandardNV12', 'VMSizeTypesStandardNV24', 'VMSizeTypesStandardNV6'
	VMSize VMSizeTypes `json:"vmSize,omitempty"`
	// OsDiskSizeGB - OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
	OsDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`
	// VnetSubnetID - VNet SubnetID specifies the VNet's subnet identifier.
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`
	// FirstConsecutiveStaticIP - FirstConsecutiveStaticIP used to specify the first static ip of masters.
	FirstConsecutiveStaticIP *string `json:"firstConsecutiveStaticIP,omitempty"`
	// StorageProfile - Storage profile specifies what kind of storage used. Choose from StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the orchestrator choice. Possible values include: 'StorageProfileTypesStorageAccount', 'StorageProfileTypesManagedDisks'
	StorageProfile StorageProfileTypes `json:"storageProfile,omitempty"`
	// Fqdn - READ-ONLY; FQDN for the master pool.
	Fqdn *string `json:"fqdn,omitempty"`
}

// MarshalJSON is the custom marshaler for MasterProfile.
func (mp MasterProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mp.Count != nil {
		objectMap["count"] = mp.Count
	}
	if mp.DNSPrefix != nil {
		objectMap["dnsPrefix"] = mp.DNSPrefix
	}
	if mp.VMSize != "" {
		objectMap["vmSize"] = mp.VMSize
	}
	if mp.OsDiskSizeGB != nil {
		objectMap["osDiskSizeGB"] = mp.OsDiskSizeGB
	}
	if mp.VnetSubnetID != nil {
		objectMap["vnetSubnetID"] = mp.VnetSubnetID
	}
	if mp.FirstConsecutiveStaticIP != nil {
		objectMap["firstConsecutiveStaticIP"] = mp.FirstConsecutiveStaticIP
	}
	if mp.StorageProfile != "" {
		objectMap["storageProfile"] = mp.StorageProfile
	}
	return json.Marshal(objectMap)
}

// NetworkProfile profile of network configuration.
type NetworkProfile struct {
	// NetworkPlugin - Network plugin used for building the Kubernetes network. Possible values include: 'NetworkPluginAzure', 'NetworkPluginKubenet'
	NetworkPlugin NetworkPlugin `json:"networkPlugin,omitempty"`
	// NetworkPolicy - Network policy used for building the Kubernetes network. Possible values include: 'NetworkPolicyCalico', 'NetworkPolicyAzure'
	NetworkPolicy NetworkPolicy `json:"networkPolicy,omitempty"`
	// NetworkMode - This cannot be specified if networkPlugin is anything other than 'azure'. Possible values include: 'NetworkModeTransparent', 'NetworkModeBridge'
	NetworkMode NetworkMode `json:"networkMode,omitempty"`
	// PodCidr - A CIDR notation IP range from which to assign pod IPs when kubenet is used.
	PodCidr *string `json:"podCidr,omitempty"`
	// ServiceCidr - A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
	ServiceCidr *string `json:"serviceCidr,omitempty"`
	// DNSServiceIP - An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
	DNSServiceIP *string `json:"dnsServiceIP,omitempty"`
	// DockerBridgeCidr - A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
	DockerBridgeCidr *string `json:"dockerBridgeCidr,omitempty"`
	// OutboundType - This can only be set at cluster creation time and cannot be changed later. For more information see [egress outbound type](https://docs.microsoft.com/azure/aks/egress-outboundtype). Possible values include: 'OutboundTypeLoadBalancer', 'OutboundTypeUserDefinedRouting', 'OutboundTypeManagedNATGateway', 'OutboundTypeUserAssignedNATGateway'
	OutboundType OutboundType `json:"outboundType,omitempty"`
	// LoadBalancerSku - The default is 'standard'. See [Azure Load Balancer SKUs](https://docs.microsoft.com/azure/load-balancer/skus) for more information about the differences between load balancer SKUs. Possible values include: 'LoadBalancerSkuStandard', 'LoadBalancerSkuBasic'
	LoadBalancerSku LoadBalancerSku `json:"loadBalancerSku,omitempty"`
	// LoadBalancerProfile - Profile of the cluster load balancer.
	LoadBalancerProfile *ManagedClusterLoadBalancerProfile `json:"loadBalancerProfile,omitempty"`
	// NatGatewayProfile - Profile of the cluster NAT gateway.
	NatGatewayProfile *ManagedClusterNATGatewayProfile `json:"natGatewayProfile,omitempty"`
	// PodCidrs - One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
	PodCidrs *[]string `json:"podCidrs,omitempty"`
	// ServiceCidrs - One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
	ServiceCidrs *[]string `json:"serviceCidrs,omitempty"`
	// IPFamilies - IP families are used to determine single-stack or dual-stack clusters. For single-stack, the expected value is IPv4. For dual-stack, the expected values are IPv4 and IPv6.
	IPFamilies *[]IPFamily `json:"ipFamilies,omitempty"`
}

// OperationListResult the List Operation response.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of operations
	Value *[]OperationValue `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationValue describes the properties of a Operation value.
type OperationValue struct {
	// Origin - READ-ONLY; The origin of the operation.
	Origin *string `json:"origin,omitempty"`
	// Name - READ-ONLY; The name of the operation.
	Name *string `json:"name,omitempty"`
	// OperationValueDisplay - Describes the properties of a Operation Value Display.
	*OperationValueDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationValue.
func (ov OperationValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ov.OperationValueDisplay != nil {
		objectMap["display"] = ov.OperationValueDisplay
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OperationValue struct.
func (ov *OperationValue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				ov.Origin = &origin
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ov.Name = &name
			}
		case "display":
			if v != nil {
				var operationValueDisplay OperationValueDisplay
				err = json.Unmarshal(*v, &operationValueDisplay)
				if err != nil {
					return err
				}
				ov.OperationValueDisplay = &operationValueDisplay
			}
		}
	}

	return nil
}

// OperationValueDisplay describes the properties of a Operation Value Display.
type OperationValueDisplay struct {
	// Operation - READ-ONLY; The display name of the operation.
	Operation *string `json:"operation,omitempty"`
	// Resource - READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty"`
	// Description - READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty"`
	// Provider - READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationValueDisplay.
func (ovd OperationValueDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OSOptionProfile the OS option profile.
type OSOptionProfile struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The ID of the OS option resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the OS option resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the OS option resource.
	Type *string `json:"type,omitempty"`
	// OSOptionPropertyList - The list of OS options.
	*OSOptionPropertyList `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OSOptionProfile.
func (oop OSOptionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oop.OSOptionPropertyList != nil {
		objectMap["properties"] = oop.OSOptionPropertyList
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OSOptionProfile struct.
func (oop *OSOptionProfile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				oop.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				oop.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				oop.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var oSOptionPropertyList OSOptionPropertyList
				err = json.Unmarshal(*v, &oSOptionPropertyList)
				if err != nil {
					return err
				}
				oop.OSOptionPropertyList = &oSOptionPropertyList
			}
		}
	}

	return nil
}

// OSOptionProperty OS option property.
type OSOptionProperty struct {
	// OsType - The OS type.
	OsType *string `json:"os-type,omitempty"`
	// EnableFipsImage - Whether the image is FIPS-enabled.
	EnableFipsImage *bool `json:"enable-fips-image,omitempty"`
}

// OSOptionPropertyList the list of OS option properties.
type OSOptionPropertyList struct {
	// OsOptionPropertyList - The list of OS options.
	OsOptionPropertyList *[]OSOptionProperty `json:"osOptionPropertyList,omitempty"`
}

// OutboundEnvironmentEndpoint egress endpoints which AKS agent nodes connect to for common purpose.
type OutboundEnvironmentEndpoint struct {
	// Category - The category of endpoints accessed by the AKS agent node, e.g. azure-resource-management, apiserver, etc.
	Category *string `json:"category,omitempty"`
	// Endpoints - The endpoints that AKS agent nodes connect to
	Endpoints *[]EndpointDependency `json:"endpoints,omitempty"`
}

// OutboundEnvironmentEndpointCollection collection of OutboundEnvironmentEndpoint
type OutboundEnvironmentEndpointCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]OutboundEnvironmentEndpoint `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OutboundEnvironmentEndpointCollection.
func (oeec OutboundEnvironmentEndpointCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oeec.Value != nil {
		objectMap["value"] = oeec.Value
	}
	return json.Marshal(objectMap)
}

// OutboundEnvironmentEndpointCollectionIterator provides access to a complete listing of
// OutboundEnvironmentEndpoint values.
type OutboundEnvironmentEndpointCollectionIterator struct {
	i    int
	page OutboundEnvironmentEndpointCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OutboundEnvironmentEndpointCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OutboundEnvironmentEndpointCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OutboundEnvironmentEndpointCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OutboundEnvironmentEndpointCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OutboundEnvironmentEndpointCollectionIterator) Response() OutboundEnvironmentEndpointCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OutboundEnvironmentEndpointCollectionIterator) Value() OutboundEnvironmentEndpoint {
	if !iter.page.NotDone() {
		return OutboundEnvironmentEndpoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OutboundEnvironmentEndpointCollectionIterator type.
func NewOutboundEnvironmentEndpointCollectionIterator(page OutboundEnvironmentEndpointCollectionPage) OutboundEnvironmentEndpointCollectionIterator {
	return OutboundEnvironmentEndpointCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oeec OutboundEnvironmentEndpointCollection) IsEmpty() bool {
	return oeec.Value == nil || len(*oeec.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oeec OutboundEnvironmentEndpointCollection) hasNextLink() bool {
	return oeec.NextLink != nil && len(*oeec.NextLink) != 0
}

// outboundEnvironmentEndpointCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oeec OutboundEnvironmentEndpointCollection) outboundEnvironmentEndpointCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !oeec.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oeec.NextLink)))
}

// OutboundEnvironmentEndpointCollectionPage contains a page of OutboundEnvironmentEndpoint values.
type OutboundEnvironmentEndpointCollectionPage struct {
	fn   func(context.Context, OutboundEnvironmentEndpointCollection) (OutboundEnvironmentEndpointCollection, error)
	oeec OutboundEnvironmentEndpointCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OutboundEnvironmentEndpointCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OutboundEnvironmentEndpointCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oeec)
		if err != nil {
			return err
		}
		page.oeec = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OutboundEnvironmentEndpointCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OutboundEnvironmentEndpointCollectionPage) NotDone() bool {
	return !page.oeec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OutboundEnvironmentEndpointCollectionPage) Response() OutboundEnvironmentEndpointCollection {
	return page.oeec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OutboundEnvironmentEndpointCollectionPage) Values() []OutboundEnvironmentEndpoint {
	if page.oeec.IsEmpty() {
		return nil
	}
	return *page.oeec.Value
}

// Creates a new instance of the OutboundEnvironmentEndpointCollectionPage type.
func NewOutboundEnvironmentEndpointCollectionPage(cur OutboundEnvironmentEndpointCollection, getNextPage func(context.Context, OutboundEnvironmentEndpointCollection) (OutboundEnvironmentEndpointCollection, error)) OutboundEnvironmentEndpointCollectionPage {
	return OutboundEnvironmentEndpointCollectionPage{
		fn:   getNextPage,
		oeec: cur,
	}
}

// PowerState describes the Power State of the cluster
type PowerState struct {
	// Code - Tells whether the cluster is Running or Stopped. Possible values include: 'CodeRunning', 'CodeStopped'
	Code Code `json:"code,omitempty"`
}

// PrivateEndpoint private endpoint which a connection belongs to.
type PrivateEndpoint struct {
	// ID - The resource ID of the private endpoint
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection a private endpoint connection
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The ID of the private endpoint connection.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the private endpoint connection.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// PrivateEndpointConnectionProperties - The properties of a private endpoint connection.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult a list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// ProvisioningState - READ-ONLY; The current provisioning state. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
	// PrivateEndpoint - The resource of private endpoint.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionProperties.
func (pecp PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecp.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = pecp.PrivateEndpoint
	}
	if pecp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = pecp.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerservice.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// ID - The ID of the private link resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the private link resource.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
	// GroupID - The group ID of the resource.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - The RequiredMembers of the resource
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// PrivateLinkServiceID - READ-ONLY; The private link service ID of the resource, this field is exposed only to NRP internally.
	PrivateLinkServiceID *string `json:"privateLinkServiceID,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.ID != nil {
		objectMap["id"] = plr.ID
	}
	if plr.Name != nil {
		objectMap["name"] = plr.Name
	}
	if plr.Type != nil {
		objectMap["type"] = plr.Type
	}
	if plr.GroupID != nil {
		objectMap["groupId"] = plr.GroupID
	}
	if plr.RequiredMembers != nil {
		objectMap["requiredMembers"] = plr.RequiredMembers
	}
	return json.Marshal(objectMap)
}

// PrivateLinkResourcesListResult a list of private link resources
type PrivateLinkResourcesListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkServiceConnectionState the state of a private link service connection.
type PrivateLinkServiceConnectionState struct {
	// Status - The private link service connection status. Possible values include: 'ConnectionStatusPending', 'ConnectionStatusApproved', 'ConnectionStatusRejected', 'ConnectionStatusDisconnected'
	Status ConnectionStatus `json:"status,omitempty"`
	// Description - The private link service connection description.
	Description *string `json:"description,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceReference a reference to an Azure resource.
type ResourceReference struct {
	// ID - The fully qualified Azure resource id.
	ID *string `json:"id,omitempty"`
}

// RunCommandRequest a run command request
type RunCommandRequest struct {
	// Command - The command to run.
	Command *string `json:"command,omitempty"`
	// Context - A base64 encoded zip file containing the files required by the command.
	Context *string `json:"context,omitempty"`
	// ClusterToken - AuthToken issued for AKS AAD Server App.
	ClusterToken *string `json:"clusterToken,omitempty"`
}

// RunCommandResult run command result.
type RunCommandResult struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The command id.
	ID *string `json:"id,omitempty"`
	// CommandResultProperties - Properties of command result.
	*CommandResultProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RunCommandResult.
func (rcr RunCommandResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcr.CommandResultProperties != nil {
		objectMap["properties"] = rcr.CommandResultProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RunCommandResult struct.
func (rcr *RunCommandResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rcr.ID = &ID
			}
		case "properties":
			if v != nil {
				var commandResultProperties CommandResultProperties
				err = json.Unmarshal(*v, &commandResultProperties)
				if err != nil {
					return err
				}
				rcr.CommandResultProperties = &commandResultProperties
			}
		}
	}

	return nil
}

// Snapshot a node pool snapshot resource.
type Snapshot struct {
	autorest.Response `json:"-"`
	// SnapshotProperties - Properties of a snapshot.
	*SnapshotProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Snapshot.
func (s Snapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SnapshotProperties != nil {
		objectMap["properties"] = s.SnapshotProperties
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Snapshot struct.
func (s *Snapshot) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var snapshotProperties SnapshotProperties
				err = json.Unmarshal(*v, &snapshotProperties)
				if err != nil {
					return err
				}
				s.SnapshotProperties = &snapshotProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				s.SystemData = &systemData
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		}
	}

	return nil
}

// SnapshotListResult the response from the List Snapshots operation.
type SnapshotListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of snapshots.
	Value *[]Snapshot `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of snapshot results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SnapshotListResult.
func (slr SnapshotListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if slr.Value != nil {
		objectMap["value"] = slr.Value
	}
	return json.Marshal(objectMap)
}

// SnapshotListResultIterator provides access to a complete listing of Snapshot values.
type SnapshotListResultIterator struct {
	i    int
	page SnapshotListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SnapshotListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SnapshotListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SnapshotListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SnapshotListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SnapshotListResultIterator) Response() SnapshotListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SnapshotListResultIterator) Value() Snapshot {
	if !iter.page.NotDone() {
		return Snapshot{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SnapshotListResultIterator type.
func NewSnapshotListResultIterator(page SnapshotListResultPage) SnapshotListResultIterator {
	return SnapshotListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr SnapshotListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr SnapshotListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// snapshotListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SnapshotListResult) snapshotListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// SnapshotListResultPage contains a page of Snapshot values.
type SnapshotListResultPage struct {
	fn  func(context.Context, SnapshotListResult) (SnapshotListResult, error)
	slr SnapshotListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SnapshotListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SnapshotListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SnapshotListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SnapshotListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SnapshotListResultPage) Response() SnapshotListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SnapshotListResultPage) Values() []Snapshot {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the SnapshotListResultPage type.
func NewSnapshotListResultPage(cur SnapshotListResult, getNextPage func(context.Context, SnapshotListResult) (SnapshotListResult, error)) SnapshotListResultPage {
	return SnapshotListResultPage{
		fn:  getNextPage,
		slr: cur,
	}
}

// SnapshotProperties properties used to configure a node pool snapshot.
type SnapshotProperties struct {
	// CreationData - CreationData to be used to specify the source agent pool resource ID to create this snapshot.
	CreationData *CreationData `json:"creationData,omitempty"`
	// SnapshotType - Possible values include: 'SnapshotTypeNodePool'
	SnapshotType SnapshotType `json:"snapshotType,omitempty"`
	// KubernetesVersion - READ-ONLY; The version of Kubernetes.
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// NodeImageVersion - READ-ONLY; The version of node image.
	NodeImageVersion *string `json:"nodeImageVersion,omitempty"`
	// OsType - READ-ONLY; Possible values include: 'OSTypeLinux', 'OSTypeWindows'
	OsType OSType `json:"osType,omitempty"`
	// OsSku - READ-ONLY; Possible values include: 'OSSKUUbuntu', 'OSSKUCBLMariner'
	OsSku OSSKU `json:"osSku,omitempty"`
	// VMSize - READ-ONLY; The size of the VM.
	VMSize *string `json:"vmSize,omitempty"`
	// EnableFIPS - READ-ONLY; Whether to use a FIPS-enabled OS.
	EnableFIPS *bool `json:"enableFIPS,omitempty"`
}

// MarshalJSON is the custom marshaler for SnapshotProperties.
func (sp SnapshotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.CreationData != nil {
		objectMap["creationData"] = sp.CreationData
	}
	if sp.SnapshotType != "" {
		objectMap["snapshotType"] = sp.SnapshotType
	}
	return json.Marshal(objectMap)
}

// SSHConfiguration SSH configuration for Linux-based VMs running on Azure.
type SSHConfiguration struct {
	// PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. A maximum of 1 key may be specified.
	PublicKeys *[]SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey contains information about SSH certificate public key data.
type SSHPublicKey struct {
	// KeyData - Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
	KeyData *string `json:"keyData,omitempty"`
}

// SubResource reference to another subresource.
type SubResource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SubResource.
func (sr SubResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SysctlConfig sysctl settings for Linux agent nodes.
type SysctlConfig struct {
	// NetCoreSomaxconn - Sysctl setting net.core.somaxconn.
	NetCoreSomaxconn *int32 `json:"netCoreSomaxconn,omitempty"`
	// NetCoreNetdevMaxBacklog - Sysctl setting net.core.netdev_max_backlog.
	NetCoreNetdevMaxBacklog *int32 `json:"netCoreNetdevMaxBacklog,omitempty"`
	// NetCoreRmemDefault - Sysctl setting net.core.rmem_default.
	NetCoreRmemDefault *int32 `json:"netCoreRmemDefault,omitempty"`
	// NetCoreRmemMax - Sysctl setting net.core.rmem_max.
	NetCoreRmemMax *int32 `json:"netCoreRmemMax,omitempty"`
	// NetCoreWmemDefault - Sysctl setting net.core.wmem_default.
	NetCoreWmemDefault *int32 `json:"netCoreWmemDefault,omitempty"`
	// NetCoreWmemMax - Sysctl setting net.core.wmem_max.
	NetCoreWmemMax *int32 `json:"netCoreWmemMax,omitempty"`
	// NetCoreOptmemMax - Sysctl setting net.core.optmem_max.
	NetCoreOptmemMax *int32 `json:"netCoreOptmemMax,omitempty"`
	// NetIpv4TCPMaxSynBacklog - Sysctl setting net.ipv4.tcp_max_syn_backlog.
	NetIpv4TCPMaxSynBacklog *int32 `json:"netIpv4TcpMaxSynBacklog,omitempty"`
	// NetIpv4TCPMaxTwBuckets - Sysctl setting net.ipv4.tcp_max_tw_buckets.
	NetIpv4TCPMaxTwBuckets *int32 `json:"netIpv4TcpMaxTwBuckets,omitempty"`
	// NetIpv4TCPFinTimeout - Sysctl setting net.ipv4.tcp_fin_timeout.
	NetIpv4TCPFinTimeout *int32 `json:"netIpv4TcpFinTimeout,omitempty"`
	// NetIpv4TCPKeepaliveTime - Sysctl setting net.ipv4.tcp_keepalive_time.
	NetIpv4TCPKeepaliveTime *int32 `json:"netIpv4TcpKeepaliveTime,omitempty"`
	// NetIpv4TCPKeepaliveProbes - Sysctl setting net.ipv4.tcp_keepalive_probes.
	NetIpv4TCPKeepaliveProbes *int32 `json:"netIpv4TcpKeepaliveProbes,omitempty"`
	// NetIpv4TcpkeepaliveIntvl - Sysctl setting net.ipv4.tcp_keepalive_intvl.
	NetIpv4TcpkeepaliveIntvl *int32 `json:"netIpv4TcpkeepaliveIntvl,omitempty"`
	// NetIpv4TCPTwReuse - Sysctl setting net.ipv4.tcp_tw_reuse.
	NetIpv4TCPTwReuse *bool `json:"netIpv4TcpTwReuse,omitempty"`
	// NetIpv4IPLocalPortRange - Sysctl setting net.ipv4.ip_local_port_range.
	NetIpv4IPLocalPortRange *string `json:"netIpv4IpLocalPortRange,omitempty"`
	// NetIpv4NeighDefaultGcThresh1 - Sysctl setting net.ipv4.neigh.default.gc_thresh1.
	NetIpv4NeighDefaultGcThresh1 *int32 `json:"netIpv4NeighDefaultGcThresh1,omitempty"`
	// NetIpv4NeighDefaultGcThresh2 - Sysctl setting net.ipv4.neigh.default.gc_thresh2.
	NetIpv4NeighDefaultGcThresh2 *int32 `json:"netIpv4NeighDefaultGcThresh2,omitempty"`
	// NetIpv4NeighDefaultGcThresh3 - Sysctl setting net.ipv4.neigh.default.gc_thresh3.
	NetIpv4NeighDefaultGcThresh3 *int32 `json:"netIpv4NeighDefaultGcThresh3,omitempty"`
	// NetNetfilterNfConntrackMax - Sysctl setting net.netfilter.nf_conntrack_max.
	NetNetfilterNfConntrackMax *int32 `json:"netNetfilterNfConntrackMax,omitempty"`
	// NetNetfilterNfConntrackBuckets - Sysctl setting net.netfilter.nf_conntrack_buckets.
	NetNetfilterNfConntrackBuckets *int32 `json:"netNetfilterNfConntrackBuckets,omitempty"`
	// FsInotifyMaxUserWatches - Sysctl setting fs.inotify.max_user_watches.
	FsInotifyMaxUserWatches *int32 `json:"fsInotifyMaxUserWatches,omitempty"`
	// FsFileMax - Sysctl setting fs.file-max.
	FsFileMax *int32 `json:"fsFileMax,omitempty"`
	// FsAioMaxNr - Sysctl setting fs.aio-max-nr.
	FsAioMaxNr *int32 `json:"fsAioMaxNr,omitempty"`
	// FsNrOpen - Sysctl setting fs.nr_open.
	FsNrOpen *int32 `json:"fsNrOpen,omitempty"`
	// KernelThreadsMax - Sysctl setting kernel.threads-max.
	KernelThreadsMax *int32 `json:"kernelThreadsMax,omitempty"`
	// VMMaxMapCount - Sysctl setting vm.max_map_count.
	VMMaxMapCount *int32 `json:"vmMaxMapCount,omitempty"`
	// VMSwappiness - Sysctl setting vm.swappiness.
	VMSwappiness *int32 `json:"vmSwappiness,omitempty"`
	// VMVfsCachePressure - Sysctl setting vm.vfs_cache_pressure.
	VMVfsCachePressure *int32 `json:"vmVfsCachePressure,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TagsObject tags object for patch operations.
type TagsObject struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsObject.
func (toVar TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if toVar.Tags != nil {
		objectMap["tags"] = toVar.Tags
	}
	return json.Marshal(objectMap)
}

// TimeInWeek time in a week.
type TimeInWeek struct {
	// Day - The day of the week. Possible values include: 'WeekDaySunday', 'WeekDayMonday', 'WeekDayTuesday', 'WeekDayWednesday', 'WeekDayThursday', 'WeekDayFriday', 'WeekDaySaturday'
	Day WeekDay `json:"day,omitempty"`
	// HourSlots - Each integer hour represents a time range beginning at 0m after the hour ending at the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means the 00:00 - 02:00 UTC time range.
	HourSlots *[]int32 `json:"hourSlots,omitempty"`
}

// TimeSpan for example, between 2021-05-25T13:00:00Z and 2021-05-25T14:00:00Z.
type TimeSpan struct {
	// Start - The start of a time span
	Start *date.Time `json:"start,omitempty"`
	// End - The end of a time span
	End *date.Time `json:"end,omitempty"`
}

// UserAssignedIdentity details about a user assigned identity.
type UserAssignedIdentity struct {
	// ResourceID - The resource ID of the user assigned identity.
	ResourceID *string `json:"resourceId,omitempty"`
	// ClientID - The client ID of the user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
	// ObjectID - The object ID of the user assigned identity.
	ObjectID *string `json:"objectId,omitempty"`
}

// VMDiagnostics profile for diagnostics on the container service VMs.
type VMDiagnostics struct {
	// Enabled - Whether the VM diagnostic agent is provisioned on the VM.
	Enabled *bool `json:"enabled,omitempty"`
	// StorageURI - READ-ONLY; The URI of the storage account where diagnostics are stored.
	StorageURI *string `json:"storageUri,omitempty"`
}

// MarshalJSON is the custom marshaler for VMDiagnostics.
func (vd VMDiagnostics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vd.Enabled != nil {
		objectMap["enabled"] = vd.Enabled
	}
	return json.Marshal(objectMap)
}

// WindowsGmsaProfile windows gMSA Profile in the managed cluster.
type WindowsGmsaProfile struct {
	// Enabled - Specifies whether to enable Windows gMSA in the managed cluster.
	Enabled *bool `json:"enabled,omitempty"`
	// DNSServer - Specifies the DNS server for Windows gMSA. <br><br> Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
	DNSServer *string `json:"dnsServer,omitempty"`
	// RootDomainName - Specifies the root domain name for Windows gMSA. <br><br> Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
	RootDomainName *string `json:"rootDomainName,omitempty"`
}
