/* taquin-view.c generated by valac 0.40.0.6-2c488, the Vala compiler
 * generated from taquin-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2014-2016 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of Taquin.
 *
 * Taquin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Taquin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Taquin. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_TAQUIN_VIEW (taquin_view_get_type ())
#define TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAQUIN_VIEW, TaquinView))
#define TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAQUIN_VIEW, TaquinViewClass))
#define IS_TAQUIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAQUIN_VIEW))
#define IS_TAQUIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAQUIN_VIEW))
#define TAQUIN_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAQUIN_VIEW, TaquinViewClass))

typedef struct _TaquinView TaquinView;
typedef struct _TaquinViewClass TaquinViewClass;
typedef struct _TaquinViewPrivate TaquinViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
enum  {
	TAQUIN_VIEW_0_PROPERTY,
	TAQUIN_VIEW_GAME_PROPERTY,
	TAQUIN_VIEW_THEME_PROPERTY,
	TAQUIN_VIEW_NUM_PROPERTIES
};
static GParamSpec* taquin_view_properties[TAQUIN_VIEW_NUM_PROPERTIES];
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_GAME_TYPE (game_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	DIRECTION_TOP,
	DIRECTION_LEFT,
	DIRECTION_RIGHT,
	DIRECTION_BOTTOM,
	DIRECTION_NONE
} Direction;

struct _TaquinView {
	GtkDrawingArea parent_instance;
	TaquinViewPrivate * priv;
};

struct _TaquinViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _TaquinViewPrivate {
	gint grid_border_main;
	gint grid_border_thin;
	gint arrows;
	gint tile_size;
	gint board_size;
	gint x_arrow;
	gint y_arrow;
	gboolean draw_lights;
	gint render_size;
	cairo_pattern_t* tiles_pattern;
	gboolean animate;
	gint animation_offset;
	gboolean x_axis;
	gint number;
	gint x_gap;
	gint y_gap;
	gboolean animate_end;
	gboolean finished;
	gdouble animation_end_offset;
	Game* _game;
	gchar* _theme;
};

typedef enum  {
	GAME_TYPE_FIFTEEN,
	GAME_TYPE_SIXTEEN
} GameType;


static gpointer taquin_view_parent_class = NULL;

GType direction_get_type (void) G_GNUC_CONST;
GType taquin_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define TAQUIN_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TAQUIN_VIEW, TaquinViewPrivate))
#define TAQUIN_VIEW_GRID_SPACING 1
static void taquin_view_calculate (TaquinView* self);
Game* taquin_view_get_game (TaquinView* self);
gint game_get_size (Game* self);
TaquinView* taquin_view_new (void);
TaquinView* taquin_view_construct (GType object_type);
static gboolean taquin_view_real_draw (GtkWidget* base,
                                cairo_t* cr);
static void taquin_view_load_image (TaquinView* self,
                             cairo_t* c);
static gint taquin_view_get_x_offset (TaquinView* self);
static gint taquin_view_get_y_offset (TaquinView* self);
GType game_type_get_type (void) G_GNUC_CONST;
GameType game_get_game_type (Game* self);
static void taquin_view_draw_movable_lights (TaquinView* self,
                                      cairo_t* cr);
static void taquin_view_draw_fixed_arrows (TaquinView* self,
                                    cairo_t* cr);
static void taquin_view_draw_movable_arrows (TaquinView* self,
                                      cairo_t* cr);
gint* game_get_tiles (Game* self,
                      int* result_length1,
                      int* result_length2);
const gchar* taquin_view_get_theme (TaquinView* self);
static void taquin_view_draw_light (TaquinView* self,
                             cairo_t* cr,
                             gboolean horizontal);
static void taquin_view_draw_vertical_arrow (TaquinView* self,
                                      cairo_t* cr,
                                      gboolean inside,
                                      gint number);
static void taquin_view_draw_horizontal_arrow (TaquinView* self,
                                        cairo_t* cr,
                                        gboolean inside,
                                        gint number);
static void taquin_view_move_cb (TaquinView* self,
                          gboolean x_axis,
                          gint number,
                          gint x_gap,
                          gint y_gap);
static void taquin_view_complete_cb (TaquinView* self);
static gboolean __lambda4_ (TaquinView* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean taquin_view_real_button_press_event (GtkWidget* base,
                                              GdkEventButton* event);
void game_request_move (Game* self,
                        gint x,
                        gint y);
static gboolean taquin_view_real_key_press_event (GtkWidget* base,
                                           GdkEventKey* event);
void taquin_view_set_game (TaquinView* self,
                           Game* value);
static void _taquin_view_move_cb_game_move (Game* _sender,
                                     gboolean x_axis,
                                     gint number,
                                     gint x_gap,
                                     gint y_gap,
                                     gpointer self);
static void _taquin_view_complete_cb_game_complete (Game* _sender,
                                             gpointer self);
void taquin_view_set_theme (TaquinView* self,
                            const gchar* value);
static void taquin_view_finalize (GObject * obj);
static void _vala_taquin_view_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_taquin_view_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);


GType
direction_get_type (void)
{
	static volatile gsize direction_type_id__volatile = 0;
	if (g_once_init_enter (&direction_type_id__volatile)) {
		static const GEnumValue values[] = {{DIRECTION_TOP, "DIRECTION_TOP", "top"}, {DIRECTION_LEFT, "DIRECTION_LEFT", "left"}, {DIRECTION_RIGHT, "DIRECTION_RIGHT", "right"}, {DIRECTION_BOTTOM, "DIRECTION_BOTTOM", "bottom"}, {DIRECTION_NONE, "DIRECTION_NONE", "none"}, {0, NULL, NULL}};
		GType direction_type_id;
		direction_type_id = g_enum_register_static ("Direction", values);
		g_once_init_leave (&direction_type_id__volatile, direction_type_id);
	}
	return direction_type_id__volatile;
}


static void
taquin_view_calculate (TaquinView* self)
{
	gint size = 0;
	Game* _tmp0_;
	Game* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	Game* _tmp5_;
	Game* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	size = MIN (gtk_widget_get_allocated_width ((GtkWidget*) self), gtk_widget_get_allocated_height ((GtkWidget*) self));
	_tmp0_ = taquin_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->tile_size = ((size * 10) / 12) / _tmp3_;
	_tmp4_ = self->priv->tile_size;
	_tmp5_ = taquin_view_get_game (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = game_get_size (_tmp6_);
	_tmp8_ = _tmp7_;
	self->priv->board_size = (_tmp4_ * _tmp8_) - TAQUIN_VIEW_GRID_SPACING;
	_tmp9_ = self->priv->board_size;
	self->priv->grid_border_main = (size - _tmp9_) / 2;
	self->priv->arrows = size / 100;
}


TaquinView*
taquin_view_construct (GType object_type)
{
	TaquinView * self = NULL;
	self = (TaquinView*) g_object_new (object_type, NULL);
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_KEY_PRESS_MASK));
	gtk_widget_set_size_request ((GtkWidget*) self, 350, 350);
	return self;
}


TaquinView*
taquin_view_new (void)
{
	return taquin_view_construct (TYPE_TAQUIN_VIEW);
}


static gboolean
taquin_view_real_draw (GtkWidget* base,
                       cairo_t* cr)
{
	TaquinView * self;
	gboolean result = FALSE;
	Game* _tmp0_;
	Game* _tmp1_;
	gboolean _tmp2_ = FALSE;
	cairo_pattern_t* _tmp3_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	gdouble _tmp52_;
	gint _tmp53_;
	Game* _tmp54_;
	Game* _tmp55_;
	GameType _tmp56_;
	GameType _tmp57_;
	gint _tmp59_;
	gint _tmp60_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_;
	gboolean _tmp256_;
	gboolean _tmp263_;
	self = (TaquinView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = taquin_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	taquin_view_calculate (self);
	_tmp3_ = self->priv->tiles_pattern;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = self->priv->render_size;
		_tmp5_ = self->priv->tile_size;
		_tmp2_ = _tmp4_ != _tmp5_;
	}
	if (_tmp2_) {
		gint _tmp6_;
		cairo_surface_t* surface = NULL;
		cairo_surface_t* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		cairo_surface_t* _tmp10_;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp11_;
		cairo_t* _tmp12_;
		cairo_t* _tmp13_;
		cairo_surface_t* _tmp14_;
		cairo_pattern_t* _tmp15_;
		_tmp6_ = self->priv->tile_size;
		self->priv->render_size = _tmp6_;
		_tmp7_ = cairo_get_target (cr);
		_tmp8_ = self->priv->board_size;
		_tmp9_ = self->priv->board_size;
		_tmp10_ = cairo_surface_create_similar (_tmp7_, CAIRO_CONTENT_COLOR_ALPHA, _tmp8_, _tmp9_);
		surface = _tmp10_;
		_tmp11_ = surface;
		_tmp12_ = cairo_create (_tmp11_);
		c = _tmp12_;
		_tmp13_ = c;
		taquin_view_load_image (self, _tmp13_);
		_tmp14_ = surface;
		_tmp15_ = cairo_pattern_create_for_surface (_tmp14_);
		_cairo_pattern_destroy0 (self->priv->tiles_pattern);
		self->priv->tiles_pattern = _tmp15_;
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (surface);
	}
	_tmp16_ = taquin_view_get_x_offset (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = taquin_view_get_y_offset (self);
	_tmp19_ = _tmp18_;
	cairo_translate (cr, (gdouble) _tmp17_, (gdouble) _tmp19_);
	cairo_set_line_cap (cr, CAIRO_LINE_CAP_ROUND);
	cairo_set_line_join (cr, CAIRO_LINE_JOIN_ROUND);
	cairo_set_source_rgb (cr, 0.8, 0.8, 0.8);
	_tmp20_ = self->priv->grid_border_main;
	_tmp21_ = self->priv->grid_border_main;
	_tmp22_ = self->priv->board_size;
	_tmp23_ = self->priv->grid_border_main;
	_tmp24_ = self->priv->board_size;
	_tmp25_ = self->priv->grid_border_main;
	cairo_rectangle (cr, _tmp20_ / 2.0, _tmp21_ / 2.0, (gdouble) (_tmp22_ + _tmp23_), (gdouble) (_tmp24_ + _tmp25_));
	cairo_fill_preserve (cr);
	cairo_set_source_rgb (cr, 0.3, 0.3, 0.3);
	_tmp26_ = self->priv->grid_border_main;
	cairo_set_line_width (cr, (gdouble) _tmp26_);
	cairo_stroke (cr);
	cairo_set_source_rgb (cr, 0.1, 0.1, 0.1);
	_tmp27_ = self->priv->grid_border_thin;
	cairo_set_line_width (cr, (gdouble) _tmp27_);
	_tmp28_ = self->priv->grid_border_main;
	_tmp29_ = self->priv->grid_border_main;
	_tmp30_ = self->priv->grid_border_main;
	_tmp31_ = self->priv->grid_border_thin;
	cairo_arc (cr, _tmp28_ / 2.0, _tmp29_ / 2.0, (_tmp30_ - _tmp31_) / 2.0, G_PI, (G_PI * 3) / 2.0);
	_tmp32_ = self->priv->grid_border_main;
	_tmp33_ = self->priv->board_size;
	_tmp34_ = self->priv->grid_border_main;
	_tmp35_ = self->priv->grid_border_main;
	_tmp36_ = self->priv->grid_border_thin;
	cairo_arc (cr, ((_tmp32_ * 3) / 2.0) + _tmp33_, _tmp34_ / 2.0, (_tmp35_ - _tmp36_) / 2.0, (G_PI * 3) / 2.0, (gdouble) 0);
	_tmp37_ = self->priv->grid_border_main;
	_tmp38_ = self->priv->board_size;
	_tmp39_ = self->priv->grid_border_main;
	_tmp40_ = self->priv->board_size;
	_tmp41_ = self->priv->grid_border_main;
	_tmp42_ = self->priv->grid_border_thin;
	cairo_arc (cr, ((_tmp37_ * 3) / 2.0) + _tmp38_, ((_tmp39_ * 3) / 2.0) + _tmp40_, (_tmp41_ - _tmp42_) / 2.0, (gdouble) 0, G_PI / 2.0);
	_tmp43_ = self->priv->grid_border_main;
	_tmp44_ = self->priv->grid_border_main;
	_tmp45_ = self->priv->board_size;
	_tmp46_ = self->priv->grid_border_main;
	_tmp47_ = self->priv->grid_border_thin;
	cairo_arc (cr, _tmp43_ / 2.0, ((_tmp44_ * 3) / 2.0) + _tmp45_, (_tmp46_ - _tmp47_) / 2.0, G_PI / 2.0, G_PI);
	_tmp48_ = self->priv->grid_border_main;
	_tmp49_ = self->priv->grid_border_main;
	_tmp50_ = self->priv->grid_border_main;
	_tmp51_ = self->priv->grid_border_thin;
	cairo_arc (cr, _tmp48_ / 2.0, _tmp49_ / 2.0, (_tmp50_ - _tmp51_) / 2.0, G_PI, (G_PI * 3) / 2.0);
	cairo_stroke (cr);
	_tmp52_ = self->priv->animation_end_offset;
	cairo_set_source_rgba (cr, 0.25, 0.25, 0.25, 1.0 - _tmp52_);
	_tmp53_ = self->priv->arrows;
	cairo_set_line_width (cr, (gdouble) _tmp53_);
	_tmp54_ = taquin_view_get_game (self);
	_tmp55_ = _tmp54_;
	_tmp56_ = game_get_game_type (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp57_ == GAME_TYPE_SIXTEEN) {
		gboolean _tmp58_;
		_tmp58_ = self->priv->draw_lights;
		if (_tmp58_) {
			taquin_view_draw_movable_lights (self, cr);
		}
		taquin_view_draw_fixed_arrows (self, cr);
	} else {
		taquin_view_draw_movable_arrows (self, cr);
	}
	cairo_stroke (cr);
	cairo_save (cr);
	_tmp59_ = self->priv->grid_border_main;
	_tmp60_ = self->priv->grid_border_main;
	cairo_translate (cr, (gdouble) _tmp59_, (gdouble) _tmp60_);
	_tmp62_ = self->priv->animate;
	if (_tmp62_) {
		Game* _tmp63_;
		Game* _tmp64_;
		GameType _tmp65_;
		GameType _tmp66_;
		_tmp63_ = taquin_view_get_game (self);
		_tmp64_ = _tmp63_;
		_tmp65_ = game_get_game_type (_tmp64_);
		_tmp66_ = _tmp65_;
		_tmp61_ = _tmp66_ == GAME_TYPE_SIXTEEN;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		gint texture_x = 0;
		Game* _tmp67_;
		Game* _tmp68_;
		gint* _tmp69_;
		gint _tmp69__length1;
		gint _tmp69__length2;
		gint* _tmp70_;
		gint _tmp70__length1;
		gint _tmp70__length2;
		gint _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		Game* _tmp74_;
		Game* _tmp75_;
		gint _tmp76_;
		gint _tmp77_;
		gint _tmp78_;
		gint texture_y = 0;
		Game* _tmp79_;
		Game* _tmp80_;
		gint* _tmp81_;
		gint _tmp81__length1;
		gint _tmp81__length2;
		gint* _tmp82_;
		gint _tmp82__length1;
		gint _tmp82__length2;
		gint _tmp83_;
		gint _tmp84_;
		gint _tmp85_;
		Game* _tmp86_;
		Game* _tmp87_;
		gint _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		gint tile_x = 0;
		gint _tmp91_;
		gint _tmp92_;
		gint tile_y = 0;
		gint _tmp93_;
		gint _tmp94_;
		cairo_matrix_t matrix = {0};
		gint _tmp95_;
		gint _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		cairo_pattern_t* _tmp99_;
		cairo_matrix_t _tmp100_;
		cairo_pattern_t* _tmp101_;
		gint _tmp102_;
		gint _tmp103_;
		gint _tmp104_;
		gint _tmp105_;
		gint _tmp106_ = 0;
		gboolean _tmp107_;
		gint _tmp115_;
		gint _tmp116_ = 0;
		gboolean _tmp117_;
		gint _tmp125_;
		gint _tmp126_;
		gint _tmp127_;
		gint _tmp128_;
		gint _tmp129_;
		cairo_pattern_t* _tmp130_;
		cairo_matrix_t _tmp131_;
		cairo_pattern_t* _tmp132_;
		gint _tmp133_;
		gint _tmp134_;
		gint _tmp135_;
		gint _tmp136_;
		_tmp67_ = taquin_view_get_game (self);
		_tmp68_ = _tmp67_;
		_tmp69_ = game_get_tiles (_tmp68_, &_tmp69__length1, &_tmp69__length2);
		_tmp70_ = _tmp69_;
		_tmp70__length1 = _tmp69__length1;
		_tmp70__length2 = _tmp69__length2;
		_tmp71_ = self->priv->x_gap;
		_tmp72_ = self->priv->y_gap;
		_tmp73_ = _tmp70_[(_tmp71_ * _tmp70__length2) + _tmp72_];
		_tmp74_ = taquin_view_get_game (self);
		_tmp75_ = _tmp74_;
		_tmp76_ = game_get_size (_tmp75_);
		_tmp77_ = _tmp76_;
		_tmp78_ = self->priv->tile_size;
		texture_x = (_tmp73_ % _tmp77_) * _tmp78_;
		_tmp79_ = taquin_view_get_game (self);
		_tmp80_ = _tmp79_;
		_tmp81_ = game_get_tiles (_tmp80_, &_tmp81__length1, &_tmp81__length2);
		_tmp82_ = _tmp81_;
		_tmp82__length1 = _tmp81__length1;
		_tmp82__length2 = _tmp81__length2;
		_tmp83_ = self->priv->x_gap;
		_tmp84_ = self->priv->y_gap;
		_tmp85_ = _tmp82_[(_tmp83_ * _tmp82__length2) + _tmp84_];
		_tmp86_ = taquin_view_get_game (self);
		_tmp87_ = _tmp86_;
		_tmp88_ = game_get_size (_tmp87_);
		_tmp89_ = _tmp88_;
		_tmp90_ = self->priv->tile_size;
		texture_y = (_tmp85_ / _tmp89_) * _tmp90_;
		_tmp91_ = self->priv->x_gap;
		_tmp92_ = self->priv->tile_size;
		tile_x = _tmp91_ * _tmp92_;
		_tmp93_ = self->priv->y_gap;
		_tmp94_ = self->priv->tile_size;
		tile_y = _tmp93_ * _tmp94_;
		cairo_matrix_init_identity (&matrix);
		_tmp95_ = texture_x;
		_tmp96_ = tile_x;
		_tmp97_ = texture_y;
		_tmp98_ = tile_y;
		cairo_matrix_translate (&matrix, (gdouble) (_tmp95_ - _tmp96_), (gdouble) (_tmp97_ - _tmp98_));
		_tmp99_ = self->priv->tiles_pattern;
		_tmp100_ = matrix;
		cairo_pattern_set_matrix (_tmp99_, &_tmp100_);
		_tmp101_ = self->priv->tiles_pattern;
		cairo_set_source (cr, _tmp101_);
		_tmp102_ = tile_x;
		_tmp103_ = tile_y;
		_tmp104_ = self->priv->tile_size;
		_tmp105_ = self->priv->tile_size;
		cairo_rectangle (cr, (gdouble) _tmp102_, (gdouble) _tmp103_, (gdouble) (_tmp104_ - TAQUIN_VIEW_GRID_SPACING), (gdouble) (_tmp105_ - TAQUIN_VIEW_GRID_SPACING));
		cairo_fill (cr);
		_tmp107_ = self->priv->x_axis;
		if (_tmp107_) {
			gint _tmp108_ = 0;
			gint _tmp109_;
			_tmp109_ = self->priv->x_gap;
			if (_tmp109_ == 0) {
				Game* _tmp110_;
				Game* _tmp111_;
				gint _tmp112_;
				gint _tmp113_;
				_tmp110_ = taquin_view_get_game (self);
				_tmp111_ = _tmp110_;
				_tmp112_ = game_get_size (_tmp111_);
				_tmp113_ = _tmp112_;
				_tmp108_ = _tmp113_ - 1;
			} else {
				_tmp108_ = 0;
			}
			_tmp106_ = _tmp108_;
		} else {
			gint _tmp114_;
			_tmp114_ = self->priv->x_gap;
			_tmp106_ = _tmp114_;
		}
		_tmp115_ = self->priv->tile_size;
		tile_x = _tmp115_ * _tmp106_;
		_tmp117_ = self->priv->x_axis;
		if (_tmp117_) {
			gint _tmp118_;
			_tmp118_ = self->priv->y_gap;
			_tmp116_ = _tmp118_;
		} else {
			gint _tmp119_ = 0;
			gint _tmp120_;
			_tmp120_ = self->priv->y_gap;
			if (_tmp120_ == 0) {
				Game* _tmp121_;
				Game* _tmp122_;
				gint _tmp123_;
				gint _tmp124_;
				_tmp121_ = taquin_view_get_game (self);
				_tmp122_ = _tmp121_;
				_tmp123_ = game_get_size (_tmp122_);
				_tmp124_ = _tmp123_;
				_tmp119_ = _tmp124_ - 1;
			} else {
				_tmp119_ = 0;
			}
			_tmp116_ = _tmp119_;
		}
		_tmp125_ = self->priv->tile_size;
		tile_y = _tmp125_ * _tmp116_;
		cairo_matrix_init_identity (&matrix);
		_tmp126_ = texture_x;
		_tmp127_ = tile_x;
		_tmp128_ = texture_y;
		_tmp129_ = tile_y;
		cairo_matrix_translate (&matrix, (gdouble) (_tmp126_ - _tmp127_), (gdouble) (_tmp128_ - _tmp129_));
		_tmp130_ = self->priv->tiles_pattern;
		_tmp131_ = matrix;
		cairo_pattern_set_matrix (_tmp130_, &_tmp131_);
		_tmp132_ = self->priv->tiles_pattern;
		cairo_set_source (cr, _tmp132_);
		_tmp133_ = tile_x;
		_tmp134_ = tile_y;
		_tmp135_ = self->priv->tile_size;
		_tmp136_ = self->priv->tile_size;
		cairo_rectangle (cr, (gdouble) _tmp133_, (gdouble) _tmp134_, (gdouble) (_tmp135_ - TAQUIN_VIEW_GRID_SPACING), (gdouble) (_tmp136_ - TAQUIN_VIEW_GRID_SPACING));
		cairo_fill (cr);
	}
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp137_ = FALSE;
			_tmp137_ = TRUE;
			while (TRUE) {
				gint _tmp139_;
				Game* _tmp140_;
				Game* _tmp141_;
				gint _tmp142_;
				gint _tmp143_;
				if (!_tmp137_) {
					gint _tmp138_;
					_tmp138_ = y;
					y = _tmp138_ + 1;
				}
				_tmp137_ = FALSE;
				_tmp139_ = y;
				_tmp140_ = taquin_view_get_game (self);
				_tmp141_ = _tmp140_;
				_tmp142_ = game_get_size (_tmp141_);
				_tmp143_ = _tmp142_;
				if (!(_tmp139_ < _tmp143_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp144_ = FALSE;
						_tmp144_ = TRUE;
						while (TRUE) {
							gint _tmp146_;
							Game* _tmp147_;
							Game* _tmp148_;
							gint _tmp149_;
							gint _tmp150_;
							gboolean _tmp151_ = FALSE;
							gboolean _tmp152_ = FALSE;
							gboolean _tmp153_;
							gint tile_x = 0;
							gint _tmp158_;
							gint _tmp159_;
							gint tile_y = 0;
							gint _tmp160_;
							gint _tmp161_;
							gboolean _tmp162_ = FALSE;
							gboolean _tmp163_;
							gint texture_x = 0;
							Game* _tmp221_;
							Game* _tmp222_;
							gint* _tmp223_;
							gint _tmp223__length1;
							gint _tmp223__length2;
							gint* _tmp224_;
							gint _tmp224__length1;
							gint _tmp224__length2;
							gint _tmp225_;
							gint _tmp226_;
							gint _tmp227_;
							Game* _tmp228_;
							Game* _tmp229_;
							gint _tmp230_;
							gint _tmp231_;
							gint _tmp232_;
							gint texture_y = 0;
							Game* _tmp233_;
							Game* _tmp234_;
							gint* _tmp235_;
							gint _tmp235__length1;
							gint _tmp235__length2;
							gint* _tmp236_;
							gint _tmp236__length1;
							gint _tmp236__length2;
							gint _tmp237_;
							gint _tmp238_;
							gint _tmp239_;
							Game* _tmp240_;
							Game* _tmp241_;
							gint _tmp242_;
							gint _tmp243_;
							gint _tmp244_;
							cairo_matrix_t matrix = {0};
							gint _tmp245_;
							gint _tmp246_;
							gint _tmp247_;
							gint _tmp248_;
							cairo_pattern_t* _tmp249_;
							cairo_matrix_t _tmp250_;
							cairo_pattern_t* _tmp251_;
							gint _tmp252_;
							gint _tmp253_;
							gint _tmp254_;
							gint _tmp255_;
							if (!_tmp144_) {
								gint _tmp145_;
								_tmp145_ = x;
								x = _tmp145_ + 1;
							}
							_tmp144_ = FALSE;
							_tmp146_ = x;
							_tmp147_ = taquin_view_get_game (self);
							_tmp148_ = _tmp147_;
							_tmp149_ = game_get_size (_tmp148_);
							_tmp150_ = _tmp149_;
							if (!(_tmp146_ < _tmp150_)) {
								break;
							}
							_tmp153_ = self->priv->animate;
							if (_tmp153_) {
								gint _tmp154_;
								gint _tmp155_;
								_tmp154_ = x;
								_tmp155_ = self->priv->x_gap;
								_tmp152_ = _tmp154_ == _tmp155_;
							} else {
								_tmp152_ = FALSE;
							}
							if (_tmp152_) {
								gint _tmp156_;
								gint _tmp157_;
								_tmp156_ = y;
								_tmp157_ = self->priv->y_gap;
								_tmp151_ = _tmp156_ == _tmp157_;
							} else {
								_tmp151_ = FALSE;
							}
							if (_tmp151_) {
								continue;
							}
							_tmp158_ = x;
							_tmp159_ = self->priv->tile_size;
							tile_x = _tmp158_ * _tmp159_;
							_tmp160_ = y;
							_tmp161_ = self->priv->tile_size;
							tile_y = _tmp160_ * _tmp161_;
							_tmp163_ = self->priv->animate;
							if (_tmp163_) {
								gboolean _tmp164_ = FALSE;
								gint _tmp165_;
								gint _tmp166_;
								_tmp165_ = x;
								_tmp166_ = self->priv->x_gap;
								if (_tmp165_ != _tmp166_) {
									_tmp164_ = TRUE;
								} else {
									gint _tmp167_;
									gint _tmp168_;
									_tmp167_ = y;
									_tmp168_ = self->priv->y_gap;
									_tmp164_ = _tmp167_ != _tmp168_;
								}
								_tmp162_ = _tmp164_;
							} else {
								_tmp162_ = FALSE;
							}
							if (_tmp162_) {
								gboolean _tmp169_ = FALSE;
								gboolean _tmp170_;
								_tmp170_ = self->priv->x_axis;
								if (_tmp170_) {
									gint _tmp171_;
									gint _tmp172_;
									_tmp171_ = y;
									_tmp172_ = self->priv->y_gap;
									_tmp169_ = _tmp171_ == _tmp172_;
								} else {
									_tmp169_ = FALSE;
								}
								if (_tmp169_) {
									gboolean _tmp173_ = FALSE;
									gboolean _tmp174_ = FALSE;
									gint _tmp175_;
									_tmp175_ = self->priv->number;
									if (_tmp175_ > 0) {
										gint _tmp176_;
										gint _tmp177_;
										gint _tmp178_;
										_tmp176_ = x;
										_tmp177_ = self->priv->x_gap;
										_tmp178_ = self->priv->number;
										_tmp174_ = _tmp176_ <= (_tmp177_ + _tmp178_);
									} else {
										_tmp174_ = FALSE;
									}
									if (_tmp174_) {
										gint _tmp179_;
										gint _tmp180_;
										_tmp179_ = x;
										_tmp180_ = self->priv->x_gap;
										_tmp173_ = _tmp179_ >= _tmp180_;
									} else {
										_tmp173_ = FALSE;
									}
									if (_tmp173_) {
										gint _tmp181_;
										gint _tmp182_;
										gint _tmp183_;
										_tmp181_ = tile_x;
										_tmp182_ = self->priv->tile_size;
										_tmp183_ = self->priv->animation_offset;
										tile_x = _tmp181_ - (_tmp182_ - _tmp183_);
									} else {
										gboolean _tmp184_ = FALSE;
										gboolean _tmp185_ = FALSE;
										gint _tmp186_;
										_tmp186_ = self->priv->number;
										if (_tmp186_ < 0) {
											gint _tmp187_;
											gint _tmp188_;
											gint _tmp189_;
											_tmp187_ = x;
											_tmp188_ = self->priv->x_gap;
											_tmp189_ = self->priv->number;
											_tmp185_ = _tmp187_ >= (_tmp188_ + _tmp189_);
										} else {
											_tmp185_ = FALSE;
										}
										if (_tmp185_) {
											gint _tmp190_;
											gint _tmp191_;
											_tmp190_ = x;
											_tmp191_ = self->priv->x_gap;
											_tmp184_ = _tmp190_ <= _tmp191_;
										} else {
											_tmp184_ = FALSE;
										}
										if (_tmp184_) {
											gint _tmp192_;
											gint _tmp193_;
											gint _tmp194_;
											_tmp192_ = tile_x;
											_tmp193_ = self->priv->tile_size;
											_tmp194_ = self->priv->animation_offset;
											tile_x = _tmp192_ + (_tmp193_ - _tmp194_);
										}
									}
								} else {
									gboolean _tmp195_ = FALSE;
									gboolean _tmp196_;
									_tmp196_ = self->priv->x_axis;
									if (!_tmp196_) {
										gint _tmp197_;
										gint _tmp198_;
										_tmp197_ = x;
										_tmp198_ = self->priv->x_gap;
										_tmp195_ = _tmp197_ == _tmp198_;
									} else {
										_tmp195_ = FALSE;
									}
									if (_tmp195_) {
										gboolean _tmp199_ = FALSE;
										gboolean _tmp200_ = FALSE;
										gint _tmp201_;
										_tmp201_ = self->priv->number;
										if (_tmp201_ > 0) {
											gint _tmp202_;
											gint _tmp203_;
											gint _tmp204_;
											_tmp202_ = y;
											_tmp203_ = self->priv->y_gap;
											_tmp204_ = self->priv->number;
											_tmp200_ = _tmp202_ <= (_tmp203_ + _tmp204_);
										} else {
											_tmp200_ = FALSE;
										}
										if (_tmp200_) {
											gint _tmp205_;
											gint _tmp206_;
											_tmp205_ = y;
											_tmp206_ = self->priv->y_gap;
											_tmp199_ = _tmp205_ >= _tmp206_;
										} else {
											_tmp199_ = FALSE;
										}
										if (_tmp199_) {
											gint _tmp207_;
											gint _tmp208_;
											gint _tmp209_;
											_tmp207_ = tile_y;
											_tmp208_ = self->priv->tile_size;
											_tmp209_ = self->priv->animation_offset;
											tile_y = _tmp207_ - (_tmp208_ - _tmp209_);
										} else {
											gboolean _tmp210_ = FALSE;
											gboolean _tmp211_ = FALSE;
											gint _tmp212_;
											_tmp212_ = self->priv->number;
											if (_tmp212_ < 0) {
												gint _tmp213_;
												gint _tmp214_;
												gint _tmp215_;
												_tmp213_ = y;
												_tmp214_ = self->priv->y_gap;
												_tmp215_ = self->priv->number;
												_tmp211_ = _tmp213_ >= (_tmp214_ + _tmp215_);
											} else {
												_tmp211_ = FALSE;
											}
											if (_tmp211_) {
												gint _tmp216_;
												gint _tmp217_;
												_tmp216_ = y;
												_tmp217_ = self->priv->y_gap;
												_tmp210_ = _tmp216_ <= _tmp217_;
											} else {
												_tmp210_ = FALSE;
											}
											if (_tmp210_) {
												gint _tmp218_;
												gint _tmp219_;
												gint _tmp220_;
												_tmp218_ = tile_y;
												_tmp219_ = self->priv->tile_size;
												_tmp220_ = self->priv->animation_offset;
												tile_y = _tmp218_ + (_tmp219_ - _tmp220_);
											}
										}
									}
								}
							}
							_tmp221_ = taquin_view_get_game (self);
							_tmp222_ = _tmp221_;
							_tmp223_ = game_get_tiles (_tmp222_, &_tmp223__length1, &_tmp223__length2);
							_tmp224_ = _tmp223_;
							_tmp224__length1 = _tmp223__length1;
							_tmp224__length2 = _tmp223__length2;
							_tmp225_ = x;
							_tmp226_ = y;
							_tmp227_ = _tmp224_[(_tmp225_ * _tmp224__length2) + _tmp226_];
							_tmp228_ = taquin_view_get_game (self);
							_tmp229_ = _tmp228_;
							_tmp230_ = game_get_size (_tmp229_);
							_tmp231_ = _tmp230_;
							_tmp232_ = self->priv->tile_size;
							texture_x = (_tmp227_ % _tmp231_) * _tmp232_;
							_tmp233_ = taquin_view_get_game (self);
							_tmp234_ = _tmp233_;
							_tmp235_ = game_get_tiles (_tmp234_, &_tmp235__length1, &_tmp235__length2);
							_tmp236_ = _tmp235_;
							_tmp236__length1 = _tmp235__length1;
							_tmp236__length2 = _tmp235__length2;
							_tmp237_ = x;
							_tmp238_ = y;
							_tmp239_ = _tmp236_[(_tmp237_ * _tmp236__length2) + _tmp238_];
							_tmp240_ = taquin_view_get_game (self);
							_tmp241_ = _tmp240_;
							_tmp242_ = game_get_size (_tmp241_);
							_tmp243_ = _tmp242_;
							_tmp244_ = self->priv->tile_size;
							texture_y = (_tmp239_ / _tmp243_) * _tmp244_;
							cairo_matrix_init_identity (&matrix);
							_tmp245_ = texture_x;
							_tmp246_ = tile_x;
							_tmp247_ = texture_y;
							_tmp248_ = tile_y;
							cairo_matrix_translate (&matrix, (gdouble) (_tmp245_ - _tmp246_), (gdouble) (_tmp247_ - _tmp248_));
							_tmp249_ = self->priv->tiles_pattern;
							_tmp250_ = matrix;
							cairo_pattern_set_matrix (_tmp249_, &_tmp250_);
							_tmp251_ = self->priv->tiles_pattern;
							cairo_set_source (cr, _tmp251_);
							_tmp252_ = tile_x;
							_tmp253_ = tile_y;
							_tmp254_ = self->priv->tile_size;
							_tmp255_ = self->priv->tile_size;
							cairo_rectangle (cr, (gdouble) _tmp252_, (gdouble) _tmp253_, (gdouble) (_tmp254_ - TAQUIN_VIEW_GRID_SPACING), (gdouble) (_tmp255_ - TAQUIN_VIEW_GRID_SPACING));
							cairo_fill (cr);
						}
					}
				}
			}
		}
	}
	_tmp256_ = self->priv->animate_end;
	if (_tmp256_) {
		gdouble _tmp257_;
		gdouble _tmp258_;
		cairo_matrix_t matrix = {0};
		cairo_pattern_t* _tmp259_;
		cairo_matrix_t _tmp260_;
		gdouble _tmp261_;
		gdouble _tmp262_;
		_tmp257_ = self->priv->animation_end_offset;
		self->priv->animation_end_offset = _tmp257_ + 0.01;
		_tmp258_ = self->priv->animation_end_offset;
		if (_tmp258_ >= ((gdouble) 1)) {
			self->priv->animation_end_offset = (gdouble) 1;
		}
		cairo_matrix_init_identity (&matrix);
		_tmp259_ = self->priv->tiles_pattern;
		_tmp260_ = matrix;
		cairo_pattern_set_matrix (_tmp259_, &_tmp260_);
		_tmp261_ = self->priv->animation_end_offset;
		cairo_paint_with_alpha (cr, _tmp261_);
		_tmp262_ = self->priv->animation_end_offset;
		if (_tmp262_ != ((gdouble) 1)) {
			gtk_widget_queue_draw ((GtkWidget*) self);
		}
	}
	cairo_restore (cr);
	_tmp263_ = self->priv->animate;
	if (_tmp263_) {
		gint _tmp264_;
		gboolean _tmp265_;
		gint _tmp296_;
		gint _tmp297_;
		_tmp264_ = self->priv->animation_offset;
		self->priv->animation_offset = _tmp264_ + 8;
		_tmp265_ = self->priv->x_axis;
		if (_tmp265_) {
			gint _tmp266_;
			gint _tmp267_;
			gint _tmp268_;
			gint _tmp269_;
			gint _tmp270_;
			gint _tmp271_;
			gint _tmp272_;
			gint _tmp273_;
			gint _tmp274_;
			gint _tmp275_;
			gint _tmp276_;
			gint _tmp277_;
			gint _tmp278_;
			gint _tmp279_;
			gint _tmp280_;
			_tmp266_ = taquin_view_get_x_offset (self);
			_tmp267_ = _tmp266_;
			_tmp268_ = self->priv->grid_border_main;
			_tmp269_ = self->priv->tile_size;
			_tmp270_ = self->priv->x_gap;
			_tmp271_ = self->priv->x_gap;
			_tmp272_ = self->priv->number;
			_tmp273_ = taquin_view_get_y_offset (self);
			_tmp274_ = _tmp273_;
			_tmp275_ = self->priv->grid_border_main;
			_tmp276_ = self->priv->tile_size;
			_tmp277_ = self->priv->y_gap;
			_tmp278_ = self->priv->tile_size;
			_tmp279_ = self->priv->number;
			_tmp280_ = self->priv->tile_size;
			gtk_widget_queue_draw_area ((GtkWidget*) self, (_tmp267_ + _tmp268_) + (_tmp269_ * MIN (_tmp270_, _tmp271_ + _tmp272_)), (_tmp274_ + _tmp275_) + (_tmp276_ * _tmp277_), _tmp278_ * (abs (_tmp279_) + 1), _tmp280_);
		} else {
			gint _tmp281_;
			gint _tmp282_;
			gint _tmp283_;
			gint _tmp284_;
			gint _tmp285_;
			gint _tmp286_;
			gint _tmp287_;
			gint _tmp288_;
			gint _tmp289_;
			gint _tmp290_;
			gint _tmp291_;
			gint _tmp292_;
			gint _tmp293_;
			gint _tmp294_;
			gint _tmp295_;
			_tmp281_ = taquin_view_get_x_offset (self);
			_tmp282_ = _tmp281_;
			_tmp283_ = self->priv->grid_border_main;
			_tmp284_ = self->priv->tile_size;
			_tmp285_ = self->priv->x_gap;
			_tmp286_ = taquin_view_get_y_offset (self);
			_tmp287_ = _tmp286_;
			_tmp288_ = self->priv->grid_border_main;
			_tmp289_ = self->priv->tile_size;
			_tmp290_ = self->priv->y_gap;
			_tmp291_ = self->priv->y_gap;
			_tmp292_ = self->priv->number;
			_tmp293_ = self->priv->tile_size;
			_tmp294_ = self->priv->tile_size;
			_tmp295_ = self->priv->number;
			gtk_widget_queue_draw_area ((GtkWidget*) self, (_tmp282_ + _tmp283_) + (_tmp284_ * _tmp285_), (_tmp287_ + _tmp288_) + (_tmp289_ * MIN (_tmp290_, _tmp291_ + _tmp292_)), _tmp293_, _tmp294_ * (abs (_tmp295_) + 1));
		}
		_tmp296_ = self->priv->animation_offset;
		_tmp297_ = self->priv->tile_size;
		if (_tmp296_ > _tmp297_) {
			self->priv->animate = FALSE;
		}
	}
	result = FALSE;
	return result;
}


static void
taquin_view_load_image (TaquinView* self,
                        cairo_t* c)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	{
		GdkPixbuf* p = NULL;
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp0_ = taquin_view_get_theme (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = self->priv->board_size;
		_tmp3_ = self->priv->board_size;
		_tmp4_ = gdk_pixbuf_new_from_file_at_scale (_tmp1_, _tmp2_, _tmp3_, FALSE, &_inner_error_);
		p = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		gdk_cairo_set_source_pixbuf (c, p, (gdouble) 0, (gdouble) 0);
		cairo_paint (c);
		_g_object_unref0 (p);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = taquin_view_get_theme (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("taquin-view.vala:294: Failed to load theme %s: %s\n" \
"\n" \
"If you were trying to launch an unusual size, retry, it may work. But " \
"it probably implies that you have not an image adapted to the requeste" \
"d size in the current theme. If that's not the case, file a bug please" \
".\n", _tmp6_, _tmp8_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
taquin_view_draw_movable_lights (TaquinView* self,
                                 cairo_t* cr)
{
	gdouble _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_save (cr);
	_tmp0_ = self->priv->animation_end_offset;
	cairo_set_source_rgba (cr, 0.8, 0.8, 0.8, 0.3 - (0.3 * _tmp0_));
	cairo_save (cr);
	_tmp1_ = self->priv->grid_border_main;
	_tmp2_ = self->priv->tile_size;
	_tmp3_ = self->priv->x_arrow;
	_tmp4_ = self->priv->grid_border_main;
	_tmp5_ = self->priv->grid_border_thin;
	cairo_translate (cr, _tmp1_ + (_tmp2_ * (_tmp3_ + 0.5)), (_tmp4_ + _tmp5_) / 2.0);
	taquin_view_draw_light (self, cr, TRUE);
	_tmp6_ = self->priv->board_size;
	_tmp7_ = self->priv->grid_border_main;
	_tmp8_ = self->priv->grid_border_thin;
	cairo_translate (cr, (gdouble) 0, (gdouble) ((_tmp6_ + _tmp7_) - _tmp8_));
	taquin_view_draw_light (self, cr, TRUE);
	cairo_restore (cr);
	cairo_fill (cr);
	cairo_save (cr);
	_tmp9_ = self->priv->grid_border_main;
	_tmp10_ = self->priv->grid_border_thin;
	_tmp11_ = self->priv->grid_border_main;
	_tmp12_ = self->priv->tile_size;
	_tmp13_ = self->priv->y_arrow;
	cairo_translate (cr, (_tmp9_ + _tmp10_) / 2.0, _tmp11_ + (_tmp12_ * (_tmp13_ + 0.5)));
	taquin_view_draw_light (self, cr, FALSE);
	_tmp14_ = self->priv->board_size;
	_tmp15_ = self->priv->grid_border_main;
	_tmp16_ = self->priv->grid_border_thin;
	cairo_translate (cr, (gdouble) ((_tmp14_ + _tmp15_) - _tmp16_), (gdouble) 0);
	taquin_view_draw_light (self, cr, FALSE);
	cairo_restore (cr);
	cairo_fill (cr);
	cairo_restore (cr);
}


static void
taquin_view_draw_light (TaquinView* self,
                        cairo_t* cr,
                        gboolean horizontal)
{
	gdouble size = 0.0;
	gint _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_save (cr);
	_tmp0_ = self->priv->tile_size;
	_tmp1_ = self->priv->grid_border_main;
	size = (0.3 * _tmp0_) / _tmp1_;
	if (horizontal) {
		gdouble _tmp3_;
		_tmp3_ = size;
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = 0.3;
	}
	if (horizontal) {
		_tmp4_ = 0.3;
	} else {
		gdouble _tmp5_;
		_tmp5_ = size;
		_tmp4_ = _tmp5_;
	}
	cairo_scale (cr, _tmp2_, _tmp4_);
	_tmp6_ = self->priv->grid_border_main;
	cairo_arc (cr, 0.0, 0.0, (gdouble) _tmp6_, 0.0, 2.0 * G_PI);
	cairo_restore (cr);
}


static void
taquin_view_draw_fixed_arrows (TaquinView* self,
                               cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Game* _tmp3_;
				Game* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = taquin_view_get_game (self);
				_tmp4_ = _tmp3_;
				_tmp5_ = game_get_size (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp2_ < _tmp6_)) {
					break;
				}
				_tmp7_ = i;
				taquin_view_draw_vertical_arrow (self, cr, FALSE, _tmp7_);
				_tmp8_ = i;
				taquin_view_draw_horizontal_arrow (self, cr, FALSE, _tmp8_);
			}
		}
	}
}


static void
taquin_view_draw_movable_arrows (TaquinView* self,
                                 cairo_t* cr)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->x_arrow;
	taquin_view_draw_vertical_arrow (self, cr, TRUE, _tmp0_);
	_tmp1_ = self->priv->y_arrow;
	taquin_view_draw_horizontal_arrow (self, cr, TRUE, _tmp1_);
}


static void
taquin_view_draw_horizontal_arrow (TaquinView* self,
                                   cairo_t* cr,
                                   gboolean inside,
                                   gint number)
{
	gdouble x1 = 0.0;
	gint _tmp0_;
	gint _tmp1_;
	gdouble x2 = 0.0;
	gint _tmp2_;
	gint _tmp3_;
	gdouble _tmp4_ = 0.0;
	gint _tmp7_;
	gint _tmp8_;
	gdouble _tmp9_ = 0.0;
	gint _tmp12_;
	gint _tmp13_;
	gdouble _tmp14_ = 0.0;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gdouble _tmp25_ = 0.0;
	gint _tmp28_;
	gint _tmp29_;
	gdouble _tmp30_ = 0.0;
	gint _tmp33_;
	gint _tmp34_;
	gdouble _tmp35_ = 0.0;
	gint _tmp38_;
	gint _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->grid_border_main;
	_tmp1_ = self->priv->grid_border_thin;
	x1 = ((_tmp0_ * 1.0) / 3) + ((_tmp1_ * 2.0) / 3);
	_tmp2_ = self->priv->grid_border_main;
	_tmp3_ = self->priv->grid_border_thin;
	x2 = ((_tmp2_ * 2.0) / 3) + ((_tmp3_ * 1.0) / 3);
	if (inside) {
		gdouble _tmp5_;
		_tmp5_ = x1;
		_tmp4_ = _tmp5_;
	} else {
		gdouble _tmp6_;
		_tmp6_ = x2;
		_tmp4_ = _tmp6_;
	}
	_tmp7_ = self->priv->grid_border_main;
	_tmp8_ = self->priv->tile_size;
	cairo_move_to (cr, _tmp4_, _tmp7_ + (_tmp8_ * (number + (1.0 / 3))));
	if (inside) {
		gdouble _tmp10_;
		_tmp10_ = x2;
		_tmp9_ = _tmp10_;
	} else {
		gdouble _tmp11_;
		_tmp11_ = x1;
		_tmp9_ = _tmp11_;
	}
	_tmp12_ = self->priv->grid_border_main;
	_tmp13_ = self->priv->tile_size;
	cairo_line_to (cr, _tmp9_, _tmp12_ + (_tmp13_ * (number + (1.0 / 2))));
	if (inside) {
		gdouble _tmp15_;
		_tmp15_ = x1;
		_tmp14_ = _tmp15_;
	} else {
		gdouble _tmp16_;
		_tmp16_ = x2;
		_tmp14_ = _tmp16_;
	}
	_tmp17_ = self->priv->grid_border_main;
	_tmp18_ = self->priv->tile_size;
	cairo_line_to (cr, _tmp14_, _tmp17_ + (_tmp18_ * (number + (2.0 / 3))));
	_tmp19_ = self->priv->board_size;
	_tmp20_ = self->priv->grid_border_main;
	_tmp21_ = self->priv->grid_border_thin;
	x1 = (_tmp19_ + ((_tmp20_ * 5.0) / 3)) - ((_tmp21_ * 2.0) / 3);
	_tmp22_ = self->priv->board_size;
	_tmp23_ = self->priv->grid_border_main;
	_tmp24_ = self->priv->grid_border_thin;
	x2 = (_tmp22_ + ((_tmp23_ * 4.0) / 3)) - ((_tmp24_ * 1.0) / 3);
	if (inside) {
		gdouble _tmp26_;
		_tmp26_ = x1;
		_tmp25_ = _tmp26_;
	} else {
		gdouble _tmp27_;
		_tmp27_ = x2;
		_tmp25_ = _tmp27_;
	}
	_tmp28_ = self->priv->grid_border_main;
	_tmp29_ = self->priv->tile_size;
	cairo_move_to (cr, _tmp25_, _tmp28_ + (_tmp29_ * (number + (1.0 / 3))));
	if (inside) {
		gdouble _tmp31_;
		_tmp31_ = x2;
		_tmp30_ = _tmp31_;
	} else {
		gdouble _tmp32_;
		_tmp32_ = x1;
		_tmp30_ = _tmp32_;
	}
	_tmp33_ = self->priv->grid_border_main;
	_tmp34_ = self->priv->tile_size;
	cairo_line_to (cr, _tmp30_, _tmp33_ + (_tmp34_ * (number + (1.0 / 2))));
	if (inside) {
		gdouble _tmp36_;
		_tmp36_ = x1;
		_tmp35_ = _tmp36_;
	} else {
		gdouble _tmp37_;
		_tmp37_ = x2;
		_tmp35_ = _tmp37_;
	}
	_tmp38_ = self->priv->grid_border_main;
	_tmp39_ = self->priv->tile_size;
	cairo_line_to (cr, _tmp35_, _tmp38_ + (_tmp39_ * (number + (2.0 / 3))));
}


static void
taquin_view_draw_vertical_arrow (TaquinView* self,
                                 cairo_t* cr,
                                 gboolean inside,
                                 gint number)
{
	gdouble y1 = 0.0;
	gint _tmp0_;
	gint _tmp1_;
	gdouble y2 = 0.0;
	gint _tmp2_;
	gint _tmp3_;
	gdouble _tmp4_ = 0.0;
	gint _tmp7_;
	gint _tmp8_;
	gdouble _tmp9_ = 0.0;
	gint _tmp12_;
	gint _tmp13_;
	gdouble _tmp14_ = 0.0;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gdouble _tmp25_ = 0.0;
	gint _tmp28_;
	gint _tmp29_;
	gdouble _tmp30_ = 0.0;
	gint _tmp33_;
	gint _tmp34_;
	gdouble _tmp35_ = 0.0;
	gint _tmp38_;
	gint _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->grid_border_main;
	_tmp1_ = self->priv->grid_border_thin;
	y1 = ((_tmp0_ * 1.0) / 3) + ((_tmp1_ * 2.0) / 3);
	_tmp2_ = self->priv->grid_border_main;
	_tmp3_ = self->priv->grid_border_thin;
	y2 = ((_tmp2_ * 2.0) / 3) + ((_tmp3_ * 1.0) / 3);
	if (inside) {
		gdouble _tmp5_;
		_tmp5_ = y1;
		_tmp4_ = _tmp5_;
	} else {
		gdouble _tmp6_;
		_tmp6_ = y2;
		_tmp4_ = _tmp6_;
	}
	_tmp7_ = self->priv->grid_border_main;
	_tmp8_ = self->priv->tile_size;
	cairo_move_to (cr, _tmp7_ + (_tmp8_ * (number + (1.0 / 3))), _tmp4_);
	if (inside) {
		gdouble _tmp10_;
		_tmp10_ = y2;
		_tmp9_ = _tmp10_;
	} else {
		gdouble _tmp11_;
		_tmp11_ = y1;
		_tmp9_ = _tmp11_;
	}
	_tmp12_ = self->priv->grid_border_main;
	_tmp13_ = self->priv->tile_size;
	cairo_line_to (cr, _tmp12_ + (_tmp13_ * (number + (1.0 / 2))), _tmp9_);
	if (inside) {
		gdouble _tmp15_;
		_tmp15_ = y1;
		_tmp14_ = _tmp15_;
	} else {
		gdouble _tmp16_;
		_tmp16_ = y2;
		_tmp14_ = _tmp16_;
	}
	_tmp17_ = self->priv->grid_border_main;
	_tmp18_ = self->priv->tile_size;
	cairo_line_to (cr, _tmp17_ + (_tmp18_ * (number + (2.0 / 3))), _tmp14_);
	_tmp19_ = self->priv->board_size;
	_tmp20_ = self->priv->grid_border_main;
	_tmp21_ = self->priv->grid_border_thin;
	y1 = (_tmp19_ + ((_tmp20_ * 5.0) / 3)) - ((_tmp21_ * 2.0) / 3);
	_tmp22_ = self->priv->board_size;
	_tmp23_ = self->priv->grid_border_main;
	_tmp24_ = self->priv->grid_border_thin;
	y2 = (_tmp22_ + ((_tmp23_ * 4.0) / 3)) - ((_tmp24_ * 1.0) / 3);
	if (inside) {
		gdouble _tmp26_;
		_tmp26_ = y1;
		_tmp25_ = _tmp26_;
	} else {
		gdouble _tmp27_;
		_tmp27_ = y2;
		_tmp25_ = _tmp27_;
	}
	_tmp28_ = self->priv->grid_border_main;
	_tmp29_ = self->priv->tile_size;
	cairo_move_to (cr, _tmp28_ + (_tmp29_ * (number + (1.0 / 3))), _tmp25_);
	if (inside) {
		gdouble _tmp31_;
		_tmp31_ = y2;
		_tmp30_ = _tmp31_;
	} else {
		gdouble _tmp32_;
		_tmp32_ = y1;
		_tmp30_ = _tmp32_;
	}
	_tmp33_ = self->priv->grid_border_main;
	_tmp34_ = self->priv->tile_size;
	cairo_line_to (cr, _tmp33_ + (_tmp34_ * (number + (1.0 / 2))), _tmp30_);
	if (inside) {
		gdouble _tmp36_;
		_tmp36_ = y1;
		_tmp35_ = _tmp36_;
	} else {
		gdouble _tmp37_;
		_tmp37_ = y2;
		_tmp35_ = _tmp37_;
	}
	_tmp38_ = self->priv->grid_border_main;
	_tmp39_ = self->priv->tile_size;
	cairo_line_to (cr, _tmp38_ + (_tmp39_ * (number + (2.0 / 3))), _tmp35_);
}


static void
taquin_view_move_cb (TaquinView* self,
                     gboolean x_axis,
                     gint number,
                     gint x_gap,
                     gint y_gap)
{
	Game* _tmp0_;
	Game* _tmp1_;
	GameType _tmp2_;
	GameType _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->x_axis = x_axis;
	self->priv->number = number;
	self->priv->x_gap = x_gap;
	self->priv->y_gap = y_gap;
	_tmp0_ = taquin_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_game_type (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == GAME_TYPE_FIFTEEN) {
		self->priv->x_arrow = x_gap;
		self->priv->y_arrow = y_gap;
	}
	self->priv->animation_offset = 0;
	self->priv->animate = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static gboolean
__lambda4_ (TaquinView* self)
{
	gboolean result = FALSE;
	self->priv->animation_end_offset = (gdouble) 0;
	self->priv->animate_end = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ ((TaquinView*) self);
	return result;
}


static void
taquin_view_complete_cb (TaquinView* self)
{
	g_return_if_fail (self != NULL);
	self->priv->finished = TRUE;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
}


static gboolean
taquin_view_real_button_press_event (GtkWidget* base,
                                     GdkEventButton* event)
{
	TaquinView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_ = FALSE;
	guint _tmp4_;
	self = (TaquinView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->animate;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->animate_end;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = event->button;
	if (_tmp4_ == ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp3_ = TRUE;
	} else {
		guint _tmp5_;
		_tmp5_ = event->button;
		_tmp3_ = _tmp5_ == ((guint) GDK_BUTTON_SECONDARY);
	}
	if (_tmp3_) {
		Game* _tmp6_;
		Game* _tmp7_;
		gdouble _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gdouble _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		self->priv->draw_lights = FALSE;
		_tmp6_ = taquin_view_get_game (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = event->x;
		_tmp9_ = taquin_view_get_x_offset (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->grid_border_main;
		_tmp12_ = self->priv->tile_size;
		_tmp13_ = self->priv->tile_size;
		_tmp14_ = event->y;
		_tmp15_ = taquin_view_get_y_offset (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->grid_border_main;
		_tmp18_ = self->priv->tile_size;
		_tmp19_ = self->priv->tile_size;
		game_request_move (_tmp7_, (((gint) (((_tmp8_ - _tmp10_) - _tmp11_) + _tmp12_)) / _tmp13_) - 1, (((gint) (((_tmp14_ - _tmp16_) - _tmp17_) + _tmp18_)) / _tmp19_) - 1);
	}
	result = TRUE;
	return result;
}


static gboolean
taquin_view_real_key_press_event (GtkWidget* base,
                                  GdkEventKey* event)
{
	TaquinView * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gchar* k_name = NULL;
	guint _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	Game* _tmp5_;
	Game* _tmp6_;
	GameType _tmp7_;
	GameType _tmp8_;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp38_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	GQuark _tmp48_ = 0U;
	static GQuark _tmp47_label0 = 0;
	static GQuark _tmp47_label1 = 0;
	static GQuark _tmp47_label2 = 0;
	static GQuark _tmp47_label3 = 0;
	self = (TaquinView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->finished;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = event->keyval;
	_tmp2_ = gdk_keyval_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	k_name = _tmp3_;
	_tmp5_ = taquin_view_get_game (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = game_get_game_type (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == GAME_TYPE_SIXTEEN) {
		gboolean _tmp9_ = FALSE;
		GdkModifierType _tmp10_;
		_tmp10_ = event->state;
		if ((_tmp10_ & GDK_SHIFT_MASK) > 0) {
			_tmp9_ = TRUE;
		} else {
			GdkModifierType _tmp11_;
			_tmp11_ = event->state;
			_tmp9_ = (_tmp11_ & GDK_CONTROL_MASK) > 0;
		}
		_tmp4_ = _tmp9_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		GQuark _tmp15_ = 0U;
		static GQuark _tmp14_label0 = 0;
		static GQuark _tmp14_label1 = 0;
		static GQuark _tmp14_label2 = 0;
		static GQuark _tmp14_label3 = 0;
		_tmp12_ = k_name;
		_tmp13_ = _tmp12_;
		_tmp15_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
		if (_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("Left")))) {
			switch (0) {
				default:
				{
					Game* _tmp16_;
					Game* _tmp17_;
					gint _tmp18_;
					_tmp16_ = taquin_view_get_game (self);
					_tmp17_ = _tmp16_;
					_tmp18_ = self->priv->y_arrow;
					game_request_move (_tmp17_, -1, _tmp18_);
					break;
				}
			}
		} else if (_tmp15_ == ((0 != _tmp14_label1) ? _tmp14_label1 : (_tmp14_label1 = g_quark_from_static_string ("Right")))) {
			switch (0) {
				default:
				{
					Game* _tmp19_;
					Game* _tmp20_;
					Game* _tmp21_;
					Game* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					_tmp19_ = taquin_view_get_game (self);
					_tmp20_ = _tmp19_;
					_tmp21_ = taquin_view_get_game (self);
					_tmp22_ = _tmp21_;
					_tmp23_ = game_get_size (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = self->priv->y_arrow;
					game_request_move (_tmp20_, _tmp24_, _tmp25_);
					break;
				}
			}
		} else if (_tmp15_ == ((0 != _tmp14_label2) ? _tmp14_label2 : (_tmp14_label2 = g_quark_from_static_string ("Up")))) {
			switch (0) {
				default:
				{
					Game* _tmp26_;
					Game* _tmp27_;
					gint _tmp28_;
					_tmp26_ = taquin_view_get_game (self);
					_tmp27_ = _tmp26_;
					_tmp28_ = self->priv->x_arrow;
					game_request_move (_tmp27_, _tmp28_, -1);
					break;
				}
			}
		} else if (_tmp15_ == ((0 != _tmp14_label3) ? _tmp14_label3 : (_tmp14_label3 = g_quark_from_static_string ("Down")))) {
			switch (0) {
				default:
				{
					Game* _tmp29_;
					Game* _tmp30_;
					gint _tmp31_;
					Game* _tmp32_;
					Game* _tmp33_;
					gint _tmp34_;
					gint _tmp35_;
					_tmp29_ = taquin_view_get_game (self);
					_tmp30_ = _tmp29_;
					_tmp31_ = self->priv->x_arrow;
					_tmp32_ = taquin_view_get_game (self);
					_tmp33_ = _tmp32_;
					_tmp34_ = game_get_size (_tmp33_);
					_tmp35_ = _tmp34_;
					game_request_move (_tmp30_, _tmp31_, _tmp35_);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					result = FALSE;
					_g_free0 (k_name);
					return result;
				}
			}
		}
	}
	_tmp38_ = k_name;
	if (g_strcmp0 (_tmp38_, "space") == 0) {
		_tmp37_ = TRUE;
	} else {
		const gchar* _tmp39_;
		_tmp39_ = k_name;
		_tmp37_ = g_strcmp0 (_tmp39_, "KP_Enter") == 0;
	}
	if (_tmp37_) {
		_tmp36_ = TRUE;
	} else {
		const gchar* _tmp40_;
		_tmp40_ = k_name;
		_tmp36_ = g_strcmp0 (_tmp40_, "Return") == 0;
	}
	if (_tmp36_) {
		Game* _tmp41_;
		Game* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		_tmp41_ = taquin_view_get_game (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = self->priv->x_arrow;
		_tmp44_ = self->priv->y_arrow;
		game_request_move (_tmp42_, _tmp43_, _tmp44_);
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	_tmp45_ = k_name;
	_tmp46_ = _tmp45_;
	_tmp48_ = (NULL == _tmp46_) ? 0 : g_quark_from_string (_tmp46_);
	if (_tmp48_ == ((0 != _tmp47_label0) ? _tmp47_label0 : (_tmp47_label0 = g_quark_from_static_string ("Left")))) {
		switch (0) {
			default:
			{
				gint _tmp49_;
				_tmp49_ = self->priv->x_arrow;
				if (_tmp49_ > 0) {
					gint _tmp50_;
					_tmp50_ = self->priv->x_arrow;
					self->priv->x_arrow = _tmp50_ - 1;
				}
				break;
			}
		}
	} else if (_tmp48_ == ((0 != _tmp47_label1) ? _tmp47_label1 : (_tmp47_label1 = g_quark_from_static_string ("Right")))) {
		switch (0) {
			default:
			{
				gint _tmp51_;
				Game* _tmp52_;
				Game* _tmp53_;
				gint _tmp54_;
				gint _tmp55_;
				_tmp51_ = self->priv->x_arrow;
				_tmp52_ = taquin_view_get_game (self);
				_tmp53_ = _tmp52_;
				_tmp54_ = game_get_size (_tmp53_);
				_tmp55_ = _tmp54_;
				if (_tmp51_ < (_tmp55_ - 1)) {
					gint _tmp56_;
					_tmp56_ = self->priv->x_arrow;
					self->priv->x_arrow = _tmp56_ + 1;
				}
				break;
			}
		}
	} else if (_tmp48_ == ((0 != _tmp47_label2) ? _tmp47_label2 : (_tmp47_label2 = g_quark_from_static_string ("Up")))) {
		switch (0) {
			default:
			{
				gint _tmp57_;
				_tmp57_ = self->priv->y_arrow;
				if (_tmp57_ > 0) {
					gint _tmp58_;
					_tmp58_ = self->priv->y_arrow;
					self->priv->y_arrow = _tmp58_ - 1;
				}
				break;
			}
		}
	} else if (_tmp48_ == ((0 != _tmp47_label3) ? _tmp47_label3 : (_tmp47_label3 = g_quark_from_static_string ("Down")))) {
		switch (0) {
			default:
			{
				gint _tmp59_;
				Game* _tmp60_;
				Game* _tmp61_;
				gint _tmp62_;
				gint _tmp63_;
				_tmp59_ = self->priv->y_arrow;
				_tmp60_ = taquin_view_get_game (self);
				_tmp61_ = _tmp60_;
				_tmp62_ = game_get_size (_tmp61_);
				_tmp63_ = _tmp62_;
				if (_tmp59_ < (_tmp63_ - 1)) {
					gint _tmp64_;
					_tmp64_ = self->priv->y_arrow;
					self->priv->y_arrow = _tmp64_ + 1;
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (k_name);
				return result;
			}
		}
	}
	self->priv->draw_lights = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = TRUE;
	_g_free0 (k_name);
	return result;
}


static gint
taquin_view_get_x_offset (TaquinView* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->board_size;
	_tmp1_ = self->priv->grid_border_main;
	result = ((gtk_widget_get_allocated_width ((GtkWidget*) self) - _tmp0_) / 2) - _tmp1_;
	return result;
}


static gint
taquin_view_get_y_offset (TaquinView* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->board_size;
	_tmp1_ = self->priv->grid_border_main;
	result = ((gtk_widget_get_allocated_height ((GtkWidget*) self) - _tmp0_) / 2) - _tmp1_;
	return result;
}


Game*
taquin_view_get_game (TaquinView* self)
{
	Game* result;
	Game* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
_taquin_view_move_cb_game_move (Game* _sender,
                                gboolean x_axis,
                                gint number,
                                gint x_gap,
                                gint y_gap,
                                gpointer self)
{
	taquin_view_move_cb ((TaquinView*) self, x_axis, number, x_gap, y_gap);
}


static void
_taquin_view_complete_cb_game_complete (Game* _sender,
                                        gpointer self)
{
	taquin_view_complete_cb ((TaquinView*) self);
}


void
taquin_view_set_game (TaquinView* self,
                      Game* value)
{
	Game* _tmp0_;
	Game* _tmp2_;
	Game* _tmp3_;
	Game* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_;
		_tmp1_ = self->priv->_game;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	self->priv->animate = FALSE;
	self->priv->finished = FALSE;
	self->priv->animate_end = FALSE;
	self->priv->animation_end_offset = (gdouble) 0;
	self->priv->draw_lights = FALSE;
	self->priv->x_arrow = 0;
	self->priv->y_arrow = 0;
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp2_;
	_tmp3_ = self->priv->_game;
	g_signal_connect_object (_tmp3_, "move", (GCallback) _taquin_view_move_cb_game_move, self, 0);
	_tmp4_ = self->priv->_game;
	g_signal_connect_object (_tmp4_, "complete", (GCallback) _taquin_view_complete_cb_game_complete, self, 0);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, taquin_view_properties[TAQUIN_VIEW_GAME_PROPERTY]);
}


const gchar*
taquin_view_get_theme (TaquinView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}


void
taquin_view_set_theme (TaquinView* self,
                       const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_theme);
	self->priv->_theme = _tmp0_;
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	self->priv->tiles_pattern = NULL;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, taquin_view_properties[TAQUIN_VIEW_THEME_PROPERTY]);
}


static void
taquin_view_class_init (TaquinViewClass * klass)
{
	taquin_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TaquinViewPrivate));
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) taquin_view_real_draw;
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget *, GdkEventButton*)) taquin_view_real_button_press_event;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget *, GdkEventKey*)) taquin_view_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_taquin_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_taquin_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = taquin_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAQUIN_VIEW_GAME_PROPERTY, taquin_view_properties[TAQUIN_VIEW_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TAQUIN_VIEW_THEME_PROPERTY, taquin_view_properties[TAQUIN_VIEW_THEME_PROPERTY] = g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
taquin_view_instance_init (TaquinView * self)
{
	self->priv = TAQUIN_VIEW_GET_PRIVATE (self);
	self->priv->grid_border_thin = 6;
	self->priv->x_arrow = 0;
	self->priv->y_arrow = 0;
	self->priv->draw_lights = FALSE;
	self->priv->render_size = 0;
	self->priv->tiles_pattern = NULL;
	self->priv->animate = FALSE;
	self->priv->animate_end = FALSE;
	self->priv->finished = FALSE;
	self->priv->_game = NULL;
	self->priv->_theme = NULL;
}


static void
taquin_view_finalize (GObject * obj)
{
	TaquinView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TAQUIN_VIEW, TaquinView);
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	_g_object_unref0 (self->priv->_game);
	_g_free0 (self->priv->_theme);
	G_OBJECT_CLASS (taquin_view_parent_class)->finalize (obj);
}


GType
taquin_view_get_type (void)
{
	static volatile gsize taquin_view_type_id__volatile = 0;
	if (g_once_init_enter (&taquin_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaquinViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) taquin_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaquinView), 0, (GInstanceInitFunc) taquin_view_instance_init, NULL };
		GType taquin_view_type_id;
		taquin_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "TaquinView", &g_define_type_info, 0);
		g_once_init_leave (&taquin_view_type_id__volatile, taquin_view_type_id);
	}
	return taquin_view_type_id__volatile;
}


static void
_vala_taquin_view_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	TaquinView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TAQUIN_VIEW, TaquinView);
	switch (property_id) {
		case TAQUIN_VIEW_GAME_PROPERTY:
		g_value_set_object (value, taquin_view_get_game (self));
		break;
		case TAQUIN_VIEW_THEME_PROPERTY:
		g_value_set_string (value, taquin_view_get_theme (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_taquin_view_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	TaquinView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TAQUIN_VIEW, TaquinView);
	switch (property_id) {
		case TAQUIN_VIEW_GAME_PROPERTY:
		taquin_view_set_game (self, g_value_get_object (value));
		break;
		case TAQUIN_VIEW_THEME_PROPERTY:
		taquin_view_set_theme (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



