"""
 Copyright © 2017 Bilal Elmoussaoui <bil.elmoussaoui@gmail.com>

 This file is part of Authenticator.

 Authenticator is free software: you can redistribute it and/or
 modify it under the terms of the GNU General Public License as published
 by the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 Authenticator is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Authenticator. If not, see <http://www.gnu.org/licenses/>.
"""
import logging


class Logger:
    """Logging handler."""
    DEBUG: int = logging.DEBUG
    ERROR: int = logging.ERROR
    # Default instance of Logger
    instance: 'Logger' = None
    # Message format
    FORMAT: str = "[%(levelname)-s] %(asctime)s %(message)s"
    # Date format
    DATE: str = "%Y-%m-%d %H:%M:%S"

    def __init__(self):
        pass

    @staticmethod
    def new():
        """Create a new instance of Logger."""
        logger = logging.getLogger('authenticator')
        handler = logging.StreamHandler()
        formatter = logging.Formatter(Logger.FORMAT, Logger.DATE)
        handler.setFormatter(formatter)
        logger.setLevel(logging.DEBUG)
        logger.addHandler(handler)
        return logger

    @staticmethod
    def get_default() -> 'Logger':
        """Return the default instance of Logger."""
        if Logger.instance is None:
            # Init the Logger
            Logger.instance = Logger.new()
        return Logger.instance

    @staticmethod
    def set_level(level: int):
        """Set the logging level."""
        Logger.get_default().setLevel(level)

    @staticmethod
    def warning(msg: str):
        """Log a warning message."""
        Logger.get_default().warning(msg)

    @staticmethod
    def debug(msg: str):
        """Log a debug message."""
        Logger.get_default().debug(msg)

    @staticmethod
    def info(msg: str):
        """Log an info message."""
        Logger.get_default().info(msg)

    @staticmethod
    def error(msg: str):
        """Log an error message."""
        Logger.get_default().error(msg)
