;; -*- coding: euc-jp -*-
;;  Nqueen
;;  nn θߤ˸ˤʤߤĤ

;;  SHINYAMA Yusuke (euske@cl.cs.titech.ac.jp)
;;  This software is public domain.

(define (decr x) (- x 1))
(define (incr x) (+ x 1))

; rotate: ٥ x  pos ž
(define (rotate x pos)
  (do ((last (decr (vector-length x)))
       (x0 (vector-ref x pos))
       (i pos (incr i)))
      ((= i last) (vector-set! x last x0))
    (vector-set! x i (vector-ref x (incr i)))))

; rotrec: ٥ x ǤΡ֤Ȥ߹碌 func ŬѤ
(define (rotrec func x pos)
  (let ((last (decr (vector-length x))))
    (if (= pos last)
        (func x)
        (do ((i pos (incr i)))
            ((< last i) #f)
          (rotrec func x (incr pos))
          (rotate x pos)))))

; genpat: nn פνѥ
(define (genpat n)
  (let ((x (make-vector n)))
    (do ((i 0 (incr i)))
        ((= n i) x)
      (vector-set! x i i))))

; checkqueen: ѥ p ٤Ƹߤ˸ˤʤʤ #t
(define (checkqueen p)
  (define (loop i diag0 diag1) ; i ϥ, diag0, diag1 ϥꥹ
    (or (zero? i)
        (let* ((x (decr i))
               (y (vector-ref p x))
               (d0 (+ x y))
               (d1 (- x y)))
;         (format #t "check: ~a (~a,~a) in ~a,~a\n" p x y diag0 diag1)
          (and (not (or (memv d0 diag0)
                        (memv d1 diag1)))
               (loop (decr i) (cons d0 diag0) (cons d1 diag1))))))
  (loop (vector-length p) '() '()))

; nqueen: ᥤ롼
(define (nqueen n)
  (let ((result '()))
    (rotrec (lambda (p) 
              (if (checkqueen p)
                  (set! result
                        (cons (vector->list p) result))))
            (genpat n) 0)
    result))

; sample
;(display (nqueen 8))(newline)(exit)

(define (main args)
  (display (nqueen 8))
  (newline)
  0)
