/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.sequenceChooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.emboss.jemboss.gui.form.TextFieldSink;

public class OutputSequenceAttributes {
    private JTextField osextension = new JTextField();
    private JTextField osname = new JTextField();
    private JTextField offormat = new JTextField();
    private JTextField ofname = new JTextField();
    private JRadioButton ossingle;
    private JComboBox fileFormats;
    private JScrollPane rscroll;
    private String[] ff = new String[]{"unspecified", "text", "fasta", "msf", "fitch", "gcg", "gcg8", "embl", "swiss", "ncbi", "pearson", "genbank", "nbrf", "pir", "codata", "strider", "clustal", "aln", "phylip", "phylip3", "asn1", "acedb", "dbid", "hennig86", "jackknifer", "jackknifernon", "nexus", "nexusnon", "paup", "paupnon", "treecon", "mega", "meganon", "ig", "experiment", "staden", "plain", "gff", "raw", "selex"};

    public OutputSequenceAttributes(final TextFieldSink tfs) {
        JPanel pscroll = new JPanel(new BorderLayout());
        this.rscroll = new JScrollPane(pscroll);
        Box b = new Box(1);
        pscroll.add((Component)b, "Center");
        Box bx = new Box(0);
        b.add(bx);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        JLabel lab = new JLabel("Sequence Attributes");
        lab.setForeground(Color.red);
        lab.setFont(new Font("SansSerif", 1, 13));
        bx.add(lab);
        bx.add(Box.createHorizontalGlue());
        b.add(Box.createRigidArea(new Dimension(0, 3)));
        bx = new Box(0);
        b.add(bx);
        this.fileFormats = new JComboBox<String>(this.ff);
        this.setRigidSize(this.fileFormats, 100, 25);
        this.fileFormats.setSelectedIndex(0);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        bx.add(this.fileFormats);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        lab = new JLabel("Sequence format");
        lab.setForeground(Color.black);
        bx.add(lab);
        bx.add(Box.createHorizontalGlue());
        this.osextension = new JTextField();
        this.setRigidSize(this.osextension, 100, 30);
        b.add(Box.createRigidArea(new Dimension(0, 3)));
        bx = new Box(0);
        b.add(bx);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        bx.add(this.osextension);
        bx.add(Box.createRigidArea(new Dimension(2, 0)));
        final JLabel lab_fne = new JLabel("File name extension");
        lab.setForeground(Color.black);
        bx.add(lab_fne);
        bx.add(Box.createHorizontalGlue());
        this.osname = new JTextField();
        this.setRigidSize(this.osname, 100, 30);
        b.add(Box.createRigidArea(new Dimension(0, 3)));
        bx = new Box(0);
        b.add(bx);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        bx.add(this.osname);
        bx.add(Box.createRigidArea(new Dimension(2, 0)));
        final JLabel lab_bfn = new JLabel("Base file name");
        lab.setForeground(Color.black);
        bx.add(lab_bfn);
        bx.add(Box.createHorizontalGlue());
        this.ossingle = new JRadioButton("Separate file for each entry");
        this.ossingle.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String why = "'Separate file for each entry' option has been selected";
                if (OutputSequenceAttributes.this.ossingle.isSelected()) {
                    OutputSequenceAttributes.this.osname.setEnabled(false);
                    OutputSequenceAttributes.this.osextension.setEnabled(false);
                    OutputSequenceAttributes.this.osname.setToolTipText("'Separate file for each entry' option has been selected");
                    OutputSequenceAttributes.this.osextension.setToolTipText("'Separate file for each entry' option has been selected");
                    lab_fne.setEnabled(false);
                    lab_bfn.setEnabled(false);
                    tfs.setEnabled(false);
                } else {
                    OutputSequenceAttributes.this.osname.setEnabled(true);
                    OutputSequenceAttributes.this.osextension.setEnabled(true);
                    OutputSequenceAttributes.this.osname.setToolTipText("");
                    OutputSequenceAttributes.this.osextension.setToolTipText("");
                    tfs.setEnabled(true);
                    lab_fne.setEnabled(true);
                    lab_bfn.setEnabled(true);
                }
            }
        });
        b.add(Box.createRigidArea(new Dimension(0, 3)));
        bx = new Box(0);
        b.add(bx);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        bx.add(this.ossingle);
        bx.add(Box.createHorizontalGlue());
        bx.add(Box.createHorizontalGlue());
        this.offormat = new JTextField();
        this.setRigidSize(this.offormat, 100, 30);
        b.add(Box.createRigidArea(new Dimension(0, 3)));
        bx = new Box(0);
        b.add(bx);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        bx.add(this.offormat);
        bx.add(Box.createRigidArea(new Dimension(2, 0)));
        final JLabel lab_ff = new JLabel("Features format");
        lab.setForeground(Color.black);
        bx.add(lab_ff);
        bx.add(Box.createHorizontalGlue());
        this.ofname = new JTextField();
        this.setRigidSize(this.ofname, 100, 30);
        b.add(Box.createRigidArea(new Dimension(0, 3)));
        bx = new Box(0);
        b.add(bx);
        bx.add(Box.createRigidArea(new Dimension(3, 0)));
        bx.add(this.ofname);
        bx.add(Box.createRigidArea(new Dimension(2, 0)));
        final JLabel lab_ffn = new JLabel("Features file name");
        lab.setForeground(Color.black);
        bx.add(lab_ffn);
        bx.add(Box.createHorizontalGlue());
        this.fileFormats.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String why = "A sequence format that is capable of holding a feature table has been specified";
                int i = OutputSequenceAttributes.this.fileFormats.getSelectedIndex();
                String format = OutputSequenceAttributes.this.ff[i];
                if (format.equals("swiss") || format.equals("nbrf") || format.equals("pir") || format.equals("genbank") || format.equals("embl") || format.equals("gff")) {
                    OutputSequenceAttributes.this.offormat.setEnabled(false);
                    OutputSequenceAttributes.this.ofname.setEnabled(false);
                    lab_ff.setEnabled(false);
                    lab_ffn.setEnabled(false);
                    OutputSequenceAttributes.this.offormat.setToolTipText("A sequence format that is capable of holding a feature table has been specified");
                    OutputSequenceAttributes.this.ofname.setToolTipText("A sequence format that is capable of holding a feature table has been specified");
                } else {
                    OutputSequenceAttributes.this.offormat.setEnabled(true);
                    OutputSequenceAttributes.this.ofname.setEnabled(true);
                    OutputSequenceAttributes.this.offormat.setToolTipText("");
                    OutputSequenceAttributes.this.ofname.setToolTipText("");
                    lab_ff.setEnabled(true);
                    lab_ffn.setEnabled(true);
                }
            }
        });
    }

    public JScrollPane getJScrollPane() {
        return this.rscroll;
    }

    public String getFormatChoosen() {
        return (String)this.fileFormats.getSelectedItem();
    }

    public boolean isExtensionDefault() {
        return this.osextension.getText() == null || this.osextension.getText().equals("");
    }

    public boolean isNameDefault() {
        return this.osname.getText() == null || this.osname.getText().equals("");
    }

    public boolean isFNameDefault() {
        return this.ofname.getText() == null || this.ofname.getText().equals("");
    }

    public String getOuputSeqAttr() {
        String options = "";
        if (!this.getFormatChoosen().equals("unspecified")) {
            options = options.concat(" -osformat " + this.getFormatChoosen());
        }
        if (this.osextension.isEnabled() && !this.isExtensionDefault()) {
            options = options.concat(" -osextension " + this.osextension.getText());
        }
        if (this.osname.isEnabled() && !this.isNameDefault()) {
            options = options.concat(" -osname " + this.osname.getText());
        }
        if (this.ossingle.isSelected()) {
            options = options.concat(" -ossingle ");
        }
        if (this.ofname.isEnabled() && !this.isFNameDefault()) {
            options = options.concat(" -ofname " + this.ofname.getText());
        }
        if (this.offormat.isEnabled() && this.offormat.getText() != null && !this.offormat.getText().equals("")) {
            options = options.concat(" -offormat " + this.offormat.getText());
        }
        return options;
    }

    public List getOuputSeqAttrA() {
        ArrayList<String> options = new ArrayList<String>();
        if (!this.getFormatChoosen().equals("unspecified")) {
            options.add("-osformat");
            options.add(this.getFormatChoosen());
        }
        if (this.osextension.isEnabled() && !this.isExtensionDefault()) {
            options.add("-osextension");
            options.add(this.osextension.getText());
        }
        if (this.osname.isEnabled() && !this.isNameDefault()) {
            options.add("-osname");
            options.add(this.osname.getText());
        }
        if (this.ossingle.isSelected()) {
            options.add("-ossingle");
        }
        if (this.ofname.isEnabled() && !this.isFNameDefault()) {
            options.add("-ofname");
            options.add(this.ofname.getText());
        }
        if (this.offormat.isEnabled() && this.offormat.getText() != null && !this.offormat.getText().equals("")) {
            options.add("-offormat");
            options.add(this.offormat.getText());
        }
        return options;
    }

    private void setRigidSize(JComponent c, int width, int height) {
        Dimension d = new Dimension(width, height);
        c.setPreferredSize(d);
        c.setMinimumSize(d);
        c.setMaximumSize(d);
    }
}

