/*
 * Copyright (c) 2021 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains mutable and immutable sorted map interfaces.
 * <p>
 *     A sorted map is a map which contains elements in sorted order. It allows for faster retrievals.
 * <p>
 * This package contains 3 interfaces:
 * <ul>
 *     <li>
 *         {@link org.eclipse.collections.api.map.sorted.MutableSortedMap} - an implementation of a JCF Map which provides methods matching the Smalltalk Collection protocol.
 *     </li>
 *     <li>
 *         {@link org.eclipse.collections.api.map.sorted.ImmutableSortedMap} - the non-mutable equivalent of {@link org.eclipse.collections.api.map.sorted.MutableSortedMap}.
 *     </li>
 *     <li>
 *         {@link org.eclipse.collections.api.map.sorted.SortedMapIterable} - a map which contains elements in sorted order.
 *     </li>
 * </ul>
 */
package org.eclipse.collections.api.map.sorted;
