#!/bin/bash
#                               -*- Mode: Sh -*- 
# get-orig.sh --- 
# Author           : Marc Haber <mh+debian-bugs@zugschlus.de>
# Last Modified By : Manoj Srivastava
# Last Modified On : Tue Dec 24 00:24:28 2002
# Last Machine Used: glaurung.green-gryphon.com
# Update Count     : 2
# Status           : Unknown, Use with caution!
# HISTORY          : 
# Description      : 
# Example script to add to the hook to get the original sources
# 

BASEURL="http://your.favorite.debian.mirror/debian"
SUFFIX="orig.tar.gz"

SECTION="main"
POOL="debian"
#case $package in
#  if you have local pools, set here POOL, SECTION or direct SOURCETAR
#  path for your local packages.
#esac

if [ -z "$SOURCETAR" ]; then
    case $POOL in
	local) SOURCETAR="$BASEURL/localpool/$SECTION/$package/${package}_${upstream_version}.$SUFFIX";;
	debian) SOURCETAR="$BASEURL/pool/$SECTION/${package:0:1}/$package/${package}_${upstream_version}.$SUFFIX";;
	*) echo >&2 "ERR: illegal pool defined"; exit 1 ;;
    esac
fi

if [ -n "$SOURCETAR" ]; then
    echo "curl --remote-name $SOURCETAR"
    if ! curl --remote-name $SOURCETAR; then
	echo >&2 "ERR: can't download $SOURCETAR"
	exit 1
    fi
else
    echo >&2 "ERR: no original tar ball for ${package}_${upstream_version} is available. Stop."
    exit 1
fi
