/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TailCallReturner;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;

public class Template
extends Procedure
implements InstructionInfoProvider {
    private int precedence;
    private int minImportPrecedence;
    private int templateFingerprint;
    private boolean hasRequiredParams;
    private boolean bodyIsTailCallReturner;
    private transient InstructionDetails details;

    public Template() {
        this.setHostLanguage(50);
    }

    public void init(int n, int n2, int n3) {
        this.templateFingerprint = n;
        this.precedence = n2;
        this.minImportPrecedence = n3;
    }

    public void setBody(Expression expression) {
        super.setBody(expression);
        this.bodyIsTailCallReturner = expression instanceof TailCallReturner;
    }

    public int getFingerprint() {
        return this.templateFingerprint;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public void setHasRequiredParams(boolean bl) {
        this.hasRequiredParams = bl;
    }

    public boolean hasRequiredParams() {
        return this.hasRequiredParams;
    }

    public void apply(XPathContext xPathContext, Rule rule) throws XPathException {
        for (TailCall tailCall = this.applyLeavingTail(xPathContext, rule); tailCall != null; tailCall = tailCall.processLeavingTail()) {
        }
    }

    public TailCall applyLeavingTail(XPathContext xPathContext, Rule rule) throws XPathException {
        if (this.body == null) {
            return null;
        }
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setCurrentTemplateRule(rule);
        if (this.bodyIsTailCallReturner) {
            return ((TailCallReturner)((Object)this.body)).processLeavingTail(xPathContextMajor);
        }
        this.body.process(xPathContextMajor);
        return null;
    }

    public TailCall expand(XPathContext xPathContext) throws XPathException {
        if (this.bodyIsTailCallReturner) {
            return ((TailCallReturner)((Object)this.body)).processLeavingTail(xPathContext);
        }
        if (this.body != null) {
            this.body.process(xPathContext);
        }
        return null;
    }

    public InstructionInfo getInstructionInfo() {
        if (this.details == null) {
            this.details = new InstructionDetails();
            this.details.setSystemId(this.getSystemId());
            this.details.setLineNumber(this.getLineNumber());
            this.details.setConstructType(181);
            this.details.setProperty("template", this);
        }
        return this.details;
    }

    public boolean hasBadParentPointer() {
        if (this.getBody() instanceof ComputedExpression) {
            return ((ComputedExpression)this.getBody()).hasBadParentPointer();
        }
        return false;
    }
}

