{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetGeoOrigin: TGeoOriginNode;
    procedure SetGeoOrigin(const Value: TGeoOriginNode);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventHitNormal_changed: TSFVec3fEvent;
    {  }
    public property EventHitNormal_changed: TSFVec3fEvent read FEventHitNormal_changed;

    strict private FEventHitPoint_changed: TSFVec3fEvent;
    {  }
    public property EventHitPoint_changed: TSFVec3fEvent read FEventHitPoint_changed;

    strict private FEventHitTexCoord_changed: TSFVec2fEvent;
    {  }
    public property EventHitTexCoord_changed: TSFVec2fEvent read FEventHitTexCoord_changed;

    strict private FEventHitGeoCoord_changed: TSFVec3dEvent;
    {  }
    public property EventHitGeoCoord_changed: TSFVec3dEvent read FEventHitGeoCoord_changed;

    strict private FFdGeoOrigin: TSFNode;
    { Internal wrapper for property @code(GeoOrigin). This wrapper API may change, we advise to access simpler @code(GeoOrigin) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGeoOrigin: TSFNode read FFdGeoOrigin;
    {  }
    property GeoOrigin: TGeoOriginNode read GetGeoOrigin write SetGeoOrigin;

    strict private FFdGeoSystem: TMFString;
    { Internal wrapper for property @code(GeoSystem). This wrapper API may change, we advise to access simpler @code(GeoSystem) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGeoSystem: TMFString read FFdGeoSystem;
    {  }
    procedure SetGeoSystem(const Value: array of string); overload;
    {  }
    procedure SetGeoSystem(const Value: TCastleStringList); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TGeoTouchSensorNode ----------------------------------------------- }

function TGeoTouchSensorNode.GetGeoOrigin: TGeoOriginNode;
begin
  if FdGeoOrigin.Value is TGeoOriginNode then
    Result := TGeoOriginNode(FdGeoOrigin.Value)
  else
    Result := nil;
end;

procedure TGeoTouchSensorNode.SetGeoOrigin(const Value: TGeoOriginNode);
begin
  FdGeoOrigin.Send(Value);
end;

procedure TGeoTouchSensorNode.SetGeoSystem(const Value: array of string);
begin
  FdGeoSystem.Send(Value);
end;

procedure TGeoTouchSensorNode.SetGeoSystem(const Value: TCastleStringList);
begin
  FdGeoSystem.Send(Value);
end;

class function TGeoTouchSensorNode.ClassX3DType: String;
begin
  Result := 'GeoTouchSensor';
end;

procedure TGeoTouchSensorNode.CreateNode;
begin
  inherited;

  FEventHitNormal_changed := TSFVec3fEvent.Create(Self, 'hitNormal_changed', false);
  AddEvent(FEventHitNormal_changed);

  FEventHitPoint_changed := TSFVec3fEvent.Create(Self, 'hitPoint_changed', false);
  AddEvent(FEventHitPoint_changed);

  FEventHitTexCoord_changed := TSFVec2fEvent.Create(Self, 'hitTexCoord_changed', false);
  AddEvent(FEventHitTexCoord_changed);

  FEventHitGeoCoord_changed := TSFVec3dEvent.Create(Self, 'hitGeoCoord_changed', false);
  AddEvent(FEventHitGeoCoord_changed);

  FFdGeoOrigin := TSFNode.Create(Self, False, 'geoOrigin', [TGeoOriginNode]);
   FdGeoOrigin.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGeoOrigin);

  FFdGeoSystem := TMFString.Create(Self, False, 'geoSystem', ['GD','WE']);
   FdGeoSystem.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGeoSystem);
end;

{$endif read_implementation}
