// TodoList.C  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD
// Copyright (C) 2002 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#include "TodoList.H"

TodoList::TodoList()
{
#ifdef HAVE_STL_CLEAR
  todoQueue.clear();
#endif
}

TodoList::~TodoList()
{ }

void
TodoList::addDeban(String channel, String mask, time_t when)
{
  TodoListItem tdli(String("MODE ") + channel +
                    " -b " + mask, when);
  todoQueue.insert(tdli);
}

String
TodoList::getNext()
{
  std::multiset<TodoListItem, std::less<TodoListItem> >::iterator it;
  std::time_t current_time = time(0);

  it = todoQueue.begin();

  if (it == todoQueue.end() || (*it).when > current_time)
    return "";

  String result = (*it).line;
  todoQueue.erase(it);

  return result;
}
