# Print a localized message
# USAGE: print_message $level $message $extra_values[…]
print_message() {
	local level message
	# Valid levels are "error", "warning" and "info". Unknown levels will be handled similar to "info".
	level="$1"
	# The message is a format string, any included "%s" will be replaced by the values passed as extra arguments.
	# See printf(1) for details on the sequences that can be used in the format string.
	message="$2"
	shift 2

	case "$level" in
		('warning')
			local warning_string
			case "${LANG%_*}" in
				('fr')
					warning_string='Avertissement :'
				;;
				('en'|*)
					warning_string='Warning:'
				;;
			esac
			printf '\n\033[1;33m%s\033[0m\n' "$warning_string"
			## Silence ShellCheck false-positive
			## Don't use variables in the printf format string. Use printf "..%s.." "$foo".
			# shellcheck disable=SC2059
			printf -- "$message" "$@"
		;;
		('error')
			(
				## Since this is called from a subshell, this should not trigger unwanted output redirections.
				exec 1>&2
				local error_string
				case "${LANG%_*}" in
					('fr')
						error_string='Erreur :'
					;;
					('en'|*)
						error_string='Error:'
					;;
				esac
				printf '\n\033[1;31m%s\033[0m\n' "$error_string"
				## Silence ShellCheck false-positive
				## Don't use variables in the printf format string. Use printf "..%s.." "$foo".
				# shellcheck disable=SC2059
				printf -- "$message" "$@"
			)
		;;
		('info'|*)
			## Silence ShellCheck false-positive
			## Don't use variables in the printf format string. Use printf "..%s.." "$foo".
			# shellcheck disable=SC2059
			printf -- "$message" "$@"
		;;
	esac
}

