/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_PHYSICALCONNECTOR_H_
#define OPENDRIM_PHYSICALCONNECTOR_H_

#include <Instance.h>

const static char* OpenDRIM_PhysicalConnector_classnames[] = {"OpenDRIM_PhysicalConnector"};
static string OpenDRIM_PhysicalConnector_NAMESPACE = _NAMESPACE;

class OpenDRIM_PhysicalConnector {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string InstallDate;
	bool InstallDate_isNULL;
	
	string Name;
	bool Name_isNULL;
	
	vector<unsigned short> OperationalStatus;
	bool OperationalStatus_isNULL;
	
	vector<string> StatusDescriptions;
	bool StatusDescriptions_isNULL;
	
	string Status;
	bool Status_isNULL;
	
	unsigned short HealthState;
	bool HealthState_isNULL;
	
	unsigned short PrimaryStatus;
	bool PrimaryStatus_isNULL;
	
	unsigned short DetailedStatus;
	bool DetailedStatus_isNULL;
	
	unsigned short OperatingStatus;
	bool OperatingStatus_isNULL;
	
	unsigned short CommunicationStatus;
	bool CommunicationStatus_isNULL;
	
	string Tag;
	bool Tag_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string CreationClassName;
	bool CreationClassName_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string Manufacturer;
	bool Manufacturer_isNULL;
	
	string Model;
	bool Model_isNULL;
	
	string SKU;
	bool SKU_isNULL;
	
	string SerialNumber;
	bool SerialNumber_isNULL;
	
	string Version;
	bool Version_isNULL;
	
	string PartNumber;
	bool PartNumber_isNULL;
	
	string OtherIdentifyingInfo;
	bool OtherIdentifyingInfo_isNULL;
	
	bool PoweredOn;
	bool PoweredOn_isNULL;
	
	string ManufactureDate;
	bool ManufactureDate_isNULL;
	
	string VendorEquipmentType;
	bool VendorEquipmentType_isNULL;
	
	string UserTracking;
	bool UserTracking_isNULL;
	
	bool CanBeFRUed;
	bool CanBeFRUed_isNULL;
	
	string ConnectorPinout;
	bool ConnectorPinout_isNULL;
	
	vector<unsigned short> ConnectorType;
	bool ConnectorType_isNULL;
	
	string OtherTypeDescription;
	bool OtherTypeDescription_isNULL;
	
	unsigned short ConnectorGender;
	bool ConnectorGender_isNULL;
	
	vector<unsigned short> ConnectorElectricalCharacteristics;
	bool ConnectorElectricalCharacteristics_isNULL;
	
	vector<string> OtherElectricalCharacteristics;
	bool OtherElectricalCharacteristics_isNULL;
	
	unsigned int NumPhysicalPins;
	bool NumPhysicalPins_isNULL;
	
	unsigned short ConnectorLayout;
	bool ConnectorLayout_isNULL;
	
	string ConnectorDescription;
	bool ConnectorDescription_isNULL;
	
	OpenDRIM_PhysicalConnector() {
		Caption_isNULL = true;
		InstallDate_isNULL = true;
		Name_isNULL = true;
		OperationalStatus_isNULL = true;
		StatusDescriptions_isNULL = true;
		Status_isNULL = true;
		HealthState_isNULL = true;
		PrimaryStatus_isNULL = true;
		DetailedStatus_isNULL = true;
		OperatingStatus_isNULL = true;
		CommunicationStatus_isNULL = true;
		Tag_isNULL = true;
		Description_isNULL = true;
		CreationClassName_isNULL = true;
		ElementName_isNULL = true;
		Manufacturer_isNULL = true;
		Model_isNULL = true;
		SKU_isNULL = true;
		SerialNumber_isNULL = true;
		Version_isNULL = true;
		PartNumber_isNULL = true;
		OtherIdentifyingInfo_isNULL = true;
		PoweredOn_isNULL = true;
		ManufactureDate_isNULL = true;
		VendorEquipmentType_isNULL = true;
		UserTracking_isNULL = true;
		CanBeFRUed_isNULL = true;
		ConnectorPinout_isNULL = true;
		ConnectorType_isNULL = true;
		OtherTypeDescription_isNULL = true;
		ConnectorGender_isNULL = true;
		ConnectorElectricalCharacteristics_isNULL = true;
		OtherElectricalCharacteristics_isNULL = true;
		NumPhysicalPins_isNULL = true;
		ConnectorLayout_isNULL = true;
		ConnectorDescription_isNULL = true;
	}
	
	~OpenDRIM_PhysicalConnector() {}
	
	string getKeys() const {
		return CF_toLowCase(".Tag=\"" + CF_quoteString(Tag) + "\""".CreationClassName=\"" + CF_quoteString(CreationClassName) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getInstallDate(string& value) const {
		if (InstallDate_isNULL==true)
			return NOT_FOUND;
		value = InstallDate;
		return OK;
	}
	
	int setInstallDate(const string& newValue) {
		InstallDate = newValue;
		InstallDate_isNULL = false;
		return OK;
	}

	int getName(string& value) const {
		if (Name_isNULL==true)
			return NOT_FOUND;
		value = Name;
		return OK;
	}
	
	int setName(const string& newValue) {
		Name = newValue;
		Name_isNULL = false;
		return OK;
	}

	int getOperationalStatus(vector<unsigned short>& value) const {
		if (OperationalStatus_isNULL==true)
			return NOT_FOUND;
		value = OperationalStatus;
		return OK;
	}
	
	int setOperationalStatus(const vector<unsigned short>& newValue) {
		OperationalStatus = newValue;
		OperationalStatus_isNULL = false;
		return OK;
	}

	int getStatusDescriptions(vector<string>& value) const {
		if (StatusDescriptions_isNULL==true)
			return NOT_FOUND;
		value = StatusDescriptions;
		return OK;
	}
	
	int setStatusDescriptions(const vector<string>& newValue) {
		StatusDescriptions = newValue;
		StatusDescriptions_isNULL = false;
		return OK;
	}

	int getStatus(string& value) const {
		if (Status_isNULL==true)
			return NOT_FOUND;
		value = Status;
		return OK;
	}
	
	int setStatus(const string& newValue) {
		Status = newValue;
		Status_isNULL = false;
		return OK;
	}

	int getHealthState(unsigned short& value) const {
		if (HealthState_isNULL==true)
			return NOT_FOUND;
		value = HealthState;
		return OK;
	}
	
	int setHealthState(const unsigned short& newValue) {
		HealthState = newValue;
		HealthState_isNULL = false;
		return OK;
	}

	int getPrimaryStatus(unsigned short& value) const {
		if (PrimaryStatus_isNULL==true)
			return NOT_FOUND;
		value = PrimaryStatus;
		return OK;
	}
	
	int setPrimaryStatus(const unsigned short& newValue) {
		PrimaryStatus = newValue;
		PrimaryStatus_isNULL = false;
		return OK;
	}

	int getDetailedStatus(unsigned short& value) const {
		if (DetailedStatus_isNULL==true)
			return NOT_FOUND;
		value = DetailedStatus;
		return OK;
	}
	
	int setDetailedStatus(const unsigned short& newValue) {
		DetailedStatus = newValue;
		DetailedStatus_isNULL = false;
		return OK;
	}

	int getOperatingStatus(unsigned short& value) const {
		if (OperatingStatus_isNULL==true)
			return NOT_FOUND;
		value = OperatingStatus;
		return OK;
	}
	
	int setOperatingStatus(const unsigned short& newValue) {
		OperatingStatus = newValue;
		OperatingStatus_isNULL = false;
		return OK;
	}

	int getCommunicationStatus(unsigned short& value) const {
		if (CommunicationStatus_isNULL==true)
			return NOT_FOUND;
		value = CommunicationStatus;
		return OK;
	}
	
	int setCommunicationStatus(const unsigned short& newValue) {
		CommunicationStatus = newValue;
		CommunicationStatus_isNULL = false;
		return OK;
	}

	int getTag(string& value) const {
		if (Tag_isNULL==true)
			return NOT_FOUND;
		value = Tag;
		return OK;
	}
	
	int setTag(const string& newValue) {
		Tag = newValue;
		Tag_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getCreationClassName(string& value) const {
		if (CreationClassName_isNULL==true)
			return NOT_FOUND;
		value = CreationClassName;
		return OK;
	}
	
	int setCreationClassName(const string& newValue) {
		CreationClassName = newValue;
		CreationClassName_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getManufacturer(string& value) const {
		if (Manufacturer_isNULL==true)
			return NOT_FOUND;
		value = Manufacturer;
		return OK;
	}
	
	int setManufacturer(const string& newValue) {
		Manufacturer = newValue;
		Manufacturer_isNULL = false;
		return OK;
	}

	int getModel(string& value) const {
		if (Model_isNULL==true)
			return NOT_FOUND;
		value = Model;
		return OK;
	}
	
	int setModel(const string& newValue) {
		Model = newValue;
		Model_isNULL = false;
		return OK;
	}

	int getSKU(string& value) const {
		if (SKU_isNULL==true)
			return NOT_FOUND;
		value = SKU;
		return OK;
	}
	
	int setSKU(const string& newValue) {
		SKU = newValue;
		SKU_isNULL = false;
		return OK;
	}

	int getSerialNumber(string& value) const {
		if (SerialNumber_isNULL==true)
			return NOT_FOUND;
		value = SerialNumber;
		return OK;
	}
	
	int setSerialNumber(const string& newValue) {
		SerialNumber = newValue;
		SerialNumber_isNULL = false;
		return OK;
	}

	int getVersion(string& value) const {
		if (Version_isNULL==true)
			return NOT_FOUND;
		value = Version;
		return OK;
	}
	
	int setVersion(const string& newValue) {
		Version = newValue;
		Version_isNULL = false;
		return OK;
	}

	int getPartNumber(string& value) const {
		if (PartNumber_isNULL==true)
			return NOT_FOUND;
		value = PartNumber;
		return OK;
	}
	
	int setPartNumber(const string& newValue) {
		PartNumber = newValue;
		PartNumber_isNULL = false;
		return OK;
	}

	int getOtherIdentifyingInfo(string& value) const {
		if (OtherIdentifyingInfo_isNULL==true)
			return NOT_FOUND;
		value = OtherIdentifyingInfo;
		return OK;
	}
	
	int setOtherIdentifyingInfo(const string& newValue) {
		OtherIdentifyingInfo = newValue;
		OtherIdentifyingInfo_isNULL = false;
		return OK;
	}

	int getPoweredOn(bool& value) const {
		if (PoweredOn_isNULL==true)
			return NOT_FOUND;
		value = PoweredOn;
		return OK;
	}
	
	int setPoweredOn(const bool& newValue) {
		PoweredOn = newValue;
		PoweredOn_isNULL = false;
		return OK;
	}

	int getManufactureDate(string& value) const {
		if (ManufactureDate_isNULL==true)
			return NOT_FOUND;
		value = ManufactureDate;
		return OK;
	}
	
	int setManufactureDate(const string& newValue) {
		ManufactureDate = newValue;
		ManufactureDate_isNULL = false;
		return OK;
	}

	int getVendorEquipmentType(string& value) const {
		if (VendorEquipmentType_isNULL==true)
			return NOT_FOUND;
		value = VendorEquipmentType;
		return OK;
	}
	
	int setVendorEquipmentType(const string& newValue) {
		VendorEquipmentType = newValue;
		VendorEquipmentType_isNULL = false;
		return OK;
	}

	int getUserTracking(string& value) const {
		if (UserTracking_isNULL==true)
			return NOT_FOUND;
		value = UserTracking;
		return OK;
	}
	
	int setUserTracking(const string& newValue) {
		UserTracking = newValue;
		UserTracking_isNULL = false;
		return OK;
	}

	int getCanBeFRUed(bool& value) const {
		if (CanBeFRUed_isNULL==true)
			return NOT_FOUND;
		value = CanBeFRUed;
		return OK;
	}
	
	int setCanBeFRUed(const bool& newValue) {
		CanBeFRUed = newValue;
		CanBeFRUed_isNULL = false;
		return OK;
	}

	int getConnectorPinout(string& value) const {
		if (ConnectorPinout_isNULL==true)
			return NOT_FOUND;
		value = ConnectorPinout;
		return OK;
	}
	
	int setConnectorPinout(const string& newValue) {
		ConnectorPinout = newValue;
		ConnectorPinout_isNULL = false;
		return OK;
	}

	int getConnectorType(vector<unsigned short>& value) const {
		if (ConnectorType_isNULL==true)
			return NOT_FOUND;
		value = ConnectorType;
		return OK;
	}
	
	int setConnectorType(const vector<unsigned short>& newValue) {
		ConnectorType = newValue;
		ConnectorType_isNULL = false;
		return OK;
	}

	int getOtherTypeDescription(string& value) const {
		if (OtherTypeDescription_isNULL==true)
			return NOT_FOUND;
		value = OtherTypeDescription;
		return OK;
	}
	
	int setOtherTypeDescription(const string& newValue) {
		OtherTypeDescription = newValue;
		OtherTypeDescription_isNULL = false;
		return OK;
	}

	int getConnectorGender(unsigned short& value) const {
		if (ConnectorGender_isNULL==true)
			return NOT_FOUND;
		value = ConnectorGender;
		return OK;
	}
	
	int setConnectorGender(const unsigned short& newValue) {
		ConnectorGender = newValue;
		ConnectorGender_isNULL = false;
		return OK;
	}

	int getConnectorElectricalCharacteristics(vector<unsigned short>& value) const {
		if (ConnectorElectricalCharacteristics_isNULL==true)
			return NOT_FOUND;
		value = ConnectorElectricalCharacteristics;
		return OK;
	}
	
	int setConnectorElectricalCharacteristics(const vector<unsigned short>& newValue) {
		ConnectorElectricalCharacteristics = newValue;
		ConnectorElectricalCharacteristics_isNULL = false;
		return OK;
	}

	int getOtherElectricalCharacteristics(vector<string>& value) const {
		if (OtherElectricalCharacteristics_isNULL==true)
			return NOT_FOUND;
		value = OtherElectricalCharacteristics;
		return OK;
	}
	
	int setOtherElectricalCharacteristics(const vector<string>& newValue) {
		OtherElectricalCharacteristics = newValue;
		OtherElectricalCharacteristics_isNULL = false;
		return OK;
	}

	int getNumPhysicalPins(unsigned int& value) const {
		if (NumPhysicalPins_isNULL==true)
			return NOT_FOUND;
		value = NumPhysicalPins;
		return OK;
	}
	
	int setNumPhysicalPins(const unsigned int& newValue) {
		NumPhysicalPins = newValue;
		NumPhysicalPins_isNULL = false;
		return OK;
	}

	int getConnectorLayout(unsigned short& value) const {
		if (ConnectorLayout_isNULL==true)
			return NOT_FOUND;
		value = ConnectorLayout;
		return OK;
	}
	
	int setConnectorLayout(const unsigned short& newValue) {
		ConnectorLayout = newValue;
		ConnectorLayout_isNULL = false;
		return OK;
	}

	int getConnectorDescription(string& value) const {
		if (ConnectorDescription_isNULL==true)
			return NOT_FOUND;
		value = ConnectorDescription;
		return OK;
	}
	
	int setConnectorDescription(const string& newValue) {
		ConnectorDescription = newValue;
		ConnectorDescription_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_PHYSICALCONNECTOR_H_*/
