/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.exceptions;

import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.util.DateUtils;

public abstract class CliCommandoException
extends RuntimeException {
    private ErrorMessages.ErrorCode errorCode;
    private String debugInfo = null;

    public CliCommandoException(ErrorMessages.ErrorCode errorCode, String ... arguments) {
        this(null, null, errorCode, arguments);
    }

    public CliCommandoException(String debugInfo, ErrorMessages.ErrorCode errorCode, String ... arguments) {
        this(debugInfo, null, errorCode, arguments);
    }

    public CliCommandoException(ErrorMessages.ErrorCode typeCode, ErrorMessages.ErrorCode errorCode, String ... arguments) {
        this(null, typeCode, errorCode, arguments);
    }

    public CliCommandoException(String debugInfo, ErrorMessages.ErrorCode typeCode, ErrorMessages.ErrorCode errorCode, String ... arguments) {
        super(CliCommandoException.buildMessage(typeCode, errorCode, arguments));
        this.errorCode = errorCode;
        this.setDebugInfo(debugInfo);
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public ErrorMessages.ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public CliCommandoException(String message, String debugInfo) {
        super(message);
        this.debugInfo = debugInfo;
    }

    public String toString() {
        return super.getMessage();
    }

    private static String buildMessage(ErrorMessages.ErrorCode errorType, ErrorMessages.ErrorCode errorCode, String ... arguments) {
        String message = "";
        if (errorType != null) {
            message = message + ErrorMessages.getMessageFormat(errorType) + "-";
        }
        if (errorCode != null) {
            String messageFormat = ErrorMessages.getMessageFormat(errorCode);
            try {
                message = message + String.format(messageFormat, arguments);
            }
            catch (Exception ife) {
                message = "Command line tool deployment has error, please re deploy";
            }
        }
        return message;
    }

    protected void setDebugInfo(String debugInfo) {
        String message = super.getLocalizedMessage();
        StringBuilder sb = new StringBuilder();
        sb.append(DateUtils.now() + "\n");
        sb.append(message + "\n");
        if (debugInfo != null) {
            sb.append(debugInfo + "\n");
        }
        this.debugInfo = sb.toString();
    }
}

