var Cu = Components.utils;
var Ci = Components.interfaces;
var Cc = Components.classes;
var Cr = Components.results;

var jumlib = {};
Cu.import("resource://mozmill/modules/jum.js", jumlib);

var topsrcDir;

function setupModule(module) {
    var localFile = Components.classes["@mozilla.org/file/local;1"]
        .createInstance(Components.interfaces.nsILocalFile);
    localFile.initWithPath(module.__file__);
    topsrcDir = localFile.parent.parent.path;

    module.controller = mozmill.getBrowserController();
}

function testGeneral() {
    controller.open(topsrcDir + '/html-tests/dnd/2.html');
    controller.waitForPageLoad();

    controller.sleep(1000);

    jumlib.assertEquals(controller.window.document.title.search('DND'), 0);
    controller.tabs.selectTabIndex(controller.tabs.length - 1);

    jumlib.assertEquals(controller.window.document.title.search('Firefox') != -1, true);
}
