/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_OOX_DRAWINGML_TEXTBODY_HXX
#define INCLUDED_OOX_DRAWINGML_TEXTBODY_HXX

#include <oox/drawingml/drawingmltypes.hxx>
#include <drawingml/textbodyproperties.hxx>
#include <drawingml/textliststyle.hxx>

namespace com { namespace sun { namespace star {
    namespace text { class XText; }
    namespace text { class XTextCursor; }
} } }

namespace oox { namespace core { class XmlFilterBase; } }

namespace oox { namespace drawingml {

class TextParagraph;
typedef RefVector< TextParagraph > TextParagraphVector;

class TextBody
{
public:
    TextBody();
    TextBody( const TextBodyPtr& pBody );
    ~TextBody();

    const TextParagraphVector&          getParagraphs() const { return maParagraphs; }
    TextParagraph&                      addParagraph();
    /// Appends an existing paragraph to this text body.
    void appendParagraph(std::shared_ptr<TextParagraph> pTextParagraph);

    const TextListStyle&                getTextListStyle() const { return maTextListStyle; }
    TextListStyle&                      getTextListStyle() { return maTextListStyle; }

    const TextBodyProperties&           getTextProperties() const { return maTextProperties; }
    TextBodyProperties&                 getTextProperties() { return maTextProperties; }

    /** insert the text body at the text cursor */
    void                insertAt(
                            const ::oox::core::XmlFilterBase& rFilterBase,
                            const css::uno::Reference < css::text::XText > & xText,
                            const css::uno::Reference < css::text::XTextCursor > & xAt,
                            const TextCharacterProperties& rTextStyleProperties,
                            const TextListStylePtr& pMasterTextListStyle ) const;
    bool isEmpty() const;

    void                ApplyStyleEmpty(
                            const ::oox::core::XmlFilterBase& rFilterBase,
                            const css::uno::Reference < css::text::XText > & xText,
                            const TextCharacterProperties& rTextStyleProperties,
                            const TextListStylePtr& pMasterTextListStylePtr) const;
protected:
    TextParagraphVector maParagraphs;
    TextBodyProperties  maTextProperties;
    TextListStyle       maTextListStyle;
};

} }

#endif // INCLUDED_OOX_DRAWINGML_TEXTBODY_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
