; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
;
; Test that the ffs library call simplifier works correctly even for
; targets with 16-bit int.
;
; RUN: opt < %s -mtriple=avr-linux -passes=instcombine -S | FileCheck %s --check-prefix=AVR
; RUN: opt < %s -mtriple=msp430-linux -passes=instcombine -S | FileCheck %s --check-prefix=MSP430
; REQUIRES: avr-registered-target,msp430-registered-target


declare i16 @ffs(i16)

declare void @sink(i16)


define void @fold_ffs(i16 %x) {
; AVR-LABEL: @fold_ffs(
; AVR-NEXT:    call addrspace(1) void @sink(i16 0)
; AVR-NEXT:    call addrspace(1) void @sink(i16 1)
; AVR-NEXT:    [[CTTZ:%.*]] = call addrspace(1) i16 @llvm.cttz.i16(i16 [[X:%.*]], i1 true), !range [[RNG0:![0-9]+]]
; AVR-NEXT:    [[TMP1:%.*]] = add nuw nsw i16 [[CTTZ]], 1
; AVR-NEXT:    [[DOTNOT:%.*]] = icmp eq i16 [[X]], 0
; AVR-NEXT:    [[NX:%.*]] = select i1 [[DOTNOT]], i16 0, i16 [[TMP1]]
; AVR-NEXT:    call addrspace(1) void @sink(i16 [[NX]])
; AVR-NEXT:    ret void
;
; MSP430-LABEL: @fold_ffs(
; MSP430-NEXT:    call void @sink(i16 0)
; MSP430-NEXT:    call void @sink(i16 1)
; MSP430-NEXT:    [[CTTZ:%.*]] = call i16 @llvm.cttz.i16(i16 [[X:%.*]], i1 true), !range [[RNG0:![0-9]+]]
; MSP430-NEXT:    [[TMP1:%.*]] = add nuw nsw i16 [[CTTZ]], 1
; MSP430-NEXT:    [[DOTNOT:%.*]] = icmp eq i16 [[X]], 0
; MSP430-NEXT:    [[NX:%.*]] = select i1 [[DOTNOT]], i16 0, i16 [[TMP1]]
; MSP430-NEXT:    call void @sink(i16 [[NX]])
; MSP430-NEXT:    ret void
;
  %n0 = call i16 @ffs(i16 0)
  call void @sink(i16 %n0)

  %n1 = call i16 @ffs(i16 1)
  call void @sink(i16 %n1)

  %nx = call i16 @ffs(i16 %x)
  call void @sink(i16 %nx)

  ret void
}
