'\" e
.TH groff_diff @MAN7EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
groff_diff \- differences between GNU
.I roff
and AT&T
.I troff
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2023 Free Software Foundation, Inc.
.\"
.\" This file is part of groff, the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, with no Front-Cover Texts,
.\" and with no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called FDL in the main directory of the groff source package.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_groff_diff_7_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.\" Local definitions
.\" ====================================================================
.
.\" define a string tx for the TeX logo
.ie t .ds tx T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el   .ds tx TeX
.
.
.\" from old groff_out.man
.ie \n(.g \
.  ds ic \/
.el \
.  ds ic \^
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
The GNU
.I roff
text processing system,
.IR groff ,
is an extension of AT&T
.IR troff , \" AT&T
the typesetting system originating in Unix systems of the 1970s.
.
.I groff
removes many arbitrary limitations and adds features,
both to the input language and to the page description language output
by the
.I troff \" generic
formatter.
.
Differences arising from
.IR groff 's
implementation of AT&T
.I troff \" AT&T
features are also noted.
.
See
.MR roff @MAN7EXT@
for background.
.
.
.\" ====================================================================
.SH Language
.\" ====================================================================
.
GNU
.I troff \" GNU
features identifiers of arbitrary length;
supports color output,
non-integral type sizes,
and user-defined characters;
adds more conditional expression operators;
recognizes additional scaling units and numeric operators;
enables general file I/O
(in \[lq]unsafe mode\[rq] only);
and exposes more formatter state.
.
.
.\" ====================================================================
.SS "Long names"
.\" ====================================================================
.
GNU
.I troff \" GNU
introduces many new requests;
with three exceptions
.RB ( cp ,
.BR do ,
.BR rj ),
they have names longer than two characters.
.
The names of registers,
fonts,
strings/\:macros/\:diversions,
environments,
special characters,
streams,
and colors can be of any length.
.
Anywhere AT&T
.I troff \" AT&T
supports a parameterized escape sequence that uses an opening
parenthesis \[lq](\[rq] to introduce a two-character argument,
.I groff
supports a square-bracketed form \[lq][]\[rq] where the argument
within can be of arbitrary length.
.
.
.\" ====================================================================
.SS "Font families, abstract styles, and translation"
.\" ====================================================================
.
GNU
.I troff \" GNU
can group text typefaces into
.I families
containing each of the styles
.RB \[lq] R \[rq],
.RB \[lq] I \[rq],
.RB \[lq] B \[rq],
and
.RB \[lq] BI \[rq].
.
So that a document need not be coupled to a specific font family,
an output device can associate a style in the abstract sense with a
mounting position.
.
Thus the default family can be combined with a style dynamically,
producing a
.I "resolved font name."
.
A document can
.I translate,
or remap,
fonts with the
.B ftr
request.
.
.
.P
Applying the requests
.BR cs ,
.BR bd ,
.BR tkf ,
.BR uf ,
or
.B \%fspecial
to an abstract style affects the member of the default family
corresponding to that style.
.
The default family can be set with the
.B fam
request or
.B \-f
command-line option.
.
The
.B styles
directive in the output device's
.I DESC
file controls which mounting positions
(if any)
are initially associated with abstract styles rather than fonts,
and the
.B sty
request can update this association.
.
.
.\" ====================================================================
.SS Colors
.\" ====================================================================
.
.I groff
supports color output with a variety of color spaces and up to 16 bits
per channel.
.
Some devices,
particularly terminals,
may be more limited.
.
When color support is enabled,
two colors are current at any given time:
the
.I stroke color,
with which glyphs,
rules (lines),
and geometric figures are drawn,
and the
.I fill color,
which paints the interior of filled geometric figures.
.
The
.BR color ,
.BR \%defcolor ,
.BR gcolor ,
and
.B fcolor
requests;
.B \[rs]m
and
.B \[rs]M
escape sequences;
and
.BR .color ,
.BR .m ,
and
.B .M
registers exercise color support.
.
.
.\" ====================================================================
.SS "Fractional type sizes and new scaling units"
.\" ====================================================================
.
.\" BEGIN Keep (roughly) parallel with groff.texi node "Using Fractional
.\" Type Sizes".
AT&T
.I troff \" AT&T
interpreted all type size measurements in points.
.
Combined with integer arithmetic,
this design choice made it impossible to support,
for instance,
ten and a half-point type.
.
In GNU
.IR troff , \" GNU
an output device can select a scaling factor that subdivides a point
into \[lq]scaled points\[rq].
.
A type size expressed in scaled points can thus represent a non-integral
type size.
.
.
.P
A
.I scaled point
is equal to
.RI 1/ sizescale
points,
where
.I sizescale
is specified in the device description file,
.IR DESC ,
and defaults to\~1;
see
.MR groff_font @MAN5EXT@ .
.
Requests and escape sequences in GNU
.I troff \" GNU
interpret arguments that represent a type size in points,
which the formatter multiplies by
.I sizescale
and converts to an integer.
.
Arguments treated in this way comprise those to the escape sequences
.B \[rs]H
and
.BR \[rs]s ,
to the request
.BR ps ,
the third argument to the
.B cs
request,
and the second and fourth arguments to the
.B tkf
request.
.
Scaled points may be specified explicitly with the
.B z
scaling unit.
.
In GNU
.IR troff , \" GNU
the register
.B \[rs]n[.s]
can interpolate a non-integral type size.
.
The register
.B \[rs]n[.ps]
interpolates the type size in scaled points.
.
.
.P
For example,
if
.I sizescale
is\~1000,
then a scaled point is one thousandth of a point.
.
Consequently,
.RB \[lq] ".ps 10.5" \[rq]
is synonymous with
.RB \[lq] ".ps 10.5z" \[rq];
both set the type size to 10,500\~scaled points,
or 10.5\~points.
.
.
.P
It makes no sense to use the
.RB \[lq] z \[rq]\~scaling
unit in a numeric expression whose default scaling unit is neither
.RB \[lq] u \[rq]
.RB nor\~\[lq] z \[rq],
so GNU
.I troff \" GNU
disallows this.
.
Similarly,
it is nonsensical to use a scaling unit other
.RB than\~\[lq] z \[rq]
.RB or\~\[lq] u \[rq]
in a numeric expression whose default scaling unit
.RB is\~\[lq] z \[rq],
so GNU
.I troff
disallows this as well.
.
.
.br
.ne 2v
.P
Another new scaling unit,
.RB \[lq] s \[rq],
multiplies by the number of basic units in a scaled point.
.
Thus,
.RB \[lq]\^ \[rs]n[.ps]s \[rq]
is equal to
.RB \[lq] 1m \[rq]
by definition.
.
Do not confuse the
.RB \[lq] s \[rq]
and
.RB \[lq] z \[rq]
scaling units.
.
.
.br
.ne 2v
.P
Output devices may be limited in the type sizes they can employ.
.
The
.B .s
and
.B .ps
registers represent the type size as selected by the output driver as it
understands a device's capability.
.
The last
.I requested
type size is interpolated in scaled points by the read-only register
.B .psr
and in points as a decimal fraction by the read-only string-valued
register
.BR .sr .
.
Both are associated with the environment.
.
For example,
if a type size of 10.95\~points is requested,
and the nearest size permitted by a
.B sizes
request
(or by the
.B sizes
or
.B \%sizescale
directives in the device's
.I DESC
file)
is 11\~points,
the output driver uses the latter value.
.\" END Keep (roughly) parallel with groff.texi node "Using Fractional
.\" Type Sizes".
.
.
.P
A further two new measurement units available in
.I groff
are
.RB \[lq] M \[rq],
which indicates hundredths of an em,
and
.RB \[lq] f \^\[rq],
which multiplies by 65,536.
.
The latter provides convenient fractions for color definitions with the
.B \%defcolor
request.
.
For example,
0.5f equals 32768u.
.
.
.\" ====================================================================
.SS "Numeric expressions"
.\" ====================================================================
.
GNU
.I troff \" GNU
permits spaces in a numeric expression within parentheses,
and offers three new operators.
.
.
.TP
.IB e1 >? e2
Interpolate the greater of
.I e1
and
.IR e2 .
.
.
.TP
.IB e1 <? e2
Interpolate the lesser of
.I e1
and
.IR e2 .
.
.
.TP
.BI ( c ; e )
Evaluate
.I e
using
.I c
as the default scaling unit,
ignoring scaling units in
.I e
if
.I c
is empty.
.
.
.\" ====================================================================
.SS "Conditional expressions"
.\" ====================================================================
.
More conditions can be tested with the
.RB \[lq]\| if \|\[rq]
and
.B ie
requests,
as well as the new
.RB \[lq] while \[rq]
request.
.
.
.TP
.BI c\~ chr
True if a character
.I chr
is available,
where
.I chr
is an ordinary character
(Unicode basic Latin excluding control characters and the space),
a special character,
or
.BI \[rs]N\[aq] index\c
.BR \[aq] .
.
.
.TP
.BI d\~ nam
True if a string,
macro,
diversion,
or request
.I nam
is defined.
.
.
.TP
.BI F\~ fnt
True if a font
.I fnt
is available;
.I fnt
can be an abstract style
or a font name.
.
.I fnt
is handled as if it
were accessed with the
.B ft
request
(that is,
abstract styles and font translation are applied),
but
.I fnt
cannot be a mounting position,
and no font is mounted.
.
.
.TP
.BI m\~ col
True if a color
.I col
is defined.
.
.
.TP
.BI r\~ reg
True if a register
.I reg
is defined.
.
.
.TP
.BI S\~ sty
True if a style
.I sty
is registered.
.
Font translation applies.
.
.
.TP
.B v
Always false.
.
This condition is for compatibility with certain other
.I troff
implementations only.
.
(This refers to
.IR vtroff ,
a translator that would convert the C/A/T output from early-vintage AT&T
.I troff \" AT&T
to a form suitable for Versatec and Benson-Varian plotters.)
.
.
.\" ====================================================================
.SS "Drawing commands"
.\" ====================================================================
.
GNU
.I troff \" GNU
offers drawing commands to create filled
circles and ellipses,
and polygons.
.\" CSTR #54 did not countenance polygons, but DWB 3.3 had outlined ones
.\" as \D'p' as we do.  Filled polygons appear to be a GNU innovation.
.
Stroked (outlined) objects are drawn with the stroke color and
filled (solid) ones shaded with the fill color.
.
These are independent properties;
if you want a filled,
stroked figure,
you must draw the same figure twice using each drawing command.
.
A filled figure is always smaller than a stroked one because the former
is drawn only within its defined area,
whereas strokes have a line thickness
(set with another new drawing command,
.BR \[rs]D\[aq]t\[aq] ).
.
.
.\" ====================================================================
.SS "Escape sequences"
.\" ====================================================================
.
.\" TODO: Some of the synopses here and in "New requests" get pretty
.\" discursive.  It would be better to lift the introduction of new
.\" concepts in groff programming to new subsections above.  Examples
.\" include: string parameterization, user-definable characters,
.\" character properties (cflags), character classes; the hyphenation
.\" language, code, and pattern file system; file stream manipulation...
.\"
.\" _Maybe_ output suppression.  It's a big enough concept, but only
.\" well understood by retired contributors, only used by the grohtml
.\" output driver (still beta after 20 years), and we have some Savannah
.\" tickets that point the way to radically simplifying its design,
.\" eliminating its need to groff before you groff.
.I groff
introduces several new escape sequences
and extends the syntax of a few AT&T
.I troff \" AT&T
escape sequences
(namely,
.BR \[rs]D ,
.BR \[rs]f ,
.BR \[rs]k ,
.BR \[rs]n ,
.BR \[rs]s ,
.BR \[rs]$ ,
and
.BR \[rs]* ).
.
In the following list,
escape sequences are collated alphabetically at first,
and then by symbol roughly in Unicode code point order.
.\" Exceptions are made to group closely-related escape sequences in an
.\" order more agreeable to the development of a topic.
.
.
.TP 7.5 \" sinfully obtain better pagination on typesetters
.BI \[rs]A\[aq] anything \[aq]
Interpolate 1 if
.I anything
is a valid identifier,
and\~0 otherwise.
.
Because invalid input characters are removed,
invalid identifiers are empty or contain spaces,
tabs,
or newlines.
.
You can employ
.B \[rs]A
to validate a macro argument before using it to construct another escape
sequence or identifier.
.
.TP
.BI \[rs]B\[aq] anything \[aq]
Interpolate 1 if
.I anything
is a valid numeric expression,
and\~0 otherwise.
.
You might use
.B \[rs]B
along with the
.RB \[lq]\| if \|\[rq]
request to filter out invalid macro arguments.
.
.
.TP
.BI \[rs]D\[aq]C\~ "d" \[aq]
Draw filled circle of diameter
.I d
with its leftmost point at the drawing position.
.
.
.TP
.BI \[rs]D\[aq]E\~ "h v" \[aq]
Draw filled ellipse with
.I h
and
.I v
as the axes and the leftmost point at the drawing position.
.
.
.TP
.BI \[rs]D\[aq]p\~ "h1 v1"\~\c
.RI .\|.\|.\~ "hn vn"\c
.B \[aq]
Draw polygon with vertices at drawing position and each point
in sequence.
.
GNU
.I troff \" GNU
closes the polygon by drawing a line from
.RI ( hn ,\~ vn )
back to the initial drawing position;
DWB and Heirloom
.IR troff s \" DWB, Heirloom
do not.
.
.\" XXX: This would be the "STUPID_DRAWING_POSITIONING" complained of in
.\" src/libs/libdriver/input.cpp.  It is neither the rightmost point
.\" of the figure nor the initial drawing position that GNU troff
.\" automatically returned to to close the figure.
Afterward,
the drawing position is left at
.RI ( hn ,\~ vn ).
.
.
.TP
.BI \[rs]D\[aq]P\~ "h1 v1"\~\c
.RI .\|.\|.\~ "hn vn"\c
.B \[aq]
As
.BR \[rs]D\[aq]p\[aq] ,
but the polygon is filled.
.
.
.TP
.BI \[rs]D\[aq]t\~ "n" \[aq]
Set line thickness of geometric objects to
.RI to\~ n
basic units.
.
A zero
.I n
selects the minimal supported thickness.
.
A negative
.I n
selects a thickness proportional to the type size;
this is the default.
.
.
.TP
.B \[rs]E
Embed an escape character that is not interpreted in copy mode
(compare with
.B \[rs]a
and
.BR \[rs]t ).
.
You can use it to ease the writing of nested macro definitions.
.
It is also convenient to define strings containing escape sequences that
need to work when used in copy mode
(for example,
as macro arguments),
or which will be interpolated at varying macro nesting depths.
.
.
.TP
.BI \[rs]f[ font ]
Select
.IR font ,
which may be a mounting position,
abstract style,
or font name,
to choose the typeface.
.
.B \[rs]f[]
and
.B \[rs]fP
are synonyms;
we recommend the former.
.
.
.TP
.BI \[rs]F f
.TQ
.BI \[rs]F( fm
.TQ
.BI \[rs]F[ family ]
Select default font family.
.
.B \[rs]F[]
makes the previous font family the default.
.
.B \[rs]FP
is unlike
.BR \[rs]fP ;
it selects font family \[lq]P\[rq] as the default.
.
See the
.B fam
request below.
.
.
.TP
.BI \[rs]k( rg
.TQ
.BI \[rs]k[ reg ]
Mark horizontal drawing position in
two-character register
.RI name\~ rg
or arbitrary register
.RI name\~ reg .
.
.
.TP
.BI \[rs]m c
.TQ
.BI \[rs]m( cl
.TQ
.BI \[rs]m[ col ]
Set the stroke color.
.
.B \[rs]m[]
restores the previous stroke color,
or the default if there is none.
.
.
.TP
.BI \[rs]M c
.TQ
.BI \[rs]M( cl
.TQ
.BI \[rs]M[ col ]
Set the fill color.
.
.B \[rs]M[]
restores the previous fill color,
or the default if there is none.
.
.
.TP
.BI \[rs]n[ reg ]
Interpolate register
.IR reg .
.
.
.TP
.BI \[rs]O n
.TQ
.BI \[rs]O[ n ]
Suppress
.I @g@troff
output of glyphs and geometric objects.
.
The sequences
.BR \[rs]O2 ,
.BR \[rs]O3 ,
.BR \[rs]O4 ,
and
.B \[rs]O5
are intended for internal use by
.MR grohtml @MAN1EXT@ .
.
.
.RS
.TP
.B \[rs]O0
.TQ
.B \[rs]O1
Disable and enable,
respectively,
the emission of glyphs and geometric objects to the output driver,
provided that this sequence occurs at the outermost suppression level
(see
.B \[rs]O3
and
.BR \[rs]O4 ).
.
Horizontal motions corresponding to non-overstruck glyph widths still
occur.
.
These sequences also reset the registers
.BR opminx ,
.BR opminy ,
.BR opmaxx ,
and
.B opmaxy
to\~\-1.
.
These four registers mark the top left and bottom right hand corners of
a box encompassing all written or drawn output.
.
.
.TP
.B \[rs]O2
At the outermost suppression level,
enable emission of glyphs and geometric objects,
and write to the standard error stream the page number and values of the
four aforementioned registers encompassing glyphs written since the last
interpolation of a
.B \[rs]O
sequence,
as well as the page offset,
line length,
image file name
(if any),
horizontal and vertical device motion quanta,
and input file name.
.
Numeric values are in basic units.
.
.
.TP
.B \[rs]O3
.TQ
.B \[rs]O4
Begin and end a nested suppression level,
respectively.
.
.I \%grohtml
uses this mechanism to create images of output preprocessed with
.IR @g@pic ,
.IR @g@eqn ,
and
.IR @g@tbl .
.
At startup,
.I @g@troff
is at the outermost suppression level.
.
.I \%pre\-grohtml
generates these sequences when processing the document,
using
.I @g@troff
with the
.B ps
output device,
Ghostscript,
and the PNM tools to produce images in PNG format.
.
These sequences start a new page if the device is not
.B html
or
.BR xhtml ,
to reduce the number of images crossing a page boundary.
.
.
.TP
.BI \[rs]O5[ Pfile ]
At the outermost suppression level,
write the name
.I file
to the standard error stream at position
.IR P ,
which must be one of
.BR l ,
.BR r ,
.BR c ,
or
.BR i ,
corresponding to
left,
right,
centered,
and inline alignments within the document,
respectively.
.
.I file
is is a name associated with the production of the next image.
.RE
.
.
.TP
.BI \[rs]R\[aq] name\~\[+-]n \[aq]
Synonymous with
.RB \[lq] .nr
.IR name\~\[+-]n \[rq].
.
.
.TP
.BI \[rs]s[ \[+-]n ]
.TQ
.BI \[rs]s \[+-] [ n ]
.TQ
.BI \[rs]s\[aq] \[+-]n \[aq]
.TQ
.BI \[rs]s \[+-] \[aq] n \[aq]
Set the type size to,
or increment or decrement it by,
.I n
scaled points.
.
.
.br
.ne 5v
.TP
.BI \[rs]V e
.TQ
.BI \[rs]V( ev
.TQ
.BI \[rs]V[ env ]
Interpolate contents of the environment variable
.IR env ,
as returned by
.MR getenv 3 .
.
.B \[rs]V
is interpreted even in copy mode.
.
.
.TP
.BI \[rs]X\[aq] anything \[aq]
Within
.B \[rs]X
arguments,
the escape sequences
.BR \[rs]& ,
.BR \[rs]) ,
.BR \[rs]% ,
and
.B \[rs]:
are ignored;
.BI \[rs] space
and
.B \[rs]\[ti]
are converted to single space characters;
and
.B \[rs]\[rs]
is reduced to
.BR \[rs] .
.
So that the basic Latin subset of the Unicode character set
(that is,
ISO\~646:1991-IRV or,
popularly,
\[lq]US-ASCII\[rq])
can be reliably encoded in
.I anything,
the special character escape sequences
.BR \[rs]\- ,
.BR \[rs][aq] ,
.BR \[rs][dq] ,
.BR \[rs][ga] ,
.BR \[rs][ha] ,
.BR \[rs][rs] ,
and
.B \[rs][ti]
are mapped to basic Latin characters;
see
.MR groff_char @MAN7EXT@ .
.
For this transformation,
character translations and definitions are ignored.
.
Other escape sequences are not supported.
.
.
.IP
If the
.B \%use_charnames_in_special
directive appears in the output device's
.I DESC
file,
the use of special character escape sequences is
.I not
an error;
they are simply output verbatim
(with the exception of the seven mapped to Unicode basic Latin
characters,
discussed above).
.
.B \%use_charnames_in_special
is currently employed only by
.MR grohtml @MAN1EXT@ .
.
.
.TP
.BI \[rs]Y m
.TQ
.BI \[rs]Y( ma
.TQ
.BI \[rs]Y[ mac ]
Interpolate a macro as a device control command.
.
This is similar to
.BI \[rs]X\[aq]\[rs]*[ mac ]\[aq]\f[R],
except the contents of
.I mac
are not interpreted,
and
.I mac
can be a macro and thus contain newlines,
whereas the argument to
.B \[rs]X
cannot.
.
This inclusion of newlines requires an extension to the AT&T
.I troff \" AT&T
output format,
and will confuse postprocessors that do not know about it.
.
.
.TP
.BI \[rs]Z\[aq] anything \[aq]
Save the drawing position,
format
.IR anything ,
then restore it.
.
Tabs and leaders in the argument are ignored with an error diagnostic.
.
.
.TP
.B \[rs]#
Everything up to and including the next newline is ignored.
.
This escape sequence is interpreted even in copy mode.
.
.B \[rs]#
is like
.BR \[rs]" ,
except that
.B \[rs]"
does not ignore a newline;
the latter therefore cannot be used by itself for a whole-line
comment\[em]it leaves a blank line on the input stream.
.
.
.\" Keep \$0 before \$( in spite of collation.
.TP
.B \[rs]$0
Interpolate the name by which the macro being interpreted was called.
.
In GNU
.I troff \" GNU
this name can vary;
see the
.B als
request.
.
.
.TP
.BI \[rs]$( nn
.TQ
.BI \[rs]$[ nnn ]
In a macro or string definition,
interpolate
the
.IR nn th
or
.IR nnn th
argument.
.
Macros and strings can have an unlimited number of arguments.
.
.
.TP
.B \[rs]$*
In a macro or string definition,
interpolate the catenation of all arguments,
separated by spaces.
.
.
.TP
.B \[rs]$@
In a macro or string definition,
interpolate the catenation of all arguments,
with each surrounded by double quotes and separated by spaces.
.
.
.TP
.B \[rs]$\[ha]
In a macro or string definition,
interpolate the catenation of all arguments
constructed in a form suitable for passage to the
.B ds
request.
.
.
.TP
.B \[rs])
Interpolate a
.I transparent
dummy character\[em]one that is ignored by end-of-sentence detection.
.
It behaves as
.BR \[rs]& ,
except that
.B \[rs]&
is treated as letters and numerals normally are after
\[lq].\[rq],
\[lq]?\[rq],
and
\[lq]!\[rq];
.B \[rs]&
cancels end-of-sentence detection,
and
.B \[rs])
does not.
.
.
.TP
.BI \[rs]*[ "string\~\c
.RI [ arg \~.\|.\|.]\c
.B ]
Interpolate
.I string,
passing it
.I arg
\&.\|.\|.\&
as arguments.
.
.
.\" Keep \/ before \, in spite of collation.
.TP
.B \[rs]/
Apply an
.IR "italic correction" :
modify the spacing of the preceding glyph so that the distance between
it and the following glyph is correct if the latter is of upright shape.
.
For example,
if an italic\~\[lq]f\^\[rq] is followed immediately by a roman right
parenthesis,
then in many fonts the top right portion of the\~\[lq]f\^\[rq] overlaps
the top left of the right parenthesis,
.if t producing \f[I]f\f[R]),
which is ugly.
.
Inserting
.B \[rs]\^/
between them
.if t \{\
.  nop produces
.  ie \n(.g \f[I]f\/\f[R])
.  el       \f[I]f\|\f[R])
.  nop and
.\}
avoids this problem.
.
Use this escape sequence whenever an oblique glyph is immediately
followed by an upright glyph without any intervening space.
.
.
.TP
.B \[rs],
Apply a
.IR "left italic correction" :
modify the spacing of the following glyph so that the distance between
it and the preceding glyph is correct if the latter is of upright shape.
.
For example,
if a roman left parenthesis is immediately followed by an
italic\~\[lq]f\^\[rq],
then in many fonts the bottom left portion of the\~\[lq]f\^\[rq]
overlaps the bottom of the left parenthesis,
.if t producing \f[R](\f[I]f\f[R],
which is ugly.
.
Inserting
.B \[rs],
between them
.if t \{\
.  nop produces
.  ie \n(.g \f[R](\,\f[I]f\f[R]
.  el       \f[R](\^\f[I]f\f[R]
.  nop and
.\}
avoids this problem.
.
Use this escape sequence whenever an upright glyph is followed
immediately by an oblique glyph without any intervening space.
.
.
.TP
.B \[rs]:
Insert a non-printing break point.
.
That is,
a word can break there,
but the soft hyphen character does not mark the break point if it does
(in contrast to
.RB \[lq]\^ \[rs]% \[rq]).
.
This escape sequence is an input word boundary,
so the remainder of the word is subject to hyphenation as normal.
.
.
.TP
.BI \[rs]? anything \[rs]?
When used in a diversion,
this transparently embeds
.I anything
in the diversion.
.I anything
is read in copy mode.
.
When the diversion is reread,
.I anything
is interpreted.
.I anything
may not contain newlines;
use
.B \[rs]!\&
if you want to embed newlines in a diversion.
.
The escape sequence
.B \[rs]?\&
is also recognized in copy mode and becomes an internal code;
it is this code that terminates
.IR anything .
Thus
.
.
.RS
.IP
.EX
.ne 14v+\n(.Vu
\&.nr x 1
\&.nf
\&.di d
\&\[rs]?\[rs]\[rs]?\[rs]\[rs]\[rs]\[rs]?\[rs]\[rs]\[rs]\[rs]\[rs]\[rs]\
\[rs]\c
\&\[rs]nx\[rs]\[rs]\[rs]\[rs]?\[rs]\[rs]?\[rs]?
\&.di
\&.nr x 2
\&.di e
\&.d
\&.di
\&.nr x 3
\&.di f
\&.e
\&.di
\&.nr x 4
\&.f
.EE
.RE
.
.
.IP
prints\~\c
.BR 4 .
.
.
.TP
.BI \[rs][ char ]
Typeset the special character
.IR char .
.
.
.TP
.BI \[rs][ "base-char combining-component\~"\c
.RB .\|.\|. ]
Typeset a composite glyph consisting of
.I base-char
overlaid with one or more
.IR combining-component s.
.
For example,
.RB \[lq]\| \[rs][A\~ho] \^\[rq]
is a capital letter \[lq]A\[rq] with a \[lq]hook accent\[rq] (ogonek).
.
See the
.B \%composite
request below;
.IR "Groff: The GNU Implementation of troff" ,
the
.I groff
Texinfo manual,
for details of composite glyph name construction;
and
.MR groff_char @MAN7EXT@
for a list of components used in composite glyph names.
.
.
.TP
.B \[rs]\[ti]
Insert an unbreakable space that is adjustable like an ordinary space.
.
It is discarded from the end of an output line if a break is forced.
.
.
.\" ====================================================================
.SS "Restricted requests"
.\" ====================================================================
.
To mitigate risks from untrusted input documents,
the
.B pi
and
.B sy
requests are disabled by default.
.
.MR @g@troff @MAN1EXT@ 's
.B \-U
option enables the formatter's \[lq]unsafe mode\[rq],
restoring their function
(and enabling additional
.I groff
extension requests,
.BR open ,
.BR opena ,
and
.BR pso ).
.
.
.\" ====================================================================
.SS "New requests"
.\" ====================================================================
.
.TP
.BI .aln\~ "new old"
Create alias
.I new
for existing register named
.IR old ,
causing the names to refer to the same stored value.
.
If
.I old
is undefined,
a warning in category
.RB \[lq] reg \[rq]
is generated and the request is ignored.
.
To remove a register alias,
invoke
.B rr
on its name.
.
A register's contents do not become inaccessible until it has no more
names.
.
.
.TP
.BI .als\~ "new old"
Create alias
.I new
for existing request,
string,
macro,
or diversion named
.IR old ,
causing the names to refer to the same stored object.
.
If
.I old
is undefined,
a warning in category
.RB \[lq] mac \[rq]
is produced,
and the request is ignored.
.
The
.RB \[lq] am \[rq],
.RB \[lq] as \[rq],
.BR da ,
.BR de ,
.BR di ,
and
.B ds
requests
(together with their variants)
create a new object only if the name of the macro,
diversion,
or string is currently undefined
or if it is defined as a request;
normally,
they modify the value of an existing object.
.
To remove an alias,
invoke
.B rm
on its name.
.
The object itself is not destroyed until it has no more names.
.
.
.IP
When a request,
macro,
string,
or diversion is aliased,
redefinitions and appendments \[lq]write through\[rq] alias names.
.
To replace an alias with a separately defined object,
you must use the
.B rm
request on its name first.
.
.
.TP
.BI .am1\~ name\~\c
.RI [ end-name ]
As
.RB \[lq] am \[rq],
but compatibility mode is disabled while the appendment to
.I name
is interpreted:
a \[lq]compatibility save\[rq] token is inserted at its beginning,
and a \[lq]compatibility restore\[rq] token at its end.
.
As a consequence,
the requests
.RB \[lq] am \[rq],
.BR am1 ,
.BR de ,
and
.B de1
can be intermixed freely since the compatibility save/\:restore tokens
affect only the parts of the macro populated by
.B am1
and
.BR de1 .
.
.
.TP
.BI .ami\~ name\~\c
.RI [ end-name ]
Append to macro indirectly.
.
See
.B dei
below.
.
.
.TP
.BI .ami1\~ name\~\c
.RI [ end-name ]
As
.BR ami ,
but compatibility mode is disabled during interpretation of the
appendment.
.
.
.TP
.BI .as1\~ name\~\c
.RI [ contents ]
As
.RB \[lq] as \[rq],
but compatibility mode is disabled while the appendment to
.I name
is interpreted:
a \[lq]compatibility save\[rq] token is inserted at the beginning of
.IR contents ,
and a \[lq]compatibility restore\[rq] token after it.
.
As a consequence,
the requests
.RB \[lq] as \[rq],
.BR as1 ,
.BR ds ,
and
.B ds1
can be intermixed freely since the compatibility save/\:restore tokens
affect only the portions of the strings populated by
.B as1
and
.BR ds1 .
.
.
.TP
.BI .asciify\~ div
.I Unformat
the diversion
.I div
in a way such that Unicode basic Latin (ASCII) characters,
characters translated with the
.B trin
request,
space characters,
and some escape sequences,
that were formatted in the diversion
.I div
are treated like ordinary input characters when
.I div
is reread.
.
Doing so can be useful in conjunction with the
.B writem
request.
.
.B asciify
can be also used for gross hacks;
for example,
the following sets
.RB register\~ n
to\~1.
.
.
.RS
.IP
.EX
.ne 8v+\n(.Vu
\&.tr @.
\&.di x
\&@nr n 1
\&.br
\&.di
\&.tr @@
\&.asciify x
\&.x
.EE
.RE
.
.
.IP
.B asciify
cannot return all items in a diversion to their source equivalent:
nodes such as those produced by
.BR \[rs]N[ .\|.\|.\& ]
will remain nodes,
so the result cannot be guaranteed to be a pure string.
.
See section \[lq]Copy mode\[rq] in
.MR groff @MAN7EXT@ .
.
Glyph parameters such as the type face and size are not preserved;
use
.B unformat
to achieve that.
.
.
.TP
.B .backtrace
Write backtrace of input stack to the standard error stream.
.
See the
.B \-b
option of
.MR @g@troff @MAN1EXT@ .
.
.
.TP
.BR .blm\~ [\c
.IR name ]
Set a blank line macro (trap).
.
If a blank line macro is thus defined,
.I groff
executes
.I macro
when a blank line is encountered in the input file,
instead of the usual behavior.
.
A line consisting only of spaces is also treated as blank and subject to
this trap.
.
If no argument is supplied,
the default blank line behavior is (re-)established.
.
.
.TP
.BR .box\~ [\c
.IR name ]
.TQ
.BR .boxa\~ [\c
.IR name ]
Divert
(or append)
output to
.I name,
similarly to the
.B di
and
.B da
requests,
respectively.
.
Any pending output line is
.I not
included in the diversion.
.
Without an argument,
stop diverting output;
any pending output line inside the diversion is discarded.
.
.
.TP
.B .break
Exit a
.RB \[lq] while \[rq]
loop.
.
Do not confuse this request with a typographical break or the
.B br
request.
.
See
.RB \[lq] continue \[rq].
.
.
.TP
.B .brp
Break and adjust line;
this is the AT&T
.I troff \" AT&T
escape sequence
.B \[rs]p
in request form.
.
.
.TP
.BI .cflags\~ "n c1 c2\~"\c
\&.\|.\|.
Assign properties encoded by the number
.I n
to characters
.IR c1 ,
.IR c2 ,
and so on.
.
Ordinary and special characters have certain associated properties.
.
(Glyphs don't:
to GNU
.IR troff , \" GNU
like AT&T device-independent
.IR troff , \" AT&T
a glyph is an identifier corresponding to a rectangle with some metrics;
see
.MR groff_font @MAN5EXT@ .)
.
The first argument is the sum of the desired flags and the remaining
arguments are the characters to be assigned those properties.
.
Spaces between the
.I cn
arguments are optional.
.
Any argument
.I cn
can be a character class defined with the
.B class
request rather than an individual character.
.
.
.IP
The non-negative integer
.I n
is the sum of any of the following.
.
Some combinations are nonsensical,
such as
.RB \[lq] 33 \[rq]
(1 + 32).
.
.
.RS
.IP 1
Recognize the character as ending a sentence if followed by a newline
or two spaces.
.
Initially,
characters
.RB \[lq] .?! \[rq]
have this property.
.
.
.IP 2
Enable breaks before the character.
.
A line is not broken at a character with this property unless the
characters on each side both have non-zero hyphenation codes.
.
This exception can be overridden by adding 64.
.
Initially,
no characters have this property.
.
.
.IP 4
Enable breaks after the character.
.
A line is not broken at a character with this property unless the
characters on each side both have non-zero hyphenation codes.
.
This exception can be overridden by adding 64.
.
Initially,
characters
.RB \[lq] \-\[rs][hy]\[rs][em] \^\[rq]
have this property.
.
.
.IP 8
Mark the glyph associated with this character as overlapping other
instances of itself horizontally.
.
Initially,
characters
.RB \[lq]\^ \[rs][ul]\[rs][rn]\[rs][ru]\[rs][radicalex]\[rs][sqrtex]\
\& \^\[rq]
have this property.
.
.
.IP 16
Mark the glyph associated with this character as overlapping other
instances of itself vertically.
.
Initially,
the character
.RB \[lq]\^ \[rs][br] \^\[rq]
has this property.
.
.
.IP 32
Mark the character as transparent for the purpose of end-of-sentence
recognition.
.
In other words,
an end-of-sentence character followed by any number of characters with
this property is treated as the end of a sentence if followed by a
newline or two spaces.
.
This is the same as having a zero space factor in \*[tx].
.
Initially,
characters
.\" The following is ordered with the apostrophe and (single) closing
.\" quote on the ends so they are more easily visually distinguished
.\" from the double quotation marks in roman.
.RB \[lq]\| \[aq]\|"\|)]*\[rs][dg]\[rs][dd]\[rs][rq]\[rs]\^[cq] \|\[rq]
have this property.
.
.
.IP 64
Ignore hyphenation codes of the surrounding characters.
.
Use this value in combination with values 2 and\~4.
.
Initially,
no characters have this property.
.
.
.IP
For example,
if you need an automatic break point after
the en-dash in numeric ranges like \[lq]3000\[en]5000\[rq],
insert
.RS
.RS
.EX
\&.cflags 68 \[rs][en]
.EE
.RE
into your document.
.
However,
this can lead to bad layout if done without thinking;
in most situations,
a better solution than
changing the
.B cflags
value is inserting
.RB \[lq] \[rs]: \[rq]
right after the hyphen at the places that really need a break point.
.RE
.
.
.P
The remaining values were implemented for East Asian language support;
those who use alphabetic scripts exclusively can disregard them.
.
.
.IP 128
Prohibit a break before the character,
but allow a break after the character.
.
This works only in combination with values 256 and 512 and has no effect
otherwise.
.
Initially,
no characters have this property.
.
.
.IP 256
Prohibit a break after the character,
but allow a break before the character.
.
This works only in combination with values 128 and 512 and has no effect
otherwise.
.
Initially,
no characters have this property.
.
.
.IP 512
Allow a break before or after the character.
.
This works only in combination with values 128 and 256 and has no effect
otherwise.
.
Initially,
no characters have this property.
.RE
.
.
.IP
In contrast to values 2 and\~4,
the values 128,
256,
and 512 work
pairwise.
.
If,
for example,
the left character has value 512,
and the right character 128,
no break will be automatically inserted between them.
.
If we use value\~6 instead for the left character,
a break after the character can't be suppressed since the neighboring
character on the right doesn't get examined.
.
.
.TP
.BI .char\~ "c contents"
Define the ordinary or special
.RI character\~ c
as
.IR contents ,
which can be empty.
.
More precisely,
.B char
defines a
.I groff
object
(or redefines an existing one)
that is accessed with the
.RI name\~ c
on input,
and produces
.I contents
on output.
.
Every time
.I c
is to be formatted,
.I contents
is processed in a temporary environment and the result is wrapped up
into a single object.
.
Compatibility mode is turned off and the escape character is
set
.RB to\~ \[rs]
while
.I contents
is processed.
.
Any emboldening,
constant spacing,
or track kerning is applied to this object as a whole,
not to each character in
.IR contents .
.
.
.IP
An object defined by this request can be used just like a glyph
provided by the output device.
.
In particular,
other characters can be translated to it with the
.B tr
request;
it can be made the tab or leader fill character with the
.B tc
and
.B lc
requests;
sequences of it can be drawn with the
.B \[rs]l
and
.B \[rs]L
escape sequences;
and,
if the
.B hcode
request is used on
.IR c ,
it is subject to automatic hyphenation.
.
.
.IP
To prevent infinite recursion,
occurrences of
.I c
within its own definition are treated normally
(as if it were not being defined with
.BR char ).
.
The
.B tr
and
.B trin
requests take precedence if
.B char
both apply
.RI to\~ c .
.
A character definition can be removed with the
.B rchar
request.
.
.
.TP
.BI .chop\~ object
Remove the last character from the macro,
string,
or diversion
.IR object .
.
This is useful for removing the newline from the end of a diversion that
is to be interpolated as a string.
.
This request can be used repeatedly on the same
.IR object ;
see section \[lq]gtroff Internals\[rq] in
.IR "Groff: The GNU Implementation of troff" ,
the
.I groff
Texinfo manual,
for discussion of nodes inserted by
.IR groff .
.
.
.TP
.BI .class\~ "name c1 c2\~"\c
\&.\|.\|.
Define a character class
(or simply \[lq]class\[rq])
.I name
comprising the characters or range expressions
.IR c1 ,
.IR c2 ,
and so on.
.
.
.IP
A class thus defined can then be referred to in lieu of listing all the
characters within it.
.
Currently,
only the
.B cflags
request can handle references to character classes.
.
.
.IP
In the request's simplest form,
each
.I cn
is a character
(or special character).
.
.RS
.RS
.EX
\&.class [quotes] \[aq] \[rs][aq] \[rs][dq] \[rs][oq] \[rs][cq] \
\[rs][lq] \[rs][rq]
.EE
.RE
.RE
.
.
.IP
Since class and special character names share the same name space,
we recommend starting and ending the class name with
.RB \[lq] [ \[rq]
and
.RB \[lq] ] \[rq],
respectively,
to avoid collisions with existing character names defined by
.I groff
or the user
(with
.B char
and related requests).
.
This practice applies the presence of
.RB \[lq] ] \[rq]
in the class name to prevent the usage of the special character escape
form
.RB \[lq] \[rs][ .\|.\|. ] \[rq],
thus you must use the
.B \[rs]C
escape to access a class with such a name.
.
.
.IP
You can also use a character range expression consisting of a start
character followed by
.RB \[lq] \- \[rq]
and then an end character.
.
Internally,
GNU
.I troff \" GNU
converts these two character names to Unicode code points
(according to the
.I groff
glyph list [GGL]),
which determine the start and end values of the range.
.
If that fails,
the class definition is skipped.
.
Furthermore,
classes can be nested.
.
.RS
.RS
.EX
\&.class [prepunct] , : ; > }
\&.class [prepunctx] \[rs]C\[aq][prepunct]\[aq] \
\[rs][u2013]\-\[rs][u2016]
.EE
.RE
The class
.RB \[lq] [prepunctx] \[rq]
thus contains the contents of the class
.RB \[lq] [prepunct] \[rq]
and characters in the range U+2013\[en]U+2016.
.RE
.
.
.IP
If you want to include
.RB \[lq] \- \[rq]
in a class,
it must be the first character value in the argument list,
otherwise it gets misinterpreted as part of the range syntax.
.
.
.IP
It is not possible to use class names as end points of range
definitions.
.
.
.IP
A typical use of the
.B class
request is to control line-breaking and hyphenation rules as defined by
the
.B cflags
request.
.
For example,
to inhibit line breaks before the characters belonging to the
.RB \[lq] [prepunctx] \[rq]
class defined in the previous example,
you can write the following.
.
.RS
.RS
.EX
\&.cflags 2 \[rs]C\[aq][prepunctx]\[aq]
.EE
.RE
.RE
.
.
.TP
.BI .close\~ stream
Close the stream named
.IR stream ,
invalidating it as an argument to the
.B write
request.
.
See
.BR open .
.
.
.TP
.BI .composite\~ c1\~c2
Map character name
.I c1
to character name
.I c2
when
.I c1
is a combining component in a composite glyph.
.
Typically,
this remaps a spacing glyph to a combining one.
.
.
.TP
.B .continue
Skip the remainder of a
.RB \[lq] while \[rq]
loop's body,
immediately starting the next iteration.
.
See
.BR break .
.
.
.TP
.BI .color\~ n
If
.I n
is non-zero or missing,
enable colors
(the default),
otherwise disable them.
.
.
.TP
.BI .cp\~ n
If
.I n
is non-zero or missing,
enable compatibility mode,
otherwise disable it.
.
In compatibility mode,
long names are not recognized,
and the incompatibilities they cause do not arise.
.
.
.TP
.BI .defcolor\~ "ident scheme color-component\~\c"
\&.\|.\|.
Define a color named
.I ident.
.
.I scheme
identifies a color space and determines the number of required
.IR color-component s;
it must be one of
.RB \[lq] rgb \[rq]
(three components),
.RB \[lq] cmy \[rq]
(three components),
.RB \[lq] cmyk \[rq]
(four components),
or
.RB \[lq] gray \[rq]
(one component).
.
.RB \[lq] grey \[rq]
is accepted as a synonym of
.RB \[lq] gray \[rq].
.
The color components can be encoded as a hexadecimal value starting
with
.B #
or
.BR ## .
.
The former indicates that each component is in the range 0\[en]255
(0\[en]FF),
the latter the range 0\[en]65535 (0\[en]FFFF).
.
Alternatively,
each color component can be specified as a decimal fraction in the range
0\[en]1,
interpreted using a default scaling unit
.RB of\~\[lq] f \[rq],
which multiplies its value by 65,536
(but clamps it at 65,535).
.
.
.IP
Each output device has a color named
.RB \[lq] default \[rq],
which cannot be redefined.
.
A device's default stroke and fill colors are not necessarily the same.
.
.
.TP
.BI .de1\~ name\~\c
.RI [ end-name ]
Define a macro to be interpreted with compatibility mode disabled.
.
When
.I name
is called,
compatibility mode enablement status is saved;
it is restored when the call completes.
.
.
.TP
.BI .dei\~ name\~\c
.RI [ end-name ]
Define macro indirectly,
with the name of the macro to be defined in string
.I name
and the name of the end macro terminating its definition in string
.IR end-name .
.
.
.TP
.BI .dei1\~ name\~\c
.RI [ end-name ]
As
.BR dei ,
but compatibility mode is disabled while the definition of the macro
named in string
.I name
is interpreted.
.
.
.TP
.BI .device\~ anything
Write
.IR anything ,
read in copy mode,
to
.I @g@troff
output as a device control command.
.
An initial neutral double quote is stripped to allow the embedding of
leading spaces.
.
.
.TP
.BI .devicem\~ name
Write contents of macro or string
.I name
to
.I @g@troff
output as a device control command.
.
.
.TP
.BI .do\~ name\~\c
.RI [ arg \~.\|.\|.]
Interpret the string,
request,
diversion,
or macro
.I name
(along with any arguments)
with compatibility mode disabled.
.
Compatibility mode is restored
(only if it was active)
when the
.I expansion
of
.I name
is interpreted;
that is,
the restored compatibility state applies to the contents of the macro,
string,
or diversion
.I name
as well as data read from files or pipes if
.I name
is any of the
.BR so ,
.BR soquiet ,
.BR mso ,
.BR msoquiet ,
or
.B pso
requests.
.
.
.IP
For example,
.RS
.RS \" one "extra" RS to get us inboard of this indented paragraph
.EX
\&.de mac1
FOO
\&..
\&.de1 mac2
groff
\&.mac1
\&..
\&.de mac3
compatibility
\&.mac1
\&..
\&.de ma
\[rs]\[rs]$1
\&..
\&.cp 1
\&.do mac1
\&.do mac2 \[rs]" mac2, defined with .de1, calls "mac1"
\&.do mac3 \[rs]" mac3 calls "ma" with argument "c1"
\&.do mac3 \[rs][ti] \[rs]" groff syntax accepted in .do arguments
.EE
.RE
results in
.RS
.EX
FOO groff FOO compatibility c1 \[ti]
.EE
.RE
as output.
.RE \" this "extra" RE avoids indentation of the remaining paragraphs
.
.
.TP
.BI .ds1\~ "name contents"
As
.BR ds ,
but compatibility mode is disabled while
.I name
is interpreted:
a \[lq]compatibility save\[rq] token is inserted at the beginning of
.IR contents ,
and a \[lq]compatibility restore\[rq] token after it.
.
.
.TP
.B .ecr
Restore the escape character saved with
.BR ecs ,
or set escape character to
.RB \[lq]\| \[rs] \[rq]
if none has been saved.
.
.
.TP
.B .ecs
Save the current escape character.
.
.
.TP
.BI .evc\~ env
Copy the properties of environment
.I env
to the current environment,
except for the following data.
.
.
.RS
.IP \[bu] 2n
a partially collected line,
if present;
.
.
.IP \[bu]
the interruption status of the previous input line
(due to use of the
.B \[rs]c
escape sequence);
.
.
.IP \[bu]
the count of remaining lines to center,
to right-justify,
or to underline
(with or without underlined spaces)\[em]these are set to zero;
.
.
.IP \[bu]
the activation status of temporary indentation;
.
.
.IP \[bu]
input traps and their associated data;
.
.
.IP \[bu]
the activation status of line numbering
(which can be reactivated with
.RB \[lq] .nm\~+0 \[rq]);
and
.
.
.IP \[bu]
the count of consecutive hyphenated lines
(set to zero).
.RE
.
.
.TP
.BR .fam\~ [\c
.IR family ]
Set default font family to
.IR family .
.
If no argument is given,
the previous font family is selected,
or the formatter's default family if there is none.
.
The formatter's default font family is \[lq]T\[rq] (Times),
but it can be overridden by the output device\[em]see
.MR groff_font @MAN5EXT@ .
.
The default font family is associated with the environment.
.
See
.BR \[rs]F .
.
.
.TP
.BI .fchar\~ c\~contents
Define fallback
.RI character\~ c
as
.IR contents .
.
The syntax of this request is the same as the
.B char
request;
the difference is that a character defined with
.B char
hides a glyph with the same name in the selected font,
whereas characters defined with
.B fchar
are checked only if
.I c
isn't found in the selected font.
.
This test happens before special fonts are searched.
.
.
.TP
.BI .fcolor\~ color
Set the fill color to
.IR color .
.
Without an argument,
the previous fill color is selected.
.
.
.TP
.BI .fschar\~ f\~c\~contents
Define fallback special
.RI character\~ c
for font\~\c
.I f
as
.IR contents .
.
A character defined by
.B fschar
is located after the list of fonts declared with
.B \%fspecial
is searched but before those declared with the
.RB \%\[lq] special \[rq]
request.
.
.TP
.BI .fspecial\~ "f s1 s2\~"\c
\&.\|.\|.
When
.RI font\~ f
is selected,
fonts
.IR s1 ,
.IR s2 ,
\&.\|.\|.\&
are treated as special;
that is,
they are searched for glyphs not found in
.IR f .
.
Any fonts specified in the
.RB \%\[lq] special \[rq]
request are searched after
.IR s1 ,
.IR s2 ,
and so on.
.
Without
.I s
arguments,
.B \%fspecial
clears the list of fonts treated as special when
.I f
is selected.
.
.
.TP
.BI .ftr\~ f\~g
Translate
.RI font\~ f
.RI to\~ g .
.
Whenever a font
.RI named\~ f
is referred to in an
.B \[rs]f
escape sequence,
in the
.B F
and
.B S
conditional expression operators,
or in the
.BR ft ,
.BR ul ,
.BR bd ,
.BR cs ,
.BR tkf ,
.BR \%special ,
.BR \%fspecial ,
.BR fp ,
or
.B sty
requests,
.RI font\~ g
is used.
If
.I g
is missing or identical
.RI to\~ f ,
then
.RI font\~ f
is not translated.
.
.
.TP
.BI .fzoom\~ f\~zoom
Set zoom factor
.I zoom
for font\~\c
.IR f .
.I zoom
must a non-negative integer multiple of 1/1000th.
.
If it is missing or is equal to zero,
it means the same as 1000,
namely no magnification.
.
.IR f \~\c
must be a resolved font name,
not an abstract style.
.\" XXX: What about a mounting position?  It's not rejected...
.
.
.TP
.BI .gcolor\~ color
Set the stroke color to
.IR color .
.
Without an argument,
the previous stroke color is selected.
.
.
.TP
.BI .hcode\~ "c1 code1\~"\c
.RI [ "c2 code2" "] .\|.\|."
Set the hyphenation code of character
.I c1
to
.IR code1 ,
that of
.I c2
to
.IR code2 ,
and so on.
.
A hyphenation code must be an ordinary character
(not a special character escape sequence)
other than a digit.
.
The request is ignored if given no arguments.
.
.
.IP
For hyphenation to work,
hyphenation codes must be set up.
.
At startup,
.I groff
assigns hyphenation codes to the letters \[lq]a\[en]z\[rq]
(mapped to themselves),
to the letters \[lq]A\[en]Z\[rq]
(mapped to \[lq]a\[en]z\[rq]),
and zero to all other characters.
.
Normally,
hyphenation patterns contain only lowercase letters which should be
applied regardless of case.
.
In other words,
they assume that the words \[lq]ABBOT\[rq] and \[lq]Abbot\[rq] should be
hyphenated exactly as \[lq]abbot\[rq] is.
.
.B hcode
extends this principle to letters outside the Unicode basic Latin
alphabet;
without it,
words containing such letters won't be hyphenated properly even if the
corresponding hyphenation patterns contain them.
.
.
.TP
.BI .hla\~ lang
Set the hyphenation language to
.IR lang .
.
Hyphenation exceptions specified with the
.B hw
request and hyphenation patterns and exceptions specified with the
.B hpf
and
.B hpfa
requests are associated with the hyphenation language.
.
The
.B hla
request is usually invoked by a localization file,
which is in turn loaded by the
.I troffrc
or
.I troffrc\-end
file;
see the
.B hpf
request below.
.
The hyphenation language is associated with the environment.
.
.
.TP
.BR .hlm\~ [\c
.IR n ]
Set the maximum number of consecutive hyphenated lines
.RI to\~ n .
.
If
.I n
is negative,
there is no maximum.
.
If omitted,
.I n
is\~\-1.
.
This value is associated with the environment.
.
Only lines output from a given environment count towards the maximum
associated with that environment.
.
Hyphens resulting from
.B \[rs]%
are counted;
explicit hyphens are not.
.
.
.TP
.BI .hpf\~ pattern-file
Read hyphenation patterns from
.IR pattern-file .
.
This file is sought in the same way that macro files are with the
.B mso
request or the
.BI \-m name
command-line option to
.MR groff @MAN1EXT@
and
.MR @g@troff @MAN1EXT@ .
.
.
.IP
The
.I pattern-file
should have the same format as (simple) \*[tx] pattern files.
.
The following scanning rules are implemented.
.
.
.RS
.IP \[bu] 2n
A percent sign starts a comment
(up to the end of the line)
even if preceded by a backslash.
.
.
.IP \[bu]
\[lq]Digraphs\[rq] like
.B \[rs]$
are not supported.
.
.
.IP \[bu]
.RB \[lq] \[ha]\[ha]\c
.IR xx \[rq]
(where each
.I x
is 0\[en]9 or a\[en]f) and
.BI \[ha]\[ha] c
.RI (character\~ c
in the code point range 0\[en]127 decimal)
are recognized;
other uses
.RB of\~ \[ha]
cause an error.
.
.
.IP \[bu]
No macro expansion is performed.
.
.
.IP \[bu]
.B hpf
checks for the expression
.BR \[rs]patterns{ .\|.\|. }
(possibly with whitespace before or after the braces).
.
Everything between the braces is taken as hyphenation patterns.
.
Consequently,
.RB \[lq] { \[rq]
and
.RB \[lq] } \[rq]
are not allowed in patterns.
.
.
.IP \[bu]
Similarly,
.BR \[rs]hyphenation{ .\|.\|. }
gives a list of hyphenation exceptions.
.
.
.IP \[bu]
.B \[rs]endinput
is recognized also.
.
.
.IP \[bu]
For backwards compatibility,
if
.B \[rs]patterns
is missing,
the whole file is treated as a list of hyphenation patterns
(but the
.RB \[lq] % \[rq]
character is still recognized as the start of a comment).
.RE
.
.
.IP
Use the
.B hpfcode
request
(see below)
to map the encoding used in hyphenation pattern files to
.IR groff 's
input encoding.
.
.
.IP
The set of hyphenation patterns is associated with the hyphenation
language set by the
.B hla
request.
.
The
.B hpf
request is usually invoked by a localization file loaded by the
.I troffrc
file.
.
By default,
.I troffrc
loads the localization file for English.
.
(As of
.I groff
1.23.0,
localization files for Czech
.RI ( cs ),
German
.RI ( de ),
English
.RI ( en ),
French
.RI ( fr ),
Japanese
.RI ( ja ),
Swedish
.RI ( sv ),
and Chinese
.RI ( zh )
exist.)
.
For Western languages,
the localization file sets the hyphenation mode and loads hyphenation
patterns and exceptions.
.
.
.IP
A second call to
.B hpf
(for the same language)
replaces the old patterns with the new ones.
.
.
.IP
Invoking
.B hpf
causes an error if there is no hyphenation language.
.
.
.IP
If no
.B hpf
request is specified
(either in the document,
in a file loaded at startup,
or in a macro package),
GNU
.I troff \" GNU
won't automatically hyphenate at all.
.
.
.TP
.BI .hpfa\~ pattern-file
As
.BR hpf ,
except that the hyphenation patterns and exceptions from
.I pattern-file
are appended to the patterns already applied to the hyphenation language
of the environment.
.
.
.TP
.BI .hpfcode\~ "a b"\c
.RI \~[ "c d" "] .\|.\|."
Define mapping values for character codes in pattern files.
.
This is an older mechanism no longer used by
.IR groff 's
own macro files;
for its successor,
see
.B hcode
above.
.
.B hpf
or
.B hpfa
apply the mapping
after reading or appending to the active list of patterns.
.
Its arguments are pairs of character codes\[em]integers from 0 to\~255.
.
The request maps character
.RI code\~ a
to
.RI code\~ b ,
.RI code\~ c
to
.RI code\~ d ,
and so on.
.
Character codes that would otherwise be invalid in
.I groff
can be used.
.
By default,
every code maps to itself except those for letters \[lq]A\[rq] to
\[lq]Z\[rq],
which map to those for \[lq]a\[rq] to \[lq]z\[rq].
.
.
.TP
.BR .hym\~ [\c
.IR length ]
Set the (right) hyphenation margin
.RI to\~ length .
.
If the adjustment mode is not
.RB \[lq] b \[rq]
or
.RB \[lq] n \[rq],
the line is not hyphenated if it is shorter than
.IR length .
.
Without an argument,
the default hyphenation margin is reset to its default value,
0.
.
The default scaling unit
.RB is\~\[lq] m \[rq].
.
The hyphenation margin is associated with the environment.
.
A negative argument resets the hyphenation margin to zero,
emitting a warning in category
.RB \[lq] range \[rq].
.
.
.TP
.BR .hys\~ [\c
.IR hyphenation-space ]
Suppress hyphenation of the line in adjustment modes
.RB \[lq] b \[rq]
or
.RB \[lq] n \[rq],
if it can be justified by adding no more than
.I hyphenation-space
extra space to each inter-word space.
.
Without an argument,
the hyphenation space adjustment threshold is set to its default value,
0.
.
The default scaling unit
.RB is\~\[lq] m \[rq].
.
The hyphenation space adjustment threshold is associated with the
current environment.
.
A negative argument resets the hyphenation space adjustment threshold to
zero,
emitting a warning in category
.RB \[lq] range \[rq].
.
.
.TP
.BI .itc\~ n\~name
As
.RB \[lq] it \[rq],
but lines interrupted with the
.B \[rs]c
escape sequence are not applied to the line count.
.
.
.TP
.BI .kern\~ n
If
.I n
is non-zero or missing,
enable pairwise kerning
(the default),
otherwise disable it.
.
.
.TP
.BI .length\~ "reg anything"
Compute the number of characters in
.I anything
and return the count in the register
.IR reg .
.
If
.I reg
doesn't exist,
it is created.
.
.I anything
is read in copy mode.
.
.
.RS
.IP
.EX
.B .ds xxx abcd\eh\[aq]3i\[aq]efgh
.B .length yyy \e*[xxx]
.B \en[yyy]
14
.EE
.RE
.
.
.TP
.BI .linetabs\~ n
.RS
If
.I n
is non-zero or missing,
enable line-tabs mode,
otherwise disable it
(the default).
.
In this mode,
tab stops are computed relative to the start of the pending output line,
instead of the drawing position corresponding to the start of the input
line.
.
Line-tabs mode is a property of the environment.
.
.
.P
For example,
the following
.
.
.RS
.P
.ne 6v+\n(.Vu
.EX
\&.ds x a\[rs]t\[rs]c
\&.ds y b\[rs]t\[rs]c
\&.ds z c
\&.ta 1i 3i
\&\[rs]*x
\&\[rs]*y
\&\[rs]*z
.EE
.RE
.
yields
.
.RS
.EX
a         b         c
.EE
.RE
.
whereas in line-tabs mode,
the same input gives
.
.RS
.EX
a         b                   c
.EE
.RE
.
instead.
.RE
.
.
.TP
.BR .lsm\~ [\c
.IR name ]
Set the leading space macro (trap) to
.IR name .
.
If there are leading space characters on an input line,
.I name
is invoked in lieu of the usual
.I roff
behavior;
the leading spaces are removed.
.
The count of leading spaces on an input line is stored in
.BR \[rs]n[lsn] ,
and the amount of corresponding horizontal motion in
.BR \[rs]n[lss] ,
irrespective of whether a leading space trap is set.
.
When it is,
the leading spaces are removed from the input line,
and no motion is produced before calling
.IR name .
.
If no argument is supplied,
the default leading space behavior is (re-)established.
.
.
.TP
.BI .mso\~ file
As
.RB \[lq] so \[rq],
except that
.I file
is sought in the same directories as arguments to the
.MR groff @MAN1EXT@
and
.MR @g@troff @MAN1EXT@
.B \-m
command-line option are
(the \[lq]tmac path\[rq]).
.
If the file name to be interpolated has the form
.IB name .tmac
and it isn't found,
.B mso
tries to include
.BI tmac. name
instead and vice versa.
.
If
.I file
does not exist,
a warning in category
.RB \[lq] file \[rq]
is emitted
and the request has no other effect.
.
.
.TP
.BI .msoquiet\~ file
As
.BR mso ,
but no warning is emitted if
.I file
does not exist.
.
.
.TP
.BI .nop \~anything
Interpret
.I anything
as if it were an input line.
.
.B nop
resembles
.RB \[lq] ".if 1" \[rq];
it puts a break on the output if
.I anything
is empty.
.
Unlike
.RB \[lq]\| if \|\[rq],
it cannot govern conditional blocks.
.
Its application is to maintain consistent indentation within macro
definitions even when producing text lines.
.
.
.TP
.B .nroff
Make the
.B n
conditional expression evaluate true and
.B t
false.
.
See
.BR troff .
.
.
.TP
.BI .open\~ "stream file"
Open
.I file
for writing and associate
.I stream
with it.
.
See
.B write
and
.BR close .
.
.
.TP
.BI .opena\~ "stream file"
As
.BR open ,
but if
.I file
exists,
append to it instead of truncating it.
.
.
.TP
.BI .output\~ contents
Emit
.IR contents ,
which are read in copy mode,
to the formatter output;
this is similar to
.B \[rs]!\&
used in the top-level diversion.
.
An initial neutral double quote in
.I contents
is stripped to allow the embedding of leading spaces.
.\" XXX: useless request warning if no argument?
.
.
.TP
.B .pev
Report the state of the current environment followed by that of all
other environments to the standard error stream.
.
.
.TP
.B .pnr
Write the names and values of all currently defined registers to the
standard error stream.
.
.
.TP
.BI .psbb \~file
Get the bounding box of a PostScript image
.IR file .
.
This file must conform to Adobe's Document Structuring Conventions;
the request attempts to extract the bounding box values from a
.B \%%%BoundingBox
comment.
.
After invocation,
the
.I x
and
.I y
coordinates
(in PostScript units)
of the lower left and upper right corners can be found in the registers
.BR \[rs]n[llx] ,
.BR \[rs]n[lly] ,
.BR \[rs]n[urx] ,
and
.BR \[rs]n[ury] ,
respectively.
.
If an error occurs,
these four registers are set to zero.
.
.
.TP
.BI .pso \~command
As
.RB \[lq] so \[rq],
except that input comes from the standard output stream of
.IR command .
.
.
.TP
.B .ptr
Report the names and vertical positions of all page location traps
to the standard error stream.
.
Empty slots in the list are shown as well,
because they can affect the visibility of subsequently planted traps.
.
.
.TP
.BI .pvs \~\[+-]n
Set the post-vertical line spacing
.RI to\~ n ;
default scaling unit
.RB is\~\[lq] p \[rq].
.
With no argument,
the post-vertical line space is set to its previous value.
.
.
.IP
In GNU
.IR troff , \" GNU
the distance between text baselines consists of the extra pre-vertical
line spacing set by the most negative
.B \[rs]x
argument on the pending output line,
the vertical spacing
.RB ( vs ),
the extra post-vertical line spacing set by the most positive
.B \[rs]x
argument on the pending output line,
and the post-vertical line spacing set by this request.
.
.
.TP
.BI .rchar\~ c\~\c
\&.\|.\|.
Remove definition of each ordinary or special character
.IR c ,
undoing the effect of a
.BR char ,
.BR fchar ,
or
.B schar
request.
.
Glyphs,
which are defined by font description files,
cannot be removed.
.
Spaces and tabs may separate
.I c
arguments.
.
.
.TP
.B .return
Within a macro,
return immediately.
.
If called with an argument,
return twice,
namely from the current macro and from the macro one level higher.
.
No effect otherwise.
.\" XXX: useless request warning?
.
.
.TP
.BI .rfschar\~ "f c\~"\c
\&.\|.\|.
Remove each fallback special
.RI character\~ c
for font
.IR f .
.
Spaces and tabs may separate
.I c
arguments.
.
See
.BR fschar .
.
.
.TP
.BR .rj\~ [\c
.IR n ]
Right-align the
.RI next\~ n
input lines.
.
Without an argument,
right-align the next input line.
.
.B rj
implies
.RB \[lq] ".ce 0" \[rq],
and
.B ce
implies
.RB \[lq] ".rj 0" \[rq].
.
.
.TP
.BI .rnn \~r1\~r2
Rename register
.I r1
to
.IR r2 .
.
If
.I r1
doesn't exist,
the request is ignored.
.
.
.TP
.BI .schar\~ c\~contents
Define global fallback character
.I c
as
.IR contents .
.
See
.BR char ;
the distinction is that a character defined with
.B schar
is located after the list of fonts declared with the
.B \%special
request but before any mounted special fonts.
.
.
.TP
.BR .shc \~\c
.RI [ c ]
Set the soft hyphen character,
inserted when a word is hyphenated automatically or at a hyphenation
character,
.RI to\~ c .
.
If
.I c
is omitted,
the soft hyphen character is set to the default,
.BR \[rs][hy] .
.
If the selected glyph does not exist in the font in use at a potential
hyphenation point,
then the line is not broken at that point.
.
Neither character definitions
.RB ( char
and similar)
nor translations
.RB ( tr
and similar)
are considered when assigning the soft hyphen character.
.
.
.TP
.BI .shift\~ n
In a macro,
shift the arguments by
.I n
positions:
.RI argument\~ i
becomes argument
.IR i \|\-\| n ;
arguments 1
.RI to\~ n
are no longer available.
.
.RI If\~ n
is missing,
arguments are shifted by\~1.
.
No effect otherwise.
.\" XXX: useless request warning?
.
.
.TP
.BI .sizes\~ "s1 s2\~"\c
.RI .\|.\|.\~ sn\~\c
.RB [ 0 ]
Set the available type sizes to
.IR s1 ,
.IR s2 ,
\&.\|.\|.\&
.I sn
scaled points.
.
The list of sizes can be terminated by an
.RB optional\~\[lq] 0 \[rq].
.
Each
.I si
can also be a range
.IR m \(en n .
.
In contrast to the device description file directive of the same name
(see
.MR groff_font @MAN5EXT@ ),
the argument list can't extend over more than one line.
.
.
.TP
.BI .soquiet\~ file
As
.RB \[lq] so \[rq],
but no warning is emitted if
.I file
does not exist.
.
.
.TP
.BI .special\~ f\~\c
\&.\|.\|.
Declare each font
.I f
as special,
searching it for glyphs not found in the selected font.
.
Without arguments,
this list of special fonts is made empty.
.
.
.TP
.BR .spreadwarn\~ [\c
.IR limit ]
Emit a
.B break
warning if the additional space inserted for each space between words in
an output line adjusted to both margins with
.RB \[lq] .ad\~b \[rq]
is larger than or equal to
.IR limit .
.
A negative value is treated as zero;
an absent argument toggles the warning on and off without changing
.IR limit .
.
The default scaling unit is
.BR m .
.
At startup,
.B spreadwarn
is inactive and
.I limit
is 3\~m.
.
.
.IP
For example,
.RB \[lq] ".spreadwarn 0.2m" \[rq]
causes a warning if
.B break
warnings are not suppressed and
.I @g@troff
must add 0.2\~m or more for each inter-word space in a line.
.
.
.TP
.BI .stringdown \~str
.TQ
.BI .stringup \~str
Alter the string named
.I str
by replacing each of its bytes with its
lowercase
.RB ( down )
or uppercase
.RB ( up )
version
(if one exists).
.
Special characters
(see
.MR groff_char @MAN7EXT@ )
will often transform in the expected way due to the regular naming
convention for accented characters.
.
When they do not,
use substrings and/or catenation.
.
.
.IP
.RS
.RS
.EX
.B .ds resume R\e[\[aq]e]sum\e[\[aq]e]\e"
.B \e*[resume]
.B .stringdown resume
.B \e*[resume]
.B .stringup resume
.B \e*[resume]
R\['e]sum\['e] r\['e]sum\['e] R\['E]SUM\['E]
.EE
.RE
.RE
.
.
.TP
.BI .sty\~ n\~s
Associate abstract
.RI style\~ s
with font mounting
.RI position\~ n .
.
.
.TP
.BI .substring\~ "string start\~"\c
.RI [ end ]
Replace the string named
.I string
with its substring bounded by the indices
.I start
and
.IR end ,
inclusively.
.
The first character in the string has index\~0.
.
If
.I end
is omitted,
it is implicitly set to the largest valid value
(the string length minus one).
.
Negative indices count backwards from the end of the string:
the last character has index\~\-1,
the character before the last has index\~\-2,
and so on.
.
.
.RS
.IP
.EX
.B .ds xxx abcdefgh
.B .substring xxx 1 \-4
.B \e*[xxx]
bcde
.B .substring xxx 2
.B \e*[xxx]
de
.EE
.RE
.
.
.TP
.BI .tkf\~ f\~s1\~n1\~s2\~n2
Enable track kerning for font\~\c
.IR f .
When the current font is\~\c
.I f
the width of every glyph is increased by an amount between
.I n1
and
.IR n2 ;
when the current type size is less than or equal to
.I s1
the width is increased by
.IR n1 ;
when it is greater than or equal to
.I s2
the width is increased by
.IR n2 ;
when the type size is greater than or equal to
.I s1
and less than or equal to
.I s2
the increase in width is a linear function of the type size.
.
.
.TP
.BI .tm1\~ message
As
.B tm
request,
but strips a leading neutral double quote from
.I message
to allow the embedding of leading spaces.
.
.
.TP
.BI .tmc\~ message
As
.B tm1
request,
but does not append a newline.
.
.
.TP
.BI .trf\~ file
Transparently output the contents of file
.IR file .
.
Each line is output as if preceded by
.BR \[rs]! ;
however,
the lines are not subject to copy-mode interpretation.
.
If the file does not end with a newline,
then a newline is added.
.
Unlike
.BR cf ,
.I file
cannot contain characters
that are invalid as input to GNU
.IR troff . \" GNU
.
.
.IP
For example,
you can define a macro\~\c
.I x
containing the contents of file\~\c
.IR f ,
using
.
.
.RS
.IP
.ne 2v+\n(.Vu
.EX
\&.di x
\&.trf f
\&.di
.EE
.RE
.
.
.TP
.BI .trin\~ abcd
This is the same as the
.B tr
request except that the
.B asciify
request uses the character code
(if any)
before the character translation.
.
Example:
.
.
.RS
.IP
.EX
\&.trin ax
\&.di xxx
\&a
\&.br
\&.di
\&.xxx
\&.trin aa
\&.asciify xxx
\&.xxx
.EE
.RE
.
.
.IP
The result is \[lq]x\~a\[rq].
.
Using
.BR tr ,
the result would be \[lq]x\~x\[rq].
.
.
.TP
.BI .trnt\~ abcd
This is the same as the
.B tr
request except that the translations do not apply to text that is
transparently throughput into a diversion with
.BR \[rs]! .
For example,
.
.
.RS
.IP
.EX
\&.tr ab
\&.di x
\&\[rs]!.tm a
\&.di
\&.x
.EE
.RE
.
.
.IP
prints\~\c
.BR b ;
if
.B trnt
is used instead of
.B tr
it prints\~\c
.BR a .
.
.
.TP
.B .troff
Make the
.B t
conditional expression evaluate true and
.B n
false.
.
See
.BR nroff .
.
.
.TP
.BI .unformat\~ div
Unformat the diversion
.IR div .
.
Unlike
.BR asciify ,
.B unformat
handles only tabs and spaces between words,
the latter usually arising from spaces or newlines in the input.
.
Tabs are treated as input tokens,
and spaces become adjustable again.
.
The vertical sizes of lines are not preserved,
but glyph information
(font,
type size,
space width,
and so on)
is retained.
.
.
.TP
.BI .vpt\~ n
If
.I n
is non-zero or missing,
enable vertical position traps
(the default),
otherwise disable them.
.
Vertical position traps are those set by the
.BR ch ,
.BR wh ,
and
.B dt
requests.
.
.
.TP
.BR .warn\~ [\c
.IR n ]
Select the categories,
or \[lq]types\[rq],
of reported warnings.
.
.IR n \~is
the sum of the numeric codes associated with each warning category that
is to be enabled;
all other categories are disabled.
.
The categories and their associated codes are listed in section
\[lq]Warnings\[rq] of
.MR @g@troff @MAN1EXT@ .
.\" TODO: Maybe move that table to groff(7).
.
For example,
.RB \[lq] ".warn 0" \[rq]
disables all warnings,
and
.RB \[lq] ".warn 1" \[rq]
disables all warnings except those about missing glyphs.
.
If no argument is given,
all warning categories are enabled.
.
.
.TP
.BI .warnscale\~ si
Set the scaling unit used in warnings to
.IR si .
.
Valid values for
.I si
are
.BR u ,
.B i
(the default),
.BR c ,
.BR p ,
.RB and\~ P .
.
.
.TP
.BI .while \~cond-expr\~anything
Evaluate the conditional expression
.IR cond-expr ,
and repeatedly execute
.I anything
unless and until
.I cond-expr
evaluates false.
.
.I anything,
which is often a conditional block,
is referred to as the
.B while
request's
.I body.
.
.
.IP
.I @g@troff
treats the body of a
.B while
request similarly to that of a
.B de
request
(albeit one not read in copy mode),
but stores it under an internal name and deletes it when the loop
finishes.
.
The operation of a macro containing a
.B while
request can slow significantly if the
.B while
body is large.
.
Each time the macro is executed,
the
.B while
body is parsed and stored again.
.
An often better solution\[em]and one that is more portable,
since AT&T
.I troff \" AT&T
lacked the
.B while
request\[em]is to instead write a recursive macro.
.
It will be parsed only once (unless you redefine it).
.
To prevent infinite loops,
the default number of available recursion levels is 1,000 or somewhat
less (because things other than macro calls can be on the input stack).
.
You can disable this protective measure,
or raise the limit,
by setting the
.B slimit
register.
.
See section \[lq]Debugging\[rq] below.
.
.
.IP
If a
.B while
body begins with a conditional block,
its closing brace must end an input line.
.
.
.IP
The
.B break
and
.B continue
requests alter a
.B while
loop's flow of control.
.
.
.TP
.BI .write\~ stream\~anything
Write
.I anything
to
.IR stream ,
which must previously have been the subject of an
.B open
request,
followed by a newline.
.
.I anything
is read in copy mode.
.
An initial neutral double quote in
.I anything
is stripped to allow the embedding of leading spaces.
.
.
.TP
.BI .writec\~ stream\~anything
As
.BR write ,
but without a trailing newline.
.
.
.TP
.BI .writem\~ "stream name"
Write the contents of the macro or string
.I name
to
.IR stream ,
which must previously have been the subject of an
.B open
request.
.
.I name
is read in copy mode.
.
.
.br
.ne 6v
.\" ====================================================================
.SS "Extended requests"
.\" ====================================================================
.
.\" XXX: .cf might better belong in "Implementation differences".
.TP
.BI .cf\~ file
In a diversion,
embed an object which,
when reread,
will cause the contents of
.I file
to be copied verbatim to the output.
.
In AT&T
.IR troff ,
the contents of
.I file
are immediately copied to the output regardless of whether a diversion
is being written to;
this behavior is so anomalous that it must be considered a bug.
.
.
.TP
.BI .de\~ name\~\c
.RI [ end-name ]
.TQ
.BI .am\~ name\~\c
.RI [ end-name ]
.TQ
.BI .ds\~ name\~\c
.RI [ contents ]
.TQ
.BI .as\~ name\~\c
.RI [ contents ]
In compatibility mode,
these requests behave similarly to
.BR de1 ,
.BR am1 ,
.BR ds1 ,
and
.BR as1 ,
respectively:
a \[lq]compatibility save\[rq] token is inserted at the beginning,
and a \[lq]compatibility restore\[rq] token at the end,
with compatibility mode switched on during execution.
.
.
.TP
.BI .hy\~ n
New values 16 and\~32 are available;
the former enables hyphenation before the last character in a word,
and the latter enables hyphenation after the first character in a word.
.
.
.TP
.BI .ss\~ word-space-size\~\c
.RI [ additional-sentence-space-size ]
A second argument sets the amount of additional space separating
sentences on the same output line.
.
If omitted,
this amount is set to
.IR word-space-size .
.
Both arguments are in twelfths of current font's space width
(typically one-fourth to one-third em for Western scripts;
see
.MR groff_font @MAN5EXT@ ).
.
The default for both parameters is\~12.
.
Negative values are erroneous.
.
.
.TP
.BR .ta\~ [[\c
.IR "n1 n2\~" .\|.\|.\~ nn \~]\c
.BR T \~\c \" space in roman because we must use 2-font macro with \c
.IR "r1 r2\~" .\|.\|.\~ rn ]
.I groff
supports an extended syntax to specify repeating tab stops after
the
.RB \[lq] T \[rq]
mark.
.
These values are always taken as relative distances from the previous
tab stop.
.
This is the idiomatic way to specify tab stops at equal intervals in
.IR groff .
.
.
.IP
The syntax summary above instructs
.I groff
to set tabs at positions
.IR n1 ,
.IR n2 ,
\&.\|.\|.\|,
.IR nn ,
then at
.IR nn \|+\| r1 ,
.IR nn \|+\| r2 ,
\&.\|.\|.\|,
.IR nn \|+\| rn ,
then at
.IR nn \|+\| rn \|+\| r1 ,
.IR nn \|+\| rn \|+\| r2 ,
\&.\|.\|.\|,
.IR nn \|+\| rn \|+\| rn ,
and so on.
.
.
.\" ====================================================================
.SS "New registers"
.\" ====================================================================
.
GNU
.I troff \" GNU
exposes more formatter state via many new read-only registers.
.
Their names often correspond to the requests that affect them.
.
.
.TP 12n
.B \[rs]n[.br]
Within a macro call,
interpolate\~1
if the macro is called with the \[lq]normal\[rq] control character
(\[lq].\[rq] by default),
and\~0 otherwise.
.
This facility allows the reliable modification of requests.
.
Using this register outside of a macro definition makes no sense.
.
.
.RS
.IP
.ne 6v+\n(.Vu
.EX
\&.als bp*orig bp
\&.de bp
\&.tm before bp
\&.ie \[rs]\[rs]n[.br] .bp*orig
\&.el \[aq]bp*orig
\&.tm after bp
\&..
.EE
.RE
.
.
.TP
.B \[rs]n[.C]
Interpolate 1\~if compatibility mode is in effect,
0\~otherwise.
.
See
.BR cp .
.
.
.TP
.B \[rs]n[.cdp]
Interpolate depth of last glyph added to the environment.
.
It is positive if the glyph extends below the baseline.
.
.
.TP
.B \[rs]n[.ce]
Interpolate number of input lines remaining to be centered.
.
.
.TP
.B \[rs]n[.cht]
Interpolate height of last glyph added to the environment.
.
It is positive if the glyph extends above the baseline.
.
.
.TP
.B \[rs]n[.color]
Interpolate 1\~if colors are enabled,
0\~otherwise.
.
.
.TP
.B \[rs]n[.cp]
Within a
.RB \[lq] do \[rq]
request,
interpolate the saved value of compatibility mode
(see
.B \[rs]n[.C]
above).
.
.
.TP
.B \[rs]n[.csk]
Interpolate skew of last glyph added to the environment.
.
The
.I skew
of a glyph is how far to the right of the center of a glyph the center
of an accent over that glyph should be placed.
.
.
.TP
.B \[rs]n[.ev]
Interpolate name of current environment.
.
This is a string-valued register.
.
.
.TP
.B \[rs]n[.fam]
Interpolate name of default font family.
.
This is a string-valued register.
.
.
.TP
.B \[rs]n[.fn]
Interpolate resolved name of the selected font.
.
This is a string-valued register.
.
.
.TP
.B \[rs]n[.fp]
Interpolate next free font mounting position.
.
.
.TP
.B \[rs]n[.g]
Interpolate\~1.
.
Test with
.RB \[lq]\| if \|\[rq]
or
.B ie
to check whether GNU
.I troff \" GNU
is the formatter.
.
.
.TP
.B \[rs]n[.height]
Interpolate font height.
.
See
.BR \[rs]H .
.
.
.TP
.B \[rs]n[.hla]
Interpolate hyphenation language of the environment.
.
This is a string-valued register.
.
.
.TP
.B \[rs]n[.hlc]
Interpolate count of immediately preceding consecutive hyphenated lines
in the environment.
.
.
.TP
.B \[rs]n[.hlm]
Interpolate maximum number of consecutive hyphenated lines allowed in
the environment.
.
.
.TP
.B \[rs]n[.hy]
Interpolate hyphenation mode of the environment.
.
.
.TP
.B \[rs]n[.hym]
Inteprolate hyphenation margin of the environment.
.
.
.TP
.B \[rs]n[.hys]
Interpolate hyphenation space adjustment threshold of the environment.
.
.
.TP
.B \[rs]n[.in]
Interpolate indentation amount applicable to the pending output line.
.
.
.TP
.B \[rs]n[.int]
Interpolate\~1 if the previous output line was interrupted
(ended with
.BR \[rs]c ),
0\~otherwise.
.
.
.TP
.B \[rs]n[.kern]
Interpolate\~1 if pairwise kerning is enabled,
0\~otherwise.
.
.
.TP
.B \[rs]n[.lg]
Interpolate ligature mode.
.
.
.TP
.B \[rs]n[.linetabs]
Interpolate\~1 if line-tabs mode is enabled,
0\~otherwise.
.
.
.TP
.B \[rs]n[.ll]
Interpolate line length applicable to the pending output line.
.
.
.TP
.B \[rs]n[.lt]
Interpolate title line length.
.
.
.TP
.B \[rs]n[.m]
Interpolate name of the selected stroke color.
.
This is a string-valued register.
.
.
.TP
.B \[rs]n[.M]
Interpolate name of the selected fill color.
.
This is a string-valued register.
.
.
.TP
.B \[rs]n[.ne]
Interpolate amount of space demanded by the most recent
.B ne
request that caused a page location trap to be sprung.
.
See
.BR \[rs]n[.trunc] .
.
.
.TP
.B \[rs]n[.nm]
Interpolate\~1 if output line numbering is enabled
(even if temporarily suppressed),
0\~otherwise.
.
.
.TP
.B \[rs]n[.ns]
Interpolate\~1 if no-space mode is enabled,
0\~otherwise.
.
.
.TP
.B \[rs]n[.O]
Interpolate output suppression level.
.
See
.BR \[rs]O .
.
.
.TP
.B \[rs]n[.P]
Interpolate\~1 if the current page is selected for output.
.
See
.B \-o
command-line option to
.MR @g@troff @MAN1EXT@ .
.
.
.TP
.B \[rs]n[.pe]
Interpolate\~1 during page ejection,
0\~otherwise.
.
.
.TP
.B \[rs]n[.pn]
Interpolate next page number
(either that set by
.BR pn ,
or that of the current page plus\~1).
.
.
.TP
.B \[rs]n[.ps]
Interpolate type size in scaled points.
.
.
.TP
.B \[rs]n[.psr]
Interpolate most recently requested type size in scaled points.
.
.
.TP
.B \[rs]n[.pvs]
Interpolate post-vertical line spacing amount.
.
.
.TP
.B \[rs]n[.rj]
Interpolate number of input lines remaining to be right-aligned.
.
.
.TP
.B \[rs]n[.slant]
Interpolate font slant.
.
See
.BR \[rs]S .
.
.
.TP
.B \[rs]n[.sr]
Interpolate most recently requested type size in points as a decimal
fraction.
.
This is a string-valued register.
.
.
.TP
.B \[rs]n[.ss]
.TQ
.B \[rs]n[.sss]
Interpolate values of minimal inter-word space and additional
inter-sentence space,
respectively,
in twelfths of the space width of the selected font.
.
.
.TP
.B \[rs]n[.sty]
Interpolate selected abstract font style,
if any.
.
This is a string-valued register.
.
.
.TP
.B \[rs]n[.tabs]
Interpolate representation of the tab stop settings in a form suitable
for passage to the
.B ta
request.
.
.
.TP
.B \[rs]n[.trunc]
Interpolate amount of vertical space truncated by the most recently
sprung page location trap,
or,
if the trap was sprung by an
.B ne
request,
minus the amount of vertical motion produced by the
.B ne
request.
.
In other words,
at the point a trap is sprung,
.B \[rs]n[.trunc]
represents the difference of what the vertical position would have
been but for the trap,
and what the vertical position actually is.
.
See
.BR \[rs]n[.ne] .
.
.
.TP
.B \[rs]n[.U]
Interpolate\~1 if in unsafe mode,
0\~otherwise.
.
See
.B \-U
command-line option to
.MR @g@troff @MAN1EXT@ .
.
.
.TP
.B \[rs]n[.vpt]
Interpolate\~1 if vertical position traps are enabled,
0\~otherwise.
.
.
.TP
.B \[rs]n[.warn]
Interpolate warning mode.
.
See section \[lq]Warnings\[rq] of
.MR @g@troff @MAN1EXT@ .
.\" TODO: Maybe move that table to groff(7).
.
.
.TP
.B \[rs]n[.x]
Interpolate major version number of the running
.I @g@troff
formatter.
.
For example,
if the version number is 1.23.0,
then
.B \[rs]n[.x]
contains\~1.
.
.
.TP
.B \[rs]n[.y]
Interpolate minor version number of the running
.I @g@troff
formatter.
.
For example,
if the version number is 1.23.0,
then
.B \[rs]n[.y]
contains\~23.
.
.
.TP
.B \[rs]n[.Y]
Interpolate revision number of the running
.I @g@troff
formatter.
.
For example,
if the version number is 1.23.0,
then
.B \[rs]n[.Y]
contains\~0.
.
.
.TP
.B \[rs]n[.zoom]
Interpolate magnification of font,
in thousandths,
or\~0 if magnification unused.
.
See
.BR fzoom .
.
.
.P
The following (writable) registers are set by the
.B psbb
request.
.
.
.TP
.B \[rs]n[llx]
.TQ
.B \[rs]n[lly]
.TQ
.B \[rs]n[urx]
.TQ
.B \[rs]n[ury]
Interpolate the
(upper,
lower,
left,
right)
bounding box values
(in PostScript units) of the most recently processed PostScript image.
.
.
.P
The following (writable) registers are set by the
.B \[rs]w
escape sequence.
.
.
.TP 8n
.B \[rs]n[rst]
.TQ
.B \[rs]n[rsb]
Like
.B \[rs]n[st]
and
.BR \[rs]n[sb] ,
but taking account of the heights and depths of glyphs.
.
In other words,
these registers store the highest and lowest vertical positions attained
by the argument formatted by the
.B \[rs]w
escape sequence,
doing what AT&T
.I troff \" AT&T
documented
.B \[rs]n[st]
and
.B \[rs]n[sb]
as doing.
.
.
.TP
.B \[rs]n[ssc]
The amount of horizontal space (possibly negative) that should be
added to the last glyph before a subscript.
.
.
.TP
.B \[rs]n[skw]
How far to right of the center of the last glyph in the
.B \[rs]w
argument,
the center of an accent from a roman font should be placed
over that glyph.
.
.
.P
Other writable registers are as follows.
.
Those relating to date and time are initialized using
.MR localtime 3
at formatter startup.
.
.
.\" The `c.` register was documented in the January 1981 "Addendum to
.\" the Nroff/Troff User's Manual" (presumably by Kernighan), and is
.\" widely supported by descendants of his device-independent troff, but
.\" appears to have been overlooked in his 1992 revision of CSTR #54.
.TP 12n
.B \[rs]n[c.]
Interpolate input line number.
.
.B \[rs]n[.c]
is a read-only alias of this register.
.
.
.TP
.B \[rs]n[hours]
Interpolate number of hours elapsed since midnight.
.
.
.TP
.B \[rs]n[hp]
Interpolate horizontal position relative to that at the start of the
input line.
.
.
.br
.ne 3v
.TP
.B \[rs]n[lsn]
.TQ
.B \[rs]n[lss]
Interpolate count of leading spaces on input line and amount of
corresponding horizontal motion,
respectively.
.
.
.TP
.B \[rs]n[minutes]
Interpolate number of minutes elapsed in the hour.
.
.
.TP
.B \[rs]n[seconds]
Interpolate number of seconds elapsed in the minute.
.
.
.TP
.B \[rs]n[systat]
Interpolate return value of
.MR system 3
function executed by most recent
.B sy
request.
.
.
.TP
.B \[rs]n[slimit]
Interpolates maximum quantity of objects on
.IR @g@troff 's
internal input stack
(default: 1000).
.
If non-positive,
there is no limit:
recursion can continue until program memory is exhausted.
.
.
.TP
.B \[rs]n[year]
Interpolate Gregorian year.
.
AT&T
.IR troff 's \" AT&T
.B \[rs][yr]
interpolates the Gregorian year minus 1900.
.
.
.\" ====================================================================
.SS Miscellaneous
.\" ====================================================================
.
GNU
.I troff \" GNU
predefines one string,
.BR .T ,
containing the argument given to the
.B \-T
command-line option,
namely the output device
(for example,
.B pdf
or
.BR utf8 ).
.
The (read-only)
.I register
.B .T
interpolates\~1 if GNU
.I troff \" GNU
is run with the
.B \-T
command-line option,
and 0\~otherwise.
.
.
.P
A font not listed in the output device's
.I DESC
file's
.B fonts
directive is automatically mounted at the next available font position
when it is selected.
.
If you mount a font explicitly with the
.B fp
request,
you should do so on the first unused position,
which can be found in the
.B .fp
register.
.
.
.P
Unparameterized string interpolation does not conceal the arguments to a
macro being interpreted.
.
Thus,
in a macro definition,
the call of another macro with the existing argument list,
.
.RS
.EX
.BI . xx\~ \[rs]\[rs]$@
.EE
.RE
.
is more efficiently done with
.
.RS
.EX
.BI \[rs]\[rs]*[ xx ]\[rs]\[rs]
.EE
.RE
.
(that is,
with string interpolation).
.
The trailing backslashes prevent the final newline in the macro
definition from being interpolated,
potentially putting an unwanted blank line on the output.
.
See section \[lq]Punning Names\[rq] in
.MR groff @MAN7EXT@ .
.
.
.\" XXX: Is this really not an AT&T troff feature?
.P
If a font description file contains pairwise kerning information,
glyphs from that font are kerned.
.
Kerning between two glyphs can be inhibited by placing a dummy character
.B \[rs]&
between them.
.
.
.P
GNU
.I troff \" GNU
keeps track of the nesting depth of escape sequence
interpolations and other uses of delimiters,
as in the
.B tl
request and the output comparison operator
(that is,
input like
.B \[aq]foo\[aq]bar\[aq]
as a conditional expression),
so the only characters you need to avoid using as
delimiters are those that appear in the arguments you input,
not any that result from interpolation.
.
Typically,
.B \[aq]
works fine.
.
Use visible characters as delimiters in GNU
.IR troff , \" GNU
not \[lq]ASCII\[rq] controls like BEL (Control+G).
.
The implementation of
.B \[rs]$@
ensures that the double quotes surrounding an argument appear at an
interpolation depth different from that of the arguments themselves.
.
Similarly,
in bracket-form escape sequences like
.B \[rs]f[ZCMI],
a right bracket
.B ]
does not end the sequence unless it occurs at the same interpolation
depth as the
.RB opening\~ [ ,
so input like
.
.RS
.EX
\[rs]f[\[rs]*[my-family]\[rs]*[my-style]]
.EE
.RE
.
works as desired.
.
In compatibility mode,
no attention is paid to the interpolation depth.
.
.
.P
In
GNU
.IR troff , \" GNU
the
.B tr
request can map characters to the unbreakable space escape sequence
.B \[rs]\[ti]
as a special case
.RB ( tr
normally operates only on
.IR characters ).
.
This feature replaces the odd-parity
.B tr
mapping trick used in AT&T
.I troff \" AT&T
documents,
where a character,
often
.BR \[ti] ,
was \[lq]sacrificed\[rq] by mapping it to \[lq]nothing\[rq],
drafting it into use as an unadjustable,
unbreakable space.
.
(This feature was gratuitous even in early AT&T
.I troff, \" AT&T
which supported the
.BI \[rs] space
escape sequence by 1976.) \" see CSTR #54 of that year
.
Often,
it makes more sense to use
GNU
.IR troff 's \" GNU
.B \[rs]\[ti]
escape sequence instead,
which has been adopted by every other active
.I troff
implementation except that of Illumos,
as well as by the
.RI non -troff
.IR mandoc .
.
Translation of a character to
.B \[rs]\[ti]
is unnecessary.
.
.
.P
GNU
.I troff \" GNU
permits tabs and spaces after the first dot on a control line that ends
a macro definition.
.
.RS
.ne 5v+\n(.Vu
.EX
\&.if t \[rs]{\[rs]
\&.\&  de bar
\&.\&    nop Hello, I\[aq]m \[aq]bar\[aq].
\&.\&  .
\&.\[rs]}
.EE
.RS
.
.
.\" ====================================================================
.SH "Formatter output"
.\" ====================================================================
.
The page description language output by GNU
.I troff \" GNU
is modeled after that used by AT&T
.I troff \" AT&T
once the latter adopted a device-independent approach in the early
1980s.
.
Only the differences are documented here.
.
For a fuller discussion,
see
.MR groff_out @MAN5EXT@ .
.\"
.\"
.\" XXX: This feature is unused and documenting it gives a valuable
.\" hostage to fortune.
.\".P
.\"Note that single characters can have the eighth bit set, as can the
.\"names of fonts and special characters.
.
.
.P
Glyph and font names can be of arbitrary length;
postprocessors should not assume that they are at most two characters.
.
A glyph to be formatted is always drawn from the current font;
in contrast to AT&T device-independent
.IR troff , \" AT&T
drivers need not search special fonts to find a glyph.
.
.
.\" ====================================================================
.SS Units
.\" ====================================================================
.
The argument to the
.BR s \~command
is in scaled points
(units of
.RI points/ n ,
where
.I n
is the argument to the
.B sizescale
command in the
.I DESC
file).
.
The argument to the
.RB \[lq] "x H" \[rq]
command is also in scaled points.
.
.
.\" ====================================================================
.SS "Simple commands"
.\" ====================================================================
.
.\" BEGIN Keep in sync with relevant portions of section "Simple
.\" commands" from groff_out(5).
.P
If the
.B tcommand
directive is present in the output device's
.I DESC
file,
GNU
.I troff \" GNU
employs the following two commands.
.
.
.TP
.BI t\~ xyz\c
\&.\|.\|.
Typeset word
.IR xyz ;
that is,
set a sequence of ordinary glyphs named
.IR x ,
.IR y ,
.IR z ,
\&.\|.\|.\|,
terminated by a space or newline;
an optional second integer argument is ignored
(this allows the formatter to generate an even number of arguments).
.\" XXX: Why?
.
Each glyph is set at the current drawing position,
and the position is then advanced horizontally by the glyph's width.
.
A glyph's width is read from its metrics in the font description file,
scaled to the current type size,
and rounded to a multiple of the horizontal motion quantum.
.
Use the
.B C
command to emplace glyphs of special characters.
.
.
.TP
.BI u\~ "n xyz"\c
\&.\|.\|.
Typeset word
.I xyz
with track kerning.
.
As
.BR t ,
but after placing each glyph,
the drawing position is further advanced horizontally
.RI by\~ n
basic units.
.\" END Keep in sync with relevant portions of section "Simple commands"
.\" from groff_out(5).
.
.
.P
New commands implement color support.
.
.
.TP
.BI mc\~ "cyan magenta yellow"
.TQ
.B md
.TQ
.BI mg\~ gray
.TQ
.BI mk\~ "cyan magenta yellow black"
.TQ
.BI mr\~ "red green blue"
Set the components of the stroke color with respect to various color
spaces.
.
.B md
resets the stroke color to the default value.
.
The arguments are integers in the range 0 to 65535.
.
.
.P
A new device control subcommand is available.
.
.
.TP
.BI "x u\~" n
If
.I n
is\~1,
start underlining of spaces.
.
If
.I n
is\~0,
stop underlining of spaces.
.
This facility is needed for the
.B cu
request in
.I nroff \" mode
mode and is ignored otherwise.
.
.
.\" ====================================================================
.SS "Extended drawing commands"
.\" ====================================================================
.
GNU
.I pic \" GNU
does not produce
.I @g@troff
escape sequences employing these extensions if its
.B \-n
option is given.
.
.
.TP
.BI Df\~ n
Set the shade of gray used to fill geometric objects to
.IR n ,
which must be an integer.
.
0 corresponds to white and 1000 to black.
.
A grayscale ramp spans the two.
.
A value outside this range uses the stroke color as the fill color.
.
The fill color is opaque.
.
Normally the default is black,
but some drivers may provide a way of changing this.
.
.B Df
is obsolete since 2002, \" commit ea5a42d080, 2002-01-24
superseded by
.B DFg
below.
.
.
.IP
The corresponding
.B \[rs]D\[aq]f\^\[aq]
escape sequence should not be used:
its argument is rounded to an integer multiple of the horizontal motion
quantum,
which can limit the precision
.RI of\~ n .
.
.
.TP
.BI DC\~ d
Draw a filled circle of diameter
.I d
with its leftmost point at the drawing position.
.
.
.TP
.BI DE\~ "h v"
Draw a filled ellipse,
of horizontal axis
.I h
and vertical axis
.IR v ,
with its leftmost point at the drawing position.
.
.
.br
.ne 4v
.EQ
delim $$
.EN
.TP
.\" `BR`, not `BI`, here, because eqn will take care of font changes.
.BR Dp\~ "$dx sub 1 ~ dy sub 1 ~ ldots ~ dx sub n ~ dy sub n$"
Draw a polygon with,
for $i = 1 , ldots , n + 1$,
its
.IR i th
vertex at the drawing position
.
$+ sum from { j = 1 } to { i - 1 } ( dx sub j , dy sub j )$.
.
.\" The following is implied by the math above, but let's be kind.
.I groff
output drivers automatically close polygons,
drawing a line from $( dx sub n , dy sub n )$ back to
$( dx sub 1 , dy sub 1 )$.
.
The drawing position is left at the last
.I specified
vertex,
but this may change in a future version of GNU
.IR troff . \" GNU
.
Heirloom Doctools
.IR troff , \" Heirloom
like DWB
.IR troff , \" DWB
by default does not close the polygon.
.
In its
.I groff
compatibility mode,
Heirloom closes the polygon but leaves the drawing position
.IR unchanged \[em]that
is,
at the polygon's
.I initial
drawing position.
.
.
.IP
At the moment,
GNU
.I pic \" GNU
uses this command only to generate triangles and rectangles.
.
.
.TP
.BR DP\~ "$dx sub 1 ~ dy sub 1 ~ ldots ~ dx sub n ~ dy sub n$"
As
.BR Dp ,
but draw a filled rather than a stroked polygon.
.
.
.TP
.BI Dt\~ n
Set the line thickness to
.IR n \~\c
basic units.
.
AT&T
.I troff \" AT&T
output drivers use a thickness proportional to the type size;
this is the GNU
.I troff \" GNU
default.
.
A
.RI negative\~ n
requests this explicitly.
.
.RI An\~ n
of zero selects the smallest available line thickness.
.
.
.P
A difficulty arises in how the drawing position should be changed after
the execution of these commands.
.
This has little importance to most users,
since the output of GNU
.I grn \" GNU
and
.I pic \" GNU
does not depend on it.
.
Given a drawing command of the form
.BI D z
$x sub 1 ~ y sub 1 ~ ldots ~ x sub n ~ y sub n$,
where
.I z
is not
.B c
or
.BR e ,
AT&T
.I troff \" AT&T
treats each $x sub i$ as a horizontal motion,
each $y sub i$ as a vertical one,
and therefore assumes that the width of the drawn object is
$sum from { i = 1 } to n x sub i$,
and its height is $sum from { i = 1 } to n y sub i$.
.
(Verify its assumption about height by examining the
.B st
and
.B sb
registers after using such a drawing command in a
.B \[rs]w
escape sequence).
.
For the sake of compatibility,
GNU
.I troff \" GNU
also follows this rule,
even though it frustrates extensions to the
.B D
command that set drawing parameters rather than rendering objects,
producing ugly results in the case of
.B Dt
and
.BR Df ,
or otherwise don't parameterize objects as a series of vertices,
as with
GNU
.IR troff 's \" GNU
filled ellipse,
.BR DE .
.
Thus after executing a
.BR D \~command
of the form
.BI D z
$x sub 1 ~ y sub 1 ~ ldots ~ x sub n ~ y sub n$,
the drawing position should be increased by
.
$( sum from { i = 1 } to n x sub i , sum from { i = 1 } to n y sub i )$.
.EQ
delim off
.EN
.
In a future release,
GNU
.I troff \" GNU
and its output drivers may abandon the application of this assumption to
drawing commands not explicitly specified in the AT&T \[lq]Troff User's
Manual\[rq].
.
.
.P
Fill color selection is implemented with another set of extensions.
.
.
.TP
.BI DFc\~ "cyan magenta yellow"
.TQ
.B DFd
.TQ
.BI DFg\~ gray
.TQ
.BI DFk\~ "cyan magenta yellow black"
.TQ
.BI DFr\~ "red green blue"
Set the components of the fill color as described under the
.B \[rs]M
escape sequence above.
.
.B DFd
restores the device's default fill color.
.
The drawing position is not updated,
in contrast to
.BR Df .
.
.
.\" ====================================================================
.SS "Device control syntax extension"
.\" ====================================================================
.
GNU
.I troff \" GNU
introduces a line continuation convention,
permitting the argument to the
.B x X
command to contain newlines.
.
A newline in the input is transformed to the sequence
.RI \[lq] newline\c
.BR + \[rq].
.
When interpreting an
.B x X
command,
a postprocessor should therefore be prepared for a plus sign after a
newline;
if it occurs,
preserve the newline,
discard the plus sign,
and continue to collect the input into the argument of the
.B x X
command.
.
A newline
.I not
followed by a plus sign terminates the
.B x X
command.
.
An application of this feature is the embedding of PostScript or PDF
language command streams into
.I troff \"
output.
.
.
.P
GNU
.I troff \" GNU
guarantees that the first three output commands it emits are as follows.
.
.
.P
.RS
.EX
.RI x\~T\~ device
.RI x\~res\~ n\~h\~v
x init
.EE
.RE
.
.
.br
.ne 4v
.\" ====================================================================
.SH Debugging
.\" ====================================================================
.
In addition to AT&T
.IR troff 's \" AT&T
debugging features,
GNU
.I troff \" GNU
emits more error diagnostics when syntactical or semantic nonsense is
encountered and supports several warning categories;
the output of these can be selected with
.BR warn .
.
Also see the
.BR \-E ,
.BR \-w ,
and
.B \-W
options of
.MR @g@troff @MAN1EXT@ .
.
Backtraces can be automatically produced when errors or warnings occur
(the
.B \-b
option of
.MR @g@troff @MAN1EXT@ )
or generated on demand
.RB ( backtrace ).
.
.
.P
.I groff
also adds more flexible diagnostic output requests
.RB ( tmc
and
.BR tm1 ).
.
More aspects of formatter state can be examined with requests that write
lists of
defined registers
.RB ( pnr ),
environments
.RB ( pev ),
and page location traps
.RB ( ptr )
to the standard error stream.
.
.
.\" ====================================================================
.SH "Implementation differences"
.\" ====================================================================
.
.\" TODO: Resync with the node of this name in our Texinfo manual.
GNU
.IR troff 's \" GNU
features sometimes cause incompatibilities with documents written
assuming old implementations of
.IR troff . \" generic
.
Some GNU extensions to
.I troff \" generic
are supported by other implementations.
.
.
.P
When adjusting to both margins,
AT&T
.I troff \" AT&T
at first adjusts spaces starting from the right;
GNU
.I troff \" GNU
begins from the left.
.
Both implementations adjust spaces from opposite ends on alternating
output lines to prevent \[lq]rivers\[rq] in the text.
.
.
.P
GNU
.I troff \" GNU
does not always hyphenate words as AT&T
.I troff \" AT&T
does.
.
The AT&T implementation uses a set of hard-coded rules specific to
U.S.\& English,
while GNU
.I troff \" GNU
uses language-specific hyphenation pattern files derived from \*[tx].
.
In some versions of
.I troff \" generic
there was limited space to store hyphenation exceptions
(arguments to the
.B hw
request);
GNU
.I troff \" GNU
has no such restriction.
.
.
.P
Long names may be GNU
.IR troff 's \" GNU
most obvious innovation.
.
AT&T
.I troff \" AT&T
interprets
.RB \[lq] .dsabcd \[rq]
as defining a string
.RB \[lq] ab \[rq]
with contents
.RB \[lq] cd \[rq].
.
Normally,
GNU
.I troff \" GNU
interprets this as a call of a macro named
.RB \[lq] dsabcd \[rq].
.
AT&T
.I troff \" AT&T
also interprets
.B \[rs]*[
and
.B \[rs]n[
as an interpolation of a string or register,
respectively,
called
.RB \[lq] [ \[rq].
.
In GNU
.IR troff , \" GNU
however,
the
.RB \[lq] [ \[rq]
is normally interpreted as beginning the enclosure of a long identifier.
.
In compatibility mode,
GNU
.I troff \" GNU
interprets names in the traditional way,
which means that they are limited to one or two characters.
.
See the
.B \-C
option in
.MR @g@troff @MAN1EXT@
and,
above,
the
.B .C
and
.B .cp
registers,
and
.B cp
and
.RB \[lq] do \[rq]
requests,
for more on compatibility mode.
.
.
.P
The register
.B \[rs]n[.cp]
is specialized and may require a statement of rationale.
.
When writing macro packages or documents that use GNU
.I troff \" GNU
features and which may be mixed with other packages or documents that do
not\[em]common scenarios include serial processing of man pages or use
of the
.RB \[lq] so \[rq]
or
.B mso
requests\[em]you may desire correct operation regardless of
compatibility mode enablement in the surrounding context.
.
It may occur to you to save the existing value of
.B \[rs]n(.C
into a register,
say,
.BR _C ,
at the beginning of your file,
turn compatibility mode off with
.RB \[lq] .cp\~0 \[rq],
then restore it from that register at the end with
.RB \[lq] .cp\~\[rs]n(_C \[rq].
.
At the same time,
a modular design of a document or macro package may lead you to multiple
layers of inclusion.
.
You cannot use the same register name everywhere lest you
\[lq]clobber\[rq] the value from a preceding or enclosing context.
.
The two-character register name space of AT&T
.I troff \" AT&T
is confining and mnemonically challenging;
you may wish to use
GNU
.IR troff 's \" GNU
more capacious name space.
.
However,
attempting
.RB \[lq] ".nr _my_saved_C \[rs]n(.C" \[rq]
will not work in compatibility mode;
the register name is too long.
.
\[lq]This is exactly what
.B .do
is for,\[rq] you think,
.RB \[lq] ".do nr _my_saved_C \[rs]n(.C" \[rq].
.
The foregoing will always save zero to your register,
because
.RB \[lq] do \[rq]
turns compatibility mode
.I off
while it interprets its argument list.
.
What you need is:
.
.RS
.EX
\&.do nr _my_saved_C \[rs]n[.cp]
\&.cp 0
.EE
.RE
.
at the beginning of your file,
followed by
.RS
.EX
\&.cp \[rs]n[_my_saved_C]
\&.do rr _my_saved_C
.EE
.RE
at the end.
.
As in the C language,
we all have to share one big name space,
so choose a register name that is unlikely to collide with other uses.
.
.
.P
The existence of the
.B .T
string is a common feature of post-CSTR\~#54
.IR troff s\[em]DWB\~3.3, \" others
Solaris,
Heirloom Doctools,
and Plan\~9
.I troff \" foreign
all support it\[em]but valid values are specific to each implementation.
.
The behavior of the
.B .T
register in GNU
.I troff \" GNU
differs from AT&T
.IR troff , \" AT&T
which interpolated\~1 only if
.I nroff \" AT&T
was the formatter and was called with
.BR \-T .
.
.
.P
The
.B lf
request sets the number of the
.I current
input line in AT&T
.IR troff ,\" AT&T
and the
.I next
in GNU
.IR troff .\" GNU
.
.
.br
.ne 2v
.P
AT&T
.I troff
had only environments named
.RB \[lq] 0 \[rq],
.RB \[lq] 1 \[rq],
and
.RB \[lq] 2 \[rq].
.
In GNU
.IR troff ,
any number of environments may exist,
using any valid identifiers for their names.
.
.
.P
GNU
.I troff \" GNU
normally tracks the interpolation depth of escape sequence parameters
and other delimited structures,
but not in compatibility mode.
.
See section \[lq]Miscellaneous\[rq] above.
.
.
.P
In compatibility mode,
the escape sequences
.BR \[rs]f ,
.BR \[rs]H ,
.BR \[rs]m ,
.BR \[rs]M ,
.BR \[rs]R ,
.BR \[rs]s ,
and
.B \[rs]S
are transparent at the beginning of an input line for the purpose of
recognizing a control character,
because they modify formatter state
.RB ( \[rs]R )
or properties of the environment
(the rest)
and therefore do not create output nodes.
.
For example,
this code produces bold output in both cases,
but the text differs,
.
.RS
.EX
\&.de xx \[aq]
Hello!
\&..
\&\[rs]fB.xx\[rs]fP
.EE
.RE
.
formatting \[lq].xx\[rq] normally and \[lq]Hello!\[rq] in compatibility
mode.
.
.
.P
GNU
.I troff \" GNU
request names unrecognized by other
.I troff \" generic
implementations will likely be ignored;
escape sequences that are GNU
.I troff \" GNU
extensions are liable to format their function selector character.
.
For example,
the adjustable,
non-breaking space escape sequence
.B \[rs]\[ti]
.\" BEGIN Keep in sync with groff.texi node "Other Differences" and
.\" groff_man_style(7).
is also supported by Heirloom Doctools
.I troff \" Heirloom
050915 (September 2005),
.I mandoc
1.9.5 (2009-09-21),
.I neatroff
(commit 1c6ab0f6e,
2016-09-13),
and Plan\~9 from User Space
.I troff \" Plan 9
(commit 93f8143600,
2022-08-12),
but not by Solaris/Illumos
.IR troff s, \" Solaris/Illumos
which will render it as
.BR \[ti] .
.\" as of this writing, 2022-08-13
.\" END Keep in sync with groff.texi node "Other Differences" and
.\" groff_man_style(7).
.
.
.P
GNU
.I troff \" GNU
does not allow the use of the escape sequences
.BR \[rs]| ,
.BR \[rs]\[ha] ,
.BR \[rs]& ,
.BR \[rs]{ ,
.BR \[rs]} ,
.BI \[rs] space\c
,
.BR \[rs]\[aq] ,
.BR \[rs]\[ga] ,
.BR \[rs]\- ,
.BR \[rs]_ ,
.BR \[rs]! ,
.BR \[rs]% ,
or
.B \[rs]c
in identifiers;
AT&T
.I troff \" AT&T
does.
.
The
.B \[rs]A
escape sequence
(see subsection \[lq]Escape sequences\[rq] above)
may be helpful in avoiding their use.
.
.
.P
Normally,
the syntax form
.BI \[rs]s n
accepts only a single character
(a digit)
for
.IR n ,
consistently with other forms that originated in AT&T
.IR troff , \" AT&T
like
.BR \[rs]* ,
.BR \[rs]$ ,
.BR \[rs]f ,
.BR \[rs]g ,
.BR \[rs]k ,
.BR \[rs]n ,
and
.BR \[rs]z .
.
In compatibility mode only,
a
.RI non-zero\~ n
must be in the range 4\[en]39.
.
Legacy documents relying upon this quirk of parsing should be migrated
to another
.B \[rs]s
form.
.
[Background:
The Graphic Systems C/A/T phototypesetter
(the original device target for AT&T
.IR troff ) \" AT&T
supported only a few discrete type sizes in the range 6\[en]36 points,
so Ossanna contrived a special case in the parser to do what the user
must have meant.
.
Kernighan warned of this in the 1992 revision of CSTR\~#54 (\[sc]2.3),
and more recently,
McIlroy referred to it as a \[lq]living fossil\[rq].]
.
.
.P
Fractional type sizes cause one noteworthy incompatibility.
.
In AT&T
.I troff \" AT&T
the
.B ps
request ignores scaling units and thus
.RB \[lq] .ps\~10u \[rq]
sets the type size to 10\~points,
whereas in GNU
.I troff \" GNU
it sets the type size to
.RI 10\~ scaled
points,
which may be a much smaller measurement.
.
See subsection \[lq]Fractional type sizes and new scaling units\[rq]
above.
.
.
.P
The
.B ab
request differs from AT&T
.IR troff : \" AT&T
GNU
.I troff \" GNU
writes no message to the standard error stream if no arguments are
given,
and it exits with a failure status instead of a successful one.
.
.
.P
The
.B bp
request differs from AT&T
.IR troff : \" AT&T
GNU
.I troff \" GNU
does not accept a scaling unit on the argument,
a page number;
the former
(somewhat uselessly)
does.
.
.
.P
In AT&T
.I troff \" AT&T
the
.B pm
request reports
macro,
string,
and
diversion
sizes in units of 128-byte blocks,
and an argument reduces the report to a sum of the above in the same
units.
.
GNU
.I troff \" GNU
ignores any arguments and reports the sizes in bytes.
.
.
.P
Unlike AT&T
.IR troff , \" AT&T
GNU
.I troff \" GNU
does not ignore the
.B ss
request if the output is a terminal device;
instead,
the values of minimum inter-word and additional inter-sentence space are
each rounded down to the nearest multiple of\~12.
.
.
.P
In GNU
.I troff \" GNU
there is a fundamental difference between (unformatted) characters and
(formatted) glyphs.
.
Everything that affects how a glyph is output is stored with the glyph
node;
once a glyph node has been constructed,
it is unaffected by any subsequent requests that are executed,
including
.BR bd ,
.BR cs ,
.BR tkf ,
.BR tr ,
or
.B fp
requests.
.
Normally,
glyphs are constructed from characters immediately before the glyph is
added to an output line.
.
Macros,
diversions,
and strings are all,
in fact,
the same type of object;
they contain a sequence of intermixed character and glyph nodes.
.
Special characters transform from one to the other:
before being added to the output,
they behave as characters;
afterward,
they are glyphs.
.
A glyph node does not behave like a character node when it is processed
by a macro:
it does not inherit any of the special properties that the character
from which it was constructed might have had.
.
For example,
the input
.
.br
.ne 5v
.RS
.EX
\&.di x
\[rs]\[rs]\[rs]\[rs]
\&.br
\&.di
\&.x
.EE
.RE
.
produces
.RB \[lq]\^ \[rs]\[rs] \[rq]
in GNU
.IR troff . \" GNU
Each pair of backslashes becomes one backslash
.I glyph;
the resulting backslashes are thus not interpreted as escape
.I characters
when they are reread as the diversion is output.
.
AT&T
.I troff \" AT&T
.I would
interpret them as escape characters when rereading them and end up
printing one
.RB \[lq] \[rs] \[rq].
.
.
.P
One way to format a backslash in most documents is with the
.B \[rs]e
escape sequence;
this formats the glyph of the current escape character,
regardless of whether it is used in a diversion;
it also works in both GNU
.I troff \" GNU
and AT&T
.IR troff . \" AT&T
.
(Naturally,
if you've changed the escape character,
you need to prefix the
.RB \[lq] e \[rq]
with whatever it is\[em]and you'll likely get something other than a
backslash in the output.)
.
.
.P
The other correct way,
appropriate in contexts independent of the backslash's common use as a
.I roff
escape character\[em]perhaps in discussion of character sets or other
programming languages\[em]is the character escape
.B \[rs](rs
or
.BR \[rs][rs] ,
for \[lq]reverse solidus\[rq],
from its name in the ECMA-6 (ISO/IEC\~646) standard.
.
[This escape sequence is not portable to AT&T
.IR troff , \" AT&T
but is to its lineal descendant,
Heirloom Doctools
.IR troff ,
as of its 060716 release (July 2006).]
.
.
.P
To store an escape sequence in a diversion that is interpreted when the
diversion is reread,
either use the traditional
.B \[rs]!\&
transparent output facility,
or,
if this is unsuitable,
the new
.B \[rs]?\&
escape sequence.
.
See subsection \[lq]Escape sequences\[rq] above and sections
\[lq]Diversions\[rq] and \[lq]gtroff Internals\[rq] in
.IR "Groff: The GNU Implementation of troff" ,
the
.I groff
Texinfo manual.
.
.
.P
In the somewhat pathological case where a diversion exists containing a
partially collected line and a partially collected line at the top-level
diversion has never existed,
AT&T
.I troff
will output the partially collected line at the end of input;
GNU
.I troff \" GNU
will not.
.
.
.\" ====================================================================
.SS "Formatter output incompatibilities"
.\" ====================================================================
.
Its extensions notwithstanding,
the
.I groff
intermediate output format has some incompatibilities
with that of AT&T
.IR troff , \" AT&T
but better compatibility is sought;
problem reports and patches are welcome.
.
The following incompatibilities are known.
.
.
.IP \[bu] 2n
The drawing position after rendering polygons is inconsistent with AT&T
.I troff \" AT&T
practice.
.
Other implementations have diverged on this point as well.
.
.
.IP \[bu]
The output cannot be easily rescaled to other devices as AT&T
.IR troff 's \" AT&T
could.
.\" XXX: Why?  What's the problem?  sizescale?  That could be written
.\" into the output as a comment or x command.  --GBR
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
This document was written by
.MT jjc@\:jclark\:.com
James Clark
.ME ,
.MT wl@\:gnu\:.org
Werner Lemberg
.ME ,
.MT groff\-bernd\:.warken\-72@\:web\:.de
Bernd Warken
.ME ,
and
.MT g.branden\:.robinson@\:gmail\:.com
G.\& Branden Robinson
.ME .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.IR "Groff: The GNU Implementation of troff" ,
by Trent A.\& Fisher and Werner Lemberg,
is the primary
.I groff
manual.
.
You can browse it interactively with \[lq]info groff\[rq].
.
.
.br
.ne 4v
.P
\[lq]Troff User's Manual\[rq]
by Joseph F.\& Ossanna,
1976
(revised by Brian W.\& Kernighan,
1992),
AT&T Bell Laboratories Computing Science Technical Report No.\& 54,
widely called simply \[lq]CSTR\~#54\[rq],
documents the language,
device and font description file formats,
and output format
referred to collectively in
.I groff
documentation as AT&T
.IR troff . \" AT&T
.
.
.P
\[lq]A Typesetter-independent TROFF\[rq]
by Brian W.\& Kernighan,
1982,
AT&T Bell Laboratories Computing Science Technical Report No.\& 97,
provides additional insights into the
device and font description file formats
and output format.
.
.
.P
.MR groff @MAN1EXT@ ,
.MR groff @MAN7EXT@ ,
.MR roff @MAN7EXT@
.
.
.\" Clean up.
.rm tx
.rm ic
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_groff_diff_7_man_C]
.do rr *groff_groff_diff_7_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
