/* { dg-do run { target { riscv_v } } } */
/* { dg-additional-options "-O3 -minline-strcmp" } */

int
__attribute__ ((noipa))
foo (const char *s, const char *t)
{
  return __builtin_strcmp (s, t);
}

#define SZ 10

int
main ()
{
  const char *s[SZ]
    = {"",  "asdf", "0", "\0", "!@#$%***m1123fdnmoi43",
       "a", "z",    "1", "9",  "12345678901234567889012345678901234567890"};

  const int ref[SZ * SZ]
    = {0,   -97, -48, 0,   -33, -97, -122, -49, -57, -49, 97,  0,   49,	 97, 64,
       115, -25, 48,  40,  48,	48,  -49,  0,	48,  15,  -49, -74, -1,	 -9, -1,
       0,   -97, -48, 0,   -33, -97, -122, -49, -57, -49, 33,  -64, -15, 33, 0,
       -64, -89, -16, -24, -16, 97,  -115, 49,	97,  64,  0,   -25, 48,	 40, 48,
       122, 25,	 74,  122, 89,	25,  0,	   73,	65,  73,  49,  -48, 1,	 49, 16,
       -48, -73, 0,   -8,  -50, 57,  -40,  9,	57,  24,  -40, -65, 8,	 0,  8,
       49,  -48, 1,   49,  16,	-48, -73,  50,	-8,  0};

  for (int i = 0; i < SZ; i++)
    for (int j = 0; j < SZ; j++)
      if (foo (s[i], s[j]) != ref [i * SZ + j])
        __builtin_abort ();
}
