#!/usr/bin/env python
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

import re


def generate(relH, relIdl):
    input = open(relIdl, "rt").read()
    relations = re.findall(
        r"const unsigned long RELATION_([A-Z_]+) = ([x0-9a-f]+);", input
    )

    relH.write(
        "/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */\n"
        "/* Relations are defined in accessible/interfaces/nsIAccessibleRelation.idl */\n\n"
        "#ifndef mozilla_a11y_relationtype_h_\n"
        "#define mozilla_a11y_relationtype_h_\n\n"
        "namespace mozilla {\n"
        "namespace a11y {\n\n"
        "enum class RelationType {\n"
    )
    for name, num in relations:
        relH.write(f"  {name} = {num},\n")
    lastName = relations[-1][0]
    relH.write(
        f"  LAST = {lastName}\n"
        "};\n\n"
        "}  // namespace a11y\n"
        "}  // namespace mozilla\n\n"
        "#endif\n"
    )


# For debugging
if __name__ == "__main__":
    import sys

    generate(sys.stdout, "accessible/interfaces/nsIAccessibleRelation.idl")
